/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.keys;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.crypto.keys.CustomPrivateKey;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class CustomRSAPrivateKey
extends CustomPrivateKey
implements RSAPrivateKey {
    private static final Logger LOGGER = LogManager.getLogger();
    private final BigInteger modulus;
    private final BigInteger privateExponent;

    private CustomRSAPrivateKey() {
        this.modulus = null;
        this.privateExponent = null;
    }

    public CustomRSAPrivateKey(BigInteger modulus, BigInteger privateExponent) {
        this.modulus = modulus;
        this.privateExponent = privateExponent;
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public String getFormat() {
        return "None";
    }

    @Override
    public byte[] getEncoded() {
        throw new UnsupportedOperationException("CustomKey cannot be encoded");
    }

    @Override
    public BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    public void adjustInContext(TlsContext context, ConnectionEndType ownerOfKey) {
        LOGGER.debug("Adjusting RSA private key in context");
        if (null == ownerOfKey) {
            throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
        }
        switch (ownerOfKey) {
            case CLIENT: {
                context.setClientRSAPrivateKey(this.privateExponent);
                context.setClientRsaModulus(this.modulus);
                break;
            }
            case SERVER: {
                context.setServerRSAPrivateKey(this.privateExponent);
                context.setServerRsaModulus(this.modulus);
                break;
            }
            default: {
                throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
            }
        }
    }

    @Override
    public void adjustInConfig(Config config, ConnectionEndType ownerOfKey) {
        if (null == ownerOfKey) {
            throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
        }
        switch (ownerOfKey) {
            case CLIENT: {
                config.setDefaultClientRSAPrivateKey(this.privateExponent);
                config.setDefaultClientRSAModulus(this.modulus);
                break;
            }
            case SERVER: {
                config.setDefaultServerRSAPrivateKey(this.privateExponent);
                config.setDefaultServerRSAModulus(this.modulus);
                break;
            }
            default: {
                throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
            }
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 73 * hash + Objects.hashCode(this.modulus);
        hash = 73 * hash + Objects.hashCode(this.privateExponent);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomRSAPrivateKey other = (CustomRSAPrivateKey)obj;
        if (!Objects.equals(this.modulus, other.modulus)) {
            return false;
        }
        return Objects.equals(this.privateExponent, other.privateExponent);
    }

    public String toString() {
        return "CustomRSAPrivateKey{modulus=" + this.modulus + ", privateExponent=" + this.privateExponent + '}';
    }
}

