/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Font;
import java.awt.Paint;
import java.util.Locale;
import org.rrd4j.graph.Axis;
import org.rrd4j.graph.ElementsNames;
import org.rrd4j.graph.ImageParameters;
import org.rrd4j.graph.ImageWorker;
import org.rrd4j.graph.Mapper;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;
import org.rrd4j.graph.RrdGraphGenerator;

class ValueAxisLogarithmic
extends Axis {
    private static final double[][] yloglab = new double[][]{{1.0E9, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1000.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {10.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {10.0, 1.0, 2.5, 5.0, 7.5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {10.0, 1.0, 2.0, 4.0, 6.0, 8.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {10.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    private final ImageParameters im;
    private final ImageWorker worker;
    private final RrdGraphDef gdef;
    private final int fontHeight;
    private final Mapper mapper;
    private final Locale locale;

    ValueAxisLogarithmic(RrdGraph rrdGraph, ImageWorker worker, Locale locale) {
        this.im = rrdGraph.im;
        this.gdef = rrdGraph.gdef;
        this.worker = worker;
        this.fontHeight = (int)Math.ceil(worker.getFontHeight(this.gdef.getFont(FONTTAG_AXIS)));
        this.mapper = new Mapper(this.gdef, this.im);
        this.locale = locale;
    }

    ValueAxisLogarithmic(RrdGraphGenerator rrdGraph, ImageWorker worker, Locale locale) {
        this.im = rrdGraph.im;
        this.gdef = rrdGraph.gdef;
        this.worker = worker;
        this.fontHeight = (int)Math.ceil(worker.getFontHeight(this.gdef.getFont(FONTTAG_AXIS)));
        this.mapper = rrdGraph.mapper;
        this.locale = locale;
    }

    private double findStart(double positive, int idx) {
        return Math.pow(10.0, this.im.log.applyAsDouble(positive) - this.im.log.applyAsDouble(positive) % this.im.log.applyAsDouble(yloglab[idx][0]));
    }

    @Override
    boolean draw() {
        int y2;
        int i;
        double value;
        int y3;
        Font font = this.gdef.getFont(FONTTAG_AXIS);
        Paint gridColor = this.gdef.getColor(ElementsNames.grid);
        Paint mGridColor = this.gdef.getColor(ElementsNames.mgrid);
        Paint fontColor = this.gdef.getColor(ElementsNames.font);
        int labelOffset = (int)(this.worker.getFontAscent(font) / 2.0);
        if (this.im.maxval == this.im.minval) {
            return false;
        }
        double pixpex = (double)this.im.ysize / (this.im.log.applyAsDouble(this.im.maxval) - this.im.log.applyAsDouble(this.im.minval));
        if (Double.isNaN(pixpex)) {
            return false;
        }
        int minoridx = 0;
        int majoridx = 0;
        int i2 = 0;
        while (yloglab[i2][0] > 0.0) {
            double pixperstep;
            double minstep = Math.log10(yloglab[i2][0]);
            int ii = 1;
            while (yloglab[i2][ii + 1] > 0.0) {
                if (yloglab[i2][ii + 2] == 0.0) {
                    minstep = Math.log10(yloglab[i2][ii + 1]) - Math.log10(yloglab[i2][ii]);
                    break;
                }
                ++ii;
            }
            if ((pixperstep = pixpex * minstep) > 5.0) {
                minoridx = i2;
            }
            if (pixperstep > (double)(2 * this.fontHeight)) {
                majoridx = i2;
            }
            ++i2;
        }
        double positiveMin = Math.max(this.im.minval, 0.0);
        int x0 = this.im.xorigin;
        int x1 = x0 + this.im.xsize;
        if (yloglab[minoridx][0] == 0.0 || yloglab[majoridx][0] == 0.0) {
            return false;
        }
        String zeroFormatted = String.format(this.locale, "%.0e", 0.0);
        IntDoubleLabelConsumer drawAxisLabel = (y, v, f) -> {
            String graphLabel = String.format(this.locale, f, v);
            if (zeroFormatted.equals(graphLabel)) {
                graphLabel = String.format(this.locale, "%.0f", v);
            }
            int length = (int)this.worker.getStringWidth(graphLabel, font);
            this.worker.drawString(graphLabel, x0 - length - 7, y + labelOffset, font, fontColor);
        };
        IntDoubleLineConsumer drawAxisLines = (y, v, p) -> {
            if (this.gdef.drawTicks()) {
                this.worker.drawLine(x0 - 1, y, x0 + 1, y, p, this.gdef.tickStroke);
                this.worker.drawLine(x1 - 1, y, x1 + 1, y, p, this.gdef.tickStroke);
            }
            this.worker.drawLine(x0, y, x1, y, p, this.gdef.gridStroke);
        };
        for (double value2 = this.findStart(positiveMin, minoridx); value2 <= this.im.maxval; value2 *= yloglab[minoridx][0]) {
            if (value2 < positiveMin) continue;
            int i3 = 0;
            while (yloglab[minoridx][++i3] > 0.0 && (y3 = this.mapper.ytr(value2 * yloglab[minoridx][i3])) > this.im.yorigin - this.im.ysize) {
                drawAxisLines.accept(y3, value2, gridColor);
            }
        }
        double negativeMin = -1.0 * Math.min(this.im.maxval, 0.0);
        for (double value3 = this.findStart(negativeMin, minoridx); value3 <= -1.0 * this.im.minval; value3 *= yloglab[minoridx][0]) {
            int y4;
            if (value3 < negativeMin) continue;
            int i4 = 0;
            while (yloglab[minoridx][++i4] > 0.0 && (y4 = this.mapper.ytr(-1.0 * value3 * yloglab[minoridx][i4])) > this.im.yorigin - this.im.ysize) {
                drawAxisLines.accept(y4, value3, gridColor);
            }
        }
        boolean skipFirst = false;
        if (this.im.minval < 0.0 && this.im.maxval > 0.0) {
            skipFirst = true;
            y3 = this.mapper.ytr(0.0);
            drawAxisLines.accept(y3, 0.0, mGridColor);
            drawAxisLabel.accept(y3, 0.0);
        }
        int iter = 0;
        int lasty = Integer.MAX_VALUE;
        for (value = this.findStart(positiveMin, majoridx); value <= this.im.maxval; value *= yloglab[majoridx][0]) {
            if (value < positiveMin || skipFirst && ++iter == 1) continue;
            i = 0;
            while (yloglab[majoridx][++i] > 0.0 && (y2 = this.mapper.ytr(value * yloglab[majoridx][i])) > this.im.yorigin - this.im.ysize) {
                if (lasty - y2 <= this.fontHeight) continue;
                drawAxisLines.accept(y2, value, mGridColor);
                drawAxisLabel.accept(y2, value * yloglab[majoridx][i]);
                lasty = y2;
            }
        }
        iter = 0;
        for (value = this.findStart(negativeMin, majoridx); value <= -1.0 * this.im.minval; value *= yloglab[majoridx][0]) {
            if (value < negativeMin || skipFirst && ++iter == 1) continue;
            i = 0;
            while (yloglab[majoridx][++i] > 0.0 && (y2 = this.mapper.ytr(-1.0 * value * yloglab[majoridx][i])) > this.im.yorigin - this.im.ysize) {
                drawAxisLines.accept(y2, value, mGridColor);
                drawAxisLabel.accept(y2, -1.0 * value * yloglab[majoridx][i]);
            }
        }
        return true;
    }

    @FunctionalInterface
    private static interface IntDoubleLineConsumer {
        public void accept(int var1, double var2, Paint var4);
    }

    @FunctionalInterface
    private static interface IntDoubleLabelConsumer {
        public void accept(int var1, double var2, String var4);

        default public void accept(int a, double b) {
            this.accept(a, b, "%.0e");
        }
    }
}

