/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import net.i2p.router.RouterContext;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.update.DevSU3UpdateChecker;
import net.i2p.router.update.DevSU3UpdateRunner;
import net.i2p.update.Checker;
import net.i2p.update.UpdateMethod;
import net.i2p.update.UpdateTask;
import net.i2p.update.UpdateType;
import net.i2p.update.Updater;

class DevSU3UpdateHandler
implements Checker,
Updater {
    private final RouterContext _context;
    private final ConsoleUpdateManager _mgr;

    public DevSU3UpdateHandler(RouterContext ctx, ConsoleUpdateManager mgr) {
        this._context = ctx;
        this._mgr = mgr;
    }

    public List<URI> getUpdateSources() {
        String url = this._context.getProperty("router.updateDevSU3URL");
        if (url == null) {
            return null;
        }
        try {
            return Collections.singletonList(new URI(url));
        }
        catch (URISyntaxException use) {
            return null;
        }
    }

    @Override
    public UpdateTask check(UpdateType type, UpdateMethod method, String id, String currentVersion, long maxTime) {
        if (type != UpdateType.ROUTER_DEV_SU3 || method != UpdateMethod.HTTP) {
            return null;
        }
        List<URI> updateSources = this.getUpdateSources();
        if (updateSources == null) {
            return null;
        }
        long ms = this._context.getProperty("router.updateLastDownloaded", 0L);
        if (ms <= 0L) {
            this._context.router().saveConfig("router.updateLastDownloaded", Long.toString(this._context.clock().now()));
        }
        DevSU3UpdateChecker update = new DevSU3UpdateChecker(this._context, this._mgr, updateSources);
        return update;
    }

    @Override
    public UpdateTask update(UpdateType type, UpdateMethod method, List<URI> updateSources, String id, String newVersion, long maxTime) {
        if (type != UpdateType.ROUTER_DEV_SU3 || method != UpdateMethod.HTTP || updateSources.isEmpty()) {
            return null;
        }
        DevSU3UpdateRunner update = new DevSU3UpdateRunner(this._context, this._mgr, updateSources);
        this._mgr.notifyProgress(update, "<b>" + this._mgr._t("Updating") + "</b>");
        return update;
    }
}

