/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.analysis;

import com.android.tools.smali.dexlib2.AccessFlags;
import com.android.tools.smali.dexlib2.analysis.ClassPath;
import com.android.tools.smali.dexlib2.analysis.TypeProto;
import com.android.tools.smali.dexlib2.analysis.util.TypeProtoUtils;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.dexlib2.util.MethodUtil;
import com.android.tools.smali.dexlib2.util.TypeUtils;

public class AnalyzedMethodUtil {
    public static boolean canAccess(TypeProto type, Method virtualMethod, boolean checkPackagePrivate, boolean checkProtected, boolean checkClass) {
        String thisPackage;
        String otherPackage;
        if (checkPackagePrivate && MethodUtil.isPackagePrivate(virtualMethod) && !(otherPackage = TypeUtils.getPackage(virtualMethod.getDefiningClass())).equals(thisPackage = TypeUtils.getPackage(type.getType()))) {
            return false;
        }
        if (checkProtected && (virtualMethod.getAccessFlags() & AccessFlags.PROTECTED.getValue()) != 0 && !TypeProtoUtils.extendsFrom(type, virtualMethod.getDefiningClass())) {
            return false;
        }
        if (checkClass) {
            ClassPath classPath = type.getClassPath();
            ClassDef methodClassDef = classPath.getClassDef(virtualMethod.getDefiningClass());
            if (!TypeUtils.canAccessClass(type.getType(), methodClassDef)) {
                return false;
            }
        }
        return true;
    }
}

