/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.reservoirsampling;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.reservoirsampling.ReservoirSampling;
import org.pentaho.di.trans.steps.reservoirsampling.ReservoirSamplingData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReservoirSamplingMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static final String XML_TAG = "reservoir_sampling";
    protected String m_sampleSize = "100";
    protected String m_randomSeed = "1";

    public String getSampleSize() {
        return this.m_sampleSize;
    }

    public void setSampleSize(String sampleS) {
        this.m_sampleSize = sampleS;
    }

    public String getSeed() {
        return this.m_randomSeed;
    }

    public void setSeed(String seed) {
        this.m_randomSeed = seed;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(100);
        retval.append("<reservoir_sampling>");
        retval.append(XMLHandler.addTagValue((String)"sample_size", (String)this.m_sampleSize));
        retval.append(XMLHandler.addTagValue((String)"seed", (String)this.m_randomSeed));
        retval.append("</reservoir_sampling>");
        return retval.toString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            ReservoirSamplingMeta m = (ReservoirSamplingMeta)obj;
            return this.getXML() == m.getXML();
        }
        return false;
    }

    @Override
    public void setDefault() {
        this.m_sampleSize = "100";
        this.m_randomSeed = "1";
    }

    @Override
    public Object clone() {
        ReservoirSamplingMeta retval = (ReservoirSamplingMeta)super.clone();
        return retval;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        int nrSteps = XMLHandler.countNodes((Node)stepnode, (String)XML_TAG);
        if (nrSteps > 0) {
            Node reservoirnode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)XML_TAG, (int)0);
            this.m_sampleSize = XMLHandler.getTagValue((Node)reservoirnode, (String)"sample_size");
            this.m_randomSeed = XMLHandler.getTagValue((Node)reservoirnode, (String)"seed");
        }
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        this.m_sampleSize = rep.getStepAttributeString(id_step, 0, "sample_size");
        this.m_randomSeed = rep.getStepAttributeString(id_step, 0, "seed");
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, 0L, "sample_size", this.m_sampleSize);
        rep.saveStepAttribute(id_transformation, id_step, 0L, "seed", this.m_randomSeed);
    }

    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transmeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, "Not receiving any fields from previous steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new ReservoirSampling(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ReservoirSamplingData();
    }
}

