/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer;

import com.ca.commons.cbutil.CBAbout;
import com.ca.commons.cbutil.CBCache;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.commons.security.KeystoreGUI;
import com.ca.directory.jxplorer.AdvancedOptions;
import com.ca.directory.jxplorer.ButtonRegister;
import com.ca.directory.jxplorer.DataSource;
import com.ca.directory.jxplorer.JXOpenConWin;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.KeystoreOptions;
import com.ca.directory.jxplorer.LdifExport;
import com.ca.directory.jxplorer.LdifImport;
import com.ca.directory.jxplorer.broker.Broker;
import com.ca.directory.jxplorer.search.DeleteFilterGUI;
import com.ca.directory.jxplorer.search.ReturnAttributesDialog;
import com.ca.directory.jxplorer.search.SearchExecute;
import com.ca.directory.jxplorer.search.SearchModel;
import com.ca.directory.jxplorer.tree.SmartTree;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MainMenu
extends JMenuBar {
    private static Logger log = Logger.getLogger(MainMenu.class.getName());
    JXplorer jxplorer;
    JXOpenConWin getConnection = null;
    JMenu fileMenu;
    JMenuItem connect;
    JMenuItem disconnect;
    JMenuItem print;
    JMenuItem refreshTree;
    JMenuItem exit;
    JMenu editMenu;
    JMenuItem cut;
    JMenuItem copy;
    JMenuItem paste;
    JMenuItem delete;
    JMenuItem rename;
    JMenuItem copyDN;
    JMenuItem newEntry;
    JMenuItem pasteAlias;
    JMenu ldifMenu;
    JMenuItem fullExport;
    JMenuItem subExport;
    JMenuItem importFile;
    JMenuItem viewOffline;
    JMenu searchMenu;
    JMenuItem search;
    JMenuItem deleteFilter;
    JMenuItem attrList;
    JMenu bookmarkMenu;
    JMenuItem editBookmark;
    JMenuItem addBookmark;
    JMenuItem deleteBookmark;
    JMenu lookAndFeelMenu;
    JMenuItem refresh;
    JMenu optionsMenu;
    JMenu toolsMenu;
    JMenuItem advancedOptions;
    JMenu sslMenu;
    JMenuItem simpleSSL;
    JMenuItem authSSL;
    JMenuItem keystoreOptions;
    JMenu helpMenu;
    JMenuItem helpContents;
    JMenuItem helpSearch;
    JMenuItem helpAbout;
    SmartTree tree;
    String dirIcons;
    String dirImages;
    String dirTemplates;
    public static Properties myProperties;
    public static String propertyFile;
    public static String localDir;
    public static String fileURLPrefix;

    public MainMenu(JXplorer jxplorer) {
        this.jxplorer = jxplorer;
        this.setImageDirs();
        this.fileMenu = new JMenu(CBIntText.get("File"));
        this.fileMenu.setMnemonic('F');
        this.setupFileMenu(this.fileMenu);
        this.editMenu = new JMenu(CBIntText.get("Edit"));
        this.editMenu.setMnemonic('E');
        this.setupEditMenu(this.editMenu);
        this.lookAndFeelMenu = new JMenu(CBIntText.get("View"));
        this.lookAndFeelMenu.setMnemonic('V');
        this.setupLookAndFeelMenu(this.lookAndFeelMenu);
        this.ldifMenu = new JMenu(CBIntText.get("LDIF"));
        this.ldifMenu.setMnemonic('L');
        this.setupLdifMenu(this.ldifMenu);
        this.searchMenu = new JMenu(CBIntText.get("Search"));
        this.searchMenu.setMnemonic('S');
        this.setupSearchMenu(this.searchMenu);
        this.bookmarkMenu = new JMenu(CBIntText.get("Bookmark"));
        this.bookmarkMenu.setMnemonic('B');
        this.setupBookmarkMenu(this.bookmarkMenu);
        this.optionsMenu = new JMenu(CBIntText.get("Options"));
        this.optionsMenu.setMnemonic('O');
        this.setupOptionsMenu(this.optionsMenu);
        this.toolsMenu = new JMenu(CBIntText.get("Tools"));
        this.toolsMenu.setMnemonic('T');
        this.setupToolsMenu(this.toolsMenu);
        this.sslMenu = new JMenu(CBIntText.get("Security"));
        this.sslMenu.setMnemonic('i');
        this.setupSSLMenu(this.sslMenu);
        this.helpMenu = new JMenu(CBIntText.get("Help"));
        this.helpMenu.setMnemonic('H');
        this.setupHelpMenu(this.helpMenu);
        this.add(this.fileMenu);
        this.add(this.editMenu);
        this.add(this.lookAndFeelMenu);
        this.add(this.bookmarkMenu);
        this.add(this.searchMenu);
        this.add(this.ldifMenu);
        this.add(this.optionsMenu);
        this.add(this.toolsMenu);
        this.add(this.sslMenu);
        this.add(this.helpMenu);
        jxplorer.setJMenuBar(this);
        this.setDisconnected();
    }

    protected void setupFileMenu(JMenu fileMenu) {
        ActionListener fileListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem src = (JMenuItem)e.getSource();
                MainMenu.this.tree = MainMenu.this.jxplorer.getActiveTree();
                if (src == MainMenu.this.connect) {
                    MainMenu.this.connect();
                } else if (src == MainMenu.this.disconnect) {
                    MainMenu.this.disconnect();
                } else if (src == MainMenu.this.print) {
                    MainMenu.this.print();
                } else if (src == MainMenu.this.refreshTree) {
                    MainMenu.this.jxplorer.mrTree.collapse();
                } else if (src == MainMenu.this.exit) {
                    MainMenu.this.jxplorer.shutdown();
                }
                MainMenu.this.jxplorer.repaint();
            }
        };
        this.connect = this.setMenuItem(fileMenu, fileListener, new String[]{CBIntText.get("Connect"), "C", CBIntText.get("Connect to a directory server."), "E", this.dirImages + "connect.gif"});
        this.disconnect = this.setMenuItem(fileMenu, fileListener, new String[]{CBIntText.get("Disconnect"), "D", CBIntText.get("Disconnect from a directory server."), "E", this.dirImages + "disconnect.gif"});
        this.print = this.setMenuItem(fileMenu, fileListener, new String[]{CBIntText.get("Print"), "P", CBIntText.get("Print out the current entry."), "E", this.dirImages + "print.gif"});
        this.setMenuItem(fileMenu, fileListener, new String[]{"-", "", "", ""});
        this.refreshTree = this.setMenuItem(fileMenu, fileListener, new String[]{CBIntText.get("Refresh Tree"), "R", CBIntText.get("Forces the tree to be reloaded from the directory."), "E", this.dirImages + "refresh_all.gif"});
        this.setMenuItem(fileMenu, fileListener, new String[]{"-", "", "", ""});
        this.exit = this.setMenuItem(fileMenu, fileListener, new String[]{CBIntText.get("Exit"), "x", CBIntText.get("Quit the JXplorer application."), "E", this.dirImages + "blank.gif"});
        ButtonRegister br = JXplorer.getButtonRegister();
        br.registerItem(br.CONNECT, this.connect);
        br.registerItem(br.DISCONNECT, this.disconnect);
        br.registerItem(br.PRINT, this.print);
        br.registerItem(br.REFRESH_TREE, this.refreshTree);
    }

    public void connect() {
        CBCache.cleanCache();
        if (this.getConnection == null) {
            this.getConnection = new JXOpenConWin(this.jxplorer, this.jxplorer.displayLabel, JXplorer.getProperty("option.ssl.clientcerts"), JXplorer.getProperty("option.ssl.cacerts"), JXplorer.getProperty("option.ldap.referral"), JXplorer.getProperty("option.ldap.searchAliasBehaviour"));
            this.getConnection.setSize(450, 340);
            CBUtility.center(this.getConnection, this.jxplorer);
        } else {
            this.getConnection.reinit(JXplorer.getProperty("option.ssl.clientcerts"), JXplorer.getProperty("option.ssl.cacerts"), JXplorer.getProperty("option.ldap.referral"), JXplorer.getProperty("option.ldap.searchAliasBehaviour"));
        }
        this.getConnection.resetTitleAndPassword();
        this.getConnection.setVisible(true);
    }

    public void setConnected(boolean searchActive) {
        this.editMenu.setEnabled(true);
        this.searchMenu.setEnabled(searchActive);
        this.toolsMenu.setEnabled(true);
        this.bookmarkMenu.setEnabled(true);
    }

    public void disconnect() {
        this.jxplorer.disconnect();
    }

    public void setDisconnected() {
        this.editMenu.setEnabled(false);
        this.searchMenu.setEnabled(false);
        this.toolsMenu.setEnabled(false);
        this.bookmarkMenu.setEnabled(false);
    }

    public void print() {
        this.jxplorer.pushStatus("Printing...");
        this.jxplorer.mainViewer.print();
        this.jxplorer.popStatus();
    }

    public void setupEditMenu(JMenu editMenu) {
        ActionListener editListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                MainMenu.this.tree = MainMenu.this.jxplorer.getActiveTree();
                if (item == MainMenu.this.cut) {
                    MainMenu.this.tree.getPopupTool().cut();
                } else if (item == MainMenu.this.copy) {
                    MainMenu.this.tree.getPopupTool().copy();
                } else if (item == MainMenu.this.paste) {
                    MainMenu.this.tree.getPopupTool().paste();
                } else if (item == MainMenu.this.delete) {
                    MainMenu.this.tree.getPopupTool().delete();
                } else if (item == MainMenu.this.rename) {
                    MainMenu.this.tree.getPopupTool().rename();
                } else if (item == MainMenu.this.copyDN) {
                    MainMenu.this.tree.getPopupTool().copyDN();
                } else if (item == MainMenu.this.newEntry) {
                    MainMenu.this.tree.getPopupTool().newEntry();
                } else if (item == MainMenu.this.pasteAlias) {
                    MainMenu.this.tree.getPopupTool().pasteAlias();
                }
            }
        };
        this.newEntry = this.setMenuItem(editMenu, editListener, new String[]{CBIntText.get("New"), "Ctrl+N", CBIntText.get("Create a new entry."), "E", this.dirImages + "new.gif"});
        this.copyDN = this.setMenuItem(editMenu, editListener, new String[]{CBIntText.get("Copy DN"), "Ctrl+Y", CBIntText.get("Copy the Distinguished Name of an entry to the clipboard."), "E", this.dirImages + "copy_dn.gif"});
        this.setMenuItem(editMenu, editListener, new String[]{"-", "", "", ""});
        this.cut = this.setMenuItem(editMenu, editListener, new String[]{CBIntText.get("Cut Branch"), "Ctrl+U", CBIntText.get("Select a subtree to move."), "E", this.dirImages + "cut.gif"});
        this.copy = this.setMenuItem(editMenu, editListener, new String[]{CBIntText.get("Copy Branch"), "Ctrl+O", CBIntText.get("Select a subtree to copy."), "E", this.dirImages + "copy.gif"});
        this.paste = this.setMenuItem(editMenu, editListener, new String[]{CBIntText.get("Paste Branch"), "Ctrl+P", CBIntText.get("Paste a previously selected subtree."), "E", this.dirImages + "paste.gif"});
        this.pasteAlias = this.setMenuItem(editMenu, editListener, new String[]{CBIntText.get("Paste Alias"), "", CBIntText.get("Paste an Alias."), "E", this.dirIcons + "alias.gif"});
        this.setMenuItem(editMenu, editListener, new String[]{"-", "", "", ""});
        this.delete = this.setMenuItem(editMenu, editListener, new String[]{CBIntText.get("Delete"), "Ctrl+D", CBIntText.get("Delete an entry."), "E", this.dirImages + "delete.gif"});
        this.rename = this.setMenuItem(editMenu, editListener, new String[]{CBIntText.get("Rename"), "Ctrl+M", CBIntText.get("Rename an entry."), "E", this.dirImages + "rename.gif"});
        ButtonRegister br = JXplorer.getButtonRegister();
        br.registerItem(br.PASTE, this.paste);
        br.registerItem(br.PASTE_ALIAS, this.pasteAlias);
        br.registerItem(br.COPY, this.copy);
        br.registerItem(br.COPY_DN, this.copyDN);
        br.registerItem(br.CUT, this.cut);
        br.registerItem(br.DELETE, this.delete);
        br.registerItem(br.NEW, this.newEntry);
        br.registerItem(br.RENAME, this.rename);
        br.setItemEnabled(br.PASTE, false);
        br.setItemEnabled(br.PASTE_ALIAS, false);
    }

    public void setupLdifMenu(JMenu ldifMenu) {
        ActionListener ldifListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean usingSearch;
                JMenuItem item = (JMenuItem)e.getSource();
                SmartTree activeTree = MainMenu.this.jxplorer.getActiveTree();
                boolean bl = usingSearch = activeTree == MainMenu.this.jxplorer.searchTree;
                if (item == MainMenu.this.fullExport) {
                    MainMenu.this.ldifFullExport(activeTree, usingSearch);
                } else if (item == MainMenu.this.subExport) {
                    MainMenu.this.ldifSubExport(activeTree, usingSearch);
                } else if (item == MainMenu.this.importFile) {
                    MainMenu.this.importFile();
                } else if (item == MainMenu.this.viewOffline) {
                    MainMenu.this.viewOffline();
                }
                MainMenu.this.jxplorer.repaint();
            }
        };
        this.fullExport = this.setMenuItem(ldifMenu, ldifListener, new String[]{CBIntText.get("Export Full Tree"), "x", CBIntText.get("Export an LDIF file of the entire tree."), "E", ""});
        this.subExport = this.setMenuItem(ldifMenu, ldifListener, new String[]{CBIntText.get("Export Subtree"), "p", CBIntText.get("Export an LDIF file of the current subtree."), "E", ""});
        this.importFile = this.setMenuItem(ldifMenu, ldifListener, new String[]{CBIntText.get("Import File"), "I", CBIntText.get("Import an LDIF file into the directory."), "E", ""});
        this.viewOffline = this.setMenuItem(ldifMenu, ldifListener, new String[]{CBIntText.get("View Offline"), "w", CBIntText.get("View an LDIF file off-Line, without adding to a directory."), "E", ""});
        ButtonRegister br = JXplorer.getButtonRegister();
        br.registerItem(br.LDIF, this.fullExport);
        br.registerItem(br.LDIF, this.subExport);
        br.registerItem(br.LDIF, this.importFile);
    }

    public void ldifFullExport(SmartTree activeTree, boolean usingSearch) {
        DN base = activeTree.getRootDN();
        DataSource datasource = activeTree.getDataSource();
        LdifExport export = new LdifExport(base, datasource, this.jxplorer.searchTree, usingSearch, this.jxplorer, "ldif.export.tree");
        export.setSize(360, 120);
        export.setTitle(CBIntText.get("Export Full Tree"));
        CBUtility.center(export, this.jxplorer);
        export.setVisible(true);
    }

    public void ldifSubExport(SmartTree activeTree, boolean usingSearch) {
        DN base = activeTree.getCurrentDN();
        DataSource datasource = activeTree.getDataSource();
        LdifExport export = new LdifExport(base, datasource, this.jxplorer.searchTree, usingSearch, this.jxplorer, "ldif.export.subtree");
        export.setSize(360, 120);
        export.setTitle(CBIntText.get("Export Subtree"));
        CBUtility.center(export, this.jxplorer);
        export.setVisible(true);
    }

    public void importFile() {
        Broker datamodifier;
        if (this.jxplorer.workOffline) {
            datamodifier = this.jxplorer.offlineBroker;
        } else if (this.jxplorer.jndiBroker.isActive()) {
            datamodifier = this.jxplorer.jndiBroker;
        } else {
            CBUtility.error(this.jxplorer, "Error: Not Connected! (Did You Want to 'View Offline'?)");
            return;
        }
        LdifImport imp = new LdifImport(datamodifier, this.jxplorer.mrTree, this.jxplorer, null);
    }

    public void viewOffline() {
        this.disconnect();
        this.jxplorer.setStatus("Working Offline");
        this.jxplorer.workOffline = true;
        this.jxplorer.offlineBroker.clear();
        this.jxplorer.mrTree.registerDataSource(this.jxplorer.offlineBroker);
        this.jxplorer.mrTree.setRoot(new DN(SmartTree.NODATA));
        LdifImport imp = new LdifImport(this.jxplorer.offlineBroker, this.jxplorer.mrTree, this.jxplorer, null);
        ButtonRegister br = JXplorer.getButtonRegister();
        br.setItemEnabled(br.LDIF, true);
    }

    protected void setupSearchMenu(JMenu searchMenu) {
        int i;
        final SearchModel sm = new SearchModel();
        searchMenu.removeAll();
        ArrayList list = sm.getFilterNames(5);
        Object[] names = list.toArray();
        Arrays.sort(names, new SearchModel.StringComparator());
        ActionListener searchListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                if (item == MainMenu.this.search) {
                    MainMenu.this.tree = MainMenu.this.jxplorer.getActiveTree();
                    MainMenu.this.tree.openSearch();
                } else if (item == MainMenu.this.deleteFilter) {
                    if (sm.getFilterNames(2).size() == 0) {
                        JOptionPane.showMessageDialog(MainMenu.this.jxplorer, CBIntText.get("There are no filters available to delete."), CBIntText.get("Nothing to Delete"), 1);
                        return;
                    }
                    DeleteFilterGUI dfg = new DeleteFilterGUI(MainMenu.this.jxplorer);
                    dfg.setVisible(true);
                } else if (item == MainMenu.this.attrList) {
                    ReturnAttributesDialog rad = new ReturnAttributesDialog(MainMenu.this.jxplorer);
                    rad.setVisible(true);
                } else {
                    MainMenu.this.doSearch(item.getText(), ((myJMenuItem)item).getToolTipText());
                }
                MainMenu.this.jxplorer.repaint();
            }
        };
        this.search = this.setMenuItem(searchMenu, searchListener, new String[]{CBIntText.get("Search Dialog"), "Ctrl+F", CBIntText.get("Search the directory."), "E", this.dirImages + "find.gif"});
        this.deleteFilter = this.setMenuItem(searchMenu, searchListener, new String[]{CBIntText.get("Delete Filter"), "", CBIntText.get("Delete an existing filter."), "E", this.dirImages + "delete.gif"});
        this.attrList = this.setMenuItem(searchMenu, searchListener, new String[]{CBIntText.get("Return Attribute Lists"), "", CBIntText.get("Opens a dialog that lets you manage the attributes that you wish to be returned in a search."), "E", this.dirImages + "return_attrs.gif"});
        if (names.length > 0) {
            this.setMenuItem(searchMenu, searchListener, new String[]{"-", "", "", "", ""});
        }
        ButtonRegister br = JXplorer.getButtonRegister();
        br.registerItem(br.SEARCH, this.search);
        String[] searchValues = new String[names.length];
        Object[] searchNames = new String[names.length];
        for (i = 0; i < names.length; ++i) {
            String key;
            searchNames[i] = key = names[i].toString();
            searchValues[i] = sm.getLDAPFilter((String)searchNames[i]);
            searchNames[i] = ((String)searchNames[i]).startsWith("JXFilter") ? ((String)searchNames[i]).substring(9) : ((String)searchNames[i]).substring(13);
        }
        if (names.length > 15) {
            searchMenu.add(this.getScrollList(searchNames, searchValues, searchMenu));
        } else {
            for (i = 0; i < names.length; ++i) {
                myJMenuItem searchMenuItem = new myJMenuItem((String)searchNames[i]);
                searchMenuItem.name = searchValues[i];
                this.setMenuItem(searchMenu, searchMenuItem, searchListener, new String[]{"", "", searchValues[i], "E", ""});
            }
        }
    }

    public void doSearch(String name, String filter) {
        SearchModel sm = new SearchModel();
        String baseDN = sm.getValue(name + "." + "baseDN");
        DN dn = baseDN == null ? this.jxplorer.getActiveTree().getCurrentDN() : new DN(baseDN);
        int searchLevel = 2;
        try {
            searchLevel = Integer.parseInt(sm.getValue(name + "." + "searchLevel"));
        }
        catch (NumberFormatException e) {
            searchLevel = 2;
        }
        String retAttrs = sm.getValue(name + "." + "retAttrs");
        String[] retAttrsList = null;
        if (retAttrs == null) {
            retAttrsList = new String[]{"objectClass"};
        } else if (retAttrs.equalsIgnoreCase("None")) {
            retAttrs = null;
        } else {
            retAttrsList = ReturnAttributesDialog.getReturnAttributes(retAttrs);
            sm.openRetAttrDisplay(this.jxplorer, retAttrsList, this.jxplorer.getSearchTree().getDataSource());
        }
        String find = name + "." + "find";
        String search = name + "." + "search";
        String aliasOption = "always";
        if (search.equalsIgnoreCase("false") && find.equalsIgnoreCase("false")) {
            aliasOption = "never";
        } else if (search.equalsIgnoreCase("true") && find.equalsIgnoreCase("false")) {
            aliasOption = "searching";
        } else if (search.equalsIgnoreCase("false") && find.equalsIgnoreCase("true")) {
            aliasOption = "finding";
        }
        log.info("Setting search alias option to: [" + aliasOption + "]");
        JXplorer.setProperty("option.ldap.searchAliasBehaviour", aliasOption);
        SearchExecute.run(this.jxplorer.getSearchTree(), dn, filter, retAttrsList, searchLevel, this.jxplorer.getSearchBroker());
        this.jxplorer.getTreeTabPane().setSelectedComponent(this.jxplorer.getResultsPanel());
    }

    public void setSearchEnabled(boolean state) {
        if (this.searchMenu == null) {
            return;
        }
        int items = this.searchMenu.getItemCount();
        for (int i = 0; i < items; ++i) {
            JMenuItem temp = this.searchMenu.getItem(i);
            if (!(temp instanceof myJMenuItem)) continue;
            temp.setEnabled(state);
        }
        this.searchMenu.repaint();
    }

    public void updateSearchMenu() {
        this.setupSearchMenu(this.searchMenu);
    }

    protected JScrollPane getScrollList(Object[] items, String[] toolTips, JMenu menuType) {
        final Object[] names = items;
        final String[] toolTps = toolTips;
        final JMenu type = menuType;
        final JList list = new JList(names){

            public String getToolTipText(MouseEvent e) {
                int index = this.locationToIndex(e.getPoint());
                if (-1 < index) {
                    return toolTps[index];
                }
                return null;
            }
        };
        list.setToolTipText("");
        list.setBackground(Color.lightGray);
        list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getSource() == list && !e.getValueIsAdjusting()) {
                    if (type == MainMenu.this.searchMenu) {
                        MainMenu.this.doSearch(names[list.getSelectedIndex()].toString(), toolTps[list.getSelectedIndex()]);
                        MainMenu.this.searchMenu.getPopupMenu().setVisible(false);
                        MainMenu.this.searchMenu.setSelected(false);
                    } else if (type == MainMenu.this.bookmarkMenu) {
                        MainMenu.this.jxplorer.getTreeTabPane().setSelectedIndex(0);
                        MainMenu.this.goToBookmark(toolTps[list.getSelectedIndex()].toString(), MainMenu.this.jxplorer.getActiveTree());
                        MainMenu.this.bookmarkMenu.getPopupMenu().setVisible(false);
                        MainMenu.this.bookmarkMenu.setSelected(false);
                    }
                }
            }
        });
        JScrollPane sp = new JScrollPane(list);
        sp.setPreferredSize(new Dimension(100, 300));
        sp.setMinimumSize(new Dimension(100, 300));
        sp.setAlignmentX(0.0f);
        return sp;
    }

    protected void setupBookmarkMenu(JMenu bookmarkMenu) {
        bookmarkMenu.removeAll();
        ActionListener bookmarkListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                MainMenu.this.jxplorer.getTreeTabPane().setSelectedIndex(0);
                MainMenu.this.tree = MainMenu.this.jxplorer.getActiveTree();
                if (item == MainMenu.this.editBookmark) {
                    MainMenu.this.tree.openEditBookmarkDialog();
                } else if (item == MainMenu.this.addBookmark) {
                    MainMenu.this.tree.openAddBookmarkDialog(MainMenu.this.jxplorer.mrTree.getCurrentDN());
                } else if (item == MainMenu.this.deleteBookmark) {
                    MainMenu.this.tree.openDeleteBookmarkDialog();
                } else {
                    MainMenu.this.goToBookmark(((myJMenuItem)item).name, MainMenu.this.tree);
                }
                MainMenu.this.jxplorer.repaint();
            }
        };
        this.addBookmark = this.setMenuItem(bookmarkMenu, bookmarkListener, new String[]{CBIntText.get("Add Bookmark"), "Ctrl+B", CBIntText.get("Add a bookmark from the current DN."), "E", this.dirImages + "plus.gif"});
        this.deleteBookmark = this.setMenuItem(bookmarkMenu, bookmarkListener, new String[]{CBIntText.get("Delete Bookmark"), "d", CBIntText.get("Delete a bookmark."), "E", this.dirImages + "delete.gif"});
        this.editBookmark = this.setMenuItem(bookmarkMenu, bookmarkListener, new String[]{CBIntText.get("Edit Bookmark"), "i", CBIntText.get("Edit your bookmarks."), "E", this.dirImages + "edit.gif"});
        ButtonRegister br = JXplorer.getButtonRegister();
        br.registerItem(br.BOOKMARKS, this.addBookmark);
        Properties propertyList = CBUtility.readPropertyFile("bookmarks.txt");
        DXNamingEnumeration keys = new DXNamingEnumeration(propertyList.keys());
        if (keys.size() > 0) {
            this.setMenuItem(bookmarkMenu, bookmarkListener, new String[]{"-", "", "", "", ""});
        }
        Hashtable<String, String> bookmarkTable = new Hashtable<String, String>();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            if (!key.toLowerCase().startsWith("dn")) continue;
            bookmarkTable.put(key.substring(key.indexOf(".") + 1), propertyList.getProperty(key));
        }
        DXNamingEnumeration en = new DXNamingEnumeration(bookmarkTable.keys());
        en.sort();
        int size = en.size();
        String[] bookmarkVals = new String[size];
        Object[] bookmarkNams = new String[size];
        int j = 0;
        while (en.hasMore()) {
            bookmarkNams[j] = (String)en.next();
            bookmarkVals[j] = (String)bookmarkTable.get(bookmarkNams[j]);
            ++j;
        }
        if (size > 15) {
            bookmarkMenu.add(this.getScrollList(bookmarkNams, bookmarkVals, bookmarkMenu));
        } else {
            for (int i = 0; i < bookmarkVals.length; ++i) {
                myJMenuItem bookmarkMenuItem = new myJMenuItem((String)bookmarkNams[i]);
                bookmarkMenuItem.name = bookmarkVals[i];
                this.setMenuItem(bookmarkMenu, bookmarkMenuItem, bookmarkListener, new String[]{"", "", "Go to: " + bookmarkVals[i] + ".", "E", ""});
            }
        }
    }

    public void setBookmarksEnabled(boolean state) {
        if (this.bookmarkMenu == null) {
            return;
        }
        int items = this.bookmarkMenu.getItemCount();
        for (int i = 0; i < items; ++i) {
            JMenuItem temp = this.bookmarkMenu.getItem(i);
            if (!(temp instanceof myJMenuItem)) continue;
            temp.setEnabled(state);
        }
        this.bookmarkMenu.repaint();
    }

    public void updateBookmarkMenu() {
        this.setupBookmarkMenu(this.bookmarkMenu);
    }

    public void goToBookmark(String dn, SmartTree tree) {
        tree.readAndExpandDN(new DN(dn));
    }

    protected void setupLookAndFeelMenu(JMenu lookAndFeelMenu) {
        String status = "false".equals(JXplorer.getProperty("gui.buttonbar")) ? "U" : "C";
        this.setCheckBoxMenu(lookAndFeelMenu, new String[][]{{CBIntText.get("Show Button Bar"), "B", CBIntText.get("Display the shortcut button toolbar."), "E", status, this.dirImages + "blank.gif"}}, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean selected = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                MainMenu.this.jxplorer.buttonBar.setVisible(selected);
                MainMenu.this.jxplorer.repaint();
                JXplorer.setProperty("gui.buttonbar", String.valueOf(selected));
            }
        });
        status = "false".equals(JXplorer.getProperty("gui.searchbar")) ? "U" : "C";
        this.setCheckBoxMenu(lookAndFeelMenu, new String[][]{{CBIntText.get("Show Search Bar"), "w", CBIntText.get("Show the quick search tool bar."), "E", status, this.dirImages + "blank.gif"}}, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean selected = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                MainMenu.this.jxplorer.searchBar.setVisible(selected);
                MainMenu.this.jxplorer.repaint();
                JXplorer.setProperty("gui.searchbar", String.valueOf(selected));
            }
        });
        ActionListener viewListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                MainMenu.this.tree = MainMenu.this.jxplorer.getActiveTree();
                if (item == MainMenu.this.refresh) {
                    MainMenu.this.tree.getPopupTool().refresh();
                }
                MainMenu.this.jxplorer.repaint();
            }
        };
        this.setMenuItem(lookAndFeelMenu, viewListener, new String[]{"-", "", "", "", ""});
        this.refresh = this.setMenuItem(lookAndFeelMenu, viewListener, new String[]{CBIntText.get("Refresh"), "Ctrl+R", CBIntText.get("Refreshes an Entry."), "E", this.dirImages + "refresh.gif"});
        ButtonRegister br = JXplorer.getButtonRegister();
        br.registerItem(br.REFRESH, this.refresh);
    }

    protected void setupOptionsMenu(JMenu optionsMenu) {
        class PropertyCheckBoxMenuItem
        extends JCheckBoxMenuItem {
            final String propName;

            public PropertyCheckBoxMenuItem(String s, String propertyName) {
                super(CBIntText.get(s), true);
                this.propName = propertyName;
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JXplorer.myProperties.setProperty(propName, String.valueOf(this.getState()));
                        ((PropertyCheckBoxMenuItem)this).MainMenu.this.jxplorer.repaint();
                    }
                });
            }

            public void paint(Graphics g) {
                boolean state;
                boolean bl = state = !"false".equalsIgnoreCase(JXplorer.myProperties.getProperty(this.propName));
                if (state != this.getState()) {
                    this.setState(state);
                }
                super.paint(g);
            }
        }
        PropertyCheckBoxMenuItem confirmOps = new PropertyCheckBoxMenuItem(CBIntText.get("Confirm Tree Operations"), "option.confirmTreeOperations");
        this.setMenuItemState(optionsMenu, confirmOps, "C", CBIntText.get("Prompt the user whenever the tree will be modified?"), true);
        PropertyCheckBoxMenuItem confirmTableEditorUpdates = new PropertyCheckBoxMenuItem(CBIntText.get("Confirm Table Editor Updates"), "option.confirmTableEditorUpdates");
        this.setMenuItemState(optionsMenu, confirmTableEditorUpdates, "T", CBIntText.get("Display message to confirm successful updates in Table Editor?"), true);
        PropertyCheckBoxMenuItem checkSchema = new PropertyCheckBoxMenuItem(CBIntText.get("Ignore Schema Checking"), "option.ignoreSchemaOnSubmission");
        this.setMenuItemState(optionsMenu, checkSchema, "g", CBIntText.get("Don't check entry consistency before submission."), true);
        final JCheckBoxMenuItem browserSearchAliases = new JCheckBoxMenuItem(CBIntText.get("Resolve Aliases while Browsing"));
        this.setMenuItemState(optionsMenu, browserSearchAliases, "A", CBIntText.get("Whether to browse the referenced object, or the alias entry itself."), true);
        browserSearchAliases.setState("finding".equals(JXplorer.getProperty("option.ldap.browseAliasBehaviour")));
        ActionListener optionsListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                if (item == MainMenu.this.advancedOptions) {
                    MainMenu.this.setUpAdvancedOptions();
                }
                MainMenu.this.jxplorer.repaint();
            }
        };
        this.advancedOptions = this.setMenuItem(optionsMenu, optionsListener, new String[]{CBIntText.get("Advanced Options"), "d", CBIntText.get("Open the Advanced Options dialog."), "E", ""});
        browserSearchAliases.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (browserSearchAliases.isSelected()) {
                        JXplorer.setProperty("option.ldap.browseAliasBehaviour", "finding");
                        if (MainMenu.this.jxplorer.jndiBroker.getDirContext() != null) {
                            MainMenu.this.jxplorer.jndiBroker.getDirContext().addToEnvironment("java.naming.ldap.derefAliases", "finding");
                        }
                    } else {
                        JXplorer.setProperty("option.ldap.browseAliasBehaviour", "never");
                        if (MainMenu.this.jxplorer.jndiBroker.getDirContext() != null) {
                            MainMenu.this.jxplorer.jndiBroker.getDirContext().addToEnvironment("java.naming.ldap.derefAliases", "never");
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    protected void setUpAdvancedOptions() {
        AdvancedOptions adOpt = new AdvancedOptions(this.jxplorer, this);
        CBUtility.center(adOpt, this.jxplorer);
        adOpt.setVisible(true);
    }

    protected void setupSSLMenu(JMenu sslMenu) {
        ActionListener sslListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                if (item == MainMenu.this.simpleSSL) {
                    KeystoreGUI win = new KeystoreGUI(MainMenu.this.jxplorer, JXplorer.getMyProperties(), JXplorer.getProperty("option.ssl.cacerts"), null, JXplorer.getProperty("keystoreType.cacerts"), CBIntText.get("Manage Your Trusted Server Certificates."), false, "ssl.certs");
                    win.setSize(450, 320);
                    CBUtility.center(win, MainMenu.this.jxplorer);
                    win.setVisible(true);
                } else if (item == MainMenu.this.authSSL) {
                    KeystoreGUI win = new KeystoreGUI(MainMenu.this.jxplorer, JXplorer.getMyProperties(), JXplorer.getProperty("option.ssl.clientcerts"), null, JXplorer.getProperty("keystoreType.clientcerts"), CBIntText.get("Manage Your Own Private Keys and Certificates."), true, "ssl.certs");
                    win.setSize(450, 440);
                    CBUtility.center(win, MainMenu.this.jxplorer);
                    win.setVisible(true);
                } else if (item == MainMenu.this.keystoreOptions) {
                    KeystoreOptions options = new KeystoreOptions((Frame)MainMenu.this.jxplorer, JXplorer.getMyProperties());
                    options.setSize(530, 260);
                    CBUtility.center(options, MainMenu.this.jxplorer);
                    options.setVisible(true);
                }
                MainMenu.this.jxplorer.repaint();
            }
        };
        this.simpleSSL = this.setMenuItem(sslMenu, sslListener, new String[]{CBIntText.get("Trusted Servers and CAs"), "u", CBIntText.get("Setup which servers you trust for SSL."), "E", this.dirImages + "sslcert.gif"});
        this.authSSL = this.setMenuItem(sslMenu, sslListener, new String[]{CBIntText.get("Client Certificates"), "C", CBIntText.get("Setup client authentication (if available)."), "none".equals(JXplorer.getProperty("authprovider")) ? "D" : "E", this.dirImages + "sslkeycert.gif"});
        this.keystoreOptions = this.setMenuItem(sslMenu, sslListener, new String[]{CBIntText.get("Advanced Keystore Options"), "K", CBIntText.get("Select your keystore locations and the type of keystore to use."), "E", this.dirImages + "blankRec.gif"});
    }

    protected void setupToolsMenu(JMenu toolsMenu) {
        String[][] toolsMenuItems = new String[][]{{CBIntText.get("Stop Action"), "A", CBIntText.get("Stop the currently executing browser action."), "E", this.dirImages + "stop.gif"}};
        this.setMenu(toolsMenu, toolsMenuItems, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String cmd = ((JMenuItem)e.getSource()).getName();
                if (cmd.equals(CBIntText.get("Stop Action"))) {
                    MainMenu.this.jxplorer.getStopMonitor().show();
                }
                MainMenu.this.jxplorer.repaint();
            }
        });
        this.jxplorer.getStopMonitor().addWatcher(toolsMenu.getItem(0));
    }

    protected void setupHelpMenu(JMenu helpMenu) {
        ActionListener helpListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                if (MainMenu.this.jxplorer.helpSystem == null && item != MainMenu.this.helpAbout) {
                    CBUtility.error(MainMenu.this.jxplorer, "Unable to open Help System", null);
                    return;
                }
                if (item == MainMenu.this.helpContents) {
                    MainMenu.this.jxplorer.helpSystem.openTab("TOC");
                } else if (item == MainMenu.this.helpSearch) {
                    MainMenu.this.jxplorer.helpSystem.openTab("Search");
                } else if (item == MainMenu.this.helpAbout) {
                    MainMenu.this.showAboutMessage();
                }
                MainMenu.this.jxplorer.repaint();
            }
        };
        this.helpContents = this.setMenuItem(helpMenu, helpListener, new String[]{CBIntText.get("Contents"), "C", CBIntText.get("Display the help index."), "E", this.dirImages + "content.gif"});
        this.helpSearch = this.setMenuItem(helpMenu, helpListener, new String[]{CBIntText.get("Search"), "r", CBIntText.get("Search help for a keyword."), "E", this.dirImages + "search.gif"});
        this.setMenuItem(helpMenu, helpListener, new String[]{"-", "", "", "", ""});
        this.helpAbout = this.setMenuItem(helpMenu, helpListener, new String[]{CBIntText.get("About"), "A", CBIntText.get("General information about JXplorer."), "E", this.dirImages + "about.gif"});
    }

    public void showAboutMessage() {
        File licence = new File(System.getProperty("user.dir") + File.separator + "licence.txt");
        if (licence.exists()) {
            String textBody = JXplorer.version + "\n\nCopyright \u00a9 2005 CA. All rights reserved.";
            try {
                textBody = CBUtility.readTextFile(licence);
                textBody = JXplorer.version + "\n" + "\nWritten by: Chris Betts" + "\n            Trudi Ersvaer\n" + "\nThanks to:  Jason Paul" + "\n            Lachlan O'Dea" + "\n            Van Bui\n\n\n" + textBody;
            }
            catch (IOException e) {
                // empty catch block
            }
            CBAbout about = new CBAbout(this.jxplorer, textBody, new ImageIcon(this.dirTemplates + "JXAboutBottom.gif"), new ImageIcon(this.dirTemplates + "JXAboutTop.gif"), CBIntText.get("OK"), CBIntText.get("Close this window"), CBIntText.get("About JXplorer"));
            about.setSize(477, 350);
            about.setResizable(true);
            CBUtility.center(about, this.jxplorer);
            about.setVisible(true);
        }
    }

    protected void setMenu(JMenu menu, String[][] menuItems, ActionListener listener) {
        for (int i = 0; i < menuItems.length; ++i) {
            JMenuItem item = this.setMenuItem(menu, listener, menuItems[i]);
        }
    }

    protected JMenuItem setMenuItem(JMenu menu, ActionListener listener, String[] menuItems) {
        if (menuItems[0].equals("-")) {
            menu.add(new JSeparator());
            return null;
        }
        JMenuItem item = new JMenuItem(CBIntText.get(menuItems[0]), new ImageIcon(menuItems[4]));
        item.setName(menuItems[0]);
        return this.setMenuItem(menu, item, listener, menuItems);
    }

    protected JMenuItem setMenuItem(JMenu menu, JMenuItem item, ActionListener listener, String[] menuItems) {
        this.setMenuItemState(menu, item, menuItems[1], menuItems[2], menuItems[3].charAt(0) == 'E');
        if (listener != null) {
            item.addActionListener(listener);
        }
        return item;
    }

    protected void setCheckBoxMenu(JMenu menu, String[][] menuItems, ActionListener listener) {
        for (int i = 0; i < menuItems.length; ++i) {
            if (menuItems[i][0].equals("-")) {
                menu.add(new JSeparator());
                continue;
            }
            JCheckBoxMenuItem tmp = new JCheckBoxMenuItem(menuItems[i][0], new ImageIcon(menuItems[i][5]), menuItems[i][4].charAt(0) == 'C');
            this.setMenuItemState(menu, tmp, menuItems[i][1], menuItems[i][2], menuItems[i][3].charAt(0) == 'E');
            if (listener == null) continue;
            tmp.addActionListener(listener);
        }
    }

    protected void setMenuItemState(JMenu menu, JMenuItem menuItem, String mnemonic, String toolTipText, boolean enabled) {
        if (mnemonic.length() == 1) {
            menuItem.setMnemonic(mnemonic.charAt(0));
        } else if (mnemonic.startsWith("Cnt") || mnemonic.startsWith("cnt") || mnemonic.startsWith("Ctr") || mnemonic.startsWith("ctr")) {
            char C = mnemonic.charAt(mnemonic.length() - 1);
            menuItem.setAccelerator(KeyStroke.getKeyStroke(C, 2, false));
        }
        menuItem.setToolTipText(toolTipText);
        menuItem.setEnabled(enabled);
        menu.add(menuItem);
    }

    public void setImageDirs() {
        this.dirImages = JXplorer.getProperty("dir.images");
        this.dirIcons = JXplorer.getProperty("dir.icons");
        this.dirTemplates = JXplorer.getProperty("dir.templates");
    }

    public class myJMenuItem
    extends JMenuItem {
        public String name;

        public myJMenuItem(String s) {
            super(s);
        }
    }
}

