/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.jfree.layouting.input.style.CSSDeclarationRule;
import org.jfree.layouting.input.style.CSSFontFaceRule;
import org.jfree.layouting.input.style.CSSMediaRule;
import org.jfree.layouting.input.style.CSSPageAreaRule;
import org.jfree.layouting.input.style.CSSPageRule;
import org.jfree.layouting.input.style.CSSStyleRule;
import org.jfree.layouting.input.style.PageAreaType;
import org.jfree.layouting.input.style.StyleKeyRegistry;
import org.jfree.layouting.input.style.StyleRule;
import org.jfree.layouting.input.style.StyleSheet;
import org.jfree.layouting.input.style.parser.CSSParserContext;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.StyleSheetParserUtil;
import org.jfree.layouting.input.style.selectors.CSSSelector;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.resourceloader.DependencyCollector;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;

public class StyleSheetHandler
implements DocumentHandler,
ErrorHandler {
    private static final Logger logger = Logger.getLogger(StyleSheetHandler.class.getName());
    private HashMap namespaces = new HashMap();
    private StyleKeyRegistry registry;
    private StyleSheet styleSheet;
    private FastStack parentRules = new FastStack();
    private CSSDeclarationRule styleRule;
    private ResourceKey source;
    private DependencyCollector dependencies;
    private String defaultNamespace;
    private ResourceManager manager;

    public void init(ResourceManager resourceManager, ResourceKey resourceKey, long l, StyleKeyRegistry styleKeyRegistry, StyleRule styleRule) {
        if (styleKeyRegistry == null) {
            throw new NullPointerException();
        }
        this.registry = styleKeyRegistry;
        this.parentRules.clear();
        if (styleRule != null) {
            this.parentRules.push((Object)styleRule);
        }
        this.manager = resourceManager;
        this.source = resourceKey;
        if (resourceKey != null) {
            this.dependencies = new DependencyCollector(resourceKey, l);
        }
        this.namespaces.clear();
    }

    public void registerNamespace(String string, String string2) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.namespaces.put(string, string2);
    }

    public String getDefaultNamespaceURI() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespaceURI(String string) {
        this.defaultNamespace = string;
    }

    public ResourceKey getSource() {
        return this.source;
    }

    public DependencyCollector getDependencies() {
        return this.dependencies;
    }

    public CSSDeclarationRule getStyleRule() {
        return this.styleRule;
    }

    public void setStyleRule(CSSDeclarationRule cSSDeclarationRule) {
        this.styleRule = cSSDeclarationRule;
    }

    public StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    public void setStyleSheet(StyleSheet styleSheet) {
        this.styleSheet = styleSheet;
    }

    public ResourceManager getResourceManager() {
        return this.manager;
    }

    public void initParseContext(InputSource inputSource) {
        CSSParserContext.getContext().setNamespaces(this.namespaces);
        CSSParserContext.getContext().setStyleKeyRegistry(this.registry);
        CSSParserContext.getContext().setSource(this.getSource());
    }

    public void startDocument(InputSource inputSource) throws CSSException {
        this.initParseContext(inputSource);
        if (this.styleSheet == null) {
            this.styleSheet = new StyleSheet();
            this.styleSheet.setSource(this.getSource());
        }
    }

    public void endDocument(InputSource inputSource) throws CSSException {
        for (Map.Entry entry : this.namespaces.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            this.styleSheet.addNamespace(string, string2);
        }
    }

    public void comment(String string) throws CSSException {
    }

    public void ignorableAtRule(String string) throws CSSException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        String string2 = stringTokenizer.nextToken();
        if ("@namespace".equalsIgnoreCase(string2)) {
            this.parseNamespaceRule(stringTokenizer);
        } else if (this.styleRule instanceof CSSPageRule) {
            CSSPageRule cSSPageRule = (CSSPageRule)this.styleRule;
            if (string2.length() <= 1) {
                return;
            }
            String string3 = string2.substring(1);
            PageAreaType[] pageAreaTypeArray = PageAreaType.getPageAreas();
            for (int i = 0; i < pageAreaTypeArray.length; ++i) {
                PageAreaType pageAreaType = pageAreaTypeArray[i];
                if (!string3.equalsIgnoreCase(pageAreaType.getName())) continue;
                CSSPageAreaRule cSSPageAreaRule = this.parsePageRule(pageAreaType, string);
                if (cSSPageAreaRule != null) {
                    cSSPageRule.addRule(cSSPageAreaRule);
                }
                return;
            }
            logger.info("Did not recognize page @rule: " + string);
        } else {
            logger.info("Ignorable @rule: " + string);
        }
    }

    private CSSPageAreaRule parsePageRule(PageAreaType pageAreaType, String string) {
        ResourceManager resourceManager = this.getResourceManager();
        ResourceKey resourceKey = this.source;
        CSSPageAreaRule cSSPageAreaRule = new CSSPageAreaRule(this.styleSheet, this.styleRule, pageAreaType);
        int n = string.indexOf(123);
        int n2 = string.indexOf(125);
        if (n < 0 || n2 < n) {
            return null;
        }
        StyleSheetParserUtil.getInstance().parseStyleRule(this.namespaces, string.substring(n + 1, n2 - 1), resourceManager, resourceKey, cSSPageAreaRule);
        return cSSPageAreaRule;
    }

    private void parseNamespaceRule(StringTokenizer stringTokenizer) {
        String string;
        String string2;
        String string3 = stringTokenizer.nextToken();
        if (string3.startsWith("url(")) {
            string2 = "";
            string = string3;
        } else {
            string2 = string3;
            if (!stringTokenizer.hasMoreTokens()) {
                return;
            }
            string = stringTokenizer.nextToken();
        }
        int n = string.indexOf(40);
        if (n == -1) {
            return;
        }
        int n2 = string.indexOf(41);
        if (n2 == -1) {
            return;
        }
        if (n > n2) {
            return;
        }
        String string4 = string.substring(n + 1, n2);
        this.namespaceDeclaration(string2, string4);
    }

    public void namespaceDeclaration(String string, String string2) throws CSSException {
        if (string == null || "".equals(string)) {
            this.namespaces.put("", string2);
            this.defaultNamespace = string2;
            CSSParserContext.getContext().setDefaultNamespace(this.defaultNamespace);
        } else {
            this.namespaces.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importStyle(String string, SACMediaList sACMediaList, String string2) throws CSSException {
        ResourceManager resourceManager = this.getResourceManager();
        if (resourceManager == null) {
            return;
        }
        try {
            CSSParserContext.getContext().setDefaultNamespace(string2);
            ResourceKey resourceKey = this.source == null ? resourceManager.createKey((Object)string) : resourceManager.deriveKey(this.source, string);
            Resource resource = resourceManager.create(resourceKey, this.source, StyleSheet.class);
            if (resource == null) {
                return;
            }
            StyleSheet styleSheet = (StyleSheet)resource.getResource();
            this.styleSheet.addStyleSheet(styleSheet);
        }
        catch (ResourceException resourceException) {
        }
        finally {
            CSSParserContext.getContext().setStyleKeyRegistry(this.registry);
            CSSParserContext.getContext().setSource(this.getSource());
            CSSParserContext.getContext().setNamespaces(this.namespaces);
            CSSParserContext.getContext().setDefaultNamespace(this.defaultNamespace);
        }
    }

    public void startMedia(SACMediaList sACMediaList) throws CSSException {
        this.styleRule = new CSSMediaRule(this.styleSheet, this.getParentRule());
        this.parentRules.push((Object)this.styleRule);
    }

    public void endMedia(SACMediaList sACMediaList) throws CSSException {
        this.parentRules.pop();
        this.styleSheet.addRule(this.styleRule);
        this.styleRule = null;
    }

    public void startPage(String string, String string2) throws CSSException {
        this.styleRule = new CSSPageRule(this.styleSheet, this.getParentRule(), string, string2);
        this.parentRules.push((Object)this.styleRule);
    }

    public void endPage(String string, String string2) throws CSSException {
        this.parentRules.pop();
        this.styleSheet.addRule(this.styleRule);
        this.styleRule = null;
    }

    public void startFontFace() throws CSSException {
        this.styleRule = new CSSFontFaceRule(this.styleSheet, this.getParentRule());
        this.parentRules.push((Object)this.styleRule);
    }

    protected StyleRule getParentRule() {
        if (!this.parentRules.isEmpty()) {
            return (StyleRule)this.parentRules.peek();
        }
        return null;
    }

    public void endFontFace() throws CSSException {
        this.parentRules.pop();
    }

    public void startSelector(SelectorList selectorList) throws CSSException {
        this.styleRule = new CSSStyleRule(this.styleSheet, this.getParentRule());
    }

    public void endSelector(SelectorList selectorList) throws CSSException {
        if (this.styleRule.isEmpty()) {
            return;
        }
        int n = selectorList.getLength();
        for (int i = 0; i < n; ++i) {
            Selector selector = selectorList.item(i);
            try {
                CSSStyleRule cSSStyleRule = (CSSStyleRule)this.styleRule.clone();
                cSSStyleRule.setSelector((CSSSelector)selector);
                this.styleSheet.addRule(cSSStyleRule);
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
    }

    public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
        CSSValueFactory cSSValueFactory = CSSParserContext.getContext().getValueFactory();
        try {
            cSSValueFactory.parseValue(this.styleRule, string, lexicalUnit, bl);
        }
        catch (Exception exception) {
            logger.warning("Error parsing style key: " + string + " : " + exception);
        }
    }

    public void warning(CSSParseException cSSParseException) throws CSSException {
        logger.warning("Warning: " + cSSParseException.getMessage());
    }

    public void error(CSSParseException cSSParseException) throws CSSException {
        logger.warning("Error: " + cSSParseException);
    }

    public void fatalError(CSSParseException cSSParseException) throws CSSException {
        logger.warning("Fatal Error: " + cSSParseException);
    }
}

