/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.Popup;

public class PopupListenerHandler {
    private final MouseAdapter clickListener;
    private final ComponentListener resizeListener;
    private final Popup popup;
    private final JComponent glassPane;
    private final Component owningFrame;

    public PopupListenerHandler(Popup popup, JComponent glassPane, Component owningFrame) {
        this.popup = popup;
        this.glassPane = glassPane;
        this.owningFrame = owningFrame;
        this.clickListener = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                PopupListenerHandler.this.cleanup();
            }
        };
        this.resizeListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                PopupListenerHandler.this.cleanup();
            }
        };
    }

    public void cleanup() {
        this.popup.hide();
        this.owningFrame.removeComponentListener(this.resizeListener);
        this.glassPane.removeMouseListener(this.clickListener);
    }

    public void connect() {
        if (!this.isPopupVisible()) {
            this.popup.show();
            this.owningFrame.addComponentListener(this.resizeListener);
            this.glassPane.addMouseListener(this.clickListener);
        }
    }

    public boolean isPopupVisible() {
        ComponentListener[] componentListeners = this.owningFrame.getComponentListeners();
        if (Arrays.asList(componentListeners).contains(this.resizeListener)) {
            return true;
        }
        MouseListener[] mouseListeners = this.glassPane.getMouseListeners();
        return Arrays.asList(mouseListeners).contains(this.clickListener);
    }
}

