/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.i2p.crypto.EncType;
import net.i2p.data.Destination;
import net.i2p.data.PrivateKey;
import net.i2p.data.SigningPrivateKey;

public class LeaseSetKeys {
    private final SigningPrivateKey _revocationKey;
    private final PrivateKey _decryptionKey;
    private final PrivateKey _decryptionKeyEC;
    public static final Set<EncType> SET_ELG = Collections.unmodifiableSet(EnumSet.of(EncType.ELGAMAL_2048));
    public static final Set<EncType> SET_EC = Collections.unmodifiableSet(EnumSet.of(EncType.ECIES_X25519));
    public static final Set<EncType> SET_BOTH = Collections.unmodifiableSet(EnumSet.of(EncType.ELGAMAL_2048, EncType.ECIES_X25519));
    private static final Set<EncType> SET_NONE = Collections.emptySet();

    public LeaseSetKeys(Destination dest, SigningPrivateKey revocationKey, PrivateKey decryptionKey) {
        this._revocationKey = revocationKey;
        EncType type = decryptionKey.getType();
        if (type == EncType.ELGAMAL_2048) {
            this._decryptionKey = decryptionKey;
            this._decryptionKeyEC = null;
        } else if (type == EncType.ECIES_X25519) {
            this._decryptionKey = null;
            this._decryptionKeyEC = decryptionKey;
        } else {
            throw new IllegalArgumentException("Unknown type " + (Object)((Object)type));
        }
    }

    public LeaseSetKeys(Destination dest, SigningPrivateKey revocationKey, List<PrivateKey> decryptionKeys) {
        if (decryptionKeys.isEmpty()) {
            throw new IllegalArgumentException("no keys");
        }
        this._revocationKey = revocationKey;
        PrivateKey elg = null;
        PrivateKey ec = null;
        for (PrivateKey pk : decryptionKeys) {
            EncType type = pk.getType();
            if (type == EncType.ELGAMAL_2048) {
                if (elg != null) {
                    throw new IllegalArgumentException("Multiple keys same type");
                }
                elg = pk;
                continue;
            }
            if (type == EncType.ECIES_X25519) {
                if (ec != null) {
                    throw new IllegalArgumentException("Multiple keys same type");
                }
                ec = pk;
                continue;
            }
            throw new IllegalArgumentException("Unknown type " + (Object)((Object)type));
        }
        this._decryptionKey = elg;
        this._decryptionKeyEC = ec;
    }

    public SigningPrivateKey getRevocationKey() {
        return this._revocationKey;
    }

    public PrivateKey getDecryptionKey() {
        return this._decryptionKey;
    }

    public PrivateKey getDecryptionKey(EncType type) {
        if (type == EncType.ELGAMAL_2048) {
            return this._decryptionKey;
        }
        if (type == EncType.ECIES_X25519) {
            return this._decryptionKeyEC;
        }
        return null;
    }

    public boolean isSupported(EncType type) {
        if (type == EncType.ELGAMAL_2048) {
            return this._decryptionKey != null;
        }
        if (type == EncType.ECIES_X25519) {
            return this._decryptionKeyEC != null;
        }
        return false;
    }

    public Set<EncType> getSupportedEncryption() {
        if (this._decryptionKey != null) {
            return this._decryptionKeyEC != null ? SET_BOTH : SET_ELG;
        }
        return this._decryptionKeyEC != null ? SET_EC : SET_NONE;
    }
}

