/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.api.data.CodeRefType;
import jadx.api.data.ICodeComment;
import jadx.api.data.ICodeData;
import jadx.api.data.IJavaCodeRef;
import jadx.api.data.IJavaNodeRef;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.IAttributeNode;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.ProcessInstructionsVisitor;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JadxVisitor(name="AttachComments", desc="Attach user code comments", runBefore={ProcessInstructionsVisitor.class})
public class AttachCommentsVisitor
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(AttachCommentsVisitor.class);
    private Map<String, List<ICodeComment>> clsCommentsMap;

    @Override
    public void init(RootNode root) throws JadxException {
        this.updateCommentsData(root.getArgs().getCodeData());
        root.registerCodeDataUpdateListener(this::updateCommentsData);
    }

    @Override
    public boolean visit(ClassNode cls) {
        List<ICodeComment> clsComments = this.getCommentsData(cls);
        if (!clsComments.isEmpty()) {
            AttachCommentsVisitor.applyComments(cls, clsComments);
        }
        cls.getInnerClasses().forEach(this::visit);
        return false;
    }

    private static void applyComments(ClassNode cls, List<ICodeComment> clsComments) {
        for (ICodeComment comment : clsComments) {
            IJavaNodeRef nodeRef = comment.getNodeRef();
            switch (nodeRef.getType()) {
                case CLASS: {
                    AttachCommentsVisitor.addComment(cls, comment.getComment());
                    break;
                }
                case FIELD: {
                    FieldNode fieldNode = cls.searchFieldByShortId(nodeRef.getShortId());
                    if (fieldNode == null) {
                        LOG.warn("Field reference not found: {}", (Object)nodeRef);
                        break;
                    }
                    AttachCommentsVisitor.addComment(fieldNode, comment.getComment());
                    break;
                }
                case METHOD: {
                    MethodNode methodNode = cls.searchMethodByShortId(nodeRef.getShortId());
                    if (methodNode == null) {
                        LOG.warn("Method reference not found: {}", (Object)nodeRef);
                        break;
                    }
                    IJavaCodeRef codeRef = comment.getCodeRef();
                    if (codeRef == null) {
                        AttachCommentsVisitor.addComment(methodNode, comment.getComment());
                        break;
                    }
                    AttachCommentsVisitor.processCustomAttach(methodNode, codeRef, comment);
                }
            }
        }
    }

    private static InsnNode getInsnByOffset(MethodNode mth, int offset) {
        try {
            return mth.getInstructions()[offset];
        }
        catch (Exception e) {
            LOG.warn("Insn reference not found in: {} with offset: {}", (Object)mth, (Object)offset);
            return null;
        }
    }

    private static void processCustomAttach(MethodNode mth, IJavaCodeRef codeRef, ICodeComment comment) {
        CodeRefType attachType = codeRef.getAttachType();
        switch (attachType) {
            case INSN: {
                InsnNode insn = AttachCommentsVisitor.getInsnByOffset(mth, codeRef.getIndex());
                AttachCommentsVisitor.addComment(insn, comment.getComment());
                break;
            }
            default: {
                throw new JadxRuntimeException("Unexpected attach type: " + (Object)((Object)attachType));
            }
        }
    }

    private static void addComment(@Nullable IAttributeNode node, String comment) {
        if (node == null) {
            return;
        }
        node.remove(AType.CODE_COMMENTS);
        node.addAttr(AType.CODE_COMMENTS, comment);
    }

    private List<ICodeComment> getCommentsData(ClassNode cls) {
        if (this.clsCommentsMap == null) {
            return Collections.emptyList();
        }
        List<ICodeComment> clsComments = this.clsCommentsMap.get(cls.getClassInfo().getRawName());
        if (clsComments == null) {
            return Collections.emptyList();
        }
        return clsComments;
    }

    private void updateCommentsData(@Nullable ICodeData data) {
        this.clsCommentsMap = data == null ? Collections.emptyMap() : data.getComments().stream().collect(Collectors.groupingBy(c -> c.getNodeRef().getDeclaringClass()));
    }
}

