/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class XmlWriter
implements Closeable {
    protected final PrintWriter out;
    private static final Map<Character, String> ENCODING = new HashMap<Character, String>();

    public XmlWriter(PrintWriter out) {
        this.out = out;
    }

    public void flush() {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public static String encode(String unencoded) {
        return XmlWriter.encode(unencoded, false);
    }

    public static String encode(String unencoded, boolean keepApos) {
        StringBuilder buffer = null;
        if (unencoded != null) {
            for (int i = 0; i < unencoded.length(); ++i) {
                String encS = null;
                if (!keepApos || unencoded.charAt(i) != '\'') {
                    encS = ENCODING.get(Character.valueOf(unencoded.charAt(i)));
                }
                if (encS != null) {
                    if (buffer == null) {
                        buffer = new StringBuilder(unencoded.substring(0, i));
                    }
                    buffer.append(encS);
                    continue;
                }
                if (buffer == null) continue;
                buffer.append(unencoded.charAt(i));
            }
        }
        return buffer == null ? unencoded : buffer.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }

    static {
        ENCODING.put(Character.valueOf('<'), "&lt;");
        ENCODING.put(Character.valueOf('>'), "&gt;");
        ENCODING.put(Character.valueOf('\"'), "&quot;");
        ENCODING.put(Character.valueOf('\''), "&apos;");
        ENCODING.put(Character.valueOf('&'), "&amp;");
        ENCODING.put(Character.valueOf('\n'), "&#xA;");
        ENCODING.put(Character.valueOf('\r'), "&#xD;");
        ENCODING.put(Character.valueOf('\t'), "&#x9;");
    }
}

