/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.httpclient;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.HttpHost;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.jboss.logging.Logger;
import org.keycloak.utils.StringUtil;

public class ProxyMappings {
    private static final Logger logger = Logger.getLogger(ProxyMappings.class);
    private static final ProxyMappings EMPTY_MAPPING = ProxyMappings.valueOf(Collections.emptyList());
    private static final String NO_PROXY_DELIMITER = ",";
    private final List<ProxyMapping> entries;
    private static final Map<String, ProxyMapping> hostnameToProxyCache = new ConcurrentHashMap<String, ProxyMapping>();

    public ProxyMappings(List<ProxyMapping> entries) {
        this.entries = Collections.unmodifiableList(entries);
    }

    public static ProxyMappings valueOf(List<String> proxyMappings) {
        if (proxyMappings == null || proxyMappings.isEmpty()) {
            return EMPTY_MAPPING;
        }
        List<ProxyMapping> entries = proxyMappings.stream().map(ProxyMapping::valueOf).collect(Collectors.toList());
        return new ProxyMappings(entries);
    }

    public static ProxyMappings valueOf(String ... proxyMappings) {
        if (proxyMappings == null || proxyMappings.length == 0) {
            return EMPTY_MAPPING;
        }
        return ProxyMappings.valueOf(Arrays.asList(proxyMappings));
    }

    public static ProxyMappings withFixedProxyMapping(String httpProxy, String noProxy) {
        ArrayList<ProxyMapping> proxyMappings = new ArrayList<ProxyMapping>();
        if (!StringUtil.isBlank((String)httpProxy)) {
            if (!StringUtil.isBlank((String)noProxy)) {
                for (String host : noProxy.split(NO_PROXY_DELIMITER)) {
                    proxyMappings.add(new ProxyMapping(Pattern.compile("(?:.+\\.)?" + Pattern.quote(host)), null, null));
                }
            }
            proxyMappings.add(ProxyMapping.valueOf(".*;" + httpProxy));
        }
        return proxyMappings.isEmpty() ? EMPTY_MAPPING : new ProxyMappings(proxyMappings);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public ProxyMapping getProxyFor(String hostname) {
        Objects.requireNonNull(hostname, "hostname");
        if (hostnameToProxyCache.containsKey(hostname)) {
            return hostnameToProxyCache.get(hostname);
        }
        ProxyMapping proxyMapping = this.entries.stream().filter(e -> e.matches(hostname)).findFirst().orElse(null);
        if (proxyMapping == null) {
            proxyMapping = new ProxyMapping(null, null, null);
        }
        hostnameToProxyCache.put(hostname, proxyMapping);
        return proxyMapping;
    }

    public static void clearCache() {
        hostnameToProxyCache.clear();
    }

    public static class ProxyMapping {
        public static final String NO_PROXY = "NO_PROXY";
        private static final String DELIMITER = ";";
        private final Pattern hostnamePattern;
        private final HttpHost proxyHost;
        private final UsernamePasswordCredentials proxyCredentials;

        public ProxyMapping(Pattern hostnamePattern, HttpHost proxyHost, UsernamePasswordCredentials proxyCredentials) {
            this.hostnamePattern = hostnamePattern;
            this.proxyHost = proxyHost;
            this.proxyCredentials = proxyCredentials;
        }

        public Pattern getHostnamePattern() {
            return this.hostnamePattern;
        }

        public HttpHost getProxyHost() {
            return this.proxyHost;
        }

        public UsernamePasswordCredentials getProxyCredentials() {
            return this.proxyCredentials;
        }

        public boolean matches(String hostname) {
            return this.getHostnamePattern().matcher(hostname).matches();
        }

        public static ProxyMapping valueOf(String mapping) {
            String[] mappingTokens = mapping.split(DELIMITER);
            String hostPatternRegex = mappingTokens[0];
            String proxyUriString = mappingTokens[1];
            Pattern hostPattern = Pattern.compile(hostPatternRegex);
            if (NO_PROXY.equals(proxyUriString)) {
                return new ProxyMapping(hostPattern, null, null);
            }
            URI uri = URI.create(proxyUriString);
            String userInfo = uri.getUserInfo();
            UsernamePasswordCredentials proxyCredentials = null;
            if (userInfo != null) {
                if (userInfo.indexOf(":") > 0) {
                    String[] credencials = userInfo.split(":", 2);
                    if (credencials != null && credencials.length == 2) {
                        proxyCredentials = new UsernamePasswordCredentials(credencials[0], credencials[1]);
                    }
                } else {
                    logger.warn((Object)("Invalid proxy credentials: " + userInfo));
                }
            }
            return new ProxyMapping(hostPattern, new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme()), proxyCredentials);
        }

        public String toString() {
            return "ProxyMapping{hostnamePattern=" + String.valueOf(this.hostnamePattern) + ", proxyHost=" + String.valueOf(this.proxyHost) + "}";
        }
    }
}

