/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.metatype;

import aQute.bnd.annotation.xml.XMLAttribute;
import aQute.bnd.component.annotations.Component;
import aQute.bnd.metatype.DesignateDef;
import aQute.bnd.metatype.OCDDef;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Annotation;
import aQute.bnd.osgi.ClassDataCollector;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.xmlattribute.XMLAttributeFinder;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesignateReader
extends ClassDataCollector {
    static final Logger logger = LoggerFactory.getLogger(DesignateReader.class);
    private Analyzer analyzer;
    private Clazz clazz;
    private Map<Descriptors.TypeRef, OCDDef> classToOCDMap;
    private String[] pids;
    private String pid;
    private Annotation designate;
    private final XMLAttributeFinder finder;
    private DesignateDef def;

    DesignateReader(Analyzer analyzer, Clazz clazz, Map<Descriptors.TypeRef, OCDDef> classToOCDMap, XMLAttributeFinder finder) {
        this.analyzer = analyzer;
        this.clazz = clazz;
        this.classToOCDMap = classToOCDMap;
        this.finder = finder;
    }

    static DesignateDef getDesignate(Clazz c, Analyzer analyzer, Map<Descriptors.TypeRef, OCDDef> classToOCDMap, XMLAttributeFinder finder) throws Exception {
        DesignateReader r = new DesignateReader(analyzer, c, classToOCDMap, finder);
        return r.getDef();
    }

    private DesignateDef getDef() throws Exception {
        this.clazz.parseClassFileWithCollector(this);
        if (this.pid != null && this.designate != null) {
            if (this.pids != null && this.pids.length > 1) {
                this.analyzer.error("DS Component %s specifies multiple pids %s, and a Designate which requires exactly one pid", this.clazz.getClassName().getFQN(), Arrays.asList(this.pids));
                return null;
            }
            Descriptors.TypeRef ocdClass = (Descriptors.TypeRef)this.designate.get("ocd");
            logger.debug("Class {} annotated {}", (Object)this.clazz, (Object)this.designate);
            OCDDef ocd = this.classToOCDMap.get(ocdClass);
            if (ocd == null) {
                this.analyzer.error("DS Component %s specifies ocd class %s which cannot be found; known classes %s", this.clazz.getClassName().getFQN(), ocdClass, this.classToOCDMap.keySet());
                return null;
            }
            String id = ocd.id;
            boolean factoryPid = Boolean.TRUE.equals(this.designate.get("factory"));
            if (this.def == null) {
                this.def = new DesignateDef(this.finder);
            }
            this.def.ocdRef = id;
            this.def.pid = this.pid;
            this.def.factory = factoryPid;
            ocd.designates.add(this.def);
            return this.def;
        }
        return null;
    }

    @Override
    public void annotation(Annotation annotation) throws Exception {
        try {
            switch (annotation.getName().getFQN()) {
                case "org.osgi.service.metatype.annotations.Designate": {
                    this.designate = annotation;
                    break;
                }
                case "org.osgi.service.component.annotations.Component": {
                    this.doComponent(annotation, annotation.getAnnotation(Component.class));
                    break;
                }
                default: {
                    XMLAttribute xmlAttr = this.finder.getXMLAttribute(annotation);
                    if (xmlAttr != null) {
                        this.doXmlAttribute(annotation, xmlAttr);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.analyzer.error("During generation of a component on class %s, exception %s", this.clazz, e);
        }
    }

    void doComponent(Annotation a, Component c) {
        String[] stringArray = this.pids = a.containsKey("configurationPid") ? c.configurationPid() : null;
        if (this.pids != null) {
            this.pid = this.pids[0];
        }
        if (this.pids == null || "$".equals(this.pid)) {
            this.pid = a.containsKey("name") ? c.name() : this.clazz.getClassName().getFQN();
        }
    }

    private void doXmlAttribute(Annotation annotation, XMLAttribute xmlAttr) {
        if (this.def == null) {
            this.def = new DesignateDef(this.finder);
        }
        this.def.addExtensionAttribute(xmlAttr, annotation);
    }
}

