/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.provider.i18n;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.internal.provider.i18n.ModuleI18nUtil;
import org.openhab.core.automation.internal.provider.i18n.ModuleTypeI18nUtil;
import org.openhab.core.automation.module.provider.i18n.ModuleTypeI18nService;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.CompositeActionType;
import org.openhab.core.automation.type.CompositeConditionType;
import org.openhab.core.automation.type.CompositeTriggerType;
import org.openhab.core.automation.type.ConditionType;
import org.openhab.core.automation.type.Input;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.Output;
import org.openhab.core.automation.type.TriggerType;
import org.openhab.core.config.core.ConfigDescriptionBuilder;
import org.openhab.core.config.core.ConfigDescriptionParameter;
import org.openhab.core.config.core.i18n.ConfigI18nLocalizationService;
import org.openhab.core.i18n.TranslationProvider;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@NonNullByDefault
public class ModuleTypeI18nServiceImpl
implements ModuleTypeI18nService {
    private final Logger logger = LoggerFactory.getLogger(ModuleTypeI18nServiceImpl.class);
    private final ConfigI18nLocalizationService configI18nService;
    private final ModuleTypeI18nUtil moduleTypeI18nUtil;
    private final ModuleI18nUtil moduleI18nUtil;

    @Activate
    public ModuleTypeI18nServiceImpl(@Reference ConfigI18nLocalizationService configI18nService, @Reference TranslationProvider i18nProvider) {
        this.configI18nService = configI18nService;
        this.moduleTypeI18nUtil = new ModuleTypeI18nUtil(i18nProvider);
        this.moduleI18nUtil = new ModuleI18nUtil(i18nProvider);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public @Nullable ModuleType getModuleTypePerLocale(@Nullable ModuleType defModuleType, @Nullable Locale locale, Bundle bundle) {
        if (defModuleType == null || locale == null) {
            return defModuleType;
        }
        String uid = defModuleType.getUID();
        String llabel = this.moduleTypeI18nUtil.getLocalizedModuleTypeLabel(bundle, uid, defModuleType.getLabel(), locale);
        String ldescription = this.moduleTypeI18nUtil.getLocalizedModuleTypeDescription(bundle, uid, defModuleType.getDescription(), locale);
        List<ConfigDescriptionParameter> lconfigDescriptionParameters = this.getLocalizedConfigDescriptionParameters(defModuleType.getConfigurationDescriptions(), "module-type", uid, bundle, locale);
        ModuleType moduleType = defModuleType;
        if (moduleType instanceof ActionType) {
            void type;
            ActionType actionType = (ActionType)moduleType;
            ActionType cfr_ignored_0 = (ActionType)moduleType;
            return this.createLocalizedActionType((ActionType)type, bundle, uid, locale, lconfigDescriptionParameters, llabel == null ? defModuleType.getLabel() : llabel, ldescription == null ? defModuleType.getDescription() : ldescription);
        }
        ModuleType moduleType2 = defModuleType;
        if (moduleType2 instanceof ConditionType) {
            void type;
            ConditionType conditionType = (ConditionType)moduleType2;
            ConditionType cfr_ignored_1 = (ConditionType)moduleType2;
            return this.createLocalizedConditionType((ConditionType)type, bundle, uid, locale, lconfigDescriptionParameters, llabel == null ? defModuleType.getLabel() : llabel, ldescription == null ? defModuleType.getDescription() : ldescription);
        }
        ModuleType moduleType3 = defModuleType;
        if (moduleType3 instanceof TriggerType) {
            void type;
            TriggerType triggerType = (TriggerType)moduleType3;
            TriggerType cfr_ignored_2 = (TriggerType)moduleType3;
            return this.createLocalizedTriggerType((TriggerType)type, bundle, uid, locale, lconfigDescriptionParameters, llabel != null ? llabel : defModuleType.getLabel(), ldescription == null ? defModuleType.getDescription() : ldescription);
        }
        return null;
    }

    private @Nullable List<ConfigDescriptionParameter> getLocalizedConfigDescriptionParameters(List<ConfigDescriptionParameter> parameters, String prefix, String uid, Bundle bundle, @Nullable Locale locale) {
        try {
            return this.configI18nService.getLocalizedConfigDescription(bundle, ConfigDescriptionBuilder.create((URI)new URI(prefix + ":" + uid + ".name")).withParameters(parameters).build(), locale).getParameters();
        }
        catch (URISyntaxException e) {
            this.logger.error("Constructed invalid uri '{}:{}.name'", new Object[]{prefix, uid, e});
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private @Nullable ActionType createLocalizedActionType(ActionType at, Bundle bundle, String moduleTypeUID, @Nullable Locale locale, @Nullable List<ConfigDescriptionParameter> lconfigDescriptions, @Nullable String llabel, @Nullable String ldescription) {
        ActionType lat;
        List<Input> inputs = this.moduleTypeI18nUtil.getLocalizedInputs(at.getInputs(), bundle, moduleTypeUID, locale);
        List<Output> outputs = this.moduleTypeI18nUtil.getLocalizedOutputs(at.getOutputs(), bundle, moduleTypeUID, locale);
        ActionType actionType = at;
        if (actionType instanceof CompositeActionType) {
            void type;
            CompositeActionType compositeActionType = (CompositeActionType)actionType;
            CompositeActionType cfr_ignored_0 = (CompositeActionType)actionType;
            List<Action> modules = this.moduleI18nUtil.getLocalizedModules(type.getChildren(), bundle, moduleTypeUID, "module-type", locale);
            lat = new CompositeActionType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, at.getTags(), at.getVisibility(), inputs, outputs, modules);
        } else {
            lat = new ActionType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, at.getTags(), at.getVisibility(), inputs, outputs);
        }
        return lat;
    }

    /*
     * WARNING - void declaration
     */
    private @Nullable ConditionType createLocalizedConditionType(ConditionType ct, Bundle bundle, String moduleTypeUID, @Nullable Locale locale, @Nullable List<ConfigDescriptionParameter> lconfigDescriptions, @Nullable String llabel, @Nullable String ldescription) {
        ConditionType lct;
        List<Input> inputs = this.moduleTypeI18nUtil.getLocalizedInputs(ct.getInputs(), bundle, moduleTypeUID, locale);
        ConditionType conditionType = ct;
        if (conditionType instanceof CompositeConditionType) {
            void type;
            CompositeConditionType compositeConditionType = (CompositeConditionType)conditionType;
            CompositeConditionType cfr_ignored_0 = (CompositeConditionType)conditionType;
            List<Condition> modules = this.moduleI18nUtil.getLocalizedModules(type.getChildren(), bundle, moduleTypeUID, "module-type", locale);
            lct = new CompositeConditionType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, ct.getTags(), ct.getVisibility(), inputs, modules);
        } else {
            lct = new ConditionType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, ct.getTags(), ct.getVisibility(), inputs);
        }
        return lct;
    }

    /*
     * WARNING - void declaration
     */
    private @Nullable TriggerType createLocalizedTriggerType(TriggerType tt, Bundle bundle, String moduleTypeUID, @Nullable Locale locale, @Nullable List<ConfigDescriptionParameter> lconfigDescriptions, @Nullable String llabel, @Nullable String ldescription) {
        TriggerType ltt;
        List<Output> outputs = this.moduleTypeI18nUtil.getLocalizedOutputs(tt.getOutputs(), bundle, moduleTypeUID, locale);
        TriggerType triggerType = tt;
        if (triggerType instanceof CompositeTriggerType) {
            void type;
            CompositeTriggerType compositeTriggerType = (CompositeTriggerType)triggerType;
            CompositeTriggerType cfr_ignored_0 = (CompositeTriggerType)triggerType;
            List<Trigger> modules = this.moduleI18nUtil.getLocalizedModules(type.getChildren(), bundle, moduleTypeUID, "module-type", locale);
            ltt = new CompositeTriggerType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, tt.getTags(), tt.getVisibility(), outputs, modules);
        } else {
            ltt = new TriggerType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, tt.getTags(), tt.getVisibility(), outputs);
        }
        return ltt;
    }
}

