/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.row.ValueMetaInterface;

public class ExtenDBDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    private static final String[] RESERVED_WORDS = new String[]{"AFTER", "BINARY", "BOOLEAN", "DATABASES", "DBA", "ESTIMATE", "MODIFY", "NODE", "NODES", "OWNER", "PARENT", "PARTITION", "PARTITIONING", "PASSWORD", "PERCENT", "PUBLIC", "RENAME", "REPLICATED", "RESOURCE", "SAMPLE", "SERIAL", "SHOW", "STANDARD", "STAT", "STATISTICS", "TABLES", "TEMP", "TRAN", "UNSIGNED", "ZEROFILL"};

    public ExtenDBDatabaseMeta(String name, String access, String host, String db, int port, String user, String pass) {
        super(name, access, host, db, "" + port, user, pass);
    }

    public ExtenDBDatabaseMeta() {
    }

    public String getDatabaseTypeDesc() {
        return "EXTENDB";
    }

    public String getDatabaseTypeDescLong() {
        return "ExtenDB";
    }

    public int getDatabaseType() {
        return 20;
    }

    public int[] getAccessTypeList() {
        return new int[]{0, 1, 4};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 6453;
        }
        return -1;
    }

    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return "com.extendb.connect.XDBDriver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + databaseName;
        }
        return "jdbc:xdb://" + hostname + ":" + port + "/" + databaseName;
    }

    public String[] getReservedWords() {
        return RESERVED_WORDS;
    }

    public boolean isFetchSizeSupported() {
        return false;
    }

    public boolean supportsBitmapIndex() {
        return false;
    }

    public boolean supportsSynonyms() {
        return false;
    }

    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    public String getDropColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " DROP " + v.getName() + Const.CR;
    }

    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        String retval = "";
        retval = retval + "ALTER TABLE " + tablename + " DROP " + v.getName() + Const.CR + ";" + Const.CR;
        retval = retval + "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
        return retval;
    }

    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval = retval + "TIMESTAMP";
                break;
            }
            case 4: {
                if (this.supportsBooleanDataType()) {
                    retval = retval + "BOOLEAN";
                    break;
                }
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (length > 9) {
                        retval = retval + "BIGSERIAL";
                        break;
                    }
                    retval = retval + "SERIAL";
                    break;
                }
                if (length > 0) {
                    if (precision > 0 || length > 18) {
                        retval = retval + "NUMERIC(" + length + ", " + precision + ")";
                        break;
                    }
                    if (length > 9) {
                        retval = retval + "BIGINT";
                        break;
                    }
                    if (length < 5) {
                        retval = retval + "SMALLINT";
                        break;
                    }
                    retval = retval + "INTEGER";
                    break;
                }
                retval = retval + "DOUBLE PRECISION";
                break;
            }
            case 2: {
                retval = retval + "VARCHAR";
                retval = length > 0 ? retval + "(" + length : retval + "(";
                retval = retval + ")";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    public String[] getUsedLibraries() {
        return new String[]{"xdbjdbc.jar"};
    }
}

