/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.Objects;
import java.util.concurrent.Flow;

public class MultiIgnoreOp<T>
extends AbstractMultiOperator<T, Void> {
    public MultiIgnoreOp(Multi<T> upstream) {
        super(upstream);
    }

    @Override
    public void subscribe(MultiSubscriber<? super Void> downstream) {
        this.upstream.subscribe().withSubscriber(new MultiIgnoreProcessor((MultiSubscriber<? super Void>)((MultiSubscriber<Void>)Objects.requireNonNull(downstream))));
    }

    public static class MultiIgnoreProcessor<T>
    extends MultiOperatorProcessor<T, Void> {
        public MultiIgnoreProcessor(MultiSubscriber<? super Void> downstream) {
            super(downstream);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (this.compareAndSetUpstreamSubscription(null, subscription)) {
                this.downstream.onSubscribe(this);
                subscription.request(Long.MAX_VALUE);
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void request(long numberOfItems) {
            if (numberOfItems <= 0L) {
                this.onFailure(new IllegalArgumentException("Invalid number of request, must be greater than 0"));
            }
        }

        @Override
        public void onItem(T ignored) {
        }
    }
}

