/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.comm;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;
import org.eclipse.soda.dk.comm.DeviceListEntry;
import org.eclipse.soda.dk.comm.NSCommDriver;
import org.eclipse.soda.dk.comm.NSDeviceInputStream;
import org.eclipse.soda.dk.comm.NSDeviceOutputStream;
import org.eclipse.soda.dk.comm.SerialDataEventThread;
import org.eclipse.soda.dk.comm.SerialStatusEventThread;

class NSSerialPort
extends SerialPort {
    public static final int DATABITS_5 = 5;
    public static final int DATABITS_6 = 6;
    public static final int DATABITS_7 = 7;
    public static final int DATABITS_8 = 8;
    public static final int STOPBITS_1 = 1;
    public static final int STOPBITS_2 = 2;
    public static final int STOPBITS_1_5 = 3;
    public static final int PARITY_NONE = 0;
    public static final int PARITY_ODD = 1;
    public static final int PARITY_EVEN = 2;
    public static final int PARITY_MARK = 3;
    public static final int PARITY_SPACE = 4;
    public static final int FLOWCONTROL_NONE = 0;
    public static final int FLOWCONTROL_RTSCTS_IN = 1;
    public static final int FLOWCONTROL_RTSCTS_OUT = 2;
    public static final int FLOWCONTROL_XONXOFF_IN = 4;
    public static final int FLOWCONTROL_XONXOFF_OUT = 8;
    private int flowcontrol = 0;
    private int baudrate = 9600;
    private int databits = 8;
    private int stopbits = 1;
    private int parity = 0;
    private boolean dtr;
    private boolean rts;
    private DeviceListEntry dle = null;
    private NSCommDriver cd = null;
    int fd = -1;
    FileDescriptor FD = null;
    private NSDeviceInputStream ins = null;
    private NSDeviceOutputStream outs = null;
    int rcvThreshold = -1;
    int rcvTimeout = -1;
    boolean rcvFraming = false;
    int rcvFramingByte;
    boolean rcvFramingByteReceived;
    int insBufferSize = 0;
    int insBufferCount = 0;
    int outsBufferSize = 0;
    int outsBufferCount = 0;
    private SerialPortEventListener listener = null;
    private boolean notifyOnCTSFlag = false;
    private boolean notifyOnDSRFlag = false;
    private boolean notifyOnRIFlag = false;
    private boolean notifyOnCDFlag = false;
    private boolean notifyOnORFlag = false;
    private boolean notifyOnPEFlag = false;
    private boolean notifyOnFEFlag = false;
    private boolean notifyOnBIFlag = false;
    boolean notifyOnBufferFlag = false;
    private boolean notifyOnDataFlag = false;
    private SerialStatusEventThread statusThread = null;
    private SerialDataEventThread dataThread = null;

    public NSSerialPort(String portName, NSCommDriver driver) throws IOException {
        this.name = portName;
        this.cd = driver;
        DeviceListEntry cur = this.cd.getFirstDLE();
        while (cur != null) {
            if (cur.logicalName.equals(portName)) {
                if (this.fd == -1 || !cur.opened) {
                    this.fd = this.openDeviceNC(cur.physicalName, cur.semID);
                    if (this.fd == -1) {
                        throw new IOException();
                    }
                    this.dle = cur;
                    this.dle.opened = true;
                    break;
                }
                throw new IOException();
            }
            cur = this.cd.getNextDLE(cur);
        }
    }

    @Override
    public synchronized void addEventListener(SerialPortEventListener lstnr) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        this.listener = lstnr;
        if ((this.notifyOnDSRFlag || this.notifyOnRIFlag || this.notifyOnCDFlag || this.notifyOnORFlag || this.notifyOnPEFlag || this.notifyOnFEFlag || this.notifyOnCTSFlag || this.notifyOnBIFlag) && this.statusThread == null) {
            this.statusThread = new SerialStatusEventThread(this.fd, this);
            this.statusThread.start();
        }
        if (this.notifyOnDataFlag && this.dataThread == null) {
            this.dataThread = new SerialDataEventThread(this.fd, this);
            this.dataThread.start();
        }
    }

    @Override
    public void close() {
        if (this.fd == -1) {
            return;
        }
        if (this.statusThread != null) {
            this.statusThread.setStopThreadFlag(1);
            this.notifyOnCTSFlag = false;
            this.notifyOnDSRFlag = false;
            this.notifyOnRIFlag = false;
            this.notifyOnCDFlag = false;
            this.notifyOnORFlag = false;
            this.notifyOnPEFlag = false;
            this.notifyOnFEFlag = false;
            this.notifyOnBIFlag = false;
        }
        if (this.dataThread != null) {
            this.dataThread.setStopThreadFlag(1);
            this.notifyOnDataFlag = false;
        }
        if (this.outs != null) {
            try {
                this.outs.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.outs = null;
        }
        if (this.ins != null) {
            this.ins = null;
        }
        this.closeDeviceNC(this.fd, this.dle.semID);
        this.fd = -1;
        this.dle.opened = false;
        super.close();
    }

    private native int closeDeviceNC(int var1, int var2);

    @Override
    public void disableReceiveFraming() {
        this.rcvFraming = false;
    }

    @Override
    public void disableReceiveThreshold() {
        this.rcvThreshold = -1;
    }

    @Override
    public void disableReceiveTimeout() {
        this.rcvTimeout = -1;
    }

    @Override
    public void enableReceiveFraming(int rcvFramingByte) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    @Override
    public void enableReceiveThreshold(int thresh) throws UnsupportedCommOperationException {
        if (thresh > 0) {
            this.rcvThreshold = thresh;
        }
    }

    @Override
    public void enableReceiveTimeout(int rt) throws UnsupportedCommOperationException {
        if (rt > 0) {
            this.rcvTimeout = rt;
        } else if (rt == 0) {
            this.rcvTimeout = -1;
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    @Override
    public int getBaudRate() {
        int bdrate = 0;
        if (this.fd > -1) {
            bdrate = this.getBaudRateNC(this.fd);
            if (bdrate < 0) {
                bdrate = 0;
            } else {
                this.baudrate = bdrate;
            }
        }
        return bdrate;
    }

    private native int getBaudRateNC(int var1);

    public int getBaudrate() {
        return this.baudrate;
    }

    @Override
    public int getDataBits() {
        int db = 0;
        if (this.fd > -1 && (db = this.getDataBitsNC(this.fd)) != -1) {
            switch (db) {
                case 5: {
                    this.databits = 5;
                    break;
                }
                case 6: {
                    this.databits = 6;
                    break;
                }
                case 7: {
                    this.databits = 7;
                    break;
                }
                case 8: {
                    this.databits = 8;
                }
            }
        }
        return this.databits;
    }

    private native int getDataBitsNC(int var1);

    @Override
    public int getFlowControlMode() {
        if (this.fd > -1) {
            int retCode = this.getFlowControlModeNC(this.fd);
            if (retCode == -1) {
                return this.flowcontrol;
            }
            if (retCode == 0) {
                this.flowcontrol = 0;
            } else {
                int fl = 0;
                if ((retCode & 1) != 0) {
                    fl |= 1;
                }
                if ((retCode & 2) != 0) {
                    fl |= 2;
                }
                if ((retCode & 4) != 0) {
                    fl |= 4;
                }
                if ((retCode & 8) != 0) {
                    fl |= 8;
                }
                this.flowcontrol = fl;
            }
        } else {
            return this.flowcontrol;
        }
        return this.flowcontrol;
    }

    private native int getFlowControlModeNC(int var1);

    @Override
    public int getInputBufferSize() {
        return this.insBufferSize;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.ins != null) {
            return this.ins;
        }
        this.ins = new NSDeviceInputStream(this, this.dle.portType);
        if (this.ins == null) {
            throw new IOException();
        }
        this.ins.fd = this.fd;
        return this.ins;
    }

    @Override
    public int getOutputBufferSize() {
        return this.outsBufferSize;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.outs != null) {
            return this.outs;
        }
        this.outs = new NSDeviceOutputStream(this, this.dle.portType);
        if (this.outs == null) {
            throw new IOException();
        }
        this.outs.fd = this.fd;
        return this.outs;
    }

    @Override
    public int getParity() {
        int p = 0;
        if (this.fd > -1 && (p = this.getParityNC(this.fd)) != -1) {
            switch (p) {
                case 0: {
                    this.parity = 0;
                    break;
                }
                case 1: {
                    this.parity = 1;
                    break;
                }
                case 2: {
                    this.parity = 2;
                    break;
                }
                case 3: {
                    this.parity = 3;
                    break;
                }
                case 4: {
                    this.parity = 4;
                }
            }
        }
        return this.parity;
    }

    private native int getParityNC(int var1);

    @Override
    public int getReceiveFramingByte() {
        return this.rcvFramingByte;
    }

    @Override
    public int getReceiveThreshold() {
        return this.rcvThreshold;
    }

    @Override
    public int getReceiveTimeout() {
        return this.rcvTimeout;
    }

    @Override
    public int getStopBits() {
        int sb = 0;
        if (this.fd > -1 && (sb = this.getStopBitsNC(this.fd)) != -1) {
            switch (sb) {
                case 0: {
                    this.stopbits = 3;
                    break;
                }
                case 1: {
                    this.stopbits = 1;
                    break;
                }
                case 2: {
                    this.stopbits = 2;
                }
            }
        }
        return this.stopbits;
    }

    private native int getStopBitsNC(int var1);

    @Override
    public boolean isCD() {
        return this.isCDNC();
    }

    private native boolean isCDNC();

    @Override
    public boolean isCTS() {
        return this.isCTSNC();
    }

    private native boolean isCTSNC();

    @Override
    public boolean isDSR() {
        return this.isDSRNC();
    }

    private native boolean isDSRNC();

    @Override
    public boolean isDTR() {
        return this.isDTRNC();
    }

    private native boolean isDTRNC();

    public boolean isDtr() {
        return this.dtr;
    }

    @Override
    public boolean isRI() {
        return this.isRINC();
    }

    private native boolean isRINC();

    @Override
    public boolean isRTS() {
        return this.isRTSNC();
    }

    private native boolean isRTSNC();

    @Override
    public boolean isReceiveFramingEnabled() {
        return this.rcvFraming;
    }

    @Override
    public boolean isReceiveThresholdEnabled() {
        return this.rcvThreshold != -1;
    }

    @Override
    public boolean isReceiveTimeoutEnabled() {
        return this.rcvTimeout != -1;
    }

    public boolean isRts() {
        return this.rts;
    }

    @Override
    public synchronized void notifyOnBreakInterrupt(boolean notify) {
        if (notify && this.notifyOnBIFlag) {
            return;
        }
        if (notify && !this.notifyOnBIFlag) {
            if (this.statusThread == null) {
                this.statusThread = new SerialStatusEventThread(this.fd, this);
                this.statusThread.start();
            }
            this.notifyOnBIFlag = true;
        } else {
            if (!(this.notifyOnCTSFlag || this.notifyOnDSRFlag || this.notifyOnRIFlag || this.notifyOnCDFlag || this.notifyOnORFlag || this.notifyOnPEFlag || this.notifyOnFEFlag || this.statusThread == null)) {
                this.statusThread.setStopThreadFlag(1);
                this.statusThread = null;
            }
            this.notifyOnBIFlag = false;
        }
    }

    @Override
    public synchronized void notifyOnCTS(boolean notify) {
        if (notify && this.notifyOnCTSFlag) {
            return;
        }
        if (notify && !this.notifyOnCTSFlag) {
            if (this.statusThread == null) {
                this.statusThread = new SerialStatusEventThread(this.fd, this);
                this.statusThread.start();
            }
            this.notifyOnCTSFlag = true;
        } else {
            if (!(this.notifyOnDSRFlag || this.notifyOnRIFlag || this.notifyOnCDFlag || this.notifyOnORFlag || this.notifyOnPEFlag || this.notifyOnFEFlag || this.notifyOnBIFlag || this.statusThread == null)) {
                this.statusThread.setStopThreadFlag(1);
                this.statusThread = null;
            }
            this.notifyOnCTSFlag = false;
        }
    }

    @Override
    public synchronized void notifyOnCarrierDetect(boolean notify) {
        if (notify && this.notifyOnCDFlag) {
            return;
        }
        if (notify && !this.notifyOnCDFlag) {
            if (this.statusThread == null) {
                this.statusThread = new SerialStatusEventThread(this.fd, this);
                this.statusThread.start();
            }
            this.notifyOnCDFlag = true;
        } else {
            if (!(this.notifyOnCTSFlag || this.notifyOnDSRFlag || this.notifyOnORFlag || this.notifyOnRIFlag || this.notifyOnPEFlag || this.notifyOnFEFlag || this.notifyOnBIFlag || this.statusThread == null)) {
                this.statusThread.setStopThreadFlag(1);
                this.statusThread = null;
            }
            this.notifyOnCDFlag = false;
        }
    }

    @Override
    public synchronized void notifyOnDSR(boolean notify) {
        if (notify && this.notifyOnDSRFlag) {
            return;
        }
        if (notify && !this.notifyOnDSRFlag) {
            if (this.statusThread == null) {
                this.statusThread = new SerialStatusEventThread(this.fd, this);
                this.statusThread.start();
            }
            this.notifyOnDSRFlag = true;
        } else {
            if (!(this.notifyOnCTSFlag || this.notifyOnRIFlag || this.notifyOnCDFlag || this.notifyOnORFlag || this.notifyOnPEFlag || this.notifyOnFEFlag || this.notifyOnBIFlag || this.statusThread == null)) {
                this.statusThread.setStopThreadFlag(1);
                this.statusThread = null;
            }
            this.notifyOnDSRFlag = false;
        }
    }

    @Override
    public synchronized void notifyOnDataAvailable(boolean notify) {
        if (notify) {
            if (!this.notifyOnDataFlag) {
                if (this.dataThread == null) {
                    this.dataThread = new SerialDataEventThread(this.fd, this);
                    this.dataThread.start();
                }
                this.notifyOnDataFlag = true;
            }
        } else if (this.notifyOnDataFlag) {
            if (this.dataThread != null) {
                this.dataThread.setStopThreadFlag(1);
            }
            this.notifyOnDataFlag = false;
            this.dataThread = null;
        }
    }

    @Override
    public synchronized void notifyOnFramingError(boolean notify) {
        if (notify && this.notifyOnFEFlag) {
            return;
        }
        if (notify && !this.notifyOnFEFlag) {
            if (this.statusThread == null) {
                this.statusThread = new SerialStatusEventThread(this.fd, this);
                this.statusThread.start();
            }
            this.notifyOnFEFlag = true;
        } else {
            if (!(this.notifyOnCTSFlag || this.notifyOnDSRFlag || this.notifyOnRIFlag || this.notifyOnCDFlag || this.notifyOnORFlag || this.notifyOnPEFlag || this.notifyOnBIFlag || this.statusThread == null)) {
                this.statusThread.setStopThreadFlag(1);
                this.statusThread = null;
            }
            this.notifyOnFEFlag = false;
        }
    }

    @Override
    public synchronized void notifyOnOutputEmpty(boolean notify) {
        this.notifyOnBufferFlag = notify;
    }

    @Override
    public synchronized void notifyOnOverrunError(boolean notify) {
        if (notify && this.notifyOnORFlag) {
            return;
        }
        if (notify && !this.notifyOnORFlag) {
            if (this.statusThread == null) {
                this.statusThread = new SerialStatusEventThread(this.fd, this);
                this.statusThread.start();
            }
            this.notifyOnORFlag = true;
        } else {
            if (!(this.notifyOnCTSFlag || this.notifyOnDSRFlag || this.notifyOnRIFlag || this.notifyOnCDFlag || this.notifyOnPEFlag || this.notifyOnFEFlag || this.notifyOnBIFlag || this.statusThread == null)) {
                this.statusThread.setStopThreadFlag(1);
                this.statusThread = null;
            }
            this.notifyOnORFlag = false;
        }
    }

    @Override
    public synchronized void notifyOnParityError(boolean notify) {
        if (notify && this.notifyOnPEFlag) {
            return;
        }
        if (notify && !this.notifyOnPEFlag) {
            if (this.statusThread == null) {
                this.statusThread = new SerialStatusEventThread(this.fd, this);
                this.statusThread.start();
            }
            this.notifyOnPEFlag = true;
        } else {
            if (!(this.notifyOnCTSFlag || this.notifyOnDSRFlag || this.notifyOnRIFlag || this.notifyOnCDFlag || this.notifyOnORFlag || this.notifyOnFEFlag || this.notifyOnBIFlag || this.statusThread == null)) {
                this.statusThread.setStopThreadFlag(1);
                this.statusThread = null;
            }
            this.notifyOnPEFlag = false;
        }
    }

    @Override
    public synchronized void notifyOnRingIndicator(boolean notify) {
        if (notify && this.notifyOnRIFlag) {
            return;
        }
        if (notify && !this.notifyOnRIFlag) {
            if (this.statusThread == null) {
                this.statusThread = new SerialStatusEventThread(this.fd, this);
                this.statusThread.start();
            }
            this.notifyOnRIFlag = true;
        } else {
            if (!(this.notifyOnCTSFlag || this.notifyOnDSRFlag || this.notifyOnCDFlag || this.notifyOnORFlag || this.notifyOnPEFlag || this.notifyOnFEFlag || this.notifyOnBIFlag || this.statusThread == null)) {
                this.statusThread.setStopThreadFlag(1);
                this.statusThread = null;
            }
            this.notifyOnRIFlag = false;
        }
    }

    private native int openDeviceNC(String var1, int var2);

    @Override
    public synchronized void removeEventListener() {
        if (this.listener != null) {
            if (this.statusThread != null) {
                this.statusThread.setStopThreadFlag(1);
            }
            this.statusThread = null;
            if (this.dataThread != null) {
                this.dataThread.setStopThreadFlag(1);
            }
            this.dataThread = null;
            this.listener = null;
        }
    }

    synchronized void reportSerialEvent(int eventType, boolean oldvalue, boolean newvalue) {
        if (this.listener != null) {
            SerialPortEvent se = new SerialPortEvent(this, eventType, oldvalue, newvalue);
            this.listener.serialEvent(se);
        }
    }

    @Override
    public void sendBreak(int millis) {
        if (this.fd != -1) {
            this.sendBreakNC(this.fd, millis);
        }
    }

    private native int sendBreakNC(int var1, int var2);

    @Override
    public void setDTR(boolean dtr) {
        this.setDTRNC(dtr);
    }

    private native void setDTRNC(boolean var1);

    @Override
    public void setFlowControlMode(int flowctrl) throws UnsupportedCommOperationException {
        if (this.fd == -1 || (flowctrl & 1) != 0 && (flowctrl & 8) != 0 || (flowctrl & 4) != 0 && (flowctrl & 2) != 0 || (flowctrl & 1) != 0 && (flowctrl & 4) != 0 || (flowctrl & 2) != 0 && (flowctrl & 8) != 0) {
            throw new UnsupportedCommOperationException();
        }
        if (this.setFlowControlModeNC(this.fd, flowctrl) == -1) {
            throw new UnsupportedCommOperationException();
        }
        this.flowcontrol = flowctrl;
    }

    private native int setFlowControlModeNC(int var1, int var2);

    @Override
    public void setInputBufferSize(int size) {
    }

    @Override
    public void setOutputBufferSize(int size) {
        if (size >= 0) {
            this.outsBufferSize = size;
        }
    }

    @Override
    public void setRTS(boolean rts) {
        this.setRTSNC(rts);
    }

    private native void setRTSNC(boolean var1);

    @Override
    public void setRcvFifoTrigger(int trigger) {
    }

    @Override
    public void setSerialPortParams(int bd, int db, int sb, int par) throws UnsupportedCommOperationException {
        if (this.fd == -1) {
            throw new UnsupportedCommOperationException();
        }
        if (db != 5 && db != 6 && db != 7 && db != 8) {
            throw new UnsupportedCommOperationException();
        }
        if (sb != 1 && sb != 2 && sb != 3) {
            throw new UnsupportedCommOperationException();
        }
        if (par != 0 && par != 1 && par != 2 && par != 3 && par != 4) {
            throw new UnsupportedCommOperationException();
        }
        if (this.setSerialPortParamsNC(this.fd, bd, db, sb, par) < 0) {
            throw new UnsupportedCommOperationException();
        }
    }

    private native int setSerialPortParamsNC(int var1, int var2, int var3, int var4, int var5);
}

