info = {
    "name": "vi",
    "date_order": "DMY",
    "january": [
        "thg 1",
        "tháng 1",
        "Tháng một"
    ],
    "february": [
        "thg 2",
        "tháng 2",
        "Tháng hai"
    ],
    "march": [
        "thg 3",
        "tháng 3",
        "Tháng ba"
    ],
    "april": [
        "thg 4",
        "tháng 4",
        "Tháng tư"
    ],
    "may": [
        "thg 5",
        "tháng 5",
        "Tháng năm"
    ],
    "june": [
        "thg 6",
        "tháng 6",
        "Tháng sáu"
    ],
    "july": [
        "thg 7",
        "tháng 7",
        "Tháng bảy"
    ],
    "august": [
        "thg 8",
        "tháng 8",
        "Tháng tám"
    ],
    "september": [
        "thg 9",
        "tháng 9",
        "Tháng chín"
    ],
    "october": [
        "thg 10",
        "tháng 10",
        "Tháng mười"
    ],
    "november": [
        "thg 11",
        "tháng 11",
        "Tháng mười một"
    ],
    "december": [
        "thg 12",
        "tháng 12",
        "Tháng mười hai"
    ],
    "monday": [
        "th 2",
        "thứ hai",
        "Thứ 2"
    ],
    "tuesday": [
        "th 3",
        "thứ ba",
        "Thứ 3"
    ],
    "wednesday": [
        "th 4",
        "thứ tư",
        "Thứ 4"
    ],
    "thursday": [
        "th 5",
        "thứ năm",
        "Thứ 5"
    ],
    "friday": [
        "th 6",
        "thứ sáu",
        "Thứ 6"
    ],
    "saturday": [
        "th 7",
        "thứ bảy",
        "Thứ 7"
    ],
    "sunday": [
        "chủ nhật",
        "cn",
        "Thứ 1"
    ],
    "am": [
        "sa"
    ],
    "pm": [
        "ch"
    ],
    "year": [
        "năm"
    ],
    "month": [
        "tháng",
        "thang",
        "Thg"
    ],
    "week": [
        "tuần",
        "tuần lể"
    ],
    "day": [
        "ngày",
        "ban ngày",
        "buổi"
    ],
    "hour": [
        "giờ"
    ],
    "minute": [
        "phút",
        "chút",
        "lát",
        "nguyên bản"
    ],
    "second": [
        "giây",
        "giây đồng hồ",
        "hạng nhì"
    ],
    "relative-type": {
        "0 day ago": [
            "hôm nay"
        ],
        "0 hour ago": [
            "giờ này"
        ],
        "0 minute ago": [
            "phút này"
        ],
        "0 month ago": [
            "tháng này"
        ],
        "0 second ago": [
            "bây giờ"
        ],
        "0 week ago": [
            "tuần này"
        ],
        "0 year ago": [
            "năm nay"
        ],
        "1 day ago": [
            "hôm qua"
        ],
        "1 month ago": [
            "tháng trước"
        ],
        "1 week ago": [
            "tuần trước"
        ],
        "1 year ago": [
            "năm ngoái"
        ],
        "in 1 day": [
            "ngày mai"
        ],
        "in 1 month": [
            "tháng sau"
        ],
        "in 1 week": [
            "tuần sau"
        ],
        "in 1 year": [
            "năm sau"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+[.,]?\\d*) ngày trước"
        ],
        "\\1 hour ago": [
            "(\\d+[.,]?\\d*) giờ trước"
        ],
        "\\1 minute ago": [
            "(\\d+[.,]?\\d*) phút trước"
        ],
        "\\1 month ago": [
            "(\\d+[.,]?\\d*) tháng trước"
        ],
        "\\1 second ago": [
            "(\\d+[.,]?\\d*) giây trước"
        ],
        "\\1 week ago": [
            "(\\d+[.,]?\\d*) tuần trước"
        ],
        "\\1 year ago": [
            "(\\d+[.,]?\\d*) năm trước"
        ],
        "in \\1 day": [
            "sau (\\d+[.,]?\\d*) ngày nữa"
        ],
        "in \\1 hour": [
            "sau (\\d+[.,]?\\d*) giờ nữa"
        ],
        "in \\1 minute": [
            "sau (\\d+[.,]?\\d*) phút nữa"
        ],
        "in \\1 month": [
            "sau (\\d+[.,]?\\d*) tháng nữa"
        ],
        "in \\1 second": [
            "sau (\\d+[.,]?\\d*) giây nữa"
        ],
        "in \\1 week": [
            "sau (\\d+[.,]?\\d*) tuần nữa"
        ],
        "in \\1 year": [
            "sau (\\d+[.,]?\\d*) năm nữa"
        ]
    },
    "locale_specific": {},
    "pertain": [
        "lúc"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "cách đây",
        "trước đây",
        "trước",
        "trước"
    ],
    "in": [
        "trong"
    ],
    "simplifications": [
        {
            "(?:ngày|năm)\\s(\\d+[.,]?\\d*)": "\\1"
        }
    ],
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
