/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.impl;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.IDisconnectAction;
import org.freedesktop.dbus.connections.config.ReceivingServiceConfig;
import org.freedesktop.dbus.connections.config.TransportConfig;
import org.freedesktop.dbus.connections.config.TransportConfigBuilder;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.connections.transports.TransportBuilder;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.NotConnected;
import org.freedesktop.dbus.interfaces.DBus;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.ExportedObject;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.utils.AddressBuilder;
import org.freedesktop.dbus.utils.CommonRegexPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBusConnection
extends AbstractConnection {
    static final ConcurrentMap<String, DBusConnection> CONNECTIONS = new ConcurrentHashMap<String, DBusConnection>();
    private static String dbusMachineIdFile;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<String> busnames;
    private final String machineId;
    private DBus dbus;
    final AtomicInteger concurrentConnections = new AtomicInteger(1);
    private final boolean shared;

    DBusConnection(boolean _shared, String _machineId, TransportConfig _tranportCfg, ReceivingServiceConfig _rsCfg) throws DBusException {
        super(_tranportCfg, _rsCfg);
        this.busnames = new ArrayList<String>();
        this.machineId = _machineId;
        this.shared = _shared;
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public static DBusConnection getConnection(String _address) throws DBusException {
        return DBusConnection.getConnection(_address, true, true, 100000);
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public static DBusConnection getConnection(String _address, boolean _registerSelf, boolean _shared) throws DBusException {
        return DBusConnection.getConnection(_address, _registerSelf, _shared, 100000);
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public static DBusConnection getConnection(String _address, boolean _registerSelf, boolean _shared, int _timeout) throws DBusException {
        return ((DBusConnectionBuilder)((TransportConfigBuilder)DBusConnectionBuilder.forAddress(_address).withRegisterSelf(_registerSelf).withShared(_shared).transportConfig().withAdditionalConfig("TIMEOUT", 10000)).back()).build();
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public static DBusConnection getConnection(DBusBusType _bustype) throws DBusException {
        return DBusConnection.getConnection(_bustype, true, 100000);
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public static DBusConnection newConnection(DBusBusType _bustype) throws DBusException {
        return DBusConnection.getConnection(_bustype, false, 100000);
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public static DBusConnection getConnection(DBusBusType _bustype, boolean _shared, int _timeout) throws DBusException {
        BusAddress address = switch (_bustype) {
            case DBusBusType.SYSTEM -> AddressBuilder.getSystemConnection();
            case DBusBusType.SESSION -> AddressBuilder.getSessionConnection(dbusMachineIdFile);
            default -> throw new DBusException("Invalid Bus Type: " + String.valueOf((Object)_bustype));
        };
        if (!TransportBuilder.getRegisteredBusTypes().contains("UNIX") && TransportBuilder.getRegisteredBusTypes().contains("TCP") && (address == null || address.isBusType("UNIX"))) {
            address = BusAddress.of(System.getProperty("DBUS_TCP_SESSION"));
        }
        return DBusConnection.getConnection(address.toString(), true, _shared, _timeout);
    }

    private AtomicInteger getConcurrentConnections() {
        return this.concurrentConnections;
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public static void setDbusMachineIdFile(String _dbusMachineIdFile) {
        dbusMachineIdFile = _dbusMachineIdFile;
    }

    void connect(boolean _registerSelf) throws DBusException {
        this.listen();
        SigHandler h = new SigHandler();
        this.addSigHandlerWithoutMatch(DBus.NameAcquired.class, h);
        if (_registerSelf) {
            this.dbus = this.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
            try {
                this.busnames.add(this.dbus.Hello());
            }
            catch (DBusExecutionException _ex) {
                this.logger.debug("Error while doing 'Hello' handshake", (Throwable)_ex);
                throw new DBusException(_ex.getMessage());
            }
        }
    }

    public <T extends DBusInterface> T dynamicProxy(String _source, String _path, Class<T> _type) throws DBusException {
        this.logger.debug("Introspecting {} on {} for dynamic proxy creation", (Object)_path, (Object)_source);
        try {
            Introspectable intro = this.getRemoteObject(_source, _path, Introspectable.class);
            String data = intro.Introspect();
            this.logger.trace("Got introspection data: {}", (Object)data);
            String[] tags = CommonRegexPattern.PROXY_SPLIT_PATTERN.split(data);
            List<String> ifaces = Arrays.stream(tags).filter(t -> t.startsWith("interface")).map(t -> CommonRegexPattern.IFACE_PATTERN.matcher((CharSequence)t).replaceAll("$1")).map(i -> {
                if (i.startsWith("org.freedesktop.DBus.")) {
                    return CommonRegexPattern.DBUS_IFACE_PATTERN.matcher((CharSequence)i).replaceAll("$1");
                }
                return i;
            }).collect(Collectors.toList());
            List<Class<?>> ifcs = this.findMatchingTypes(_type, ifaces);
            if (ifcs.isEmpty()) {
                ifcs.add(DBusInterface.class);
            }
            RemoteObject ro = new RemoteObject(_source, _path, _type, false);
            DBusInterface newi = (DBusInterface)Proxy.newProxyInstance(ifcs.get(0).getClassLoader(), (Class[])ifcs.toArray(Class[]::new), (InvocationHandler)new RemoteInvocationHandler(this, ro));
            this.getImportedObjects().put(newi, ro);
            return (T)newi;
        }
        catch (Exception _ex) {
            this.logger.debug("", (Throwable)_ex);
            throw new DBusException(String.format("Failed to create proxy object for %s exported by %s. Reason: %s", _path, _source, _ex.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends DBusInterface> T getExportedObject(String _source, String _path, Class<T> _type) throws DBusException {
        ExportedObject o;
        Map<String, ExportedObject> map = this.getExportedObjects();
        synchronized (map) {
            o = this.getExportedObjects().get(_path);
        }
        if (null != o && o.getObject().get() == null) {
            this.unExportObject(_path);
            o = null;
        }
        if (null != o) {
            return (T)o.getObject().get();
        }
        if (null == _source) {
            throw new DBusException("Not an object exported by this connection and no remote specified");
        }
        return this.dynamicProxy(_source, _path, _type);
    }

    @Override
    public DBusInterface getExportedObject(String _source, String _path) throws DBusException {
        return this.getExportedObject(_source, _path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseBusName(String _busname) throws DBusException {
        if (_busname.length() > 255 || !BUSNAME_REGEX.matcher(_busname).matches()) {
            throw new DBusException("Invalid bus name");
        }
        try {
            this.dbus.ReleaseName(_busname);
        }
        catch (DBusExecutionException _ex) {
            this.logger.debug("", (Throwable)_ex);
            throw new DBusException(_ex.getMessage());
        }
        List<String> list = this.busnames;
        synchronized (list) {
            this.busnames.remove(_busname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestBusName(String _busname) throws DBusException {
        UInt32 rv;
        if (_busname.length() > 255 || !BUSNAME_REGEX.matcher(_busname).matches()) {
            throw new DBusException("Invalid bus name");
        }
        try {
            rv = this.dbus.RequestName(_busname, new UInt32(6L));
        }
        catch (DBusExecutionException _exDb) {
            this.logger.debug("", (Throwable)_exDb);
            throw new DBusException(_exDb);
        }
        switch (rv.intValue()) {
            case 2: 
            case 3: {
                throw new DBusException("Failed to register bus name");
            }
        }
        List<String> list = this.busnames;
        synchronized (list) {
            this.busnames.add(_busname);
        }
    }

    public String getUniqueName() {
        return this.busnames.get(0);
    }

    public String[] getNames() {
        TreeSet<String> names = new TreeSet<String>();
        names.addAll(this.busnames);
        return (String[])names.toArray(String[]::new);
    }

    public <I extends DBusInterface> I getPeerRemoteObject(String _busname, String _objectpath, Class<I> _type) throws DBusException {
        return this.getPeerRemoteObject(_busname, _objectpath, _type, true);
    }

    public DBusInterface getPeerRemoteObject(String _busname, String _objectpath) throws DBusException {
        if (null == _busname) {
            throw new DBusException("Invalid bus name: null");
        }
        if (_busname.length() > 255 || !BUSNAME_REGEX.matcher(_busname).matches() && !CONNID_REGEX.matcher(_busname).matches()) {
            throw new DBusException("Invalid bus name: " + _busname);
        }
        String unique = this.dbus.GetNameOwner(_busname);
        return this.dynamicProxy(unique, _objectpath, null);
    }

    public DBusInterface getRemoteObject(String _busname, String _objectpath) throws DBusException {
        if (null == _busname) {
            throw new DBusException("Invalid bus name: null");
        }
        if (null == _objectpath) {
            throw new DBusException("Invalid object path: null");
        }
        if (_busname.length() > 255 || !BUSNAME_REGEX.matcher(_busname).matches() && !CONNID_REGEX.matcher(_busname).matches()) {
            throw new DBusException("Invalid bus name: " + _busname);
        }
        if (_objectpath.length() > 255 || !OBJECT_REGEX_PATTERN.matcher(_objectpath).matches()) {
            throw new DBusException("Invalid object path: " + _objectpath);
        }
        return this.dynamicProxy(_busname, _objectpath, null);
    }

    public <I extends DBusInterface> I getPeerRemoteObject(String _busname, String _objectpath, Class<I> _type, boolean _autostart) throws DBusException {
        if (null == _busname) {
            throw new DBusException("Invalid bus name: null");
        }
        if (_busname.length() > 255 || !BUSNAME_REGEX.matcher(_busname).matches() && !CONNID_REGEX.matcher(_busname).matches()) {
            throw new DBusException("Invalid bus name: " + _busname);
        }
        String unique = this.dbus.GetNameOwner(_busname);
        return this.getRemoteObject(unique, _objectpath, _type, _autostart);
    }

    public <I extends DBusInterface> I getRemoteObject(String _busname, String _objectpath, Class<I> _type) throws DBusException {
        return this.getRemoteObject(_busname, _objectpath, _type, true);
    }

    public <I extends DBusInterface> I getRemoteObject(String _busname, String _objectpath, Class<I> _type, boolean _autostart) throws DBusException {
        if (null == _busname) {
            throw new DBusException("Invalid bus name: null");
        }
        if (null == _objectpath) {
            throw new DBusException("Invalid object path: null");
        }
        if (null == _type) {
            throw new ClassCastException("Not A DBus Interface");
        }
        if (_busname.length() > 255 || !BUSNAME_REGEX.matcher(_busname).matches() && !CONNID_REGEX.matcher(_busname).matches()) {
            throw new DBusException("Invalid bus name: " + _busname);
        }
        if (!OBJECT_REGEX_PATTERN.matcher(_objectpath).matches() || _objectpath.length() > 255) {
            throw new DBusException("Invalid object path: " + _objectpath);
        }
        if (!DBusInterface.class.isAssignableFrom(_type)) {
            throw new ClassCastException("Not A DBus Interface");
        }
        if (_type.getName().equals(_type.getSimpleName())) {
            throw new DBusException("DBusInterfaces cannot be declared outside a package");
        }
        RemoteObject ro = new RemoteObject(_busname, _objectpath, _type, _autostart);
        DBusInterface i = (DBusInterface)Proxy.newProxyInstance(_type.getClassLoader(), new Class[]{_type}, (InvocationHandler)new RemoteInvocationHandler(this, ro));
        this.getImportedObjects().put(i, ro);
        return (I)i;
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> _type, String _source, DBusSigHandler<T> _handler) throws DBusException {
        this.validateSignal(_type, _source);
        this.removeSigHandler(new DBusMatchRule(_type, _source, null), _handler);
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> _type, String _source, DBusInterface _object, DBusSigHandler<T> _handler) throws DBusException {
        this.validateSignal(_type, _source);
        String objectpath = this.getImportedObjects().get(_object).getObjectPath();
        if (objectpath.length() > 255 || !OBJECT_REGEX_PATTERN.matcher(objectpath).matches()) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        this.removeSigHandler(new DBusMatchRule(_type, _source, objectpath), _handler);
    }

    @Override
    protected <T extends DBusSignal> void removeSigHandler(DBusMatchRule _rule, DBusSigHandler<T> _handler) throws DBusException {
        Queue<DBusSigHandler<? extends DBusSignal>> dbusSignalList = this.getHandledSignals().get(_rule);
        if (null != dbusSignalList) {
            dbusSignalList.remove(_handler);
            if (dbusSignalList.isEmpty()) {
                this.getHandledSignals().remove(_rule);
                try {
                    this.dbus.RemoveMatch(_rule.toString());
                }
                catch (NotConnected _ex) {
                    this.logger.debug("No connection.", (Throwable)_ex);
                }
                catch (DBusExecutionException _ex) {
                    this.logger.debug("", (Throwable)_ex);
                    throw new DBusException(_ex);
                }
            }
        }
    }

    public <T extends DBusSignal> AutoCloseable addSigHandler(final Class<T> _type, final String _source, final DBusSigHandler<T> _handler) throws DBusException {
        this.validateSignal(_type, _source);
        this.addSigHandler(new DBusMatchRule(_type, _source, null), _handler);
        return new AutoCloseable(){

            @Override
            public void close() throws DBusException {
                DBusConnection.this.removeSigHandler(_type, _source, _handler);
            }
        };
    }

    public <T extends DBusSignal> AutoCloseable addSigHandler(final Class<T> _type, final String _source, final DBusInterface _object, final DBusSigHandler<T> _handler) throws DBusException {
        this.validateSignal(_type, _source);
        String objectpath = this.getImportedObjects().get(_object).getObjectPath();
        if (objectpath.length() > 255 || !OBJECT_REGEX_PATTERN.matcher(objectpath).matches()) {
            throw new DBusException("Invalid object path: " + objectpath);
        }
        this.addSigHandler(new DBusMatchRule(_type, _source, objectpath), _handler);
        return new AutoCloseable(){

            @Override
            public void close() throws DBusException {
                DBusConnection.this.removeSigHandler(_type, _source, _object, _handler);
            }
        };
    }

    private <T extends DBusSignal> void validateSignal(Class<T> _type, String _source) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(_type)) {
            throw new ClassCastException("Not A DBus Signal");
        }
        if (BUSNAME_REGEX.matcher(_source).matches()) {
            throw new DBusException("Cannot watch for signals based on well known bus name as source, only unique names.");
        }
        if (_source.length() > 255 || !CONNID_REGEX.matcher(_source).matches()) {
            throw new DBusException("Invalid bus name: " + _source);
        }
    }

    @Override
    public <T extends DBusSignal> AutoCloseable addSigHandler(final DBusMatchRule _rule, final DBusSigHandler<T> _handler) throws DBusException {
        Objects.requireNonNull(_rule, "Match rule cannot be null");
        Objects.requireNonNull(_handler, "Handler cannot be null");
        AtomicBoolean addMatch = new AtomicBoolean(false);
        Queue dbusSignalList = this.getHandledSignals().computeIfAbsent(_rule, v -> {
            ConcurrentLinkedQueue signalList = new ConcurrentLinkedQueue();
            addMatch.set(true);
            return signalList;
        });
        dbusSignalList.add(_handler);
        if (addMatch.get()) {
            try {
                this.dbus.AddMatch(_rule.toString());
            }
            catch (DBusExecutionException _ex) {
                this.logger.debug("Cannot add match rule: " + _rule.toString(), (Throwable)_ex);
                throw new DBusException("Cannot add match rule.", _ex);
            }
        }
        return new AutoCloseable(){

            @Override
            public void close() throws DBusException {
                DBusConnection.this.removeSigHandler(_rule, _handler);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        if (this.shared) {
            ConcurrentMap<String, DBusConnection> concurrentMap = CONNECTIONS;
            synchronized (concurrentMap) {
                DBusConnection connection = (DBusConnection)CONNECTIONS.get(this.getAddress().toString());
                if (connection != null) {
                    if (connection.getConcurrentConnections().get() <= 1) {
                        CONNECTIONS.remove(this.getAddress().toString());
                        super.disconnect();
                    } else {
                        this.logger.debug("Still {} connections left, decreasing connection counter", (Object)(connection.getConcurrentConnections().get() - 1));
                        Optional.ofNullable(this.getDisconnectCallback()).ifPresent(cb -> cb.requestedDisconnect(connection.getConcurrentConnections().get()));
                        connection.getConcurrentConnections().decrementAndGet();
                    }
                }
            }
        } else {
            IDisconnectAction beforeDisconnectAction = () -> {
                Map<String, ExportedObject> exportedObjects;
                List<String> list = this.busnames;
                synchronized (list) {
                    List<String> lBusNames = this.busnames.stream().filter(busName -> busName != null && busName.length() <= 255 && BUSNAME_REGEX.matcher((CharSequence)busName).matches()).collect(Collectors.toList());
                    lBusNames.forEach(busName -> {
                        try {
                            this.releaseBusName((String)busName);
                        }
                        catch (DBusException _ex) {
                            this.logger.error("Error while releasing busName '" + busName + "'.", (Throwable)_ex);
                        }
                    });
                }
                Map<String, ExportedObject> map = exportedObjects = this.getExportedObjects();
                synchronized (map) {
                    List exportedKeys = exportedObjects.keySet().stream().filter(f -> f != null).collect(Collectors.toList());
                    for (String key : exportedKeys) {
                        this.unExportObject(key);
                    }
                }
            };
            super.disconnect(beforeDisconnectAction, null);
        }
    }

    @Override
    public void close() throws IOException {
        this.disconnect();
    }

    @Override
    public String getMachineId() {
        return this.machineId;
    }

    @Override
    public void removeGenericSigHandler(DBusMatchRule _rule, DBusSigHandler<DBusSignal> _handler) throws DBusException {
        Queue<DBusSigHandler<DBusSignal>> genericSignalsList = this.getGenericHandledSignals().get(_rule);
        if (null != genericSignalsList) {
            genericSignalsList.remove(_handler);
            if (genericSignalsList.isEmpty()) {
                this.getGenericHandledSignals().remove(_rule);
                try {
                    this.dbus.RemoveMatch(_rule.toString());
                }
                catch (NotConnected _ex) {
                    this.logger.debug("No connection.", (Throwable)_ex);
                }
                catch (DBusExecutionException _ex) {
                    this.logger.debug("", (Throwable)_ex);
                    throw new DBusException(_ex);
                }
            }
        }
    }

    @Override
    public AutoCloseable addGenericSigHandler(final DBusMatchRule _rule, final DBusSigHandler<DBusSignal> _handler) throws DBusException {
        AtomicBoolean addMatch = new AtomicBoolean(false);
        Queue genericSignalsList = this.getGenericHandledSignals().computeIfAbsent(_rule, v -> {
            ConcurrentLinkedQueue signalsList = new ConcurrentLinkedQueue();
            addMatch.set(true);
            return signalsList;
        });
        genericSignalsList.add(_handler);
        if (addMatch.get()) {
            try {
                this.dbus.AddMatch(_rule.toString());
            }
            catch (DBusExecutionException _ex) {
                this.logger.debug("", (Throwable)_ex);
                throw new DBusException(_ex.getMessage());
            }
        }
        return new AutoCloseable(){

            @Override
            public void close() throws DBusException {
                DBusConnection.this.removeGenericSigHandler(_rule, _handler);
            }
        };
    }

    public static enum DBusBusType {
        SYSTEM,
        SESSION;

    }

    private class SigHandler
    implements DBusSigHandler<DBusSignal> {
        private SigHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(DBusSignal _signal) {
            if (_signal instanceof DBus.NameAcquired) {
                List<String> list = DBusConnection.this.busnames;
                synchronized (list) {
                    DBusConnection.this.busnames.add(((DBus.NameAcquired)_signal).name);
                }
            }
        }
    }
}

