/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.TypeKind;
import io.quarkus.gizmo2.impl.Box;
import io.quarkus.gizmo2.impl.CheckCast;
import io.quarkus.gizmo2.impl.If;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Preconditions;
import io.quarkus.gizmo2.impl.PrimitiveCast;
import io.quarkus.gizmo2.impl.Unbox;
import io.quarkus.gizmo2.impl.UncheckedCast;
import io.quarkus.gizmo2.impl.Util;
import java.io.Serializable;
import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

final class Conversions {
    private static final ClassDesc CD_Comparable = Util.classDesc(Comparable.class);
    private static final ClassDesc CD_Constable = Util.classDesc(Constable.class);
    private static final ClassDesc CD_ConstantDesc = Util.classDesc(ConstantDesc.class);
    private static final ClassDesc CD_Number = Util.classDesc(Number.class);
    private static final ClassDesc CD_Serializable = Util.classDesc(Serializable.class);
    private static final Map<ClassDesc, ClassDesc> boxTypes = Map.of(ConstantDescs.CD_boolean, ConstantDescs.CD_Boolean, ConstantDescs.CD_byte, ConstantDescs.CD_Byte, ConstantDescs.CD_char, ConstantDescs.CD_Character, ConstantDescs.CD_short, ConstantDescs.CD_Short, ConstantDescs.CD_int, ConstantDescs.CD_Integer, ConstantDescs.CD_long, ConstantDescs.CD_Long, ConstantDescs.CD_float, ConstantDescs.CD_Float, ConstantDescs.CD_double, ConstantDescs.CD_Double, ConstantDescs.CD_void, ConstantDescs.CD_Void);
    private static final Map<ClassDesc, Set<ClassDesc>> additionalBoxTypes = Map.of(ConstantDescs.CD_boolean, Set.of(ConstantDescs.CD_Object, CD_Comparable, CD_Constable, CD_Serializable), ConstantDescs.CD_byte, Set.of(ConstantDescs.CD_Object, CD_Number, CD_Comparable, CD_Constable, CD_Serializable), ConstantDescs.CD_char, Set.of(ConstantDescs.CD_Object, CD_Comparable, CD_Constable, CD_Serializable), ConstantDescs.CD_short, Set.of(ConstantDescs.CD_Object, CD_Number, CD_Comparable, CD_Constable, CD_Serializable), ConstantDescs.CD_int, Set.of(ConstantDescs.CD_Object, CD_Number, CD_Comparable, CD_Constable, CD_ConstantDesc, CD_Serializable), ConstantDescs.CD_long, Set.of(ConstantDescs.CD_Object, CD_Number, CD_Comparable, CD_Constable, CD_ConstantDesc, CD_Serializable), ConstantDescs.CD_float, Set.of(ConstantDescs.CD_Object, CD_Number, CD_Comparable, CD_Constable, CD_ConstantDesc, CD_Serializable), ConstantDescs.CD_double, Set.of(ConstantDescs.CD_Object, CD_Number, CD_Comparable, CD_Constable, CD_ConstantDesc, CD_Serializable), ConstantDescs.CD_void, Set.of(ConstantDescs.CD_Object));
    private static final Map<ClassDesc, ClassDesc> unboxTypes = Util.reverseMap(boxTypes);
    private static final Map<ClassDesc, Set<ClassDesc>> primitiveWideningConversions = Map.of(ConstantDescs.CD_boolean, Set.of(), ConstantDescs.CD_byte, Set.of(ConstantDescs.CD_short, ConstantDescs.CD_int, ConstantDescs.CD_long, ConstantDescs.CD_float, ConstantDescs.CD_double), ConstantDescs.CD_char, Set.of(ConstantDescs.CD_int, ConstantDescs.CD_long, ConstantDescs.CD_float, ConstantDescs.CD_double), ConstantDescs.CD_short, Set.of(ConstantDescs.CD_int, ConstantDescs.CD_long, ConstantDescs.CD_float, ConstantDescs.CD_double), ConstantDescs.CD_int, Set.of(ConstantDescs.CD_long, ConstantDescs.CD_float, ConstantDescs.CD_double), ConstantDescs.CD_long, Set.of(ConstantDescs.CD_float, ConstantDescs.CD_double), ConstantDescs.CD_float, Set.of(ConstantDescs.CD_double), ConstantDescs.CD_double, Set.of(), ConstantDescs.CD_void, Set.of());

    Conversions() {
    }

    static boolean isPrimitive(ClassDesc type) {
        return boxTypes.containsKey(type);
    }

    static boolean isPrimitiveWrapper(ClassDesc type) {
        return unboxTypes.containsKey(type);
    }

    static Optional<ClassDesc> boxingConversion(ClassDesc type) {
        return Optional.ofNullable(boxTypes.get(type));
    }

    static Optional<ClassDesc> unboxingConversion(ClassDesc type) {
        return Optional.ofNullable(unboxTypes.get(type));
    }

    static Item convert(Expr expr, ClassDesc toType) {
        Item item = (Item)expr;
        ClassDesc fromType = item.type();
        if (fromType.equals(toType)) {
            return item;
        }
        if (toType.equals(boxTypes.get(fromType))) {
            return new Box(item);
        }
        if (fromType.isPrimitive() && additionalBoxTypes.get(fromType).contains(toType)) {
            return new Box((Expr)item, toType);
        }
        if (fromType.isPrimitive() && unboxTypes.containsKey(toType)) {
            ClassDesc widerType = unboxTypes.get(toType);
            if (primitiveWideningConversions.get(fromType).contains(widerType)) {
                return new Box(new PrimitiveCast(item, GenericType.of(widerType)));
            }
        } else {
            if (toType.equals(unboxTypes.get(fromType))) {
                return new Unbox(item);
            }
            if (toType.isPrimitive() && unboxTypes.containsKey(fromType) && primitiveWideningConversions.get(unboxTypes.get(fromType)).contains(toType)) {
                return new PrimitiveCast(new Unbox(item), GenericType.of(toType));
            }
            if (fromType.isPrimitive() && toType.isPrimitive() && primitiveWideningConversions.get(fromType).contains(toType)) {
                return new PrimitiveCast(item, GenericType.of(toType));
            }
            if (!fromType.isPrimitive() && ConstantDescs.CD_Object.equals(toType)) {
                return new UncheckedCast(item, GenericType.of(toType));
            }
            if (ConstantDescs.CD_Object.equals(fromType) && !toType.isPrimitive()) {
                return new CheckCast(item, GenericType.of(toType));
            }
            if (ConstantDescs.CD_Object.equals(fromType) && toType.isPrimitive()) {
                return new Unbox(new CheckCast(item, GenericType.of(boxTypes.get(toType))));
            }
        }
        Preconditions.requireSameLoadableTypeKind(fromType, toType);
        return item;
    }

    static Optional<ClassDesc> numericPromotion(ClassDesc a, ClassDesc b) {
        if (a.isClassOrInterface()) {
            a = unboxTypes.getOrDefault(a, a);
        }
        if (b.isClassOrInterface()) {
            b = unboxTypes.getOrDefault(b, b);
        }
        if (a.isPrimitive() && b.isPrimitive()) {
            TypeKind aKind = TypeKind.from(a);
            TypeKind bKind = TypeKind.from(b);
            if (aKind == TypeKind.DOUBLE || bKind == TypeKind.DOUBLE) {
                return Optional.of(ConstantDescs.CD_double);
            }
            if (aKind == TypeKind.FLOAT || bKind == TypeKind.FLOAT) {
                return Optional.of(ConstantDescs.CD_float);
            }
            if (aKind == TypeKind.LONG || bKind == TypeKind.LONG) {
                return Optional.of(ConstantDescs.CD_long);
            }
            return Optional.of(ConstantDescs.CD_int);
        }
        return Optional.empty();
    }

    static boolean numericPromotionRequired(If.Kind kind, ClassDesc a, ClassDesc b) {
        if (kind != If.Kind.EQ && kind != If.Kind.NE) {
            return true;
        }
        return a.isPrimitive() && !ConstantDescs.CD_boolean.equals(a) || b.isPrimitive() && !ConstantDescs.CD_boolean.equals(b);
    }
}

