/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.sessions.infinispan.AuthenticationSessionAdapter;
import org.keycloak.models.sessions.infinispan.InfinispanAuthenticationSessionProvider;
import org.keycloak.models.sessions.infinispan.SessionEntityUpdater;
import org.keycloak.models.sessions.infinispan.changes.RootAuthenticationSessionUpdateTask;
import org.keycloak.models.sessions.infinispan.entities.AuthenticationSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.RootAuthenticationSessionEntity;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class RootAuthenticationSessionAdapter
implements RootAuthenticationSessionModel {
    private static final Logger log = Logger.getLogger(RootAuthenticationSessionAdapter.class);
    private final KeycloakSession session;
    private final RealmModel realm;
    private final int authSessionsLimit;
    private final InfinispanAuthenticationSessionProvider provider;
    private final RootAuthenticationSessionEntity entity;
    private static final Comparator<Map.Entry<String, AuthenticationSessionEntity>> TIMESTAMP_COMPARATOR = Comparator.comparingInt(e -> ((AuthenticationSessionEntity)e.getValue()).getTimestamp());

    public RootAuthenticationSessionAdapter(KeycloakSession session, InfinispanAuthenticationSessionProvider provider, RealmModel realm, RootAuthenticationSessionEntity entity, int authSessionsLimit) {
        this.session = session;
        this.provider = provider;
        this.entity = entity;
        this.realm = realm;
        this.authSessionsLimit = authSessionsLimit;
    }

    void update(RootAuthenticationSessionUpdateTask task) {
        this.provider.getRootAuthSessionTransaction().addTask(this.entity.getId(), task);
    }

    public String getId() {
        return this.entity.getId();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public int getTimestamp() {
        return this.entity.getTimestamp();
    }

    public void setTimestamp(final int timestamp) {
        RootAuthenticationSessionUpdateTask task = new RootAuthenticationSessionUpdateTask(){

            @Override
            public void runUpdate(RootAuthenticationSessionEntity entity) {
                entity.setTimestamp(timestamp);
            }
        };
        this.update(task);
    }

    public Map<String, AuthenticationSessionModel> getAuthenticationSessions() {
        HashMap<String, AuthenticationSessionModel> result = new HashMap<String, AuthenticationSessionModel>();
        for (Map.Entry<String, AuthenticationSessionEntity> entry : this.entity.getAuthenticationSessions().entrySet()) {
            String tabId = entry.getKey();
            result.put(tabId, new AuthenticationSessionAdapter(this.session, this, new AuthenticationSessionUpdater(this, tabId, entry.getValue()), tabId));
        }
        return result;
    }

    public AuthenticationSessionModel getAuthenticationSession(ClientModel client, String tabId) {
        if (client == null || tabId == null) {
            return null;
        }
        AuthenticationSessionModel authSession = this.getAuthenticationSessions().get(tabId);
        if (authSession != null && client.equals(authSession.getClient())) {
            this.session.getContext().setAuthenticationSession(authSession);
            return authSession;
        }
        return null;
    }

    public AuthenticationSessionModel createAuthenticationSession(ClientModel client) {
        Objects.requireNonNull(client, "client");
        final AuthenticationSessionEntity authSessionEntity = new AuthenticationSessionEntity();
        authSessionEntity.setClientUUID(client.getId());
        final String tabId = Base64Url.encode((byte[])SecretGenerator.getInstance().randomBytes(8));
        final int timestamp = Time.currentTime();
        RootAuthenticationSessionUpdateTask task = new RootAuthenticationSessionUpdateTask(){

            @Override
            public void runUpdate(RootAuthenticationSessionEntity entity) {
                String tabId2;
                Map<String, AuthenticationSessionEntity> authenticationSessions = entity.getAuthenticationSessions();
                if (authenticationSessions.size() >= RootAuthenticationSessionAdapter.this.authSessionsLimit && (tabId2 = (String)authenticationSessions.entrySet().stream().min(TIMESTAMP_COMPARATOR).map(Map.Entry::getKey).orElse(null)) != null) {
                    log.debugf("Reached limit (%s) of active authentication sessions per a root authentication session. Removing oldest authentication session with TabId %s.", RootAuthenticationSessionAdapter.this.authSessionsLimit, (Object)tabId2);
                    authenticationSessions.remove(tabId2);
                }
                authSessionEntity.setTimestamp(timestamp);
                authenticationSessions.put(tabId, authSessionEntity);
                entity.setTimestamp(timestamp);
            }
        };
        this.update(task);
        AuthenticationSessionAdapter authSession = new AuthenticationSessionAdapter(this.session, this, new AuthenticationSessionUpdater(this, tabId, authSessionEntity), tabId);
        this.session.getContext().setAuthenticationSession((AuthenticationSessionModel)authSession);
        return authSession;
    }

    public void removeAuthenticationSessionByTabId(final String tabId) {
        if (this.entity.getAuthenticationSessions().remove(tabId) != null) {
            if (this.entity.getAuthenticationSessions().isEmpty()) {
                this.provider.removeRootAuthenticationSession(this.realm, this);
            } else {
                final int currentTime = Time.currentTime();
                RootAuthenticationSessionUpdateTask task = new RootAuthenticationSessionUpdateTask(){

                    @Override
                    public void runUpdate(RootAuthenticationSessionEntity entity) {
                        entity.getAuthenticationSessions().remove(tabId);
                        entity.setTimestamp(currentTime);
                    }

                    @Override
                    public boolean shouldRemove(RootAuthenticationSessionEntity entity) {
                        return entity.getAuthenticationSessions().isEmpty();
                    }
                };
                this.update(task);
            }
        }
    }

    public void restartSession(RealmModel realm) {
        RootAuthenticationSessionUpdateTask task = new RootAuthenticationSessionUpdateTask(){

            @Override
            public void runUpdate(RootAuthenticationSessionEntity entity) {
                entity.getAuthenticationSessions().clear();
                entity.setTimestamp(Time.currentTime());
            }
        };
        this.update(task);
    }

    private record AuthenticationSessionUpdater(RootAuthenticationSessionAdapter adapter, String tabId, AuthenticationSessionEntity authenticationSession) implements SessionEntityUpdater<AuthenticationSessionEntity>
    {
        @Override
        public AuthenticationSessionEntity getEntity() {
            return this.authenticationSession;
        }

        @Override
        public void onEntityUpdated() {
            RootAuthenticationSessionUpdateTask task = new RootAuthenticationSessionUpdateTask(){

                @Override
                public void runUpdate(RootAuthenticationSessionEntity entity) {
                    entity.getAuthenticationSessions().put(tabId, authenticationSession);
                }
            };
            this.adapter.update(task);
        }

        @Override
        public void onEntityRemoved() {
        }
    }
}

