/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import jakarta.persistence.criteria.Expression;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Internal;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.SqmCastTarget;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;

public interface SqmExpression<T>
extends SqmSelectableNode<T>,
JpaExpression<T> {
    @Override
    public @Nullable SqmBindableType<T> getNodeType();

    @Internal
    public void applyInferableType(@Nullable SqmBindableType<?> var1);

    @Override
    default public void visitSubSelectableNodes(Consumer<SqmSelectableNode<?>> jpaSelectionConsumer) {
        jpaSelectionConsumer.accept(this);
    }

    public SqmExpression<Long> asLong();

    public SqmExpression<Integer> asInteger();

    public SqmExpression<Float> asFloat();

    public SqmExpression<Double> asDouble();

    public SqmExpression<BigDecimal> asBigDecimal();

    public SqmExpression<BigInteger> asBigInteger();

    public SqmExpression<String> asString();

    @Override
    public <X> SqmExpression<X> as(Class<X> var1);

    @Override
    public SqmPredicate isNull();

    @Override
    public SqmPredicate isNotNull();

    @Override
    public SqmPredicate equalTo(Expression<?> var1);

    @Override
    public SqmPredicate equalTo(Object var1);

    @Override
    public SqmPredicate in(Object ... var1);

    @Override
    public SqmPredicate in(Expression<?> ... var1);

    @Override
    public SqmPredicate in(Collection<?> var1);

    @Override
    public SqmPredicate in(Expression<Collection<?>> var1);

    @Override
    public SqmExpression<T> copy(SqmCopyContext var1);

    default public <X> SqmExpression<X> castAs(DomainType<X> type) {
        if (this.getNodeType() == type) {
            SqmExpression castExpression = this;
            return castExpression;
        }
        QueryEngine queryEngine = this.nodeBuilder().getQueryEngine();
        SqmCastTarget target = new SqmCastTarget((ReturnableType)type, this.nodeBuilder());
        return queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("cast").generateSqmExpression(Arrays.asList(this, target), (ReturnableType)type, queryEngine);
    }

    @Override
    default public <X> SqmExpression<X> cast(Class<X> type) {
        return this.castAs(this.nodeBuilder().getTypeConfiguration().getBasicTypeForJavaType(type));
    }

    @Override
    public JpaPredicate notEqualTo(Expression<?> var1);

    @Override
    public JpaPredicate notEqualTo(Object var1);
}

