/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;

public class ForUpdateFragment {
    private final StringBuilder lockItemFragment = new StringBuilder();
    private final Dialect dialect;
    private final LockOptions lockOptions;

    public ForUpdateFragment(Dialect dialect, LockOptions lockOptions, Map<String, String[]> keyColumnNameMap) {
        this.dialect = dialect;
        this.lockOptions = lockOptions;
        if (lockOptions.getLockMode() == LockMode.NONE) {
            return;
        }
        if (CollectionHelper.isEmpty(keyColumnNameMap)) {
            return;
        }
        RowLockStrategy lockStrategy = dialect.getWriteRowLockStrategy();
        if (lockStrategy == RowLockStrategy.NONE) {
            return;
        }
        keyColumnNameMap.forEach((tableAlias, keyColumnNames) -> {
            if (lockStrategy == RowLockStrategy.TABLE) {
                this.addLockItem((String)tableAlias);
            } else {
                assert (lockStrategy == RowLockStrategy.COLUMN);
                for (String keyColumnReference : StringHelper.qualify(tableAlias, keyColumnNames)) {
                    this.addLockItem(keyColumnReference);
                }
            }
        });
    }

    public ForUpdateFragment addTableAlias(String alias) {
        this.addLockItem(alias);
        return this;
    }

    public ForUpdateFragment addLockItem(String itemText) {
        if (!this.lockItemFragment.isEmpty()) {
            this.lockItemFragment.append(", ");
        }
        this.lockItemFragment.append(itemText);
        return this;
    }

    public String toFragmentString() {
        if (this.lockItemFragment.isEmpty()) {
            return this.dialect.getForUpdateString(this.lockOptions);
        }
        return this.dialect.getForUpdateString(this.lockItemFragment.toString(), this.lockOptions);
    }
}

