/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.util;

import java.util.Map;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.model.ResourceReader;
import org.jboss.resteasy.reactive.common.model.ResourceWriter;

public abstract class DeploymentUtils {
    private static final Map<String, Class<?>> primitiveTypes = Map.of(Byte.TYPE.getName(), Byte.TYPE, Boolean.TYPE.getName(), Boolean.TYPE, Character.TYPE.getName(), Character.TYPE, Short.TYPE.getName(), Short.TYPE, Integer.TYPE.getName(), Integer.TYPE, Float.TYPE.getName(), Float.TYPE, Double.TYPE.getName(), Double.TYPE, Long.TYPE.getName(), Long.TYPE);

    public static void registerWriter(Serialisers serialisers, String entityClassName, ResourceWriter writer) {
        serialisers.addWriter(DeploymentUtils.loadClass(entityClassName), writer);
    }

    public static void registerReader(Serialisers serialisers, String entityClassName, ResourceReader reader) {
        serialisers.addReader(DeploymentUtils.loadClass(entityClassName), reader);
    }

    public static <T> Class<T> loadClass(String name) {
        if (primitiveTypes.containsKey(name)) {
            return primitiveTypes.get(name);
        }
        try {
            return Class.forName(name, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

