/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.actiontoken.updateemail.UpdateEmailActionToken;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Time;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsPages;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.forms.login.freemarker.Templates;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionConfigModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.services.Urls;
import org.keycloak.services.validation.Validation;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.userprofile.AttributeChangeListener;
import org.keycloak.userprofile.EventAuditingAttributeChangeListener;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.ValidationException;

public class UpdateEmail
implements RequiredActionProvider,
RequiredActionFactory,
EnvironmentDependentProviderFactory {
    private static final Logger logger = Logger.getLogger(UpdateEmail.class);
    public static final String CONFIG_VERIFY_EMAIL = "verifyEmail";
    private static final String FORCE_EMAIL_VERIFICATION = "forceEmailVerification";

    public static boolean isEnabled(RealmModel realm) {
        if (realm == null) {
            return false;
        }
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.UPDATE_EMAIL)) {
            return false;
        }
        RequiredActionProviderModel model = realm.getRequiredActionProviderByAlias(UserModel.RequiredAction.UPDATE_EMAIL.name());
        return model != null && model.isEnabled();
    }

    public static boolean isVerifyEmailEnabled(RealmModel realm) {
        if (!UpdateEmail.isEnabled(realm)) {
            return false;
        }
        RequiredActionConfigModel config = realm.getRequiredActionConfigByAlias(UserModel.RequiredAction.UPDATE_EMAIL.name());
        if (config == null) {
            return false;
        }
        return UpdateEmail.isVerifyEmailEnabled(realm, config);
    }

    public static void forceEmailVerification(KeycloakSession session) {
        session.setAttribute(FORCE_EMAIL_VERIFICATION, (Object)true);
    }

    private static boolean isVerifyEmailEnabled(RealmModel realm, RequiredActionConfigModel config) {
        boolean forceVerifyEmail = Boolean.parseBoolean(config.getConfigValue(CONFIG_VERIFY_EMAIL, Boolean.FALSE.toString()));
        return forceVerifyEmail || realm.isVerifyEmail();
    }

    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.SUPPORTED;
    }

    public String getDisplayText() {
        return "Update Email";
    }

    public void evaluateTriggers(RequiredActionContext context) {
        UserModel user = context.getUser();
        if (user.getFirstAttribute("kc.email.pending") != null) {
            user.addRequiredAction(UserModel.RequiredAction.UPDATE_EMAIL);
            return;
        }
        Stream actions = user.getRequiredActionsStream();
        if (actions.anyMatch(UserModel.RequiredAction.UPDATE_EMAIL.name()::equals)) {
            user.removeRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
        }
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        if (UpdateEmail.isEnabled(context.getRealm())) {
            UserModel user;
            UserProfileProvider profileProvider = (UserProfileProvider)context.getSession().getProvider(UserProfileProvider.class);
            UserProfile profile = profileProvider.create(UserProfileContext.UPDATE_EMAIL, user = context.getUser());
            if (profile.getAttributes().isReadOnly("email")) {
                user.removeRequiredAction(UserModel.RequiredAction.UPDATE_EMAIL);
                return;
            }
            MultivaluedHashMap formData = new MultivaluedHashMap(context.getHttpRequest().getDecodedFormParameters());
            String newEmail = (String)formData.getFirst((Object)"email");
            if (newEmail != null) {
                user.removeRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
                this.sendEmailUpdateConfirmation(context, false);
            } else {
                String pendingEmail = this.getPendingEmailVerification(context);
                if (pendingEmail != null) {
                    MultivaluedHashMap formDataWithPendingEmail = new MultivaluedHashMap();
                    formDataWithPendingEmail.putSingle((Object)"email", (Object)pendingEmail);
                    context.challenge(context.form().setInfo("emailVerificationPending", new Object[]{pendingEmail}).setFormData((MultivaluedMap)formDataWithPendingEmail).createResponse(UserModel.RequiredAction.UPDATE_EMAIL));
                } else {
                    context.challenge(context.form().createResponse(UserModel.RequiredAction.UPDATE_EMAIL));
                }
            }
        }
    }

    public void processAction(RequiredActionContext context) {
        UserProfile emailUpdateValidationResult;
        if (!UpdateEmail.isEnabled(context.getRealm())) {
            return;
        }
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String newEmail = (String)formData.getFirst((Object)"email");
        RealmModel realm = context.getRealm();
        UserModel user = context.getUser();
        try {
            emailUpdateValidationResult = UpdateEmail.validateEmailUpdate(context.getSession(), user, newEmail);
        }
        catch (ValidationException pve) {
            List<FormMessage> errors = Validation.getFormErrorsFromValidation(pve.getErrors());
            context.challenge(context.form().setErrors(errors).setFormData(formData).createResponse(UserModel.RequiredAction.UPDATE_EMAIL));
            return;
        }
        boolean logoutSessions = "on".equals(formData.getFirst((Object)"logout-sessions"));
        if (!UpdateEmail.isVerifyEmailEnabled(realm, context.getConfig()) || Validation.isBlank(newEmail) || Objects.equals(user.getEmail(), newEmail) && user.isEmailVerified()) {
            if (logoutSessions) {
                AuthenticatorUtil.logoutOtherSessions(context);
            }
            this.updateEmailWithoutConfirmation(context, emailUpdateValidationResult);
            return;
        }
        this.sendEmailUpdateConfirmation(context, logoutSessions);
    }

    private void sendEmailUpdateConfirmation(RequiredActionContext context, boolean logoutSessions) {
        UserModel user = context.getUser();
        String oldEmail = user.getEmail();
        String newEmail = (String)context.getHttpRequest().getDecodedFormParameters().getFirst((Object)"email");
        RealmModel realm = context.getRealm();
        int validityInSecs = realm.getActionTokenGeneratedByUserLifespan("update-email");
        UriInfo uriInfo = context.getUriInfo();
        KeycloakSession session = context.getSession();
        AuthenticationSessionModel authenticationSession = context.getAuthenticationSession();
        UpdateEmailActionToken actionToken = new UpdateEmailActionToken(user.getId(), Time.currentTime() + validityInSecs, oldEmail, newEmail, authenticationSession.getClient().getClientId(), logoutSessions, authenticationSession.getRedirectUri());
        String link = Urls.actionTokenBuilder(uriInfo.getBaseUri(), actionToken.serialize(session, realm, uriInfo), authenticationSession.getClient().getClientId(), authenticationSession.getTabId(), AuthenticationProcessor.getClientData(session, authenticationSession)).build(new Object[]{realm.getName()}).toString();
        context.getEvent().event(EventType.SEND_VERIFY_EMAIL).detail("email", newEmail);
        try {
            ((EmailTemplateProvider)session.getProvider(EmailTemplateProvider.class)).setAuthenticationSession(authenticationSession).setRealm(realm).setUser(user).sendEmailUpdateConfirmation(link, TimeUnit.SECONDS.toMinutes(validityInSecs), newEmail);
        }
        catch (EmailException e) {
            logger.error((Object)"Failed to send email for email update", (Throwable)e);
            context.getEvent().error("email_send_failed");
            context.failure("emailSendErrorMessage");
            context.challenge(context.form().setError("emailSendErrorMessage", new Object[0]).createErrorPage(Response.Status.INTERNAL_SERVER_ERROR));
            return;
        }
        context.getEvent().success();
        this.setPendingEmailVerification(context, newEmail);
        LoginFormsProvider forms = context.form();
        context.challenge(forms.setAttribute("messageHeader", (Object)forms.getMessage("emailUpdateConfirmationSentTitle", new Object[0])).setInfo("emailUpdateConfirmationSent", new Object[]{newEmail}).createForm(Templates.getTemplate(LoginFormsPages.INFO)));
    }

    private void updateEmailWithoutConfirmation(RequiredActionContext context, UserProfile emailUpdateValidationResult) {
        UpdateEmail.updateEmailNow(context.getEvent(), context.getUser(), emailUpdateValidationResult);
        this.clearPendingEmailVerification(context);
        context.success();
    }

    public static UserProfile validateEmailUpdate(KeycloakSession session, UserModel user, String newEmail) {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.putSingle((Object)"username", (Object)user.getUsername());
        formData.putSingle((Object)"email", (Object)newEmail);
        UserProfileProvider profileProvider = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
        UserProfile profile = profileProvider.create(UserProfileContext.UPDATE_EMAIL, (Map)formData, user);
        profile.validate();
        return profile;
    }

    public static void updateEmailNow(EventBuilder event, UserModel user, UserProfile emailUpdateValidationResult) {
        user.removeRequiredAction(UserModel.RequiredAction.UPDATE_EMAIL);
        String oldEmail = user.getEmail();
        String newEmail = emailUpdateValidationResult.getAttributes().getFirst("email");
        event.event(EventType.UPDATE_EMAIL).detail("previous_email", oldEmail).detail("updated_email", newEmail);
        emailUpdateValidationResult.update(false, new AttributeChangeListener[]{new EventAuditingAttributeChangeListener(emailUpdateValidationResult, event)});
        user.removeAttribute("kc.email.pending");
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return UserModel.RequiredAction.UPDATE_EMAIL.name();
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        ArrayList<ProviderConfigProperty> config = new ArrayList<ProviderConfigProperty>(RequiredActionFactory.MAX_AUTH_AGE_CONFIG_PROPERTIES);
        config.addAll(ProviderConfigurationBuilder.create().property().name(CONFIG_VERIFY_EMAIL).label("Force Email Verification").helpText("If enabled, the user will be forced to verify the email regardless if email verification is enabled at the realm level or not. Otherwise, verification will be based on the realm level setting.").type("boolean").defaultValue((Object)Boolean.FALSE).add().build());
        return config;
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.UPDATE_EMAIL);
    }

    private void setPendingEmailVerification(RequiredActionContext context, String email) {
        UserModel user = context.getUser();
        user.setSingleAttribute("kc.email.pending", email);
        user.setEmailVerified(false);
    }

    private String getPendingEmailVerification(RequiredActionContext context) {
        return context.getUser().getFirstAttribute("kc.email.pending");
    }

    private void clearPendingEmailVerification(RequiredActionContext context) {
        context.getUser().removeAttribute("kc.email.pending");
    }
}

