/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import java.util.Collections;
import java.util.List;
import org.hibernate.Incubating;
import org.hibernate.Internal;
import org.hibernate.query.Order;
import org.hibernate.query.Page;

@Incubating
public class KeyedPage<R> {
    private final List<Order<? super R>> keyDefinition;
    private final Page page;
    private final List<Comparable<?>> key;
    private final KeyInterpretation keyInterpretation;

    KeyedPage(List<Order<? super R>> keyDefinition, Page page) {
        this(keyDefinition, page, null, KeyInterpretation.NO_KEY);
    }

    KeyedPage(List<Order<? super R>> keyDefinition, Page page, List<Comparable<?>> key, KeyInterpretation interpretation) {
        this.keyDefinition = Collections.unmodifiableList(keyDefinition);
        this.page = page;
        this.key = key;
        this.keyInterpretation = interpretation;
    }

    public List<Order<? super R>> getKeyDefinition() {
        return this.keyDefinition;
    }

    public Page getPage() {
        return this.page;
    }

    public List<Comparable<?>> getKey() {
        return this.key;
    }

    public KeyInterpretation getKeyInterpretation() {
        return this.keyInterpretation;
    }

    @Internal
    public KeyedPage<R> nextPage(List<Comparable<?>> keyOfLastResultOnThisPage) {
        return new KeyedPage<R>(this.keyDefinition, this.page.next(), keyOfLastResultOnThisPage, KeyInterpretation.KEY_OF_LAST_ON_PREVIOUS_PAGE);
    }

    @Internal
    public KeyedPage<R> previousPage(List<Comparable<?>> keyOfFirstResultOnThisPage) {
        if (this.page.isFirst()) {
            return null;
        }
        return new KeyedPage<R>(this.keyDefinition, this.page.previous(), keyOfFirstResultOnThisPage, KeyInterpretation.KEY_OF_FIRST_ON_NEXT_PAGE);
    }

    @Internal
    public KeyedPage<R> withKey(List<Comparable<?>> key, KeyInterpretation interpretation) {
        return new KeyedPage<R>(this.keyDefinition, this.page, key, interpretation);
    }

    public static enum KeyInterpretation {
        KEY_OF_LAST_ON_PREVIOUS_PAGE,
        KEY_OF_FIRST_ON_NEXT_PAGE,
        NO_KEY;

    }
}

