/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import java.text.MessageFormat;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class MessageFunction
implements Function {
    @Override
    public String getCanonicalName() {
        return "MESSAGE";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type type1 = parameters.getType(0);
        Object value1 = parameters.getValue(0);
        String message = context.getTypeRegistry().convertToText(type1, value1);
        MessageFormat format = new MessageFormat(message, context.getLocalizationContext().getLocale());
        Object[] args = new Object[parameterCount - 1];
        for (int i = 1; i < parameterCount; ++i) {
            args[i - 1] = parameters.getValue(i);
        }
        return new TypeValuePair(TextType.TYPE, format.format(args));
    }
}

