/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.cluster;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.Messages;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.www.SlaveServerDetection;
import org.pentaho.di.www.SlaveServerJobStatus;
import org.pentaho.di.www.SlaveServerStatus;
import org.pentaho.di.www.SlaveServerTransStatus;
import org.pentaho.di.www.WebResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlaveServer
extends ChangedFlag
implements Cloneable,
SharedObjectInterface,
VariableSpace {
    public static final String XML_TAG = "slaveserver";
    private static LogWriter log = LogWriter.getInstance();
    private String name;
    private String hostname;
    private String port;
    private String username;
    private String password;
    private String proxyHostname;
    private String proxyPort;
    private String nonProxyHosts;
    private boolean master;
    private boolean shared;
    private long id;
    private VariableSpace variables = new Variables();

    public SlaveServer() {
        this.initializeVariablesFrom(null);
        this.id = -1L;
    }

    public SlaveServer(String name, String hostname, String port, String username, String password) {
        this(name, hostname, port, username, password, null, null, null, false);
    }

    public SlaveServer(String name, String hostname, String port, String username, String password, String proxyHostname, String proxyPort, String nonProxyHosts, boolean master) {
        this();
        this.name = name;
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
        this.proxyHostname = proxyHostname;
        this.proxyPort = proxyPort;
        this.nonProxyHosts = nonProxyHosts;
        this.master = master;
        this.initializeVariablesFrom(null);
    }

    public SlaveServer(Node slaveNode) {
        this();
        this.name = XMLHandler.getTagValue((Node)slaveNode, (String)"name");
        this.hostname = XMLHandler.getTagValue((Node)slaveNode, (String)"hostname");
        this.port = XMLHandler.getTagValue((Node)slaveNode, (String)"port");
        this.username = XMLHandler.getTagValue((Node)slaveNode, (String)"username");
        this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)slaveNode, (String)"password"));
        this.proxyHostname = XMLHandler.getTagValue((Node)slaveNode, (String)"proxy_hostname");
        this.proxyPort = XMLHandler.getTagValue((Node)slaveNode, (String)"proxy_port");
        this.nonProxyHosts = XMLHandler.getTagValue((Node)slaveNode, (String)"non_proxy_hosts");
        this.master = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)slaveNode, (String)"master"));
        this.initializeVariablesFrom(null);
    }

    public String getXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<").append(XML_TAG).append(">");
        xml.append(XMLHandler.addTagValue((String)"name", (String)this.name, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"hostname", (String)this.hostname, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"port", (String)this.port, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"username", (String)this.username, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password), (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"proxy_hostname", (String)this.proxyHostname, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"proxy_port", (String)this.proxyPort, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"non_proxy_hosts", (String)this.nonProxyHosts, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"master", (boolean)this.master, (boolean)false));
        xml.append("</").append(XML_TAG).append(">");
        return xml.toString();
    }

    public void saveRep(Repository rep) throws KettleException {
        this.saveRep(rep, -1L, false);
    }

    public void saveRep(Repository rep, long id_transformation, boolean isUsedByTransformation) throws KettleException {
        this.setId(rep.getSlaveID(this.name));
        if (this.getId() < 0L) {
            this.setId(rep.insertSlave(this));
        } else {
            rep.updateSlave(this);
        }
        if (id_transformation >= 0L && isUsedByTransformation) {
            rep.insertTransformationSlave(id_transformation, this.getId());
        }
    }

    public SlaveServer(Repository rep, long id_slave_server) throws KettleException {
        this();
        this.setId(id_slave_server);
        RowMetaAndData row = rep.getSlaveServer(id_slave_server);
        if (row == null) {
            throw new KettleDatabaseException(Messages.getString("SlaveServer.SlaveCouldNotBeFound", Long.toString(id_slave_server)));
        }
        this.name = row.getString("NAME", null);
        this.hostname = row.getString("HOST_NAME", null);
        this.port = row.getString("PORT", null);
        this.username = row.getString("USERNAME", null);
        this.password = row.getString("PASSWORD", null);
        this.proxyHostname = row.getString("PROXY_HOST_NAME", null);
        this.proxyPort = row.getString("PROXY_PORT", null);
        this.nonProxyHosts = row.getString("NON_PROXY_HOSTS", null);
        this.master = row.getBoolean("MASTER", false);
    }

    public Object clone() {
        SlaveServer slaveServer = new SlaveServer();
        slaveServer.replaceMeta(this);
        return slaveServer;
    }

    public void replaceMeta(SlaveServer slaveServer) {
        this.name = slaveServer.name;
        this.hostname = slaveServer.hostname;
        this.port = slaveServer.port;
        this.username = slaveServer.username;
        this.password = slaveServer.password;
        this.proxyHostname = slaveServer.proxyHostname;
        this.proxyPort = slaveServer.proxyPort;
        this.nonProxyHosts = slaveServer.nonProxyHosts;
        this.master = slaveServer.master;
        this.id = slaveServer.id;
        this.shared = slaveServer.shared;
        this.setChanged(true);
    }

    public String toString() {
        return this.name;
    }

    public String getServerAndPort() {
        String realHostname = this.environmentSubstitute(this.hostname);
        if (!Const.isEmpty((String)realHostname)) {
            return realHostname + this.getPortSpecification();
        }
        return "Slave Server";
    }

    public boolean equals(Object obj) {
        SlaveServer slave = (SlaveServer)obj;
        return this.name.equalsIgnoreCase(slave.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String urlString) {
        this.hostname = urlString;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public void setNonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }

    public String getProxyHostname() {
        return this.proxyHostname;
    }

    public void setProxyHostname(String proxyHostname) {
        this.proxyHostname = proxyHostname;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getPortSpecification() {
        String realPort = this.environmentSubstitute(this.port);
        String portSpec = ":" + realPort;
        if (Const.isEmpty((String)realPort) || this.port.equals("80")) {
            portSpec = "";
        }
        return portSpec;
    }

    public String constructUrl(String serviceAndArguments) throws UnsupportedEncodingException {
        String realHostname = this.environmentSubstitute(this.hostname);
        String retval = "http://" + realHostname + this.getPortSpecification() + serviceAndArguments;
        retval = Const.replace((String)retval, (String)" ", (String)"%20");
        return retval;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public PutMethod getSendByteArrayMethod(byte[] content, String service) throws Exception {
        String urlString = this.constructUrl(service);
        log.logDebug(this.toString(), Messages.getString("SlaveServer.DEBUG_ConnectingTo", urlString), new Object[0]);
        PutMethod putMethod = new PutMethod(urlString);
        ByteArrayRequestEntity entity = new ByteArrayRequestEntity(content);
        putMethod.setRequestEntity((RequestEntity)entity);
        putMethod.setDoAuthentication(true);
        putMethod.addRequestHeader(new Header("Content-Type", "text/xml;charset=UTF-8"));
        return putMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendXML(String xml, String service) throws Exception {
        byte[] content = xml.getBytes("UTF-8");
        PutMethod put = this.getSendByteArrayMethod(content, service);
        HttpClient client = new HttpClient();
        this.addCredentials(client);
        try {
            int c;
            int result = client.executeMethod((HttpMethod)put);
            log.logDebug(this.toString(), Messages.getString("SlaveServer.DEBUG_ResponseStatus", Integer.toString(result)), new Object[0]);
            BufferedInputStream inputStream = new BufferedInputStream(put.getResponseBodyAsStream(), 1000);
            StringBuffer bodyBuffer = new StringBuffer();
            while ((c = ((InputStream)inputStream).read()) != -1) {
                bodyBuffer.append((char)c);
            }
            ((InputStream)inputStream).close();
            String bodyTmp = bodyBuffer.toString();
            switch (result) {
                case 401: {
                    String message = "Authentication failed\n\r\n\r" + bodyTmp;
                    WebResult webResult = new WebResult("ERROR", message);
                    bodyBuffer.setLength(0);
                    bodyBuffer.append(webResult.getXML());
                }
            }
            String body = bodyBuffer.toString();
            log.logDebug(this.toString(), Messages.getString("SlaveServer.DEBUG_ResponseBody", body), new Object[0]);
            String string = body;
            return string;
        }
        finally {
            put.releaseConnection();
            log.logDetailed(this.toString(), Messages.getString("SlaveServer.DETAILED_SentXmlToService", service, this.environmentSubstitute(this.hostname)), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendExport(String filename, String type, String load) throws Exception {
        String serviceUrl = "/kettle/addExport";
        if (type != null && load != null) {
            serviceUrl = serviceUrl + "/?type=" + type + "&" + "load" + "=" + URLEncoder.encode(load, "UTF-8");
        }
        String urlString = this.constructUrl(serviceUrl);
        log.logDebug(this.toString(), Messages.getString("SlaveServer.DEBUG_ConnectingTo", urlString), new Object[0]);
        PutMethod putMethod = new PutMethod(urlString);
        FileObject fileObject = KettleVFS.getFileObject((String)filename);
        InputStreamRequestEntity entity = new InputStreamRequestEntity(KettleVFS.getInputStream((FileObject)fileObject));
        putMethod.setRequestEntity((RequestEntity)entity);
        putMethod.setDoAuthentication(true);
        putMethod.addRequestHeader(new Header("Content-Type", "binary/zip"));
        HttpClient client = new HttpClient();
        this.addCredentials(client);
        try {
            int c;
            int result = client.executeMethod((HttpMethod)putMethod);
            log.logDebug(this.toString(), Messages.getString("SlaveServer.DEBUG_ResponseStatus", Integer.toString(result)), new Object[0]);
            BufferedInputStream inputStream = new BufferedInputStream(putMethod.getResponseBodyAsStream(), 1000);
            StringBuffer bodyBuffer = new StringBuffer();
            while ((c = ((InputStream)inputStream).read()) != -1) {
                bodyBuffer.append((char)c);
            }
            ((InputStream)inputStream).close();
            String bodyTmp = bodyBuffer.toString();
            switch (result) {
                case 401: {
                    String message = "Authentication failed\n\r\n\r" + bodyTmp;
                    WebResult webResult = new WebResult("ERROR", message);
                    bodyBuffer.setLength(0);
                    bodyBuffer.append(webResult.getXML());
                }
            }
            String body = bodyBuffer.toString();
            log.logDebug(this.toString(), Messages.getString("SlaveServer.DEBUG_ResponseBody", body), new Object[0]);
            String string = body;
            return string;
        }
        finally {
            putMethod.releaseConnection();
            log.logDetailed(this.toString(), Messages.getString("SlaveServer.DETAILED_SentExportToService", "/kettle/addExport", this.environmentSubstitute(this.hostname)), new Object[0]);
        }
    }

    public void addCredentials(HttpClient client) {
        client.getState().setCredentials(new AuthScope(this.environmentSubstitute(this.hostname), Const.toInt((String)this.environmentSubstitute(this.port), (int)80), "Kettle"), (Credentials)new UsernamePasswordCredentials(this.environmentSubstitute(this.username), this.environmentSubstitute(this.password)));
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execService(String service) throws Exception {
        HttpClient client = new HttpClient();
        this.addCredentials(client);
        GetMethod method = new GetMethod(this.constructUrl(service));
        try {
            int c;
            int result = client.executeMethod((HttpMethod)method);
            log.logDebug(this.toString(), Messages.getString("SlaveServer.DEBUG_ResponseStatus", Integer.toString(result)), new Object[0]);
            BufferedInputStream inputStream = new BufferedInputStream(method.getResponseBodyAsStream());
            StringBuffer bodyBuffer = new StringBuffer();
            while ((c = ((InputStream)inputStream).read()) != -1) {
                bodyBuffer.append((char)c);
            }
            ((InputStream)inputStream).close();
            String body = bodyBuffer.toString();
            log.logDetailed(this.toString(), Messages.getString("SlaveServer.DETAILED_FinishedReading", Integer.toString(bodyBuffer.length())), new Object[0]);
            log.logDebug(this.toString(), Messages.getString("SlaveServer.DEBUG_ResponseBody", body), new Object[0]);
            String string = body;
            return string;
        }
        finally {
            method.releaseConnection();
            log.logDetailed(this.toString(), Messages.getString("SlaveServer.DETAILED_ExecutedService", service, this.hostname), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentFromServer(String service) throws Exception {
        String urlToUse = this.constructUrl(service);
        StringBuffer result = new StringBuffer();
        try {
            String beforeProxyHost = System.getProperty("http.proxyHost");
            String beforeProxyPort = System.getProperty("http.proxyPort");
            String beforeNonProxyHosts = System.getProperty("http.nonProxyHosts");
            BufferedReader input = null;
            try {
                String line;
                if (log.isBasic()) {
                    log.logBasic(this.toString(), Messages.getString("SlaveServer.DEBUG_ConnectingTo", urlToUse), new Object[0]);
                }
                if (this.proxyHostname != null) {
                    System.setProperty("http.proxyHost", this.environmentSubstitute(this.proxyHostname));
                    System.setProperty("http.proxyPort", this.environmentSubstitute(this.proxyPort));
                    if (this.nonProxyHosts != null) {
                        System.setProperty("http.nonProxyHosts", this.environmentSubstitute(this.nonProxyHosts));
                    }
                }
                if (this.username != null && this.username.length() > 0) {
                    Authenticator.setDefault(new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(SlaveServer.this.environmentSubstitute(SlaveServer.this.username), SlaveServer.this.password != null ? SlaveServer.this.environmentSubstitute(SlaveServer.this.password).toCharArray() : new char[]{});
                        }
                    });
                }
                URL server = new URL(urlToUse);
                URLConnection connection = server.openConnection();
                log.logDetailed(this.toString(), Messages.getString("SlaveServer.StartReadingReply"), new Object[0]);
                BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream(), 1000);
                input = new BufferedReader(new InputStreamReader(inputStream));
                long bytesRead = 0L;
                while ((line = input.readLine()) != null) {
                    result.append(line).append(Const.CR);
                    bytesRead += (long)line.length();
                }
                if (log.isBasic()) {
                    log.logBasic(this.toString(), Messages.getString("SlaveServer.FinishedReadingResponse"), new Object[]{bytesRead});
                }
                if (log.isDebug()) {
                    log.logDebug(this.toString(), "response from the webserver: {0}", new Object[]{result});
                }
            }
            catch (MalformedURLException e) {
                log.logError(this.toString(), Messages.getString("SlaveServer.UrlIsInvalid", urlToUse, e.getMessage()), new Object[0]);
                log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
            }
            catch (IOException e) {
                log.logError(this.toString(), Messages.getString("SlaveServer.CannotSaveDueToIOError", e.getMessage()), new Object[0]);
                log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
            }
            catch (Exception e) {
                log.logError(this.toString(), Messages.getString("SlaveServer.ErrorReceivingFile", e.getMessage()), new Object[0]);
                log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception e) {
                    log.logError(this.toString(), Messages.getString("SlaveServer.CannotCloseStream", e.getMessage()), new Object[0]);
                    log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                }
            }
            System.setProperty("http.proxyHost", Const.NVL((String)beforeProxyHost, (String)""));
            System.setProperty("http.proxyPort", Const.NVL((String)beforeProxyPort, (String)""));
            System.setProperty("http.nonProxyHosts", Const.NVL((String)beforeNonProxyHosts, (String)""));
            return result.toString();
        }
        catch (Exception e) {
            throw new Exception(Messages.getString("SlaveServer.CannotContactURLForSecurityInformation", urlToUse), e);
        }
    }

    public SlaveServerStatus getStatus() throws Exception {
        String xml = this.execService("/kettle/status/?xml=Y");
        return SlaveServerStatus.fromXML(xml);
    }

    public List<SlaveServerDetection> getSlaveServerDetections() throws Exception {
        String xml = this.execService("/kettle/getSlaves/");
        Document document = XMLHandler.loadXMLString((String)xml);
        Node detectionsNode = XMLHandler.getSubNode((Node)document, (String)"SlaveServerDetections");
        int nrDetections = XMLHandler.countNodes((Node)detectionsNode, (String)"SlaveServerDetection");
        ArrayList<SlaveServerDetection> detections = new ArrayList<SlaveServerDetection>();
        for (int i = 0; i < nrDetections; ++i) {
            Node detectionNode = XMLHandler.getSubNodeByNr((Node)detectionsNode, (String)"SlaveServerDetection", (int)i);
            SlaveServerDetection detection = new SlaveServerDetection(detectionNode);
            detections.add(detection);
        }
        return detections;
    }

    public SlaveServerTransStatus getTransStatus(String transName) throws Exception {
        String xml = this.execService("/kettle/transStatus/?name=" + URLEncoder.encode(transName, "UTF-8") + "&xml=Y");
        return SlaveServerTransStatus.fromXML(xml);
    }

    public SlaveServerJobStatus getJobStatus(String jobName) throws Exception {
        String xml = this.execService("/kettle/jobStatus/?name=" + URLEncoder.encode(jobName, "UTF-8") + "&xml=Y");
        return SlaveServerJobStatus.fromXML(xml);
    }

    public WebResult stopTransformation(String transName) throws Exception {
        String xml = this.execService("/kettle/stopTrans/?name=" + URLEncoder.encode(transName, "UTF-8") + "&xml=Y");
        return WebResult.fromXMLString(xml);
    }

    public WebResult stopJob(String transName) throws Exception {
        String xml = this.execService("/kettle/stopJob/?name=" + URLEncoder.encode(transName, "UTF-8") + "&xml=Y");
        return WebResult.fromXMLString(xml);
    }

    public WebResult startTransformation(String transName) throws Exception {
        String xml = this.execService("/kettle/startTrans/?name=" + URLEncoder.encode(transName, "UTF-8") + "&xml=Y");
        return WebResult.fromXMLString(xml);
    }

    public WebResult startJob(String transName) throws Exception {
        String xml = this.execService("/kettle/startJob/?name=" + URLEncoder.encode(transName, "UTF-8") + "&xml=Y");
        return WebResult.fromXMLString(xml);
    }

    public WebResult cleanupTransformation(String transName) throws Exception {
        String xml = this.execService("/kettle/cleanupTrans/?name=" + URLEncoder.encode(transName, "UTF-8") + "&xml=Y");
        return WebResult.fromXMLString(xml);
    }

    public WebResult deallocatePorts(String transName) throws Exception {
        String xml = this.execService("/kettle/cleanupTrans/?sockets=Y&name=" + URLEncoder.encode(transName, "UTF-8") + "&xml=Y");
        return WebResult.fromXMLString(xml);
    }

    public static SlaveServer findSlaveServer(List<SlaveServer> slaveServers, String name) {
        for (SlaveServer slaveServer : slaveServers) {
            if (slaveServer.getName() == null || !slaveServer.getName().equalsIgnoreCase(name)) continue;
            return slaveServer;
        }
        return null;
    }

    public static String[] getSlaveServerNames(List<SlaveServer> slaveServers) {
        String[] names = new String[slaveServers.size()];
        for (int i = 0; i < slaveServers.size(); ++i) {
            SlaveServer slaveServer = slaveServers.get(i);
            names[i] = slaveServer.getName();
        }
        return names;
    }

    public int allocateServerSocket(int portRangeStart, String hostname, String transformationName, String sourceSlaveName, String sourceStepName, String sourceStepCopy, String targetSlaveName, String targetStepName, String targetStepCopy) throws Exception {
        InetAddress inetAddress = InetAddress.getByName(hostname);
        String address = inetAddress.getHostAddress();
        String service = "/kettle/allocateSocket/?";
        service = service + "rangeStart=" + Integer.toString(portRangeStart);
        service = service + "&host=" + address;
        service = service + "&trans=" + URLEncoder.encode(transformationName, "UTF-8");
        service = service + "&sourceSlave=" + URLEncoder.encode(sourceSlaveName, "UTF-8");
        service = service + "&sourceStep=" + URLEncoder.encode(sourceStepName, "UTF-8");
        service = service + "&sourceCopy=" + URLEncoder.encode(sourceStepCopy, "UTF-8");
        service = service + "&targetSlave=" + URLEncoder.encode(targetSlaveName, "UTF-8");
        service = service + "&targetStep=" + URLEncoder.encode(targetStepName, "UTF-8");
        service = service + "&targetCopy=" + URLEncoder.encode(targetStepCopy, "UTF-8");
        String xml = this.execService(service = service + "&xml=Y");
        Document doc = XMLHandler.loadXMLString((String)xml);
        String portString = XMLHandler.getTagValue((Node)doc, (String)"port");
        int port = Const.toInt((String)portString, (int)-1);
        if (port < 0) {
            throw new Exception("Unable to retrieve port from service : " + service + ", received : \n" + xml);
        }
        return port;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Const.isEmpty((String)variableName) && !Const.isEmpty((String)(value = this.environmentSubstitute(variableName)))) {
            return ValueMeta.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }
}

