/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.socketio;

import java.awt.Font;
import java.time.Duration;
import javax.swing.JLabel;
import org.graalvm.visualvm.jfr.utils.ValuesConverter;
import org.graalvm.visualvm.jfr.views.socketio.SocketIONode;
import org.graalvm.visualvm.lib.ui.Formatters;
import org.graalvm.visualvm.lib.ui.swing.renderer.FormattedLabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.McsTimeRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NumberRenderer;

final class SocketIORenderers {
    SocketIORenderers() {
    }

    private static int getMinimumWidth(String valueName) {
        return new JLabel((String)valueName).getPreferredSize().width + 30;
    }

    private static class BytesRenderer
    extends FormattedLabelRenderer {
        BytesRenderer() {
            super(Formatters.bytesFormat());
            this.setHorizontalAlignment(11);
        }

        public void setValue(Object value, int row) {
            if (value == null) {
                this.setText("-");
            } else {
                super.setValue(value, row);
            }
        }
    }

    private static class TimeRenderer
    extends McsTimeRenderer {
        private TimeRenderer() {
        }

        public void setValue(Object value, int row) {
            if (value instanceof Duration) {
                long micros = ValuesConverter.durationToMicros((Duration)value);
                if (micros == 0L) {
                    this.setText("< 0.001 ms");
                } else {
                    super.setValue((Object)micros, row);
                }
            } else {
                this.setText("-");
            }
        }
    }

    static class WriteBytesRenderer
    extends BytesRenderer {
        WriteBytesRenderer() {
        }

        static String getDisplayName() {
            return "Write Bytes";
        }

        static boolean isInitiallyVisible() {
            return true;
        }

        int getPreferredWidth() {
            this.setValue(99999999999999L, -1);
            return Math.max(this.getPreferredSize().width, SocketIORenderers.getMinimumWidth(WriteBytesRenderer.getDisplayName()));
        }
    }

    static class ReadBytesRenderer
    extends BytesRenderer {
        ReadBytesRenderer() {
        }

        static String getDisplayName() {
            return "Read Bytes";
        }

        static boolean isInitiallyVisible() {
            return true;
        }

        int getPreferredWidth() {
            this.setValue(99999999999999L, -1);
            return Math.max(this.getPreferredSize().width, SocketIORenderers.getMinimumWidth(ReadBytesRenderer.getDisplayName()));
        }
    }

    static class WriteCountRenderer
    extends NumberRenderer {
        WriteCountRenderer() {
        }

        static String getDisplayName() {
            return "Write Count";
        }

        static boolean isInitiallyVisible() {
            return false;
        }

        int getPreferredWidth() {
            this.setValue(999999999999L, -1);
            return Math.max(this.getPreferredSize().width, SocketIORenderers.getMinimumWidth(WriteCountRenderer.getDisplayName()));
        }
    }

    static class ReadCountRenderer
    extends NumberRenderer {
        ReadCountRenderer() {
        }

        static String getDisplayName() {
            return "Read Count";
        }

        static boolean isInitiallyVisible() {
            return false;
        }

        int getPreferredWidth() {
            this.setValue(999999999999L, -1);
            return Math.max(this.getPreferredSize().width, SocketIORenderers.getMinimumWidth(ReadCountRenderer.getDisplayName()));
        }
    }

    static class TotalCountRenderer
    extends NumberRenderer {
        TotalCountRenderer() {
        }

        static String getDisplayName() {
            return "Total Count";
        }

        static boolean isInitiallyVisible() {
            return true;
        }

        int getPreferredWidth() {
            this.setValue(999999999999L, -1);
            return Math.max(this.getPreferredSize().width, SocketIORenderers.getMinimumWidth(TotalCountRenderer.getDisplayName()));
        }
    }

    static class MaxWriteTimeRenderer
    extends TimeRenderer {
        MaxWriteTimeRenderer() {
        }

        static String getDisplayName() {
            return "Max Write Time";
        }

        static boolean isInitiallyVisible() {
            return false;
        }

        int getPreferredWidth() {
            this.setValue(Duration.ofMillis(999999999999L), -1);
            return Math.max(this.getPreferredSize().width, SocketIORenderers.getMinimumWidth(MaxWriteTimeRenderer.getDisplayName()));
        }
    }

    static class WriteTimeRenderer
    extends TimeRenderer {
        WriteTimeRenderer() {
        }

        static String getDisplayName() {
            return "Write Time";
        }

        static boolean isInitiallyVisible() {
            return false;
        }

        int getPreferredWidth() {
            this.setValue(Duration.ofMillis(999999999999L), -1);
            return Math.max(this.getPreferredSize().width, SocketIORenderers.getMinimumWidth(WriteTimeRenderer.getDisplayName()));
        }
    }

    static class MaxReadTimeRenderer
    extends TimeRenderer {
        MaxReadTimeRenderer() {
        }

        static String getDisplayName() {
            return "Max Read Time";
        }

        static boolean isInitiallyVisible() {
            return false;
        }

        int getPreferredWidth() {
            this.setValue(Duration.ofMillis(999999999999L), -1);
            return Math.max(this.getPreferredSize().width, SocketIORenderers.getMinimumWidth(MaxReadTimeRenderer.getDisplayName()));
        }
    }

    static class ReadTimeRenderer
    extends TimeRenderer {
        ReadTimeRenderer() {
        }

        static String getDisplayName() {
            return "Read Time";
        }

        static boolean isInitiallyVisible() {
            return false;
        }

        int getPreferredWidth() {
            this.setValue(Duration.ofMillis(999999999999L), -1);
            return Math.max(this.getPreferredSize().width, SocketIORenderers.getMinimumWidth(ReadTimeRenderer.getDisplayName()));
        }
    }

    static class TotalTimeRenderer
    extends TimeRenderer {
        TotalTimeRenderer() {
        }

        static String getDisplayName() {
            return "Total Time";
        }

        static boolean isInitiallyVisible() {
            return true;
        }

        int getPreferredWidth() {
            this.setValue(Duration.ofMillis(999999999999L), -1);
            return Math.max(this.getPreferredSize().width, SocketIORenderers.getMinimumWidth(TotalTimeRenderer.getDisplayName()));
        }
    }

    static class NameRenderer
    extends LabelRenderer {
        private static Font regular;
        private static Font bold;

        NameRenderer() {
        }

        public void setValue(Object value, int row) {
            if (value instanceof SocketIONode) {
                SocketIONode node = (SocketIONode)((Object)value);
                SocketIONode parent = node.getParent();
                this.setFont(parent == null || parent.getParent() == null ? NameRenderer.bold() : NameRenderer.regular());
                this.setText(node.name);
                this.setIcon(node.icon);
            } else {
                super.setValue(value, row);
            }
        }

        static String getDisplayName() {
            return "Name";
        }

        private static Font regular() {
            if (regular == null) {
                regular = new LabelRenderer().getFont();
            }
            return regular;
        }

        private static Font bold() {
            if (bold == null) {
                bold = new LabelRenderer().getFont().deriveFont(1);
            }
            return bold;
        }
    }
}

