/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.results;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.ui.swing.FilterUtils;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTable;
import org.graalvm.visualvm.lib.ui.swing.SearchUtils;
import org.openide.util.Lookup;

public abstract class DataView
extends JPanel {
    private JComponent bottomPanel;
    private JComponent filterPanel;
    private JComponent searchPanel;

    protected DataView() {
        super(new BorderLayout());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchUtils.enableSearchActions(DataView.this.getResultsComponent());
            }
        });
    }

    protected abstract ProfilerTable getResultsComponent();

    public final JMenuItem createCopyMenuItem() {
        return this.getResultsComponent().createCopyMenuItem();
    }

    public final JMenuItem[] createCustomMenuItems(JComponent invoker, Object value, ClientUtils.SourceCodeSelection userValue) {
        Collection customizers = Lookup.getDefault().lookupAll(PopupCustomizer.class);
        if (customizers.isEmpty()) {
            return null;
        }
        ArrayList menuItems = new ArrayList(customizers.size());
        for (PopupCustomizer customizer : customizers) {
            JMenuItem[] items = customizer.getMenuItems(invoker, this, value, userValue);
            if (items == null) continue;
            Collections.addAll(menuItems, items);
        }
        return menuItems.isEmpty() ? null : menuItems.toArray(new JMenuItem[0]);
    }

    public void notifyOnFocus(final Runnable handler) {
        this.getResultsComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                handler.run();
            }
        });
    }

    protected void installDefaultAction() {
        this.getResultsComponent().setDefaultAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = DataView.this.getResultsComponent().getSelectedRow();
                ClientUtils.SourceCodeSelection userValue = DataView.this.getUserValueForRow(row);
                if (userValue != null) {
                    DataView.this.performDefaultAction(userValue);
                }
            }
        });
    }

    protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
    }

    protected ClientUtils.SourceCodeSelection getUserValueForRow(int row) {
        return null;
    }

    protected RowFilter getExcludesFilter() {
        return null;
    }

    protected Component[] getFilterOptions() {
        return null;
    }

    protected void enableFilter() {
        Object a;
        if (this.filterPanel != null && (a = this.filterPanel.getClientProperty("SET_FILTER_CHANGED")) instanceof Action) {
            ((Action)a).actionPerformed(null);
        }
    }

    public void activateFilter() {
        JComponent panel = this.getBottomPanel();
        if (this.filterPanel == null) {
            this.filterPanel = FilterUtils.createFilterPanel(this.getResultsComponent(), this.getExcludesFilter(), this.getFilterOptions());
            panel.add(this.filterPanel);
            Container parent = panel.getParent();
            parent.invalidate();
            parent.revalidate();
            parent.repaint();
        }
        panel.setVisible(true);
        this.filterPanel.setVisible(true);
        this.filterPanel.requestFocusInWindow();
    }

    protected SearchUtils.TreeHelper getSearchHelper() {
        return null;
    }

    protected Component[] getSearchOptions() {
        return null;
    }

    public void activateSearch() {
        JComponent panel = this.getBottomPanel();
        if (this.searchPanel == null) {
            SearchUtils.TreeHelper searchHelper = this.getSearchHelper();
            this.searchPanel = searchHelper == null ? SearchUtils.createSearchPanel(this.getResultsComponent(), this.getSearchOptions()) : SearchUtils.createSearchPanel((ProfilerTreeTable)this.getResultsComponent(), searchHelper, this.getSearchOptions());
            panel.add(this.searchPanel);
            Container parent = panel.getParent();
            parent.invalidate();
            parent.revalidate();
            parent.repaint();
        }
        panel.setVisible(true);
        this.searchPanel.setVisible(true);
        this.searchPanel.requestFocusInWindow();
    }

    protected boolean hasBottomFilterFindMargin() {
        return false;
    }

    protected void addFilterFindPanel(JComponent comp) {
        this.add((Component)comp, "South");
    }

    private JComponent getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel(new FilterFindLayout());
            this.bottomPanel.setOpaque(true);
            this.bottomPanel.setBackground(UIManager.getColor("controlShadow"));
            this.addFilterFindPanel(this.bottomPanel);
        }
        return this.bottomPanel;
    }

    public static abstract class PopupCustomizer {
        public abstract JMenuItem[] getMenuItems(JComponent var1, DataView var2, Object var3, ClientUtils.SourceCodeSelection var4);
    }

    private final class FilterFindLayout
    implements LayoutManager {
        private FilterFindLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            JComponent search;
            JComponent filter = DataView.this.filterPanel;
            if (filter != null && !filter.isVisible()) {
                filter = null;
            }
            if ((search = DataView.this.searchPanel) != null && !search.isVisible()) {
                search = null;
            }
            Dimension dim = new Dimension();
            if (filter != null && search != null) {
                Dimension dim1 = filter.getPreferredSize();
                Dimension dim2 = search.getPreferredSize();
                dim.width = dim1.width + dim2.width + 1;
                dim.height = Math.max(dim1.height, dim2.height);
            } else if (filter != null) {
                dim = filter.getPreferredSize();
            } else if (search != null) {
                dim = search.getPreferredSize();
            }
            if ((filter != null || search != null) && DataView.this.hasBottomFilterFindMargin()) {
                ++dim.height;
            }
            return dim;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            JComponent search;
            JComponent filter = DataView.this.filterPanel;
            if (filter != null && !filter.isVisible()) {
                filter = null;
            }
            if ((search = DataView.this.searchPanel) != null && !search.isVisible()) {
                search = null;
            }
            Dimension dim = new Dimension();
            if (filter != null && search != null) {
                Dimension dim1 = filter.getMinimumSize();
                Dimension dim2 = search.getMinimumSize();
                dim.width = dim1.width + dim2.width + 1;
                dim.height = Math.max(dim1.height, dim2.height);
            } else if (filter != null) {
                dim = filter.getMinimumSize();
            } else if (search != null) {
                dim = search.getMinimumSize();
            }
            if ((filter != null || search != null) && DataView.this.hasBottomFilterFindMargin()) {
                ++dim.height;
            }
            return dim;
        }

        @Override
        public void layoutContainer(Container parent) {
            int bottomOffset;
            JComponent search;
            JComponent filter = DataView.this.filterPanel;
            if (filter != null && !filter.isVisible()) {
                filter = null;
            }
            if ((search = DataView.this.searchPanel) != null && !search.isVisible()) {
                search = null;
            }
            int n = bottomOffset = DataView.this.hasBottomFilterFindMargin() ? 1 : 0;
            if (filter != null && search != null) {
                Dimension size = parent.getSize();
                int w = (size.width - 1) / 2;
                filter.setBounds(0, 0, w, size.height - bottomOffset);
                search.setBounds(w + 1, 0, size.width - w - 1, size.height - bottomOffset);
            } else if (filter != null) {
                Dimension size = parent.getSize();
                filter.setBounds(0, 0, size.width, size.height - bottomOffset);
            } else if (search != null) {
                Dimension size = parent.getSize();
                search.setBounds(0, 0, size.width, size.height - bottomOffset);
            }
        }
    }
}

