/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.memory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.filters.GenericFilter;
import org.graalvm.visualvm.lib.jfluid.results.memory.AllocMemoryResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.memory.LivenessMemoryResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.memory.MemoryResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.memory.SampledMemoryResultsSnapshot;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.memory.AllocTableView;
import org.graalvm.visualvm.lib.ui.memory.AllocTreeTableView;
import org.graalvm.visualvm.lib.ui.memory.LivenessTableView;
import org.graalvm.visualvm.lib.ui.memory.LivenessTreeTableView;
import org.graalvm.visualvm.lib.ui.memory.MemoryView;
import org.graalvm.visualvm.lib.ui.memory.SampledTableView;
import org.graalvm.visualvm.lib.ui.results.DataView;
import org.graalvm.visualvm.lib.ui.swing.FilterUtils;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTable;
import org.graalvm.visualvm.lib.ui.swing.SearchUtils;
import org.graalvm.visualvm.lib.ui.swing.renderer.HideableBarRenderer;

public abstract class LiveMemoryView
extends JPanel {
    private MemoryView dataView;
    private long lastupdate;
    private volatile boolean refreshIsRunning;
    private final Set<ClientUtils.SourceCodeSelection> selection;
    private MemoryResultsSnapshot snapshot;
    private MemoryResultsSnapshot refSnapshot;
    private GenericFilter filter;

    public LiveMemoryView(Set<ClientUtils.SourceCodeSelection> selection) {
        this.selection = selection;
        this.initUI();
    }

    public boolean isRefreshRunning() {
        return this.refreshIsRunning;
    }

    public long getLastUpdate() {
        return this.lastupdate;
    }

    public void setData(final MemoryResultsSnapshot snapshotData, final GenericFilter ifilter) {
        if (this.refreshIsRunning) {
            return;
        }
        this.refreshIsRunning = true;
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                try {
                    LiveMemoryView.this.updateDataView(snapshotData);
                    LiveMemoryView.this.snapshot = snapshotData;
                    LiveMemoryView.this.filter = ifilter;
                    if (LiveMemoryView.this.dataView != null && LiveMemoryView.this.snapshot != null) {
                        if (LiveMemoryView.this.refSnapshot == null) {
                            LiveMemoryView.this.dataView.setData(LiveMemoryView.this.snapshot, LiveMemoryView.this.filter, 1);
                        } else {
                            LiveMemoryView.this.dataView.setData(LiveMemoryView.this.refSnapshot.createDiff(LiveMemoryView.this.snapshot), LiveMemoryView.this.filter, 1);
                        }
                    }
                }
                finally {
                    LiveMemoryView.this.refreshIsRunning = false;
                    LiveMemoryView.this.lastupdate = System.currentTimeMillis();
                }
            }
        });
    }

    public boolean setDiffView(boolean diff) {
        if (this.snapshot == null) {
            return false;
        }
        this.refSnapshot = diff ? this.snapshot : null;
        this.setData(this.snapshot, this.filter);
        return true;
    }

    public void resetData() {
        if (this.dataView != null) {
            this.dataView.resetData();
        }
        this.snapshot = null;
        this.refSnapshot = null;
        this.filter = null;
    }

    public void showSelectionColumn() {
        if (this.dataView != null) {
            this.dataView.showSelectionColumn();
        }
    }

    public void refreshSelection() {
        if (this.dataView != null) {
            this.dataView.showSelectionColumn();
        }
    }

    protected boolean profileClassSupported() {
        return true;
    }

    protected abstract boolean showSourceSupported();

    protected abstract void showSource(ClientUtils.SourceCodeSelection var1);

    protected abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    private void updateDataView(MemoryResultsSnapshot snapshot) {
        if (snapshot == null || snapshot instanceof SampledMemoryResultsSnapshot) {
            if (this.dataView instanceof SampledTableView) {
                return;
            }
            this.dataView = new SampledTableView(this.selection){

                @Override
                protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                    if (LiveMemoryView.this.showSourceSupported()) {
                        LiveMemoryView.this.showSource(userValue);
                    }
                }

                @Override
                protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                    LiveMemoryView.this.populatePopup(LiveMemoryView.this.dataView, popup, value, userValue);
                }

                @Override
                protected void popupShowing() {
                    LiveMemoryView.this.popupShowing();
                }

                @Override
                protected void popupHidden() {
                    LiveMemoryView.this.popupHidden();
                }

                @Override
                protected boolean hasBottomFilterFindMargin() {
                    return true;
                }
            };
        } else if (snapshot instanceof AllocMemoryResultsSnapshot) {
            if (snapshot.containsStacks()) {
                if (this.dataView instanceof AllocTreeTableView) {
                    return;
                }
                this.dataView = new AllocTreeTableView(this.selection){

                    @Override
                    protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                        if (LiveMemoryView.this.showSourceSupported()) {
                            LiveMemoryView.this.showSource(userValue);
                        }
                    }

                    @Override
                    protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                        LiveMemoryView.this.populatePopup(LiveMemoryView.this.dataView, popup, value, userValue);
                    }

                    @Override
                    protected void popupShowing() {
                        LiveMemoryView.this.popupShowing();
                    }

                    @Override
                    protected void popupHidden() {
                        LiveMemoryView.this.popupHidden();
                    }

                    @Override
                    protected boolean hasBottomFilterFindMargin() {
                        return true;
                    }

                    @Override
                    HideableBarRenderer.BarDiffMode barDiffMode() {
                        return HideableBarRenderer.BarDiffMode.MODE_BAR_NORMAL;
                    }
                };
            } else {
                if (this.dataView instanceof AllocTableView) {
                    return;
                }
                this.dataView = new AllocTableView(this.selection){

                    @Override
                    protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                        if (LiveMemoryView.this.showSourceSupported()) {
                            LiveMemoryView.this.showSource(userValue);
                        }
                    }

                    @Override
                    protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                        LiveMemoryView.this.populatePopup(LiveMemoryView.this.dataView, popup, value, userValue);
                    }

                    @Override
                    protected void popupShowing() {
                        LiveMemoryView.this.popupShowing();
                    }

                    @Override
                    protected void popupHidden() {
                        LiveMemoryView.this.popupHidden();
                    }

                    @Override
                    protected boolean hasBottomFilterFindMargin() {
                        return true;
                    }

                    @Override
                    HideableBarRenderer.BarDiffMode barDiffMode() {
                        return HideableBarRenderer.BarDiffMode.MODE_BAR_NORMAL;
                    }
                };
            }
        } else if (snapshot instanceof LivenessMemoryResultsSnapshot) {
            if (snapshot.containsStacks()) {
                if (this.dataView instanceof LivenessTreeTableView) {
                    return;
                }
                this.dataView = new LivenessTreeTableView(this.selection, false){

                    @Override
                    protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                        if (LiveMemoryView.this.showSourceSupported()) {
                            LiveMemoryView.this.showSource(userValue);
                        }
                    }

                    @Override
                    protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                        LiveMemoryView.this.populatePopup(LiveMemoryView.this.dataView, popup, value, userValue);
                    }

                    @Override
                    protected void popupShowing() {
                        LiveMemoryView.this.popupShowing();
                    }

                    @Override
                    protected void popupHidden() {
                        LiveMemoryView.this.popupHidden();
                    }

                    @Override
                    protected boolean hasBottomFilterFindMargin() {
                        return true;
                    }
                };
            } else {
                if (this.dataView instanceof LivenessTableView) {
                    return;
                }
                this.dataView = new LivenessTableView(this.selection, false){

                    @Override
                    protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                        if (LiveMemoryView.this.showSourceSupported()) {
                            LiveMemoryView.this.showSource(userValue);
                        }
                    }

                    @Override
                    protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                        LiveMemoryView.this.populatePopup(LiveMemoryView.this.dataView, popup, value, userValue);
                    }

                    @Override
                    protected void popupShowing() {
                        LiveMemoryView.this.popupShowing();
                    }

                    @Override
                    protected void popupHidden() {
                        LiveMemoryView.this.popupHidden();
                    }

                    @Override
                    protected boolean hasBottomFilterFindMargin() {
                        return true;
                    }
                };
            }
        } else {
            this.dataView = null;
        }
        this.removeAll();
        this.resetData();
        if (this.dataView != null) {
            this.add((Component)this.dataView, "Center");
        }
        this.revalidate();
        this.repaint();
    }

    private void populatePopup(final DataView invoker, JPopupMenu popup, Object value, final ClientUtils.SourceCodeSelection userValue) {
        JMenuItem[] customItems;
        if (this.showSourceSupported()) {
            popup.add(new JMenuItem(MemoryView.ACTION_GOTOSOURCE){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    LiveMemoryView.this.showSource(userValue);
                }
            });
            popup.addSeparator();
        }
        if (this.profileClassSupported()) {
            popup.add(new JMenuItem(MemoryView.ACTION_PROFILE_CLASS){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    LiveMemoryView.this.selectForProfiling(userValue);
                }
            });
        }
        if (this.profileClassSupported()) {
            popup.addSeparator();
        }
        if ((customItems = invoker.createCustomMenuItems(this, value, userValue)) != null) {
            for (JMenuItem customItem : customItems) {
                popup.add(customItem);
            }
            popup.addSeparator();
        }
        this.customizeNodePopup(invoker, popup, value, userValue);
        if (this.snapshot.containsStacks()) {
            final ProfilerTreeTable ttable = (ProfilerTreeTable)this.dataView.getResultsComponent();
            JMenu expand = new JMenu(MemoryView.EXPAND_MENU);
            popup.add(expand);
            expand.add(new JMenuItem(MemoryView.EXPAND_PLAIN_ITEM){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.expandPlainPath(ttable.getSelectedRow(), 1);
                }
            });
            expand.add(new JMenuItem(MemoryView.EXPAND_TOPMOST_ITEM){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.expandFirstPath(ttable.getSelectedRow());
                }
            });
            expand.addSeparator();
            expand.add(new JMenuItem(MemoryView.COLLAPSE_CHILDREN_ITEM){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.collapseChildren(ttable.getSelectedRow());
                }
            });
            expand.add(new JMenuItem(MemoryView.COLLAPSE_ALL_ITEM){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    ttable.collapseAll();
                }
            });
            popup.addSeparator();
        }
        popup.add(invoker.createCopyMenuItem());
        popup.addSeparator();
        popup.add(new JMenuItem(FilterUtils.ACTION_FILTER){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateFilter();
            }
        });
        popup.add(new JMenuItem(SearchUtils.ACTION_FIND){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateSearch();
            }
        });
    }

    protected void customizeNodePopup(DataView invoker, JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
    }

    private void initUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.updateDataView(null);
        this.registerActions();
    }

    private void registerActions() {
        ActionMap map = this.getActionMap();
        map.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveMemoryView.this.dataView.activateFilter();
            }
        });
        map.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveMemoryView.this.dataView.activateSearch();
            }
        });
    }
}

