/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLCatalog;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectUtils;
import ca.sqlpower.sqlobject.SQLSchema;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.util.SQLPowerUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ProfileAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(ProfileAction.class);

    public ProfileAction(ArchitectFrame frame) {
        super(frame, Messages.getString("ProfileAction.name"), Messages.getString("ProfileAction.desctiption"), "Table_profiled");
    }

    /*
     * WARNING - void declaration
     */
    private void profileItemsFromDBTree() {
        TreePath targetDBPath = this.getSession().getDBTree().getPathForRow(0);
        if (this.getSession().getDBTree().getSelectionPaths() != null) {
            for (TreePath treePath : this.getSession().getDBTree().getSelectionPaths()) {
                if (!targetDBPath.isDescendant(treePath)) continue;
                int answer = JOptionPane.showConfirmDialog(this.getSession().getArchitectFrame(), Messages.getString("ProfileAction.cannotProfileProjectDb"), Messages.getString("ProfileAction.continueProfilingOption"), 2);
                if (answer == 2) {
                    return;
                }
                break;
            }
        } else {
            this.getSession().getDBTree().setSelectionPath(targetDBPath);
        }
        try {
            void var5_10;
            HashSet<Object> sqlObject = new HashSet<Object>();
            TreePath[] arr$ = this.getSession().getDBTree().getSelectionPaths();
            int len$ = arr$.length;
            boolean bl = false;
            while (var5_10 < len$) {
                TreePath tp = arr$[var5_10];
                logger.debug((Object)("Top of first loop, treepath=" + tp));
                if (!targetDBPath.isDescendant(tp)) {
                    SQLDatabase db;
                    SQLCatalog cat;
                    SQLSchema sch;
                    SQLTable tab;
                    if (tp.getLastPathComponent() instanceof SQLDatabase) {
                        sqlObject.add((SQLDatabase)tp.getLastPathComponent());
                    } else if (tp.getLastPathComponent() instanceof SQLCatalog) {
                        SQLCatalog cat2 = (SQLCatalog)tp.getLastPathComponent();
                        sqlObject.add(cat2);
                        SQLDatabase db2 = (SQLDatabase)SQLPowerUtils.getAncestor((SPObject)cat2, SQLDatabase.class);
                        if (db2 != null && sqlObject.contains(db2)) {
                            sqlObject.remove(db2);
                        }
                    } else if (tp.getLastPathComponent() instanceof SQLSchema) {
                        SQLDatabase db3;
                        SQLSchema sch2 = (SQLSchema)tp.getLastPathComponent();
                        sqlObject.add(sch2);
                        SQLCatalog cat3 = (SQLCatalog)SQLPowerUtils.getAncestor((SPObject)sch2, SQLCatalog.class);
                        if (cat3 != null && sqlObject.contains(cat3)) {
                            sqlObject.remove(cat3);
                        }
                        if ((db3 = (SQLDatabase)SQLPowerUtils.getAncestor((SPObject)sch2, SQLDatabase.class)) != null && sqlObject.contains(db3)) {
                            sqlObject.remove(db3);
                        }
                    } else if (tp.getLastPathComponent() instanceof SQLTable) {
                        tab = (SQLTable)tp.getLastPathComponent();
                        sqlObject.add(tab);
                        sch = (SQLSchema)SQLPowerUtils.getAncestor((SPObject)tab, SQLSchema.class);
                        if (sch != null && sqlObject.contains(sch)) {
                            sqlObject.remove(sch);
                        }
                        if ((cat = (SQLCatalog)SQLPowerUtils.getAncestor((SPObject)sch, SQLCatalog.class)) != null && sqlObject.contains(cat)) {
                            sqlObject.remove(cat);
                        }
                        if ((db = (SQLDatabase)SQLPowerUtils.getAncestor((SPObject)sch, SQLDatabase.class)) != null && sqlObject.contains(db)) {
                            sqlObject.remove(db);
                        }
                    } else if (tp.getLastPathComponent() instanceof SQLColumn) {
                        tab = ((SQLColumn)tp.getLastPathComponent()).getParent();
                        sqlObject.add((SQLColumn)tp.getLastPathComponent());
                        sch = (SQLSchema)SQLPowerUtils.getAncestor((SPObject)tab, SQLSchema.class);
                        if (sch != null && sqlObject.contains(sch)) {
                            sqlObject.remove(sch);
                        }
                        if ((cat = (SQLCatalog)SQLPowerUtils.getAncestor((SPObject)sch, SQLCatalog.class)) != null && sqlObject.contains(cat)) {
                            sqlObject.remove(cat);
                        }
                        if ((db = (SQLDatabase)SQLPowerUtils.getAncestor((SPObject)sch, SQLDatabase.class)) != null && sqlObject.contains(db)) {
                            sqlObject.remove(db);
                        }
                    }
                }
                ++var5_10;
            }
            HashSet<SQLTable> tables = new HashSet<SQLTable>();
            for (SQLObject sQLObject : sqlObject) {
                if (sQLObject instanceof SQLColumn) {
                    tables.add(((SQLColumn)sQLObject).getParent());
                    continue;
                }
                tables.addAll(SQLObjectUtils.findDescendentsByClass((SQLObject)sQLObject, SQLTable.class, new ArrayList()));
            }
            logger.debug((Object)"Calling profileManager.asynchCreateProfiles(tables)");
            this.getSession().getProfileManager().asynchCreateProfiles(tables);
            JDialog profileDialog = this.getSession().getProfileDialog();
            profileDialog.pack();
            profileDialog.setVisible(true);
        }
        catch (Exception ex) {
            logger.error((Object)"Error in Profile Action ", (Throwable)ex);
            ASUtils.showExceptionDialog(this.getSession(), Messages.getString("ProfileAction.profileError"), ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.profileItemsFromDBTree();
    }
}

