/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMInvalidAccessException;
import io.sf.carte.doc.DOMNotSupportedException;
import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.LinkedStringList;
import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.CSSGroupingRule;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.CSSNamespaceParseException;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.nsac.ParserControl;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.RuleStore;
import io.sf.carte.doc.style.css.om.SheetHandler;
import io.sf.carte.doc.style.css.om.StyleRule;
import io.sf.carte.doc.style.css.parser.CSSParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.DOMException;

public abstract class GroupingRule
extends BaseCSSRule
implements CSSGroupingRule,
RuleStore {
    private static final long serialVersionUID = 1L;
    CSSRuleArrayList cssRules = null;

    protected GroupingRule(AbstractCSSStyleSheet parentSheet, short type, int origin) {
        super(parentSheet, type, origin);
    }

    protected GroupingRule(AbstractCSSStyleSheet parentSheet, GroupingRule copyfrom) {
        super(parentSheet, copyfrom.getType(), copyfrom.getOrigin());
        if (copyfrom.getPrecedingComments() != null) {
            this.setPrecedingComments(new LinkedStringList());
            this.getPrecedingComments().addAll(copyfrom.getPrecedingComments());
        }
        this.cssRules = this.cloneRuleList(parentSheet, copyfrom.getCssRules());
    }

    CSSRuleArrayList cloneRuleList(AbstractCSSStyleSheet parentSheet, CSSRuleArrayList otherRules) {
        CSSRuleArrayList rules = new CSSRuleArrayList(otherRules.getLength());
        for (AbstractCSSRule rule : otherRules) {
            AbstractCSSRule cloned = rule.clone(parentSheet);
            cloned.setParentRule(this);
            rules.add(cloned);
        }
        return rules;
    }

    public CSSRuleArrayList getCssRules() {
        return this.cssRules;
    }

    @Override
    public int insertRule(String rule, int index) throws DOMException {
        if (index < 0 || index > this.cssRules.size()) {
            throw new DOMException(1, "Index out of bounds in rule list");
        }
        StringReader re = new StringReader(rule);
        RuleHandler handler = new RuleHandler();
        handler.setCurrentInsertionIndex(index);
        AllowWarningsRuleErrorHandler errorHandler = new AllowWarningsRuleErrorHandler();
        CSSParser parser = (CSSParser)this.createSACParser();
        parser.setDocumentHandler(handler);
        parser.setErrorHandler(errorHandler);
        try {
            this.parseRule(re, parser);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return index;
    }

    void parseRule(Reader reader, Parser parser) throws DOMException, IOException {
        try {
            parser.parseRule(reader);
        }
        catch (CSSNamespaceParseException e) {
            DOMException ex = new DOMException(14, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (CSSBudgetException e) {
            throw new DOMNotSupportedException(e.getMessage(), e);
        }
        catch (CSSParseException e) {
            throw new DOMSyntaxException("Parse error at [" + e.getLineNumber() + ',' + e.getColumnNumber() + "]: " + e.getMessage(), e);
        }
        catch (CSSException e) {
            throw new DOMInvalidAccessException(e.getMessage(), e);
        }
        catch (DOMException e) {
            throw e;
        }
        catch (RuntimeException e) {
            String href;
            String message = e.getMessage();
            AbstractCSSStyleSheet parentSS = this.getParentStyleSheet();
            if (parentSS != null && (href = parentSS.getHref()) != null) {
                message = "Error in stylesheet at " + href + ": " + message;
            }
            DOMException ex = new DOMException(11, message);
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public void deleteRule(int index) throws DOMException {
        if (index < 0 || index >= this.cssRules.size()) {
            throw new DOMException(1, "Could not delete rule in rule list: index out of bounds.");
        }
        this.cssRules.remove(index);
    }

    int insertRule(AbstractCSSRule cssrule, int index) {
        cssrule.setParentRule(this);
        return this.cssRules.insertRule(cssrule, index);
    }

    @Override
    public void addRule(AbstractCSSRule cssrule) {
        this.cssRules.add(cssrule);
        cssrule.setParentRule(this);
    }

    @Override
    int addRuleList(CSSRuleArrayList otherRules, int importCount) {
        for (AbstractCSSRule oRule : otherRules) {
            this.addRule(oRule);
        }
        return importCount;
    }

    void updateDescendantsAbsoluteSelectorList(SelectorList parentList) {
        if (this.cssRules != null) {
            for (AbstractCSSRule rule : this.cssRules) {
                if (!(rule instanceof GroupingRule)) continue;
                if (rule.getType() == 1) {
                    StyleRule styleRule = (StyleRule)rule;
                    parentList = styleRule.getSelectorList().replaceNested(parentList);
                    styleRule.setAbsoluteSelectorList(parentList);
                }
                ((GroupingRule)rule).updateDescendantsAbsoluteSelectorList(parentList);
            }
        }
    }

    @Override
    void prioritySplit(AbstractCSSStyleSheet importantSheet, AbstractCSSStyleSheet normalSheet, RuleStore importantStore, RuleStore normalStore) {
        for (AbstractCSSRule r : this.cssRules) {
            r.prioritySplit(importantSheet, normalSheet, importantStore, normalStore);
        }
    }

    @Override
    boolean hasErrorsOrWarnings() {
        for (AbstractCSSRule rule : this.cssRules) {
            if (!rule.hasErrorsOrWarnings()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cssRules == null ? 0 : this.cssRules.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupingRule)) {
            return false;
        }
        GroupingRule other = (GroupingRule)obj;
        return !(this.cssRules == null ? other.cssRules != null : !this.cssRules.equals(other.cssRules));
    }

    private class RuleHandler
    extends SheetHandler {
        private AbstractCSSRule currentRule;
        private int currentInsertionIndex;

        private RuleHandler() {
            super((BaseCSSStyleSheet)GroupingRule.this.getParentStyleSheet(), GroupingRule.this.getOrigin(), (short)0);
            this.currentRule = null;
            this.currentInsertionIndex = 0;
        }

        public void setCurrentInsertionIndex(int index) {
            this.currentInsertionIndex = index;
        }

        @Override
        public void parseStart(ParserControl parserctl) {
            super.parseStart(parserctl);
            this.currentRule = null;
        }

        @Override
        public void importStyle(String uri, String layer, BooleanCondition supportsCondition, MediaQueryList media, String defaultNamespaceURI) {
        }

        @Override
        protected void addLocalRule(AbstractCSSRule rule) throws DOMException {
            if (this.currentRule != null) {
                throw new DOMException(13, "Attempted to parse more than one rule inside this one");
            }
            this.currentRule = rule;
            this.currentInsertionIndex = GroupingRule.this.insertRule(this.currentRule, this.currentInsertionIndex);
        }
    }

    class AllowWarningsRuleErrorHandler
    implements CSSErrorHandler {
        private List<CSSParseException> warnings = null;

        @Override
        public void warning(CSSParseException exception) throws CSSParseException {
            if (this.warnings == null) {
                this.warnings = new LinkedList<CSSParseException>();
            }
            this.warnings.add(exception);
        }

        @Override
        public void error(CSSParseException exception) throws CSSParseException {
            throw exception;
        }

        public List<CSSParseException> getWarnings() {
            return this.warnings;
        }
    }
}

