/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.kademlia.KBucketSet;
import net.i2p.kademlia.SelectionCollector;
import net.i2p.router.RouterContext;
import net.i2p.router.util.HashDistance;
import net.i2p.util.Log;

abstract class PeerSelector {
    protected final Log _log;
    protected final RouterContext _context;

    public PeerSelector(RouterContext ctx) {
        this._context = ctx;
        this._log = this._context.logManager().getLog(this.getClass());
    }

    List<Hash> selectMostReliablePeers(Hash key, int numClosest, Set<Hash> alreadyChecked, KBucketSet<Hash> kbuckets) {
        return this.selectNearestExplicit(key, numClosest, alreadyChecked, kbuckets);
    }

    List<Hash> selectNearestExplicit(Hash key, int maxNumRouters, Set<Hash> peersToIgnore, KBucketSet<Hash> kbuckets) {
        return this.selectNearestExplicitThin(key, maxNumRouters, peersToIgnore, kbuckets);
    }

    List<Hash> selectNearestExplicitThin(Hash key, int maxNumRouters, Set<Hash> peersToIgnore, KBucketSet<Hash> kbuckets) {
        if (peersToIgnore == null) {
            peersToIgnore = new HashSet<Hash>(1);
        }
        peersToIgnore.add(this._context.routerHash());
        MatchSelectionCollector matches = new MatchSelectionCollector(key, peersToIgnore);
        kbuckets.getAll(matches);
        List<Hash> rv = matches.get(maxNumRouters);
        if (this._log.shouldLog(10)) {
            this._log.debug("Searching for " + maxNumRouters + " peers close to " + key + ": " + rv + " (not including " + peersToIgnore + ") [allHashes.size = " + matches.size() + "]");
        }
        return rv;
    }

    List<Hash> selectNearest(Hash key, int maxNumRouters, Set<Hash> peersToIgnore, KBucketSet<Hash> kbuckets) {
        return this.selectNearestExplicit(key, maxNumRouters, peersToIgnore, kbuckets);
    }

    private class MatchSelectionCollector
    implements SelectionCollector<Hash> {
        private final TreeMap<BigInteger, Hash> _sorted;
        private final Hash _key;
        private final Set<Hash> _toIgnore;
        private int _matches;

        public MatchSelectionCollector(Hash key, Set<Hash> toIgnore) {
            this._key = key;
            this._sorted = new TreeMap();
            this._toIgnore = toIgnore;
        }

        @Override
        public void add(Hash entry) {
            if (this._toIgnore.contains(entry)) {
                return;
            }
            RouterInfo info = PeerSelector.this._context.netDb().lookupRouterInfoLocally(entry);
            if (info == null) {
                return;
            }
            if (info.isHidden()) {
                return;
            }
            BigInteger diff = HashDistance.getDistance(this._key, entry);
            this._sorted.put(diff, entry);
            ++this._matches;
        }

        public List<Hash> get(int howMany) {
            ArrayList<Hash> rv = new ArrayList<Hash>(howMany);
            for (int i = 0; i < howMany && !this._sorted.isEmpty(); ++i) {
                rv.add(this._sorted.remove(this._sorted.firstKey()));
            }
            return rv;
        }

        public int size() {
            return this._matches;
        }
    }
}

