/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAKeyGenParameterSpec;
import net.i2p.crypto.SigType;
import net.i2p.crypto.SigUtil;
import net.i2p.data.SigningPrivateKey;

final class RSASigningPrivateCrtKey
extends SigningPrivateKey {
    private final RSAPrivateCrtKey _crt;

    public static RSASigningPrivateCrtKey fromJavaKey(RSAPrivateCrtKey pk) throws GeneralSecurityException {
        SigType type;
        int sz = pk.getModulus().bitLength();
        if (sz <= ((RSAKeyGenParameterSpec)SigType.RSA_SHA256_2048.getParams()).getKeysize()) {
            type = SigType.RSA_SHA256_2048;
        } else if (sz <= ((RSAKeyGenParameterSpec)SigType.RSA_SHA384_3072.getParams()).getKeysize()) {
            type = SigType.RSA_SHA384_3072;
        } else if (sz <= ((RSAKeyGenParameterSpec)SigType.RSA_SHA512_4096.getParams()).getKeysize()) {
            type = SigType.RSA_SHA512_4096;
        } else {
            throw new GeneralSecurityException("Unknown RSA type");
        }
        BigInteger n = pk.getModulus();
        BigInteger d = pk.getPrivateExponent();
        byte[] b = SigUtil.combine(n, d, type.getPrivkeyLen());
        return new RSASigningPrivateCrtKey(pk, type, b);
    }

    private RSASigningPrivateCrtKey(RSAPrivateCrtKey pk, SigType type, byte[] data) {
        super(type, data);
        this._crt = pk;
    }

    public RSAPrivateCrtKey toJavaKey() {
        return this._crt;
    }
}

