/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.Attribute;
import io.github.dmlloyd.classfile.AttributeMapper;
import io.github.dmlloyd.classfile.impl.BufWriterImpl;
import io.github.dmlloyd.classfile.impl.Util;
import java.util.Arrays;

public class AttributeHolder {
    private static final Attribute<?>[] EMPTY_ATTRIBUTE_ARRAY = new Attribute[0];
    private int attributesCount = 0;
    private Attribute<?>[] attributes = EMPTY_ATTRIBUTE_ARRAY;

    public <A extends Attribute<A>> void withAttribute(Attribute<?> a) {
        if (a == null) {
            return;
        }
        AttributeMapper<?> am = a.attributeMapper();
        int attributesCount = this.attributesCount;
        Attribute<?>[] attributes = this.attributes;
        if (!am.allowMultiple()) {
            for (int i = attributesCount - 1; i >= 0; --i) {
                if (attributes[i].attributeMapper() != am) continue;
                System.arraycopy(attributes, i + 1, attributes, i, --attributesCount - i);
            }
        }
        if (attributesCount >= attributes.length) {
            int newCapacity = attributesCount + 4;
            this.attributes = attributes = Arrays.copyOf(attributes, newCapacity);
        }
        attributes[attributesCount] = a;
        this.attributesCount = attributesCount + 1;
    }

    public int size() {
        return this.attributesCount;
    }

    public void writeTo(BufWriterImpl buf) {
        int attributesCount = this.attributesCount;
        buf.writeU2(attributesCount);
        for (int i = 0; i < attributesCount; ++i) {
            Util.writeAttribute(buf, this.attributes[i]);
        }
    }

    <A extends Attribute<A>> A get(AttributeMapper<A> am) {
        for (int i = 0; i < this.attributesCount; ++i) {
            Attribute<?> a = this.attributes[i];
            if (a.attributeMapper() != am) continue;
            return (A)a;
        }
        return null;
    }

    boolean isPresent(AttributeMapper<?> am) {
        for (int i = 0; i < this.attributesCount; ++i) {
            if (this.attributes[i].attributeMapper() != am) continue;
            return true;
        }
        return false;
    }
}

