/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.ProjectCalendarDateRanges;
import net.sf.mpxj.RecurringData;
import net.sf.mpxj.common.DateHelper;

public final class ProjectCalendarException
extends ProjectCalendarDateRanges
implements Comparable<ProjectCalendarException> {
    private Date m_fromDate;
    private Date m_toDate;
    private String m_name;
    private RecurringData m_recurring;

    ProjectCalendarException(Date date, Date date2) {
        this.m_fromDate = DateHelper.getDayStartDate(date);
        this.m_toDate = DateHelper.getDayEndDate(date2);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public Date getFromDate() {
        return this.m_fromDate;
    }

    public Date getToDate() {
        return this.m_toDate;
    }

    public RecurringData getRecurring() {
        return this.m_recurring;
    }

    public void setRecurring(RecurringData recurringData) {
        this.m_recurring = recurringData;
    }

    public boolean getWorking() {
        return this.getRangeCount() != 0;
    }

    public boolean contains(Date date) {
        boolean bl = false;
        if (date != null) {
            bl = DateHelper.compare(this.getFromDate(), this.getToDate(), date) == 0;
        }
        return bl;
    }

    @Override
    public int compareTo(ProjectCalendarException projectCalendarException) {
        long l;
        long l2 = this.m_fromDate.getTime();
        return l2 < (l = projectCalendarException.m_fromDate.getTime()) ? -1 : (l2 == l ? 0 : 1);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ProjectCalendarException");
        if (this.m_name != null && !this.m_name.isEmpty()) {
            stringBuilder.append(" name=" + this.m_name);
        }
        stringBuilder.append(" working=" + this.getWorking());
        stringBuilder.append(" fromDate=" + String.valueOf(this.m_fromDate));
        stringBuilder.append(" toDate=" + String.valueOf(this.m_toDate));
        if (this.m_recurring != null) {
            stringBuilder.append(" recurring=" + String.valueOf(this.m_recurring));
        }
        for (DateRange dateRange : this) {
            stringBuilder.append(dateRange.toString());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

