/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.event.ActionEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.awt.ContextAction;
import org.openide.awt.ContextSelection;
import org.openide.awt.GeneralAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

class ContextManager {
    private static final Logger LOG = GeneralAction.LOG;
    private static final Map<LookupRef, Reference<ContextManager>> CACHE = new HashMap<LookupRef, Reference<ContextManager>>();
    private static final Map<LookupRef, Reference<ContextManager>> SURVIVE = new HashMap<LookupRef, Reference<ContextManager>>();
    private Map<Class, LSet> listeners = new HashMap<Class, LSet>();
    private Lookup lookup;
    private LSet<Lookup.Provider> selectionAll;

    private ContextManager(Lookup lookup) {
        this.lookup = lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContextManager findManager(Lookup lookup, boolean bl) {
        Map<LookupRef, Reference<ContextManager>> map = CACHE;
        synchronized (map) {
            ContextManager contextManager;
            Map<LookupRef, Reference<ContextManager>> map2 = bl ? SURVIVE : CACHE;
            LookupRef lookupRef = new LookupRef(lookup);
            GMReference gMReference = map2.get(lookupRef);
            ContextManager contextManager2 = contextManager = gMReference == null ? null : gMReference.get();
            if (contextManager == null) {
                contextManager = bl ? new SurviveManager(lookup) : new ContextManager(lookup);
                gMReference = new GMReference(contextManager, lookupRef, bl);
                map2.put(lookupRef, gMReference);
            }
            return contextManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache(LookupRef lookupRef, GMReference gMReference, boolean bl) {
        Map<LookupRef, Reference<ContextManager>> map = CACHE;
        synchronized (map) {
            Map<LookupRef, Reference<ContextManager>> map2;
            Map<LookupRef, Reference<ContextManager>> map3 = map2 = bl ? SURVIVE : CACHE;
            if (map2.get(lookupRef) == gMReference) {
                map2.remove(lookupRef);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void registerListener(Class<T> clazz, ContextAction<T> contextAction) {
        Map<LookupRef, Reference<ContextManager>> map = CACHE;
        synchronized (map) {
            LSet<T> lSet = this.findLSet(clazz);
            if (lSet == null) {
                Lookup.Result<T> result = this.createResult(this.lookup.lookupResult(clazz));
                lSet = new LSet<T>(result, clazz);
                this.listeners.put(clazz, lSet);
            }
            lSet.add(contextAction);
            if (contextAction.selectMode == ContextSelection.ALL) {
                this.initSelectionAll();
                this.selectionAll.add(contextAction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void unregisterListener(Class<T> clazz, ContextAction<T> contextAction) {
        Map<LookupRef, Reference<ContextManager>> map = CACHE;
        synchronized (map) {
            LSet<T> lSet = this.findLSet(clazz);
            if (lSet != null) {
                lSet.remove(contextAction);
                if (lSet.isEmpty()) {
                    this.listeners.remove(clazz);
                    ((LSet)lSet).cleanup();
                }
            }
            if (contextAction.selectMode == ContextSelection.ALL && this.selectionAll != null) {
                this.selectionAll.remove(contextAction);
                if (this.selectionAll.isEmpty() && !this.isSurvive()) {
                    this.selectionAll = null;
                }
            }
        }
    }

    public boolean isSurvive() {
        return false;
    }

    public <T> boolean isEnabled(Class<T> clazz, ContextSelection contextSelection, ContextAction.Performer<? super T> performer) {
        Lookup.Result<T> result = this.findResult(clazz);
        boolean bl = this.isEnabledOnData(result, clazz, contextSelection);
        if (performer != null) {
            if (bl) {
                List<T> list = this.listFromResult(result);
                bl = performer.enabled(list, new LkpAE<T>(list, clazz));
            } else if (performer != null) {
                performer.detach();
            }
        }
        return bl;
    }

    public <T> boolean runEnabled(Class<T> clazz, ContextSelection contextSelection, BiFunction<List<? extends T>, Lookup.Provider, Boolean> biFunction) {
        Lookup.Result<T> result = this.findResult(clazz);
        boolean bl = this.isEnabledOnData(result, clazz, contextSelection);
        if (bl) {
            List<T> list = this.listFromResult(result);
            bl = biFunction.apply(list, new LkpAE<T>(list, clazz));
        }
        return bl;
    }

    private <T> boolean isEnabledOnData(Lookup.Result<T> result, Class<T> clazz, ContextSelection contextSelection) {
        boolean bl = this.isEnabledOnDataImpl(result, clazz, contextSelection);
        LOG.log(Level.FINE, "isEnabledOnData(result, {0}, {1}) = {2}", new Object[]{clazz, contextSelection, bl});
        return bl;
    }

    private <T> boolean isEnabledOnDataImpl(Lookup.Result<T> result, Class<T> clazz, ContextSelection contextSelection) {
        switch (contextSelection) {
            case EXACTLY_ONE: {
                HashSet hashSet = new HashSet(result.allItems());
                return hashSet.size() == 1;
            }
            case ANY: {
                return !result.allItems().isEmpty();
            }
            case EACH: {
                if (result.allItems().isEmpty()) {
                    return false;
                }
                Lookup.Result result2 = this.lookup.lookupResult(Lookup.Provider.class);
                if (result.allItems().size() != result2.allItems().size()) {
                    return false;
                }
                Lookup.Template template = new Lookup.Template(clazz);
                for (Lookup.Provider provider : result2.allInstances()) {
                    if (provider.getLookup().lookupItem(template) != null) continue;
                    return false;
                }
                return true;
            }
            case ALL: {
                if (result.allItems().isEmpty()) {
                    return false;
                }
                Lookup.Result result3 = this.lookup.lookupResult(Lookup.Provider.class);
                if (result.allItems().size() < result3.allItems().size()) {
                    return false;
                }
                Lookup.Template template = new Lookup.Template(clazz);
                for (Lookup.Provider provider : result3.allInstances()) {
                    if (provider.getLookup().lookupItem(template) != null) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> LSet<T> findLSet(Class<T> clazz) {
        Map<LookupRef, Reference<ContextManager>> map = CACHE;
        synchronized (map) {
            return this.listeners.get(clazz);
        }
    }

    private <T> Lookup.Result<T> findResult(Class<T> clazz) {
        LSet<T> lSet = this.findLSet(clazz);
        Lookup.Result result = lSet != null ? lSet.result : this.lookup.lookupResult(clazz);
        return result;
    }

    protected <T> Lookup.Result<T> createResult(Lookup.Result<T> result) {
        return result;
    }

    public <T> void actionPerformed(ActionEvent actionEvent, ContextAction.Performer<? super T> performer, Class<T> clazz, ContextSelection contextSelection) {
        Lookup.Result<T> result = this.findResult(clazz);
        List<T> list = this.listFromResult(result);
        performer.actionPerformed(actionEvent, Collections.unmodifiableList(list), new LkpAE<T>(list, clazz));
    }

    private <T> List<? extends T> listFromResult(Lookup.Result<T> result) {
        List list;
        List list2 = result.allInstances();
        LinkedHashSet linkedHashSet = new LinkedHashSet(list2);
        if (linkedHashSet.size() != list2.size()) {
            list = new ArrayList(linkedHashSet.size());
            list.addAll(linkedHashSet);
            list2 = list;
        }
        if (list2 instanceof List) {
            list = list2;
        } else {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(list2);
            list = arrayList;
        }
        return list;
    }

    private Lookup.Result<Lookup.Provider> initSelectionAll() {
        assert (Thread.holdsLock(CACHE));
        if (this.selectionAll == null) {
            Lookup.Result result = this.lookup.lookupResult(Lookup.Provider.class);
            this.selectionAll = new LSet<Lookup.Provider>(result, Lookup.Provider.class);
        }
        return this.selectionAll.result;
    }

    static class LookupRef
    extends WeakReference<Lookup> {
        private final int hashCode;

        public LookupRef(Lookup lookup) {
            super(lookup);
            this.hashCode = System.identityHashCode(lookup);
        }

        public boolean equals(Object object) {
            if (object instanceof LookupRef) {
                LookupRef lookupRef = (LookupRef)object;
                return this.get() == lookupRef.get();
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    static final class LSet<T>
    extends WeakSet<ContextAction>
    implements LookupListener,
    Runnable {
        final Lookup.Result<T> result;

        public LSet(Lookup.Result<T> result, Class<T> clazz) {
            this.result = result;
            this.result.addLookupListener((LookupListener)this);
            this.result.allItems();
        }

        public boolean add(ContextAction contextAction) {
            assert (contextAction != null);
            return super.add((Object)contextAction);
        }

        public void resultChanged(LookupEvent lookupEvent) {
            Mutex.EVENT.readAccess((Runnable)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ContextAction[] contextActionArray;
            Map map = CACHE;
            synchronized (map) {
                contextActionArray = (ContextAction[])this.toArray(new ContextAction[0]);
            }
            long l = 0L;
            assert ((l = System.currentTimeMillis()) >= 0L);
            for (ContextAction contextAction : contextActionArray) {
                if (contextAction == null) continue;
                contextAction.updateState();
            }
            long l2 = 0L;
            assert ((l2 = System.currentTimeMillis() - l) >= 0L);
            if (l2 > 2000L) {
                LOG.log(Level.WARNING, "Updating state of {1} actions took {0} ms. here is the action list:", new Object[]{l2, contextActionArray.length});
                for (ContextAction contextAction : contextActionArray) {
                    LOG.log(Level.INFO, "  {0}", contextAction);
                }
            }
        }

        private void cleanup() {
            this.result.removeLookupListener((LookupListener)this);
        }
    }

    private static final class NeverEmptyResult<T>
    extends Lookup.Result<T>
    implements LookupListener {
        private final Lookup.Result<T> delegate;
        private final Lookup.Result<Lookup.Provider> nodes;
        private final Collection<LookupListener> listeners;
        private Collection<? extends Lookup.Item<T>> allItems;
        private Collection<? extends T> allInstances;
        private Set<Class<? extends T>> allClasses;

        public NeverEmptyResult(Lookup.Result<T> result, Lookup.Result<Lookup.Provider> result2) {
            this.delegate = result;
            this.nodes = result2;
            this.listeners = new CopyOnWriteArrayList<LookupListener>();
            this.delegate.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.delegate));
            this.nodes.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.nodes));
            this.initValues();
        }

        public void addLookupListener(LookupListener lookupListener) {
            this.listeners.add(lookupListener);
        }

        public void removeLookupListener(LookupListener lookupListener) {
            this.listeners.remove(lookupListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<? extends Lookup.Item<T>> allItems() {
            Collection collection = this.delegate.allItems();
            NeverEmptyResult neverEmptyResult = this;
            synchronized (neverEmptyResult) {
                if (!collection.isEmpty()) {
                    this.allItems = collection;
                }
                return this.allItems;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<? extends T> allInstances() {
            Collection collection = this.delegate.allInstances();
            NeverEmptyResult neverEmptyResult = this;
            synchronized (neverEmptyResult) {
                if (!collection.isEmpty()) {
                    this.allInstances = collection;
                }
                return this.allInstances;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<Class<? extends T>> allClasses() {
            Set set = this.delegate.allClasses();
            NeverEmptyResult neverEmptyResult = this;
            synchronized (neverEmptyResult) {
                if (!set.isEmpty()) {
                    this.allClasses = set;
                }
                return this.allClasses;
            }
        }

        public void resultChanged(LookupEvent lookupEvent) {
            if (lookupEvent.getSource() == this.nodes) {
                Collection collection = this.nodes.allItems();
                if (collection.size() == 1 && ((Lookup.Item)collection.iterator().next()).getInstance() == null) {
                    return;
                }
                this.initValues();
                return;
            }
            LookupEvent lookupEvent2 = new LookupEvent((Lookup.Result)this);
            for (LookupListener lookupListener : this.listeners) {
                lookupListener.resultChanged(lookupEvent2);
            }
        }

        private synchronized void initValues() {
            this.allItems = Collections.emptyList();
            this.allInstances = Collections.emptyList();
            this.allClasses = Collections.emptySet();
        }
    }

    private static final class SurviveManager
    extends ContextManager {
        private SurviveManager(Lookup lookup) {
            super(lookup);
        }

        @Override
        public boolean isSurvive() {
            return true;
        }

        @Override
        protected <T> Lookup.Result<T> createResult(Lookup.Result<T> result) {
            return new NeverEmptyResult<T>(result, (Lookup.Result<Lookup.Provider>)((ContextManager)this).initSelectionAll());
        }
    }

    private static final class GMReference
    extends WeakReference<ContextManager>
    implements Runnable {
        private LookupRef context;
        private boolean survive;

        public GMReference(ContextManager contextManager, LookupRef lookupRef, boolean bl) {
            super(contextManager, Utilities.activeReferenceQueue());
            this.context = lookupRef;
            this.survive = bl;
        }

        @Override
        public void run() {
            ContextManager.clearCache(this.context, this, this.survive);
        }
    }

    private final class LkpAE<T>
    implements Lookup.Provider {
        final List<? extends T> all;
        final Class<T> type;
        private Lookup lookup;

        public LkpAE(List<? extends T> list, Class<T> clazz) {
            this.all = list;
            this.type = clazz;
        }

        public Lookup getLookup() {
            if (this.lookup == null) {
                this.lookup = new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])this.all.toArray()), Lookups.exclude((Lookup)ContextManager.this.lookup, (Class[])new Class[]{this.type})});
            }
            return this.lookup;
        }
    }
}

