/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.meta;

import brut.androlib.ApktoolProperties;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.meta.PackageInfo;
import brut.androlib.meta.SdkInfo;
import brut.androlib.meta.UsesFramework;
import brut.androlib.meta.VersionInfo;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import brut.yaml.YamlLine;
import brut.yaml.YamlReader;
import brut.yaml.YamlSerializable;
import brut.yaml.YamlWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;

public final class ApkInfo
implements YamlSerializable {
    public static final String[] RESOURCES_DIRNAMES;
    public static final String[] RAW_DIRNAMES;
    public static final Pattern ORIGINAL_FILENAMES_PATTERN;
    public static final Pattern STANDARD_FILENAMES_PATTERN;
    public String mVersion = ApktoolProperties.get("application.version");
    public String mApkFileName = null;
    public final UsesFramework mUsesFramework = new UsesFramework();
    public final ArrayList mUsesLibrary = new ArrayList();
    public final SdkInfo mSdkInfo = new SdkInfo();
    public final PackageInfo mPackageInfo = new PackageInfo();
    public final VersionInfo mVersionInfo = new VersionInfo();
    public final LinkedHashMap mFeatureFlags = new LinkedHashMap();
    public Boolean mSparseResources = null;
    public Boolean mCompactEntries = null;
    public final ArrayList mDoNotCompress = new ArrayList();
    public ExtFile mApkFile;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApkInfo load(InputStream object) {
        YamlLine yamlLine;
        ApkInfo apkInfo;
        YamlReader yamlReader;
        YamlReader yamlReader2 = yamlReader;
        yamlReader = new YamlReader((InputStream)object);
        object = apkInfo;
        apkInfo = new ApkInfo();
        if (yamlReader.isEnd()) return object;
        if (!yamlReader2.isEnd()) {
            YamlReader yamlReader3;
            do {
                yamlLine = (YamlLine)yamlReader2.mLines.get(yamlReader2.mCurrent);
                if (!yamlLine.isEmpty && !yamlLine.isComment) break;
                yamlReader3 = yamlReader2;
                ++yamlReader3.mCurrent;
            } while (!yamlReader3.isEnd());
        }
        while (!yamlReader2.isEnd()) {
            yamlLine = (YamlLine)yamlReader2.mLines.get(yamlReader2.mCurrent);
            if (yamlLine.indent == 0 && yamlLine.hasColon) {
                ((ApkInfo)object).readItem(yamlReader2);
                yamlReader2.nextLine();
                continue;
            }
            yamlReader2.nextLine();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ApkInfo load(ExtFile extFile) {
        ApkInfo apkInfo;
        InputStream inputStream = extFile.getDirectory().getFileInput("apktool.yml");
        try {
            apkInfo = ApkInfo.load(inputStream);
            apkInfo.mApkFile = extFile;
            if (apkInfo.mApkFileName == null) {
                apkInfo.mApkFileName = extFile.getName();
            }
            if (inputStream == null) return apkInfo;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                void var0_4;
                try {
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new AndrolibException((Exception)var0_4);
                }
                catch (DirectoryException directoryException) {
                    throw new AndrolibException((Exception)var0_4);
                }
            }
        }
        inputStream.close();
        return apkInfo;
    }

    static {
        Pattern pattern;
        CharSequence[] charSequenceArray = new String[3];
        CharSequence[] charSequenceArray2 = charSequenceArray;
        charSequenceArray[0] = "res";
        charSequenceArray[1] = "r";
        charSequenceArray[2] = "R";
        RESOURCES_DIRNAMES = charSequenceArray;
        CharSequence[] charSequenceArray3 = new String[2];
        CharSequence[] charSequenceArray4 = charSequenceArray3;
        charSequenceArray3[0] = "assets";
        charSequenceArray3[1] = "lib";
        RAW_DIRNAMES = charSequenceArray3;
        ORIGINAL_FILENAMES_PATTERN = pattern = Pattern.compile("AndroidManifest\\.xml|META-INF/[^/]+\\.(RSA|SF|MF)|stamp-cert-sha256");
        STANDARD_FILENAMES_PATTERN = Pattern.compile("[^/]+\\.dex|resources\\.arsc|(" + String.join((CharSequence)"|", charSequenceArray2) + "|" + String.join((CharSequence)"|", charSequenceArray4) + ")/.*|" + pattern.pattern());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void save(File file) {
        YamlWriter yamlWriter;
        ApkInfo apkInfo = yamlWriter2;
        YamlWriter yamlWriter2 = yamlWriter;
        yamlWriter = new YamlWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]));
        try {
            apkInfo.write(yamlWriter);
        }
        catch (Throwable throwable) {
            try {
                yamlWriter2.mWriter.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                try {
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new AndrolibException(exception);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new AndrolibException("File not found");
                }
            }
        }
        yamlWriter2.mWriter.close();
    }

    @Override
    public final void readItem(YamlReader yamlReader) {
        YamlLine yamlLine = (YamlLine)yamlReader.mLines.get(yamlReader.mCurrent);
        String string = yamlLine.getKey();
        string.getClass();
        int n = -1;
        switch (string.hashCode()) {
            default: {
                break;
            }
            case 1947723784: {
                if (!string.equals("sdkInfo")) break;
                n = 10;
                break;
            }
            case 1607152463: {
                if (!string.equals("usesLibrary")) break;
                n = 9;
                break;
            }
            case 1185869105: {
                if (!string.equals("featureFlags")) break;
                n = 8;
                break;
            }
            case 1078908901: {
                if (!string.equals("sparseResources")) break;
                n = 7;
                break;
            }
            case 908622356: {
                if (!string.equals("packageInfo")) break;
                n = 6;
                break;
            }
            case 720675821: {
                if (!string.equals("compactEntries")) break;
                n = 5;
                break;
            }
            case 688769446: {
                if (!string.equals("versionInfo")) break;
                n = 4;
                break;
            }
            case 459524195: {
                if (!string.equals("apkFileName")) break;
                n = 3;
                break;
            }
            case 351608024: {
                if (!string.equals("version")) break;
                n = 2;
                break;
            }
            case -639607350: {
                if (!string.equals("doNotCompress")) break;
                n = 1;
                break;
            }
            case -1981305966: {
                if (!string.equals("usesFramework")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 10: {
                YamlSerializable yamlSerializable = yamlSerializable.mSdkInfo;
                yamlSerializable.mSdkInfo.mMinSdkVersion = null;
                yamlSerializable.mSdkInfo.mTargetSdkVersion = null;
                yamlSerializable.mSdkInfo.mMaxSdkVersion = null;
                yamlReader.readObject(yamlSerializable);
                break;
            }
            case 9: {
                ApkInfo apkInfo = yamlSerializable;
                apkInfo.mUsesLibrary.clear();
                yamlReader.readStringList(apkInfo.mUsesLibrary);
                break;
            }
            case 8: {
                ApkInfo apkInfo = yamlSerializable;
                apkInfo.mFeatureFlags.clear();
                yamlReader.readBoolMap(apkInfo.mFeatureFlags);
                break;
            }
            case 7: {
                yamlSerializable.mSparseResources = yamlLine.getValueBool();
                break;
            }
            case 6: {
                YamlSerializable yamlSerializable = yamlSerializable.mPackageInfo;
                yamlSerializable.mPackageInfo.mForcedPackageId = null;
                yamlSerializable.mPackageInfo.mRenameManifestPackage = null;
                yamlReader.readObject(yamlSerializable);
                break;
            }
            case 5: {
                yamlSerializable.mCompactEntries = yamlLine.getValueBool();
                break;
            }
            case 4: {
                YamlSerializable yamlSerializable = yamlSerializable.mVersionInfo;
                yamlSerializable.mVersionInfo.mVersionCode = null;
                yamlSerializable.mVersionInfo.mVersionName = null;
                yamlReader.readObject(yamlSerializable);
                break;
            }
            case 3: {
                yamlSerializable.mApkFileName = yamlLine.getValue();
                break;
            }
            case 2: {
                yamlSerializable.mVersion = yamlLine.getValue();
                break;
            }
            case 1: {
                ApkInfo apkInfo = yamlSerializable;
                apkInfo.mDoNotCompress.clear();
                yamlReader.readStringList(apkInfo.mDoNotCompress);
                break;
            }
            case 0: {
                ApkInfo apkInfo = yamlSerializable;
                apkInfo.mUsesFramework.mIds.clear();
                apkInfo.mUsesFramework.mTag = null;
                yamlReader.readObject(apkInfo.mUsesFramework);
            }
        }
    }

    @Override
    public final void write(YamlWriter yamlWriter) {
        Object object;
        Object object2;
        yamlWriter.writeString("version", this.mVersion);
        yamlWriter.writeString("apkFileName", this.mApkFileName);
        Object object3 = this.mUsesFramework;
        if (!((UsesFramework)object3).mIds.isEmpty() || ((UsesFramework)object3).mTag != null) {
            yamlWriter.writeObject("usesFramework", this.mUsesFramework);
        }
        if (!this.mUsesLibrary.isEmpty()) {
            yamlWriter.writeList("usesLibrary", this.mUsesLibrary);
        }
        object3 = this.mSdkInfo;
        if (((SdkInfo)object3).mMinSdkVersion != null || ((SdkInfo)object3).mTargetSdkVersion != null || ((SdkInfo)object3).mMaxSdkVersion != null) {
            yamlWriter.writeObject("sdkInfo", (YamlSerializable)object3);
        }
        object3 = this.mPackageInfo;
        if (((PackageInfo)object3).mForcedPackageId != null || ((PackageInfo)object3).mRenameManifestPackage != null) {
            yamlWriter.writeObject("packageInfo", (YamlSerializable)object3);
        }
        object3 = this.mVersionInfo;
        if (((VersionInfo)object3).mVersionCode != null || ((VersionInfo)object3).mVersionName != null) {
            yamlWriter.writeObject("versionInfo", (YamlSerializable)object3);
        }
        if (!this.mFeatureFlags.isEmpty()) {
            object3 = this.mFeatureFlags;
            object2 = "featureFlags";
            if (object3 == null) {
                yamlWriter.getClass();
            } else {
                YamlWriter yamlWriter2 = yamlWriter;
                yamlWriter2.writeIndent();
                yamlWriter2.mWriter.println(YamlWriter.escape((String)object2) + ":");
                yamlWriter2.mIndent += 2;
                for (String string : ((LinkedHashMap)object3).keySet()) {
                    yamlWriter.writeString(string, String.valueOf(((LinkedHashMap)object3).get(string)));
                }
                int n = yamlWriter.mIndent;
                if (n != 0) {
                    yamlWriter.mIndent = n - 2;
                }
            }
        }
        if ((object = this.mSparseResources) != null) {
            Boolean bl = object;
            object = "sparseResources";
            boolean bl2 = bl;
            yamlWriter.writeIndent();
            object2 = bl2 ? "true" : "false";
            yamlWriter.mWriter.println(YamlWriter.escape((String)object) + ": " + (String)object2);
        }
        if ((object = this.mCompactEntries) != null) {
            Object object4 = object;
            object = "compactEntries";
            boolean bl = (Boolean)object4;
            yamlWriter.writeIndent();
            object2 = bl ? "true" : "false";
            yamlWriter.mWriter.println(YamlWriter.escape((String)object) + ": " + (String)object2);
        }
        if (!this.mDoNotCompress.isEmpty()) {
            yamlWriter.writeList("doNotCompress", this.mDoNotCompress);
        }
    }

    public final boolean hasResources() {
        ExtFile extFile = ((ApkInfo)((Object)extFile)).mApkFile;
        if (extFile == null) {
            return false;
        }
        try {
            return extFile.getDirectory().containsFile("resources.arsc");
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException(directoryException);
        }
    }
}

