/* SPDX-License-Identifier: GPL-2.0-only */

/*
 * This file is created based on MT8196 Functional Specification
 * Chapter number: 13.4
 */

#ifndef SOC_MEDIATEK_MT8196_GPIO_H
#define SOC_MEDIATEK_MT8196_GPIO_H

#include <soc/addressmap.h>
#include <soc/gpio_common.h>
#include <soc/gpio_defs.h>
#include <types.h>

#define GPIO_NUM 271

struct gpio_regs {
	struct gpio_val_regs dir[16];
	struct gpio_val_regs dout[16];
	struct gpio_val_regs din[16];
	struct gpio_val_regs mode[32];
	uint32_t dram_pinmux_trapping;
};

enum {
	PIN(0, EINT0, 0, 0, 0x18, 0xa0,
		DMIC1_CLK, RES2, SPI3_A_MO, FMI2S_B_LRCK,
		SCP_DMIC1_CLK, TP_GPIO14_AO, RES7),
	PIN(1, EINT1, 0, 1, 0x18, 0xa0,
		DMIC1_DAT, SRCLKENAI1, SPI3_A_MI, FMI2S_B_DI,
		SCP_DMIC1_DAT, TP_GPIO15_AO, RES7),
	PIN(2, EINT2, 0, 1, 0x1b, 0x80,
		PWM_VLP, DSI_HSYNC, RES3, RES4,
		RG_TSFDC_LDO_EN, TP_GPIO8_AO, RES7),
	PIN(3, EINT3, 0, 2, 0x1b, 0x80,
		MD_INT0, DSI1_HSYNC, RES3, RES4,
		DA_TSFDC_LDO_MODE, TP_GPIO9_AO, RES7),
	PIN(4, EINT4, 0, 3, 0x1b, 0x80,
		DISP_PWM1, MD32_0_GPIO0, RES3, RES4,
		RES5, RES6, RES7),
	PIN(5, EINT5, 0, 4, 0x1b, 0x80,
		LCM1_RST, SPI7_A_CLK, RES3, RES4,
		RES5, RES6, RES7),
	PIN(6, EINT6, 0, 5, 0x1b, 0x80,
		DSI1_TE, SPI7_A_CSB, RES3, RES4,
		RES5, RES6, RES7),
	PIN(7, EINT7, 0, 6, 0x1b, 0x80,
		RES1, SPI7_A_MO, GPS_PPS0, RES4,
		RES5, RES6, RES7),
	PIN(8, EINT8, 0, 7, 0x1b, 0x80,
		RES1, SPI7_A_MI, EDP_TX_HPD, RES4,
		RES5, RES6, RES7),
	PIN(9, EINT9, 0, 14, 0x29, 0xc0,
		RES1, RES2, I2SIN1_LRCK, RES4,
		RES5, RES6, RG_TSFDC_LDO_REFSEL0),
	PIN(10, EINT10, 0, 12, 0x29, 0xc0,
		RES1, RES2, I2SOUT1_DO, RES4,
		RES5, RES6, RG_TSFDC_LDO_REFSEL1),
	PIN(11, EINT11, 0, 2, 0x18, 0xa0,
		RES1, RES2, RES3, FMI2S_B_BCK,
		RES5, RES6, DBG_MON_A30),
	PIN(12, EINT12, 0, 13, 0x29, 0xc0,
		RES1, RES2, I2SIN1_DI_B, RES4,
		RES5, RES6, RES7),
	PIN(13, EINT13, 0, 1, 0x26, 0xb0,
		EDP_TX_HPD, GPS_PPS1, RES3, RES4,
		RES5, RES6, RES7),
	PIN(14, EINT14, 0, 0, 0x13, 0x90,
		SRCLKENA2, DSI2_TE, SPMI_P_TRIG_FLAG, RES4,
		MD_INT3, TP_GPIO8_AO, RES7),
	PIN(15, EINT15, 0, 2, 0x26, 0xb0,
		SRCLKENAI0, SPMI_M_TRIG_FLAG, UCTS0, MD_INT4,
		I2SOUT2_DO, TP_GPIO9_AO, RES7),
	PIN(16, EINT16, 0, 3, 0x26, 0xb0,
		SRCLKENAI1, DP_TX_HPD, URTS0, GPS_L5_ELNA_EN,
		KPROW2, TP_GPIO10_AO, RES7),
	PIN(17, EINT17, 0, 4, 0x26, 0xb0,
		MD_INT0, DP_OC_EN, UCTS1, MD_NTN_URXD1,
		KPCOL2, TP_GPIO11_AO, RES7),
	PIN(18, EINT18, 0, 5, 0x26, 0xb0,
		DMIC1_CLK, DP_RAUX_SBU1, URTS1, MD_NTN_UTXD1,
		I2SIN2_DI, TP_UTXD_GNSS_VLP, RES7),
	PIN(19, EINT19, 0, 6, 0x26, 0xb0,
		DMIC1_DAT, DP_RAUX_SBU2, CONN_TCXOENA_REQ, CLKM3_A,
		I2SIN2_BCK, TP_URXD_GNSS_VLP, RES7),
	PIN(20, EINT20, 0, 1, 0x13, 0x90,
		IDDIG, LCM2_RST, GPS_PPS1, CLKM2_A,
		RES5, RES6, RES7),
	PIN(21, EINT21, 0, 3, 0x12, 0x90,
		BPI_BUS11, PCIE_PERSTN_1P, DSI1_TE, DMIC_CLK,
		SCP_DMIC_CLK, RES6, RES7),
	PIN(22, EINT22, 0, 4, 0x12, 0x90,
		BPI_BUS12, PCIE_CLKREQN_1P, DSI2_TE, DMIC_DAT,
		SCP_DMIC_DAT, RES6, RES7),
	PIN(23, EINT23, 0, 5, 0x12, 0x90,
		BPI_BUS13, PCIE_WAKEN_1P, DSI3_TE, DMIC1_CLK,
		SCP_DMIC1_CLK, RES6, RES7),
	PIN(24, EINT24, 0, 6, 0x12, 0x90,
		BPI_BUS14, LCM1_RST, AGPS_SYNC, DMIC1_DAT,
		SCP_DMIC1_DAT, DISP_PWM1, RES7),
	PIN(25, EINT25, 0, 7, 0x12, 0x90,
		BPI_BUS15, LCM2_RST, SRCLKENAI1, DMIC2_CLK,
		RES5, DISP_PWM2, RES7),
	PIN(26, EINT26, 0, 8, 0x12, 0x90,
		BPI_BUS16, LCM3_RST, RES3, DMIC2_DAT,
		RES5, DISP_PWM3, RES7),
	PIN(27, EINT27, 0, 9, 0x12, 0x90,
		BPI_BUS17, UTXD4, RES3, RES4,
		RES5, DISP_PWM4, DBG_MON_A20),
	PIN(28, EINT28, 0, 10, 0x12, 0x90,
		BPI_BUS18, URXD4, SPI2_A_MI, CLKM0_A,
		RES5, RES6, DBG_MON_A21),
	PIN(29, EINT29, 0, 11, 0x12, 0x90,
		BPI_BUS19, MD_NTN_UTXD1, SPI2_A_MO, CLKM1_A,
		RES5, UCTS4, DBG_MON_A17),
	PIN(30, EINT30, 0, 12, 0x12, 0x90,
		BPI_BUS20, MD_NTN_URXD1, SPI2_A_CLK, CLKM2_A,
		DSI3_HSYNC, URTS4, DBG_MON_A18),
	PIN(31, EINT31, 0, 13, 0x12, 0x90,
		BPI_BUS21, RES2, SPI2_A_CSB, CLKM3_A,
		RES5, EDP_TX_HPD, DBG_MON_A19),
	PIN(32, EINT32, 0, 8, 0x11, 0x90,
		LCM4_RST, DP_TX_HPD, SSPM_JTAG_TCK_VLP, ADSP_JTAG0_TCK,
		SCP_JTAG0_TCK_VLP, SPU0_TCK, IO_JTAG_TCK),
	PIN(33, EINT33, 0, 9, 0x11, 0x90,
		DSI4_TE, DP_OC_EN, SSPM_JTAG_TRSTN_VLP, ADSP_JTAG0_TRSTN,
		SCP_JTAG0_TRSTN_VLP, SPU0_NTRST, IO_JTAG_TRSTN),
	PIN(34, EINT34, 0, 10, 0x11, 0x90,
		UCTS5, DP_RAUX_SBU1, SSPM_JTAG_TDI_VLP, ADSP_JTAG0_TDI,
		SCP_JTAG0_TDI_VLP, SPU0_TDI, IO_JTAG_TDI),
	PIN(35, EINT35, 0, 11, 0x11, 0x90,
		URTS5, DP_RAUX_SBU2, SSPM_JTAG_TDO_VLP, ADSP_JTAG0_TDO,
		SCP_JTAG0_TDO_VLP, SPU0_TDO, IO_JTAG_TDO),
	PIN(36, EINT36, 0, 12, 0x11, 0x90,
		UTXD5, RES2, SSPM_JTAG_TMS_VLP, ADSP_JTAG0_TMS,
		SCP_JTAG0_TMS_VLP, SPU0_TMS, IO_JTAG_TMS),
	PIN(37, EINT37, 0, 13, 0x11, 0x90,
		URXD5, RES2, MD_INT3, CLKM0_B,
		TP_GPIO5_AO, SPU0_UTX, DAP_MD32_SWCK),
	PIN(38, EINT38, 0, 14, 0x11, 0x90,
		RES1, SPMI_P_TRIG_FLAG, MD_INT4, CLKM1_B,
		TP_GPIO6_AO, SPU0_URX, DAP_MD32_SWD),
	PIN(39, I2SIN0_MCK, 0, 6, 0x18, 0xa0,
		I2S_MCK0, RES2, GPS_PPS0, CONN_TCXOENA_REQ,
		RES5, RES6, DBG_MON_B12),
	PIN(40, I2SIN0_BCK, 0, 3, 0x18, 0xa0,
		I2SIN6_0_BCK, RES2, SPI4_B_CLK, UCTS2,
		CCU1_UTXD, RES6, DBG_MON_B13),
	PIN(41, I2SIN0_LRCK, 0, 5, 0x18, 0xa0,
		I2SIN6_0_LRCK, RES2, SPI4_B_CSB, URTS2,
		CCU1_URXD, RES6, DBG_MON_B14),
	PIN(42, I2SIN0_DI, 0, 4, 0x18, 0xa0,
		I2SIN6_0_DI, RES2, SPI4_B_MI, URXD2,
		CCU1_URTS, MD32_0_RXD, DBG_MON_B15),
	PIN(43, I2SOUT0_DO, 0, 7, 0x18, 0xa0,
		I2SOUT6_0_DO, RES2, SPI4_B_MO, UTXD2,
		CCU1_UCTS, MD32_0_TXD, DBG_MON_B16),
	PIN(44, INT_SIM1, 0, 8, 0x18, 0xa0,
		MD_INT1_C2K_UIM0_HOT_PLUG, RES2, SPI3_A_CLK, RES4,
		RES5, TP_GPIO10_AO, RES7),
	PIN(45, INT_SIM2, 0, 9, 0x18, 0xa0,
		MD_INT2_C2K_UIM1_HOT_PLUG, DSI2_HSYNC, SPI3_A_CSB, PWM_VLP,
		RES5, TP_GPIO11_AO, RES7),
	PIN(46, SCP_SCL4, 0, 10, 0x18, 0xa0,
		SCP_SCL4, PWM_VLP, RES3, SCP_ILDO_DTEST1_VLP,
		UFS_MPHY_SCL, TP_GPIO0_AO, RES7),
	PIN(47, SCP_SDA4, 0, 13, 0x18, 0xa0,
		SCP_SDA4, RES2, RES3, SCP_ILDO_DTEST2_VLP,
		UFS_MPHY_SDA, TP_GPIO1_AO, RES7),
	PIN(48, SCP_SCL5, 0, 11, 0x18, 0xa0,
		SCP_SCL5, PWM_VLP, CCU0_UTXD, SCP_ILDO_DTEST3_VLP,
		RES5, TP_GPIO2_AO, RES7),
	PIN(49, SCP_SDA5, 0, 14, 0x18, 0xa0,
		SCP_SDA5, RES2, CCU0_URXD, SCP_ILDO_DTEST4_VLP,
		RES5, TP_GPIO3_AO, RES7),
	PIN(50, SCP_SCL6, 0, 12, 0x18, 0xa0,
		SCP_SCL6, PWM_VLP, CCU0_URTS, DSI_HSYNC,
		RES5, TP_GPIO4_AO, RES7),
	PIN(51, SCP_SDA6, 0, 15, 0x18, 0xa0,
		SCP_SDA6, RES2, CCU0_UCTS, DSI1_HSYNC,
		RES5, TP_GPIO5_AO, RES7),
	PIN(52, AUD_SCL, 0, 7, 0x29, 0xc0,
		SCP_SCL1, RES2, TDM_DATA2, RES4,
		RES5, RES6, RES7),
	PIN(53, AUD_SDA, 0, 8, 0x29, 0xc0,
		SCP_SDA1, RES2, TDM_DATA3, RES4,
		RES5, RES6, RES7),
	PIN(54, AUD_CLK_MOSI, 0, 2, 0x29, 0xc0,
		AUD_CLK_MOSI, RES2, TDM_MCK, RES4,
		RES5, RES6, RES7),
	PIN(55, AUD_CLK_MISO, 0, 1, 0x29, 0xc0,
		AUD_CLK_MISO, I2SOUT2_BCK, TDM_BCK, RES4,
		RES5, RES6, RES7),
	PIN(56, AUD_DAT_MOSI0, 0, 5, 0x29, 0xc0,
		AUD_DAT_MOSI0, I2SOUT2_LRCK, TDM_LRCK, RES4,
		RES5, RES6, RES7),
	PIN(57, AUD_DAT_MOSI1, 0, 6, 0x29, 0xc0,
		AUD_DAT_MOSI1, I2SOUT2_DO, TDM_DATA0, RES4,
		RES5, RES6, RES7),
	PIN(58, AUD_DAT_MISO0, 0, 3, 0x29, 0xc0,
		AUD_DAT_MISO0, RES2, TDM_DATA1, RES4,
		RES5, RES6, RES7),
	PIN(59, AUD_DAT_MISO1, 0, 4, 0x29, 0xc0,
		AUD_DAT_MISO1, RES2, I2SIN1_BCK, RES4,
		RES5, RES6, RES7),
	PIN(60, KPCOL0, 1, 0, 0x29, 0xb0,
		KPCOL0, RES2, RES3, RES4,
		RES5, TP_GPIO13_AO, RES7),
	PIN(61, CPUM_PMIC_POC, 0, 10, 0x29, 0xc0,
		MCU_M_PMIC_POC_I, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(62, CPUB_PMIC_POC, 0, 9, 0x29, 0xc0,
		MCU_B_PMIC_POC_I, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(63, GPU_PMIC_POC, 0, 18, 0x29, 0xc0,
		MFG_PMIC_POC_I, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(64, SYS_PMIC_POC, 0, 0, 0x29, 0xc0,
		PRE_UVLO, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(65, DRAM_DVFS, 0, 11, 0x29, 0xc0,
		DPM2PMIC, SRCLKENA1, RES3, RES4,
		RES5, RES6, RES7),
	PIN(66, WATCHDOG, 0, 24, 0x29, 0xc0,
		WATCHDOG, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(67, SRCLKENA0, 0, 21, 0x29, 0xc0,
		SRCLKENA0, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(68, SCP_VREQ_VAO, 0, 20, 0x29, 0xc0,
		SCP_VREQ_VAO, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(69, X32K_IN, 0, 25, 0x29, 0xc0,
		RTC32K_CK, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(70, FL_STROBE_EN, 0, 16, 0x29, 0xc0,
		CMFLASH0, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(71, EINT_CHG_IRQB, 0, 15, 0x29, 0xc0,
		RES1, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(72, USB_RST, 0, 23, 0x29, 0xc0,
		RES1, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(73, LVSYS_INT, 0, 19, 0x29, 0xc0,
		RES1, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(74, FPM_IND, 0, 17, 0x29, 0xc0,
		DCXO_FPM_LPM, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(75, SPMI_M_SCL, 0, 2, 0x1a, 0x90,
		SPMI_M_SCL, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(76, SPMI_M_SDA, 0, 3, 0x1a, 0x90,
		SPMI_M_SDA, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(77, SPMI_P_SCL, 0, 4, 0x1a, 0x90,
		SPMI_P_SCL, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(78, SPMI_P_SDA, 0, 5, 0x1a, 0x90,
		SPMI_P_SDA, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(79, CAM_CLK0, 0, 0, 0x1a, 0x90,
		CMMCLK0, MD_INT4, RES3, RES4,
		RES5, RES6, RES7),
	PIN(80, CAM_CLK1, 0, 1, 0x1a, 0x90,
		CMMCLK1, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(81, SCP_SPI0_CK, 0, 9, 0x1b, 0x80,
		SCP_SPI0_CK, SPI6_B_CLK, PWM_VLP, I2SOUT5_BCK,
		RES5, TP_GPIO0_AO, RES7),
	PIN(82, SCP_SPI0_CSB, 0, 10, 0x1b, 0x80,
		SCP_SPI0_CS, SPI6_B_CSB, RES3, I2SOUT5_LRCK,
		RES5, TP_GPIO1_AO, RES7),
	PIN(83, SCP_SPI0_MO, 0, 12, 0x1b, 0x80,
		SCP_SPI0_MO, SPI6_B_MO, RES3, I2SOUT5_DATA0,
		RES5, TP_GPIO2_AO, RES7),
	PIN(84, SCP_SPI0_MI, 0, 11, 0x1b, 0x80,
		SCP_SPI0_MI, SPI6_B_MI, RES3, I2SOUT5_DATA1,
		RES5, TP_GPIO3_AO, RES7),
	PIN(85, SCP_SPI1_CK, 0, 13, 0x1b, 0x80,
		SCP_SPI1_CK, SPI7_B_CLK, RES3, I2SIN5_DATA0,
		PWM_VLP, TP_GPIO4_AO, RES7),
	PIN(86, SCP_SPI1_CSB, 0, 14, 0x1b, 0x80,
		SCP_SPI1_CS, SPI7_B_CSB, RES3, I2SIN5_DATA1,
		RES5, TP_GPIO5_AO, RES7),
	PIN(87, SCP_SPI1_MO, 0, 16, 0x1b, 0x80,
		SCP_SPI1_MO, SPI7_B_MO, RES3, I2SIN5_BCK,
		RES5, TP_GPIO6_AO, RES7),
	PIN(88, SCP_SPI1_MI, 0, 15, 0x1b, 0x80,
		SCP_SPI1_MI, SPI7_B_MI, RES3, I2SIN5_LRCK,
		RES5, TP_GPIO7_AO, RES7),
	PIN(89, DSI_TE, 0, 0, 0x1b, 0x80,
		DSI_TE, DSI1_TE, RES3, RES4,
		RES5, RES6, DBG_MON_B30),
	PIN(90, LCM_RST, 0, 8, 0x1b, 0x80,
		LCM_RST, LCM1_RST, RES3, RES4,
		RES5, RES6, DBG_MON_B31),
	PIN(91, PERIPHERAL_EN5, 0, 6, 0x1c, 0x90,
		CMFLASH2, SF_D0, SRCLKENAI1, RES4,
		KPCOL2, TP_GPIO11_AO, RES7),
	PIN(92, PERIPHERAL_EN6, 0, 7, 0x1c, 0x90,
		CMFLASH3, SF_D1, RES3, DISP_PWM1,
		RES5, TP_GPIO12_AO, RES7),
	PIN(93, PERIPHERAL_EN7, 0, 8, 0x1c, 0x90,
		CMFLASH1, SF_D2, SRCLKENAI0, RES4,
		KPROW2, TP_GPIO13_AO, RES7),
	PIN(94, I2SIN1_MCK, 0, 4, 0x1c, 0x90,
		I2S_MCK1, SF_D3, RES3, MD32_0_GPIO0,
		CLKM0_A, TP_GPIO14_AO, DBG_MON_B18),
	PIN(95, I2SIN1_BCK, 0, 1, 0x1c, 0x90,
		I2SIN1_BCK, I2SIN4_BCK, SPI6_A_CLK, MD32_1_GPIO0,
		CLKM1_A, TP_GPIO15_AO, DBG_MON_B19),
	PIN(96, I2SIN1_LRCK, 0, 3, 0x1c, 0x90,
		I2SIN1_LRCK, I2SIN4_LRCK, SPI6_A_CSB, MD32_2_GPIO0,
		CLKM2_A, RES6, DBG_MON_B20),
	PIN(97, I2SIN1_DI, 0, 2, 0x1c, 0x90,
		I2SIN1_DI_A, I2SIN4_DATA0, SPI6_A_MO, MD32_3_GPIO0,
		CLKM3_A, RES6, DBG_MON_B21),
	PIN(98, I2SOUT1_DO, 0, 5, 0x1c, 0x90,
		I2SOUT1_DO, I2SOUT4_DATA0, SPI6_A_MI, RES4,
		RES5, RES6, DBG_MON_B22),
	PIN(99, SCL0, 0, 9, 0x1c, 0x90,
		SCL0, LCM2_RST, AUD_DAC_26M_CLK, SPU0_SCL,
		RES5, RES6, DBG_MON_B24),
	PIN(100, SDA0, 0, 12, 0x1c, 0x90,
		SDA0, DSI2_TE, RES3, SPU0_SDA,
		RES5, RES6, DBG_MON_B25),
	PIN(101, SCL10, 0, 10, 0x1c, 0x90,
		SCL10, SF_CS, SCP_DMIC1_CLK, I2SIN5_DATA2,
		SCP_SCL_OIS, TP_GPIO10_AO, DBG_MON_B28),
	PIN(102, SDA10, 0, 13, 0x1c, 0x90,
		SDA10, SF_CK, SCP_DMIC1_DAT, I2SIN5_DATA3,
		SCP_SDA_OIS, TP_GPIO11_AO, DBG_MON_B29),
	PIN(103, DISP_PWM, 0, 0, 0x1c, 0x90,
		DISP_PWM, DSI1_TE, RES3, RES4,
		I2S_MCK0, RES6, DBG_MON_B23),
	PIN(104, SCL6, 0, 11, 0x1c, 0x90,
		SCL6, SPU1_SCL, AUD_DAC_26M_CLK, USB_DRVVBUS_2P,
		I2S_MCK1, IDDIG_2P, DBG_MON_B26),
	PIN(105, SDA6, 0, 14, 0x1c, 0x90,
		SDA6, SPU1_SDA, DISP_PWM2, VBUSVALID_2P,
		I2S_MCK2, VBUSVALID_3P, DBG_MON_B27),
	PIN(106, SCP_SPI3_CK, 0, 0, 0x15, 0x90,
		SCP_SPI3_CK, SPI3_B_CLK, MD_UTXD0, TP_UTXD1_VLP,
		CONN_BG_GPS_MCU_UART0_TXD, TP_GPIO6_AO, DBG_MON_B0),
	PIN(107, SCP_SPI3_CSB, 0, 1, 0x15, 0x90,
		SCP_SPI3_CS, SPI3_B_CSB, MD_URXD0, TP_URXD1_VLP,
		CONN_BG_GPS_MCU_UART0_RXD, TP_GPIO7_AO, DBG_MON_B1),
	PIN(108, SCP_SPI3_MO, 0, 3, 0x15, 0x90,
		SCP_SPI3_MO, SPI3_B_MO, MD_UTXD1, MD32PCM_UTXD_AO_VLP,
		CONN_BG_GPS_MCU_UART1_TXD, TP_GPIO8_AO, DBG_MON_B2),
	PIN(109, SCP_SPI3_MI, 0, 2, 0x15, 0x90,
		SCP_SPI3_MI, SPI3_B_MI, MD_URXD1, MD32PCM_URXD_AO_VLP,
		CONN_BG_GPS_MCU_UART1_RXD, TP_GPIO9_AO, DBG_MON_B3),
	PIN(110, SPI1_CLK, 0, 4, 0x15, 0x90,
		SPI1_CLK, PWM_0, MD_UCTS0, TP_UCTS1_VLP,
		RES5, SPU0_GPIO_O, DBG_MON_B4),
	PIN(111, SPI1_CSB, 0, 5, 0x15, 0x90,
		SPI1_CSB, PWM_1, MD_URTS0, TP_URTS1_VLP,
		RES5, SPU0_GPIO_I, DBG_MON_B5),
	PIN(112, SPI1_MO, 0, 7, 0x15, 0x90,
		SPI1_MO, PWM_2, MD_UCTS1, RES4,
		RES5, SPU1_GPIO_O, DBG_MON_B6),
	PIN(113, SPI1_MI, 0, 6, 0x15, 0x90,
		SPI1_MI, PWM_3, MD_URTS1, RES4,
		RES5, SPU1_GPIO_I, DBG_MON_B7),
	PIN(114, SPI_CLK_SEC, 0, 8, 0x15, 0x90,
		SPI0_SPU_CLK, SPI4_A_CLK, RES3, RES4,
		CONN_BG_GPS_MCU_DBG_UART_TXD, RES6, DBG_MON_B8),
	PIN(115, SPI_CSB_SEC, 0, 9, 0x15, 0x90,
		SPI0_SPU_CSB, SPI4_A_CSB, RES3, RES4,
		RES5, RES6, DBG_MON_B9),
	PIN(116, SPI_MO_SEC, 0, 11, 0x15, 0x90,
		SPI0_SPU_MO, SPI4_A_MO, LCM1_RST, RES4,
		RES5, RES6, DBG_MON_B10),
	PIN(117, SPI_MI_SEC, 0, 10, 0x15, 0x90,
		SPI0_SPU_MI, SPI4_A_MI, DSI1_TE, RES4,
		RES5, RES6, DBG_MON_B11),
	PIN(118, SPI5_CLK, 0, 9, 0x26, 0xb0,
		SPI5_CLK, USB_DRVVBUS, DP_TX_HPD, AD_ILDO_DTEST0,
		RES5, RES6, RES7),
	PIN(119, SPI5_CSB, 0, 10, 0x26, 0xb0,
		SPI5_CSB, VBUSVALID, DP_OC_EN, AD_ILDO_DTEST1,
		RES5, RES6, RES7),
	PIN(120, SPI5_MO, 0, 12, 0x26, 0xb0,
		SPI5_MO, LCM2_RST, DP_RAUX_SBU1, AD_ILDO_DTEST2,
		RES5, IDDIG_3P, RES7),
	PIN(121, SPI5_MI, 0, 11, 0x26, 0xb0,
		SPI5_MI, DSI2_TE, DP_RAUX_SBU2, AD_ILDO_DTEST3,
		RES5, USB_DRVVBUS_3P, DBG_MON_B17),
	PIN(122, AP_GOOD, 0, 0, 0x26, 0xb0,
		AP_GOOD, CONN_TCXOENA_REQ, RES3, RES4,
		RES5, RES6, RES7),
	PIN(123, SCL3, 0, 7, 0x26, 0xb0,
		SCL3, RES2, RES3, RES4,
		I2SIN2_LRCK, TP_UTXD_MD_VCORE, RES7),
	PIN(124, SDA3, 0, 8, 0x26, 0xb0,
		SDA3, RES2, RES3, RES4,
		RES5, TP_URXD_MD_VCORE, RES7),
	PIN(125, MSDC1_CLK, 1, 0, 0x17, 0x80,
		MSDC1_CLK, MD1_SIM2_SCLK, HFRP_JTAG0_TCK, UDI_TCK,
		CONN_BGF_DSP_L1_JCK, SCP_JTAG_LITTLE_TCK_VLP, JTCK2_SEL1),
	PIN(126, MSDC1_CMD, 1, 1, 0x17, 0x80,
		MSDC1_CMD, RES2, HFRP_JTAG0_TMS, UDI_TMS,
		CONN_BGF_DSP_L1_JMS, SCP_JTAG_LITTLE_TMS_VLP, JTMS2_SEL1),
	PIN(127, MSDC1_DAT0, 1, 2, 0x17, 0x80,
		MSDC1_DAT0, MD1_SIM2_SRST, HFRP_JTAG0_TDI, UDI_TDI_0,
		CONN_BGF_DSP_L1_JDI, SCP_JTAG_LITTLE_TDI_VLP, JTDI2_SEL1),
	PIN(128, MSDC1_DAT1, 1, 3, 0x17, 0x80,
		MSDC1_DAT1, MD1_SIM2_SIO, HFRP_JTAG0_TDO, UDI_TDO_0,
		CONN_BGF_DSP_L1_JDO, SCP_JTAG_LITTLE_TDO_VLP, JTDO2_SEL1),
	PIN(129, MSDC1_DAT2, 1, 4, 0x17, 0x80,
		MSDC1_DAT2, DSI2_HSYNC, HFRP_JTAG0_TRSTN, UDI_NTRST,
		RES5, SCP_JTAG_LITTLE_TRSTN_VLP, JTRSTn2_SEL1),
	PIN(130, MSDC1_DAT3, 1, 5, 0x17, 0x80,
		MSDC1_DAT3, DSI3_HSYNC, RES3, RES4,
		CONN_BGF_DSP_L1_JINTP, RES6, RES7),
	PIN(131, SIM2_SCLK, 1, 9, 0x17, 0x80,
		MD1_SIM2_SCLK, MD1_SIM1_SCLK, MCUPM_JTAG_TDI, CLKM0_A,
		CONN_BGF_DSP_L5_JDI, TSFDC_SCK, SCP_JTAG0_TDI_VCORE),
	PIN(132, SIM2_SRST, 1, 11, 0x17, 0x80,
		MD1_SIM2_SRST, MD1_SIM1_SRST, MCUPM_JTAG_TMS, CLKM1_B,
		CONN_BGF_DSP_L5_JMS, TSFDC_SDI, SCP_JTAG0_TMS_VCORE),
	PIN(133, SIM2_SIO, 1, 10, 0x17, 0x80,
		MD1_SIM2_SIO, MD1_SIM1_SIO, MCUPM_JTAG_TDO, RES4,
		CONN_BGF_DSP_L5_JDO, TSFDC_SCF, SCP_JTAG0_TDO_VCORE),
	PIN(134, SIM1_SCLK, 1, 6, 0x17, 0x80,
		MD1_SIM1_SCLK, MD1_SIM2_SCLK, RES3, RES4,
		RES5, TSFDC_26M, RES7),
	PIN(135, SIM1_SRST, 1, 8, 0x17, 0x80,
		MD1_SIM1_SRST, MD1_SIM2_SRST, MCUPM_JTAG_TCK, RES4,
		CONN_BGF_DSP_L5_JCK, TSFDC_SDO, SCP_JTAG0_TCK_VCORE),
	PIN(136, SIM1_SIO, 1, 7, 0x17, 0x80,
		MD1_SIM1_SIO, MD1_SIM2_SIO, MCUPM_JTAG_TRSTN, RES4,
		CONN_BGF_DSP_L5_JINTP, TSFDC_FOUT, SCP_JTAG0_TRSTN_VCORE),
	PIN(137, MIPI0_D_SCLK, 1, 10, 0x14, 0x70,
		MIPI0_D_SCLK, BPI_BUS16, RES3, EXT_FRAME_SYNC,
		RES5, SPM_JTAG_TRSTN_VCORE, DBG_MON_A0),
	PIN(138, MIPI0_D_SDATA, 1, 11, 0x14, 0x70,
		MIPI0_D_SDATA, BPI_BUS17, RES3, PCM0_LRCK,
		RES5, SPM_JTAG_TCK_VCORE, DBG_MON_A1),
	PIN(139, MIPI1_D_SCLK, 1, 12, 0x14, 0x70,
		MIPI1_D_SCLK, BPI_BUS18, RES3, MD_GPS_BLANK,
		RES5, SPM_JTAG_TMS_VCORE, DBG_MON_A2),
	PIN(140, MIPI1_D_SDATA, 1, 13, 0x14, 0x70,
		MIPI1_D_SDATA, BPI_BUS19, RES3, MD_URXD1_CONN,
		RES5, SPM_JTAG_TDO_VCORE, DBG_MON_A3),
	PIN(141, MIPI2_D_SCLK, 1, 14, 0x14, 0x70,
		MIPI2_D_SCLK, BPI_BUS20, RES3, MD_UTXD1_CONN,
		RES5, SPM_JTAG_TDI_VCORE, DBG_MON_A4),
	PIN(142, MIPI2_D_SDATA, 1, 15, 0x14, 0x70,
		MIPI2_D_SDATA, BPI_BUS21, RES3, RES4,
		RES5, SSPM_JTAG_TRSTN_VCORE, DBG_MON_A5),
	PIN(143, MIPI3_D_SCLK, 1, 16, 0x14, 0x70,
		MIPI3_D_SCLK, BPI_BUS22, RES3, TP_UTXD_GNSS_VLP,
		MD_UTXD1_CONN, SSPM_JTAG_TCK_VCORE, RES7),
	PIN(144, MIPI3_D_SDATA, 1, 17, 0x14, 0x70,
		MIPI3_D_SDATA, BPI_BUS23, RES3, TP_URXD_GNSS_VLP,
		MD_URXD1_CONN, SSPM_JTAG_TMS_VCORE, RES7),
	PIN(145, BPI_D_BUS0, 1, 0, 0x14, 0x70,
		BPI_BUS0, RES2, RES3, PCIE_WAKEN_1P,
		RES5, SSPM_JTAG_TDO_VCORE, DBG_MON_A10),
	PIN(146, BPI_D_BUS1, 1, 1, 0x14, 0x70,
		BPI_BUS1, RES2, RES3, PCIE_PERSTN_1P,
		RES5, SSPM_JTAG_TDI_VCORE, DBG_MON_A11),
	PIN(147, BPI_D_BUS2, 1, 2, 0x14, 0x70,
		BPI_BUS2, AUD_DAC_26M_CLK, RES3, PCIE_CLKREQN_1P,
		RES5, SCP_JTAG_LITTLE_TRSTN_VCORE, DBG_MON_A12),
	PIN(148, BPI_D_BUS3, 1, 3, 0x14, 0x70,
		BPI_BUS3, AUD_DAC_26M_CLK, RES3, TP_UTXD_MD_VLP,
		TP_GPIO0_AO, SCP_JTAG_LITTLE_TCK_VCORE, DBG_MON_A13),
	PIN(149, BPI_D_BUS4, 1, 4, 0x14, 0x70,
		BPI_BUS4, EXT_FRAME_SYNC, RES3, TP_URXD_MD_VLP,
		TP_GPIO1_AO, SCP_JTAG_LITTLE_TMS_VCORE, DBG_MON_A14),
	PIN(150, BPI_D_BUS5, 1, 5, 0x14, 0x70,
		BPI_BUS5, GPS_PPS0, RES3, RES4,
		TP_GPIO2_AO, SCP_JTAG_LITTLE_TDO_VCORE, DBG_MON_A15),
	PIN(151, BPI_D_BUS6, 1, 6, 0x14, 0x70,
		BPI_BUS6, GPS_PPS1, RES3, RES4,
		TP_GPIO3_AO, SCP_JTAG_LITTLE_TDI_VCORE, RES7),
	PIN(152, BPI_D_BUS7, 1, 7, 0x14, 0x70,
		BPI_BUS7, EDP_TX_HPD, RES3, RES4,
		AGPS_SYNC, SSPM_UTXD_AO_VCORE, RES7),
	PIN(153, MD_UCNT, 1, 9, 0x14, 0x70,
		MD_UCNT_A_TGL, RES2, RES3, RES4,
		RES5, TP_URTS1_VCORE, DBG_MON_A8),
	PIN(154, DIGRF_IRQ, 1, 8, 0x14, 0x70,
		DIGRF_IRQ, RES2, RES3, RES4,
		RES5, TP_UCTS1_VCORE, DBG_MON_A9),
	PIN(155, MIPI_M_SCLK, 1, 18, 0x14, 0x70,
		MIPI_M_SCLK, RES2, RES3, UCTS2,
		RES5, TP_UTXD_CONSYS_VCORE, DBG_MON_A6),
	PIN(156, MIPI_M_SDATA, 1, 19, 0x14, 0x70,
		MIPI_M_SDATA, RES2, RES3, URTS2,
		RES5, TP_URXD_CONSYS_VCORE, DBG_MON_A7),
	PIN(157, BPI_D_BUS8, 0, 1, 0x12, 0x90,
		BPI_BUS8, RES2, RES3, UTXD2,
		CLKM0_A, SSPM_URXD_AO_VCORE, DBG_MON_A16),
	PIN(158, BPI_D_BUS9, 0, 2, 0x12, 0x90,
		BPI_BUS9, RES2, RES3, URXD2,
		CLKM1_A, TP_UTXD1_VCORE, RES7),
	PIN(159, BPI_D_BUS10, 0, 0, 0x12, 0x90,
		BPI_BUS10, MD_INT0, SRCLKENAI1, RES4,
		CLKM2_A, TP_URXD1_VCORE, RES7),
	PIN(160, UTXD0, 0, 22, 0x13, 0x90,
		UTXD0, MD_UTXD1, RES3, RES4,
		mbistreaden_trigger, CONN_BG_GPS_MCU_DBG_UART_TXD, RES7),
	PIN(161, URXD0, 0, 20, 0x13, 0x90,
		URXD0, MD_URXD1, RES3, RES4,
		mbistwriteen_trigger, RES6, RES7),
	PIN(162, UTXD1, 0, 23, 0x13, 0x90,
		UTXD1, MD_UTXD0, TP_UTXD1_VLP, ADSP_UTXD0,
		SSPM_UTXD_AO_VLP, HFRP_UTXD1, RES7),
	PIN(163, URXD1, 0, 21, 0x13, 0x90,
		URXD1, MD_URXD0, TP_URXD1_VLP, ADSP_URXD0,
		SSPM_URXD_AO_VLP, HFRP_URXD1, RES7),
	PIN(164, SCP_SCL0, 0, 12, 0x13, 0x90,
		SCP_SCL0, RES2, RES3, RES4,
		RES5, TP_GPIO0_AO, DBG_MON_A22),
	PIN(165, SCP_SDA0, 0, 14, 0x13, 0x90,
		SCP_SDA0, RES2, RES3, RES4,
		RES5, TP_GPIO1_AO, DBG_MON_A23),
	PIN(166, SCP_SCL2, 0, 13, 0x13, 0x90,
		SCP_SCL2, RES2, RES3, RES4,
		RES5, TP_GPIO2_AO, DBG_MON_A24),
	PIN(167, SCP_SDA2, 0, 15, 0x13, 0x90,
		SCP_SDA2, RES2, RES3, RES4,
		RES5, TP_GPIO3_AO, DBG_MON_A25),
	PIN(168, SCP_SPI2_CK, 0, 16, 0x13, 0x90,
		SCP_SPI2_CK, SPI2_B_CLK, PWM_VLP, SCP_SCL2,
		RES5, RES6, DBG_MON_A26),
	PIN(169, SCP_SPI2_CSB, 0, 17, 0x13, 0x90,
		SCP_SPI2_CS, SPI2_B_CSB, RES3, RES4,
		RES5, RES6, DBG_MON_A27),
	PIN(170, SCP_SPI2_MO, 0, 19, 0x13, 0x90,
		SCP_SPI2_MO, SPI2_B_MO, RES3, SCP_SDA2,
		RES5, RES6, DBG_MON_A28),
	PIN(171, SCP_SPI2_MI, 0, 18, 0x13, 0x90,
		SCP_SPI2_MI, SPI2_B_MI, RES3, RES4,
		RES5, RES6, DBG_MON_A29),
	PIN(172, PERIPHERAL_EN2, 0, 10, 0x13, 0x90,
		CONN_TCXOENA_REQ, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(173, PERIPHERAL_EN3, 0, 11, 0x13, 0x90,
		CMFLASH3, PWM_3, MD_GPS_L5_BLANK, CLKM1_A,
		RES5, RES6, DBG_MON_A31),
	PIN(174, PERIPHERAL_EN0, 0, 15, 0x11, 0x90,
		CMFLASH0, PWM_0, VBUSVALID_1P, MD32_2_RXD,
		DISP_PWM3, RES6, RES7),
	PIN(175, PERIPHERAL_EN1, 0, 16, 0x11, 0x90,
		CMFLASH1, PWM_1, EDP_TX_HPD, MD32_2_TXD,
		DISP_PWM4, RES6, RES7),
	PIN(176, SCL5, 0, 17, 0x11, 0x90,
		SCL5, LCM3_RST, RES3, MD_URXD1_CONN,
		RES5, TP_UTXD_GNSS_VCORE, RES7),
	PIN(177, SDA5, 0, 18, 0x11, 0x90,
		SDA5, DSI3_TE, RES3, MD_UTXD1_CONN,
		RES5, TP_URXD_GNSS_VCORE, RES7),
	PIN(178, DMIC_CLK, 0, 6, 0x11, 0x90,
		DMIC_CLK, SCP_DMIC_CLK, SRCLKENAI0, CLKM2_B,
		TP_GPIO7_AO, SPU1_UTX, DAP_SONIC_SWCK),
	PIN(179, DMIC_DAT, 0, 7, 0x11, 0x90,
		DMIC_DAT, SCP_DMIC_DAT, SRCLKENAI1, CLKM3_B,
		TP_GPIO8_AO, SPU1_URX, DAP_SONIC_SWD),
	PIN(180, CAM_PDN0, 0, 0, 0x11, 0x90,
		IDDIG_1P, CMVREF0, GPS_PPS1, GPS_L5_ELNA_EN,
		DISP_PWM1, RES6, RES7),
	PIN(181, CAM_PDN1, 0, 1, 0x11, 0x90,
		USB_DRVVBUS_1P, CMVREF1, MFG_EB_JTAG_TRSTN, ADSP_JTAG1_TRSTN,
		HFRP_JTAG1_TRSTN, SPU1_NTRST, CONN_BG_GPS_MCU_TRST_B),
	PIN(182, CAM_PDN2, 0, 2, 0x11, 0x90,
		SCL11, CMVREF2, MFG_EB_JTAG_TCK, ADSP_JTAG1_TCK,
		HFRP_JTAG1_TCK, SPU1_TCK, CONN_BG_GPS_MCU_TCK),
	PIN(183, CAM_PDN3, 0, 3, 0x11, 0x90,
		SDA11, CMVREF3, MFG_EB_JTAG_TMS, ADSP_JTAG1_TMS,
		HFRP_JTAG1_TMS, SPU1_TMS, CONN_BG_GPS_MCU_TMS),
	PIN(184, CAM_PDN4, 0, 4, 0x11, 0x90,
		SCL12, CMVREF4, MFG_EB_JTAG_TDO, ADSP_JTAG1_TDO,
		HFRP_JTAG1_TDO, SPU1_TDO, CONN_BG_GPS_MCU_TDO),
	PIN(185, CAM_PDN5, 0, 5, 0x11, 0x90,
		SDA12, CMVREF5, MFG_EB_JTAG_TDI, ADSP_JTAG1_TDI,
		HFRP_JTAG1_TDI, SPU1_TDI, CONN_BG_GPS_MCU_TDI),
	PIN(186, CAM_RST0, 0, 4, 0x1d, 0xd0,
		MD_GPS_L1_BLANK, PMSR_SMAP, TP_GPIO2_AO, RES4,
		RES5, RES6, RES7),
	PIN(187, CAM_RST1, 0, 5, 0x1d, 0xd0,
		MD_GPS_L5_BLANK, RES2, TP_GPIO4_AO, RES4,
		RES5, RES6, RES7),
	PIN(188, CAM_SCL2, 0, 12, 0x1d, 0xd0,
		SCL2, SCP_SCL8, RES3, RES4,
		RES5, RES6, RES7),
	PIN(189, CAM_SDA2, 0, 17, 0x1d, 0xd0,
		SDA2, SCP_SDA8, RES3, RES4,
		RES5, RES6, RES7),
	PIN(190, CAM_SCL4, 0, 13, 0x1d, 0xd0,
		SCL4, SCP_SCL9, RES3, RES4,
		RES5, UDI_TDI_6, RES7),
	PIN(191, CAM_SDA4, 0, 18, 0x1d, 0xd0,
		SDA4, SCP_SDA9, RES3, RES4,
		RES5, UDI_TDI_7, RES7),
	PIN(192, CAM_CLK2, 0, 0, 0x1d, 0xd0,
		CMMCLK2, RES2, RES3, MD32_3_RXD,
		RES5, RES6, RES7),
	PIN(193, CAM_RST2, 0, 6, 0x1d, 0xd0,
		RES1, RES2, CLKM0_B, MD32_3_TXD,
		RES5, UDI_TDO_7, RES7),
	PIN(194, CAM_SCL7, 0, 14, 0x1d, 0xd0,
		SCL7, MD32_3_GPIO0, CLKM2_B, RES4,
		RES5, UDI_TDI_2, RES7),
	PIN(195, CAM_SDA7, 0, 19, 0x1d, 0xd0,
		SDA7, RES2, CLKM3_B, RES4,
		RES5, UDI_TDI_3, RES7),
	PIN(196, CAM_CLK3, 0, 1, 0x1d, 0xd0,
		CMMCLK3, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(197, CAM_RST3, 0, 7, 0x1d, 0xd0,
		RES1, RES2, CLKM1_B, RES4,
		RES5, UDI_TDI_1, RES7),
	PIN(198, CAM_SCL8, 0, 15, 0x1d, 0xd0,
		SCL8, RES2, RES3, RES4,
		RES5, UDI_TDI_4, RES7),
	PIN(199, CAM_SDA8, 0, 20, 0x1d, 0xd0,
		SDA8, RES2, RES3, RES4,
		RES5, UDI_TDI_5, RES7),
	PIN(200, SCL1, 0, 22, 0x1d, 0xd0,
		SCL1, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(201, SDA1, 0, 25, 0x1d, 0xd0,
		SDA1, RES2, RES3, RES4,
		RES5, RES6, TSFDC_BG_COMP),
	PIN(202, CAM_SCL9, 0, 16, 0x1d, 0xd0,
		SCL9, SCP_SCL7, RES3, RES4,
		RES5, TP_GPIO15_AO, RES7),
	PIN(203, CAM_SDA9, 0, 21, 0x1d, 0xd0,
		SDA9, SCP_SDA7, RES3, RES4,
		RES5, TP_GPIO9_AO, RES7),
	PIN(204, CAM_PDN6, 0, 2, 0x1d, 0xd0,
		SCL13, CMVREF6, GPS_L1_ELNA_EN, RES4,
		CLKM2_B, TP_GPIO12_AO, RES7),
	PIN(205, CAM_PDN7, 0, 3, 0x1d, 0xd0,
		SDA13, CMVREF7, GPS_L5_ELNA_EN, RES4,
		CLKM3_B, TP_GPIO13_AO, RES7),
	PIN(206, CAM_RST4, 0, 8, 0x1d, 0xd0,
		RES1, MD32_2_GPIO0, RES3, RES4,
		VBUSVALID, UDI_TDO_3, RES7),
	PIN(207, CAM_RST5, 0, 9, 0x1d, 0xd0,
		PCIE_WAKEN_2P, PMSR_SMAP_MAX, RES3, FMI2S_A_BCK,
		RES5, UDI_TDO_4, RES7),
	PIN(208, CAM_RST6, 0, 10, 0x1d, 0xd0,
		PCIE_CLKREQN_2P, PMSR_SMAP_MAX_W, RES3, FMI2S_A_LRCK,
		CLKM0_B, UDI_TDO_5, RES7),
	PIN(209, CAM_RST7, 0, 11, 0x1d, 0xd0,
		PCIE_PERSTN_2P, PMSR_SMAP, RES3, FMI2S_A_DI,
		CLKM1_B, UDI_TDO_6, RES7),
	PIN(210, CAM_CLK4, 0, 0, 0x2e, 0xb0,
		CMMCLK4, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(211, CAM_CLK5, 0, 1, 0x2e, 0xb0,
		CMMCLK5, CONN_TCXOENA_REQ, RES3, RES4,
		RES5, RES6, RES7),
	PIN(212, CAM_CLK6, 0, 2, 0x2e, 0xb0,
		CMMCLK6, TP_GPIO10_AO, RES3, RES4,
		IDDIG, UDI_TDO_1, RES7),
	PIN(213, CAM_CLK7, 0, 3, 0x2e, 0xb0,
		CMMCLK7, TP_GPIO11_AO, RES3, RES4,
		USB_DRVVBUS, UDI_TDO_2, RES7),
	PIN(214, SCP_SCL3, 0, 23, 0x1d, 0xd0,
		SCP_SCL3, SCL14, RES3, RES4,
		RES5, GBE1_MDC, GBE0_MDC),
	PIN(215, SCP_SDA3, 0, 24, 0x1d, 0xd0,
		SCP_SDA3, SDA14, RES3, RES4,
		RES5, GBE1_MDIO, GBE0_MDIO),
	PIN(216, PERIPHERAL_EN4, 0, 4, 0x2e, 0xb0,
		GPS_PPS0, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(217, KPROW0, 1, 1, 0x2e, 0xa0,
		KPROW0, RES2, RES3, RES4,
		RES5, TP_GPIO12_AO, RES7),
	PIN(218, KPROW1, 1, 2, 0x2e, 0xa0,
		KPROW1, SPI0_WP, mbistreaden_trigger, RES4,
		GPS_L5_ELNA_EN, TP_GPIO14_AO, RES7),
	PIN(219, KPCOL1, 1, 0, 0x2e, 0xa0,
		KPCOL1, SPI0_HOLD, mbistwriteen_trigger, SPMI_M_TRIG_FLAG,
		GPS_L1_ELNA_EN, SPM_JTAG_TRSTN_VLP, JTRSTn_SEL1),
	PIN(220, SPI0_CLK, 0, 5, 0x2e, 0xb0,
		SPI0_CLK, RES2, RES3, RES4,
		RES5, SPM_JTAG_TCK_VLP, JTCK_SEL1),
	PIN(221, SPI0_CSB, 0, 6, 0x2e, 0xb0,
		SPI0_CSB, RES2, RES3, RES4,
		RES5, SPM_JTAG_TMS_VLP, JTMS_SEL1),
	PIN(222, SPI0_MO, 0, 8, 0x2e, 0xb0,
		SPI0_MO, SCP_SCL7, RES3, RES4,
		RES5, SPM_JTAG_TDO_VLP, JTDO_SEL1),
	PIN(223, SPI0_MI, 0, 7, 0x2e, 0xb0,
		SPI0_MI, SCP_SDA7, RES3, RES4,
		RES5, SPM_JTAG_TDI_VLP, JTDI_SEL1),
	PIN(224, MSDC2_CLK, 1, 3, 0x2e, 0xa0,
		MSDC2_CLK, DMIC2_CLK, GBE0_AUX_PPS0, GBE0_TXER,
		GBE1_TXER, GBE1_AUX_PPS0, MD32_1_TXD),
	PIN(225, MSDC2_CMD, 1, 4, 0x2e, 0xa0,
		MSDC2_CMD, DMIC2_DAT, GBE0_AUX_PPS1, GBE0_RXER,
		GBE1_RXER, GBE1_AUX_PPS1, MD32_1_RXD),
	PIN(226, MSDC2_DAT0, 1, 5, 0x2e, 0xa0,
		MSDC2_DAT0, I2SIN3_BCK, GBE0_AUX_PPS2, GBE0_COL,
		GBE1_COL, GBE1_AUX_PPS2, GBE1_MDC),
	PIN(227, MSDC2_DAT1, 1, 6, 0x2e, 0xa0,
		MSDC2_DAT1, I2SIN3_LRCK, GBE0_AUX_PPS3, GBE0_INTR,
		GBE1_INTR, GBE1_AUX_PPS3, GBE1_MDIO),
	PIN(228, MSDC2_DAT2, 1, 7, 0x2e, 0xa0,
		MSDC2_DAT2, I2SIN3_DI, GBE0_MDC, GBE1_MDC,
		CONN_BG_GPS_MCU_AICE_TCKC, RES6, RES7),
	PIN(229, MSDC2_DAT3, 1, 8, 0x2e, 0xa0,
		MSDC2_DAT3, I2SOUT3_DO, GBE0_MDIO, GBE1_MDIO,
		CONN_BG_GPS_MCU_AICE_TMSC, RES6, AVB_CLK2),
	PIN(230, CONN_TOP_CLK, 0, 13, 0x2f, 0x90,
		CONN_TOP_CLK, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(231, CONN_TOP_DATA, 0, 14, 0x2f, 0x90,
		CONN_TOP_DATA, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(232, CONN_HRST_B, 0, 10, 0x2f, 0x90,
		CONN_HRST_B, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(233, BT_BCK, 0, 0, 0x2f, 0x90,
		I2SIN0_BCK, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(234, BT_LRCK, 0, 3, 0x2f, 0x90,
		I2SIN0_LRCK, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(235, BT_DI, 0, 1, 0x2f, 0x90,
		I2SIN0_DI, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(236, BT_DO, 0, 2, 0x2f, 0x90,
		I2SOUT0_DO, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(237, BT_UTXD, 0, 6, 0x2f, 0x90,
		CONN_UARTHUB_UART_TX, RES2, UTXD3, RES4,
		RES5, RES6, RES7),
	PIN(238, BT_URXD, 0, 5, 0x2f, 0x90,
		CONN_UARTHUB_UART_RX, RES2, URXD3, RES4,
		RES5, RES6, RES7),
	PIN(239, SCP_WB_UTXD, 0, 19, 0x2f, 0x90,
		TP_UTXD_CONSYS_VLP, TP_URXD_CONSYS_VLP, RES3, RES4,
		RES5, RES6, RES7),
	PIN(240, SCP_WB_URXD, 0, 18, 0x2f, 0x90,
		TP_URXD_CONSYS_VLP, TP_UTXD_CONSYS_VLP, RES3, RES4,
		RES5, RES6, RES7),
	PIN(241, PCIE0_PERSTN, 0, 16, 0x2f, 0x90,
		PCIE_PERSTN, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(242, PCIE0_WAKEN, 0, 17, 0x2f, 0x90,
		PCIE_WAKEN, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(243, PCIE0_CLKREQN, 0, 15, 0x2f, 0x90,
		PCIE_CLKREQN, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(244, CONN_RST, 0, 12, 0x2f, 0x90,
		CONN_RST, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(245, CONN_FAULTB, 0, 9, 0x2f, 0x90,
		RES1, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(246, COEX_UTXD, 0, 8, 0x2f, 0x90,
		CONN_PTA_TXD0, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(247, COEX_URXD, 0, 7, 0x2f, 0x90,
		CONN_PTA_RXD0, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(248, BT_RST, 0, 4, 0x2f, 0x90,
		RES1, RES2, UCTS3, RES4,
		RES5, RES6, RES7),
	PIN(249, WF_RST, 0, 20, 0x2f, 0x90,
		RES1, RES2, URTS3, RES4,
		RES5, RES6, RES7),
	PIN(250, CONN_PMIC_EN, 0, 11, 0x2f, 0x90,
		RES1, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(251, IVI_GPIO0, 0, 2, 0x13, 0x90,
		IDDIG_1P, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(252, IVI_GPIO1, 0, 3, 0x13, 0x90,
		USB_DRVVBUS_1P, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(253, IVI_GPIO2, 0, 4, 0x13, 0x90,
		VBUSVALID_1P, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(254, IVI_GPIO3, 0, 5, 0x13, 0x90,
		IDDIG_2P, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(255, IVI_GPIO4, 0, 6, 0x13, 0x90,
		USB_DRVVBUS_2P, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(256, IVI_GPIO5, 0, 7, 0x13, 0x90,
		VBUSVALID_2P, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(257, IVI_GPIO6, 0, 8, 0x13, 0x90,
		VBUSVALID_3P, RES2, RES3, RES4,
		RES5, RES6, RES7),
	PIN(258, IVI_GPIO7, 0, 9, 0x13, 0x90,
		RES1, RES2, RES3, RES4,
		RES5, RES6, AVB_CLK1),
	PIN(259, RGMII_0, 1, 9, 0x2e, 0xa0,
		GBE0_TXD0, GBE1_TXD0, RES3, RES4,
		RES5, RES6, RES7),
	PIN(260, RGMII_1, 1, 10, 0x2e, 0xa0,
		GBE0_TXD1, GBE1_TXD1, RES3, RES4,
		RES5, RES6, RES7),
	PIN(261, RGMII_2, 1, 11, 0x2e, 0xa0,
		GBE0_TXC, GBE1_TXC, RES3, RES4,
		RES5, RES6, RES7),
	PIN(262, RGMII_3, 1, 12, 0x2e, 0xa0,
		GBE0_TXEN, GBE1_TXEN, RES3, RES4,
		RES5, RES6, RES7),
	PIN(263, RGMII_4, 1, 13, 0x2e, 0xa0,
		GBE0_RXD0, GBE1_RXD0, GBE0_AUX_PPS0, RES4,
		RES5, RES6, RES7),
	PIN(264, RGMII_5, 1, 14, 0x2e, 0xa0,
		GBE0_RXD1, GBE1_RXD1, GBE0_AUX_PPS1, RES4,
		RES5, RES6, RES7),
	PIN(265, RGMII_6, 1, 15, 0x2e, 0xa0,
		GBE0_RXC, GBE1_RXC, GBE0_AUX_PPS2, RES4,
		RES5, RES6, RES7),
	PIN(266, RGMII_7, 1, 16, 0x2e, 0xa0,
		GBE0_RXDV, GBE1_RXDV, GBE0_AUX_PPS3, RES4,
		RES5, RES6, RES7),
	PIN(267, RGMII_8, 1, 2, 0x2f, 0x80,
		GBE0_TXD2, GBE1_TXD2, GBE0_RXER, GBE1_RXER,
		RES5, RES6, RES7),
	PIN(268, RGMII_9, 1, 3, 0x2f, 0x80,
		GBE0_TXD3, GBE1_TXD3, RES3, RES4,
		RES5, RES6, RES7),
	PIN(269, RGMII_10, 1, 0, 0x2f, 0x80,
		GBE0_RXD2, GBE1_RXD2, GBE0_MDC, RES4,
		RES5, RES6, RES7),
	PIN(270, RGMII_11, 1, 1, 0x2f, 0x80,
		GBE0_RXD3, GBE1_RXD3, GBE0_MDIO, RES4,
		RES5, RES6, RES7),
};

static struct gpio_regs *const mtk_gpio = (void *)(GPIO_BASE);

#endif /* SOC_MEDIATEK_MT8196_GPIO_H */
