#!/bin/bash

set -e

server="$1"

source "$(dirname "$0")"/webapp_validate_common.sh

PORT=8080
CONTEXT_PATH="css-validator/"

if [ -n "$AUTOPKGTEST_TMP" ]; then
  case "$server" in
  tomcat10)
    sudo sed -i '/common.loader/ s#$#,/usr/share/tomcat-jakartaee-migration/lib/*.jar#' "/etc/tomcat10/catalina.properties"
    ;;
  tomcat11)
    sudo sed -i '/common.loader/ s#$#,/usr/share/tomcat-jakartaee-migration/lib/*.jar#' "/etc/tomcat11/catalina.properties"
    ;;
  esac

  sudo systemctl stop --job-mode=triggering "$server"
  wait_until_not_state "$server" "active"
  sudo systemctl start "$server"
  wait_until_ready "$server" "$PORT" "$CONTEXT_PATH"
  sudo systemctl status "$server"
fi

#echo "current path: $PWD"

curl -v --stderr - \
  -o "$tempfile" \
  "http://localhost:${PORT:-8080}/css-validator/validator?uri=http://localhost:${PORT:-8080}&profile=css3svg&usermedium=all&warning=2&vextwarning=&lang=en"

if grep "<h3>Congratulations! No Error Found.</h3>" "$tempfile"; then
  echo "Validation of file was successful."
else
  debug_failure
  echo "-------------"
  cat "$tempfile"
  echo "-------------"
  echo "Issue validating the file. Output is above."
  exit 1
fi

rm "$tempfile"
