//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armpolicy

// Assignment - The policy assignment.
type Assignment struct {
	// The name of the policy assignment.
	Name *string `json:"name,omitempty"`

	// Properties for the policy assignment.
	Properties *AssignmentProperties `json:"properties,omitempty"`

	// The type of the policy assignment.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; The ID of the policy assignment.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// AssignmentListResult - List of policy assignments.
type AssignmentListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// An array of policy assignments.
	Value []*Assignment `json:"value,omitempty"`
}

// AssignmentProperties - The policy assignment properties.
type AssignmentProperties struct {
	// This message will be part of response in case of policy violation.
	Description *string `json:"description,omitempty"`

	// The display name of the policy assignment.
	DisplayName *string `json:"displayName,omitempty"`

	// Required if a parameter is used in policy rule.
	Parameters any `json:"parameters,omitempty"`

	// The ID of the policy definition.
	PolicyDefinitionID *string `json:"policyDefinitionId,omitempty"`

	// The scope for the policy assignment.
	Scope *string `json:"scope,omitempty"`
}

// AssignmentsClientCreateByIDOptions contains the optional parameters for the AssignmentsClient.CreateByID method.
type AssignmentsClientCreateByIDOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsClientCreateOptions contains the optional parameters for the AssignmentsClient.Create method.
type AssignmentsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsClientDeleteByIDOptions contains the optional parameters for the AssignmentsClient.DeleteByID method.
type AssignmentsClientDeleteByIDOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsClientDeleteOptions contains the optional parameters for the AssignmentsClient.Delete method.
type AssignmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsClientGetByIDOptions contains the optional parameters for the AssignmentsClient.GetByID method.
type AssignmentsClientGetByIDOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsClientGetOptions contains the optional parameters for the AssignmentsClient.Get method.
type AssignmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AssignmentsClientListForResourceGroupOptions contains the optional parameters for the AssignmentsClient.NewListForResourceGroupPager
// method.
type AssignmentsClientListForResourceGroupOptions struct {
	// The filter to apply on the operation.
	Filter *string
}

// AssignmentsClientListForResourceOptions contains the optional parameters for the AssignmentsClient.NewListForResourcePager
// method.
type AssignmentsClientListForResourceOptions struct {
	// The filter to apply on the operation.
	Filter *string
}

// AssignmentsClientListOptions contains the optional parameters for the AssignmentsClient.NewListPager method.
type AssignmentsClientListOptions struct {
	// The filter to apply on the operation.
	Filter *string
}

// Definition - The policy definition.
type Definition struct {
	// The policy definition properties.
	Properties *DefinitionProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the policy definition.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the policy definition.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// DefinitionListResult - List of policy definitions.
type DefinitionListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// An array of policy definitions.
	Value []*Definition `json:"value,omitempty"`
}

// DefinitionProperties - The policy definition properties.
type DefinitionProperties struct {
	// The policy definition description.
	Description *string `json:"description,omitempty"`

	// The display name of the policy definition.
	DisplayName *string `json:"displayName,omitempty"`

	// The policy definition metadata.
	Metadata any `json:"metadata,omitempty"`

	// The policy definition mode. Possible values are NotSpecified, Indexed, and All.
	Mode *PolicyMode `json:"mode,omitempty"`

	// Required if a parameter is used in policy rule.
	Parameters any `json:"parameters,omitempty"`

	// The policy rule.
	PolicyRule any `json:"policyRule,omitempty"`

	// The type of policy definition. Possible values are NotSpecified, BuiltIn, and Custom.
	PolicyType *PolicyType `json:"policyType,omitempty"`
}

// DefinitionsClientCreateOrUpdateAtManagementGroupOptions contains the optional parameters for the DefinitionsClient.CreateOrUpdateAtManagementGroup
// method.
type DefinitionsClientCreateOrUpdateAtManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// DefinitionsClientCreateOrUpdateOptions contains the optional parameters for the DefinitionsClient.CreateOrUpdate method.
type DefinitionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DefinitionsClientDeleteAtManagementGroupOptions contains the optional parameters for the DefinitionsClient.DeleteAtManagementGroup
// method.
type DefinitionsClientDeleteAtManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// DefinitionsClientDeleteOptions contains the optional parameters for the DefinitionsClient.Delete method.
type DefinitionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DefinitionsClientGetAtManagementGroupOptions contains the optional parameters for the DefinitionsClient.GetAtManagementGroup
// method.
type DefinitionsClientGetAtManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// DefinitionsClientGetBuiltInOptions contains the optional parameters for the DefinitionsClient.GetBuiltIn method.
type DefinitionsClientGetBuiltInOptions struct {
	// placeholder for future optional parameters
}

// DefinitionsClientGetOptions contains the optional parameters for the DefinitionsClient.Get method.
type DefinitionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DefinitionsClientListBuiltInOptions contains the optional parameters for the DefinitionsClient.NewListBuiltInPager method.
type DefinitionsClientListBuiltInOptions struct {
	// placeholder for future optional parameters
}

// DefinitionsClientListByManagementGroupOptions contains the optional parameters for the DefinitionsClient.NewListByManagementGroupPager
// method.
type DefinitionsClientListByManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// DefinitionsClientListOptions contains the optional parameters for the DefinitionsClient.NewListPager method.
type DefinitionsClientListOptions struct {
	// placeholder for future optional parameters
}
