//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package generated

import "time"

// Error - Azure App Configuration error object.
type Error struct {
	// A detailed description of the error.
	Detail *string

	// The name of the parameter that resulted in the error.
	Name *string

	// The HTTP status code that the error maps to.
	Status *int32

	// A brief summary of the error.
	Title *string

	// The type of the error.
	Type *string
}

// ErrorDetail - The details of an error.
type ErrorDetail struct {
	// REQUIRED; One of a server-defined set of error codes.
	Code *string

	// REQUIRED; A human-readable representation of the error.
	Message *string

	// An array of details about specific errors that led to this reported error.
	Details []ErrorDetail

	// An object containing more specific information than the current object about the error.
	Innererror *InnerError
}

// InnerError - An object containing specific information about an error.
type InnerError struct {
	// One of a server-defined set of error codes.
	Code *string

	// An object containing more specific information than the current object about the error.
	Innererror *InnerError
}

type Key struct {
	// READ-ONLY; The name of the key.
	Name *string
}

// KeyListResult - The result of a list request.
type KeyListResult struct {
	// The collection value.
	Items []Key

	// The URI that can be used to request the next set of paged results.
	NextLink *string
}

type KeyValue struct {
	// The content type of the value stored within the key-value.
	ContentType *string

	// A value representing the current state of the resource.
	Etag *string

	// The key of the key-value.
	Key *string

	// The label the key-value belongs to.
	Label *string

	// A date representing the last time the key-value was modified.
	LastModified *time.Time

	// Indicates whether the key-value is locked.
	Locked *bool

	// The tags of the key-value
	Tags map[string]*string

	// The value of the key-value.
	Value *string
}

// KeyValueFilter - Enables filtering of key-values.
type KeyValueFilter struct {
	// REQUIRED; Filters key-values by their key field.
	Key *string

	// Filters key-values by their label field.
	Label *string
}

// KeyValueListResult - The result of a list request.
type KeyValueListResult struct {
	// An identifier representing the returned state of the resource.
	Etag *string

	// The collection value.
	Items []KeyValue

	// The URI that can be used to request the next set of paged results.
	NextLink *string
}

type Label struct {
	// READ-ONLY; The name of the label.
	Name *string
}

// LabelListResult - The result of a list request.
type LabelListResult struct {
	// The collection value.
	Items []Label

	// The URI that can be used to request the next set of paged results.
	NextLink *string
}

// OperationDetails - Details of a long running operation.
type OperationDetails struct {
	// REQUIRED; The unique id of the operation.
	ID *string

	// REQUIRED; The current status of the operation
	Status *State

	// An error, available when the status is Failed, describing why the operation failed.
	Error *ErrorDetail
}

type Snapshot struct {
	// REQUIRED; A list of filters used to filter the key-values included in the snapshot.
	Filters []KeyValueFilter

	// The composition type describes how the key-values within the snapshot are composed. The 'key' composition type ensures
	// there are no two key-values containing the same key. The 'key_label' composition
	// type ensures there are no two key-values containing the same key and label.
	CompositionType *CompositionType

	// The amount of time, in seconds, that a snapshot will remain in the archived state before expiring. This property is only
	// writable during the creation of a snapshot. If not specified, the default
	// lifetime of key-value revisions will be used.
	RetentionPeriod *int64

	// The tags of the snapshot.
	Tags map[string]*string

	// READ-ONLY; The time that the snapshot was created.
	Created *time.Time

	// READ-ONLY; A value representing the current state of the snapshot.
	Etag *string

	// READ-ONLY; The time that the snapshot will expire.
	Expires *time.Time

	// READ-ONLY; The amount of key-values in the snapshot.
	ItemsCount *int64

	// READ-ONLY; The name of the snapshot.
	Name *string

	// READ-ONLY; The size in bytes of the snapshot.
	Size *int64

	// READ-ONLY; The current status of the snapshot.
	Status *SnapshotStatus
}

// SnapshotListResult - The result of a snapshot list request.
type SnapshotListResult struct {
	// The collection value.
	Items []Snapshot

	// The URI that can be used to request the next set of paged results.
	NextLink *string
}

// SnapshotUpdateParameters - Parameters used to update a snapshot.
type SnapshotUpdateParameters struct {
	// The desired status of the snapshot.
	Status *SnapshotStatus
}
