//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armappservice

import "time"

// APIDefinitionInfo - Information about the formal API definition for the app.
type APIDefinitionInfo struct {
	// The URL of the API definition.
	URL *string
}

// APIKVReference - Description of site key vault references.
type APIKVReference struct {
	// Kind of resource.
	Kind *string

	// ApiKVReference resource specific properties
	Properties *APIKVReferenceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

type APIKVReferenceCollection struct {
	// REQUIRED; Collection of resources.
	Value []*APIKVReference

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// APIKVReferenceProperties - ApiKVReference resource specific properties
type APIKVReferenceProperties struct {
	ActiveVersion *string
	Details       *string

	// Managed service identity.
	IdentityType  *ManagedServiceIdentity
	Reference     *string
	SecretName    *string
	SecretVersion *string
	Source        *string
	Status        *ResolveStatus
	VaultName     *string
}

// APIManagementConfig - Azure API management (APIM) configuration linked to the app.
type APIManagementConfig struct {
	// APIM-Api Identifier.
	ID *string
}

// AbnormalTimePeriod - Class representing Abnormal Time Period identified in diagnosis
type AbnormalTimePeriod struct {
	// End time of the downtime
	EndTime *time.Time

	// List of Possible Cause of downtime
	Events []*DetectorAbnormalTimePeriod

	// List of proposed solutions
	Solutions []*Solution

	// Start time of the downtime
	StartTime *time.Time
}

// Address information for domain registration.
type Address struct {
	// REQUIRED; First line of an Address.
	Address1 *string

	// REQUIRED; The city for the address.
	City *string

	// REQUIRED; The country for the address.
	Country *string

	// REQUIRED; The postal code for the address.
	PostalCode *string

	// REQUIRED; The state or province for the address.
	State *string

	// The second line of the Address. Optional.
	Address2 *string
}

// AddressResponse - Describes main public IP address and any extra virtual IPs.
type AddressResponse struct {
	// Kind of resource.
	Kind *string

	// AddressResponse resource specific properties
	Properties *AddressResponseProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// AddressResponseProperties - AddressResponse resource specific properties
type AddressResponseProperties struct {
	// Virtual Network internal IP address of the App Service Environment if it is in internal load-balancing mode.
	InternalIPAddress *string

	// IP addresses appearing on outbound connections.
	OutboundIPAddresses []*string

	// Main public virtual IP.
	ServiceIPAddress *string

	// Additional virtual IPs.
	VipMappings []*VirtualIPMapping
}

// AllowedAudiencesValidation - The configuration settings of the Allowed Audiences validation flow.
type AllowedAudiencesValidation struct {
	// The configuration settings of the allowed list of audiences from which to validate the JWT token.
	AllowedAudiences []*string
}

// AllowedPrincipals - The configuration settings of the Azure Active Directory allowed principals.
type AllowedPrincipals struct {
	// The list of the allowed groups.
	Groups []*string

	// The list of the allowed identities.
	Identities []*string
}

// AnalysisData - Class Representing Detector Evidence used for analysis
type AnalysisData struct {
	// Additional Source Data
	Data [][]*NameValuePair

	// Detector Definition
	DetectorDefinition *DetectorDefinition

	// Detector Meta Data
	DetectorMetaData *ResponseMetaData

	// Source Metrics
	Metrics []*DiagnosticMetricSet

	// Name of the Detector
	Source *string
}

// AnalysisDefinition - Definition of Analysis
type AnalysisDefinition struct {
	// Kind of resource.
	Kind *string

	// AnalysisDefinition resource specific properties
	Properties *AnalysisDefinitionProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// AnalysisDefinitionProperties - AnalysisDefinition resource specific properties
type AnalysisDefinitionProperties struct {
	// READ-ONLY; Description of the Analysis
	Description *string
}

// AppCertificate - SSL certificate for an app.
type AppCertificate struct {
	// REQUIRED; Resource Location.
	Location *string

	// Kind of resource.
	Kind *string

	// Certificate resource specific properties
	Properties *AppCertificateProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// AppCertificateCollection - Collection of certificates.
type AppCertificateCollection struct {
	// REQUIRED; Collection of resources.
	Value []*AppCertificate

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// AppCertificatePatchResource - ARM resource for a certificate.
type AppCertificatePatchResource struct {
	// Kind of resource.
	Kind *string

	// CertificatePatchResource resource specific properties
	Properties *AppCertificatePatchResourceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// AppCertificatePatchResourceProperties - CertificatePatchResource resource specific properties
type AppCertificatePatchResourceProperties struct {
	// CNAME of the certificate to be issued via free certificate
	CanonicalName *string

	// Method of domain validation for free cert
	DomainValidationMethod *string

	// Host names the certificate applies to.
	HostNames []*string

	// Key Vault Csm resource Id.
	KeyVaultID *string

	// Key Vault secret name.
	KeyVaultSecretName *string

	// Certificate password.
	Password *string

	// Pfx blob.
	PfxBlob []byte

	// Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
	ServerFarmID *string

	// READ-ONLY; Raw bytes of .cer file
	CerBlob []byte

	// READ-ONLY; Certificate expiration date.
	ExpirationDate *time.Time

	// READ-ONLY; Friendly name of the certificate.
	FriendlyName *string

	// READ-ONLY; Specification for the App Service Environment to use for the certificate.
	HostingEnvironmentProfile *HostingEnvironmentProfile

	// READ-ONLY; Certificate issue Date.
	IssueDate *time.Time

	// READ-ONLY; Certificate issuer.
	Issuer *string

	// READ-ONLY; Status of the Key Vault secret.
	KeyVaultSecretStatus *KeyVaultSecretStatus

	// READ-ONLY; Public key hash.
	PublicKeyHash *string

	// READ-ONLY; Self link.
	SelfLink *string

	// READ-ONLY; App name.
	SiteName *string

	// READ-ONLY; Subject name of the certificate.
	SubjectName *string

	// READ-ONLY; Certificate thumbprint.
	Thumbprint *string

	// READ-ONLY; Is the certificate valid?.
	Valid *bool
}

// AppCertificateProperties - Certificate resource specific properties
type AppCertificateProperties struct {
	// CNAME of the certificate to be issued via free certificate
	CanonicalName *string

	// Method of domain validation for free cert
	DomainValidationMethod *string

	// Host names the certificate applies to.
	HostNames []*string

	// Key Vault Csm resource Id.
	KeyVaultID *string

	// Key Vault secret name.
	KeyVaultSecretName *string

	// Certificate password.
	Password *string

	// Pfx blob.
	PfxBlob []byte

	// Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
	ServerFarmID *string

	// READ-ONLY; Raw bytes of .cer file
	CerBlob []byte

	// READ-ONLY; Certificate expiration date.
	ExpirationDate *time.Time

	// READ-ONLY; Friendly name of the certificate.
	FriendlyName *string

	// READ-ONLY; Specification for the App Service Environment to use for the certificate.
	HostingEnvironmentProfile *HostingEnvironmentProfile

	// READ-ONLY; Certificate issue Date.
	IssueDate *time.Time

	// READ-ONLY; Certificate issuer.
	Issuer *string

	// READ-ONLY; Status of the Key Vault secret.
	KeyVaultSecretStatus *KeyVaultSecretStatus

	// READ-ONLY; Public key hash.
	PublicKeyHash *string

	// READ-ONLY; Self link.
	SelfLink *string

	// READ-ONLY; App name.
	SiteName *string

	// READ-ONLY; Subject name of the certificate.
	SubjectName *string

	// READ-ONLY; Certificate thumbprint.
	Thumbprint *string

	// READ-ONLY; Is the certificate valid?.
	Valid *bool
}

// AppInsightsWebAppStackSettings - App Insights Web App stack settings.
type AppInsightsWebAppStackSettings struct {
	// READ-ONLY; true if Application Insights is disabled by default for the stack; otherwise, false.
	IsDefaultOff *bool

	// READ-ONLY; true if remote Application Insights is supported for the stack; otherwise, false.
	IsSupported *bool
}

type AppLogsConfiguration struct {
	Destination               *string
	LogAnalyticsConfiguration *LogAnalyticsConfiguration
}

// AppRegistration - The configuration settings of the app registration for providers that have app ids and app secrets
type AppRegistration struct {
	// The App ID of the app used for login.
	AppID *string

	// The app setting name that contains the app secret.
	AppSecretSettingName *string
}

// Apple - The configuration settings of the Apple provider.
type Apple struct {
	// false if the Apple provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool

	// The configuration settings of the login flow.
	Login *LoginScopes

	// The configuration settings of the Apple registration.
	Registration *AppleRegistration
}

// AppleRegistration - The configuration settings of the registration for the Apple provider
type AppleRegistration struct {
	// The Client ID of the app used for login.
	ClientID *string

	// The app setting name that contains the client secret.
	ClientSecretSettingName *string
}

// ApplicationLogsConfig - Application logs configuration.
type ApplicationLogsConfig struct {
	// Application logs to blob storage configuration.
	AzureBlobStorage *AzureBlobStorageApplicationLogsConfig

	// Application logs to azure table storage configuration.
	AzureTableStorage *AzureTableStorageApplicationLogsConfig

	// Application logs to file system configuration.
	FileSystem *FileSystemApplicationLogsConfig
}

// ApplicationStack - Application stack.
type ApplicationStack struct {
	// Application stack dependency.
	Dependency *string

	// Application stack display name.
	Display *string

	// List of frameworks associated with application stack.
	Frameworks []*ApplicationStack

	// true if this is the stack is deprecated; otherwise, false.
	IsDeprecated []*ApplicationStack

	// List of major versions available.
	MajorVersions []*StackMajorVersion

	// Application stack name.
	Name *string
}

// ApplicationStackCollection - Collection of Application Stacks
type ApplicationStackCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ApplicationStackResource

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// ApplicationStackResource - ARM resource for a ApplicationStack.
type ApplicationStackResource struct {
	// Kind of resource.
	Kind *string

	// Core resource properties
	Properties *ApplicationStack

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

type ArcConfiguration struct {
	ArtifactStorageAccessMode    *string
	ArtifactStorageClassName     *string
	ArtifactStorageMountPath     *string
	ArtifactStorageNodeName      *string
	ArtifactsStorageType         *StorageType
	FrontEndServiceConfiguration *FrontEndConfiguration
	KubeConfig                   *string
}

// ArmIDWrapper - A wrapper for an ARM resource id
type ArmIDWrapper struct {
	// READ-ONLY
	ID *string
}

// ArmPlan - The plan object in Azure Resource Manager, represents a marketplace plan.
type ArmPlan struct {
	// The name.
	Name *string

	// The product.
	Product *string

	// The promotion code.
	PromotionCode *string

	// The publisher.
	Publisher *string

	// Version of product.
	Version *string
}

// AseRegion - ASE region.
type AseRegion struct {
	// Kind of resource.
	Kind *string

	// ASE region resource specific properties
	Properties *AseRegionProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// AseRegionCollection - Collection of ASE regions.
type AseRegionCollection struct {
	// REQUIRED; Collection of resources.
	Value []*AseRegion

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// AseRegionProperties - ASE region resource specific properties
type AseRegionProperties struct {
	// Available OSs in region.
	AvailableOS []*string

	// Available Skus in region.
	AvailableSKU []*string

	// READ-ONLY; Dedicated host enabled.
	DedicatedHost *bool

	// READ-ONLY; Display name for region.
	DisplayName *string

	// READ-ONLY; Is region standard.
	Standard *bool

	// READ-ONLY; Zone redundant deployment enabled.
	ZoneRedundant *bool
}

// AseV3NetworkingConfiguration - Full view of networking configuration for an ASE.
type AseV3NetworkingConfiguration struct {
	// Kind of resource.
	Kind *string

	// AseV3NetworkingConfiguration resource specific properties
	Properties *AseV3NetworkingConfigurationProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// AseV3NetworkingConfigurationProperties - AseV3NetworkingConfiguration resource specific properties
type AseV3NetworkingConfigurationProperties struct {
	// Property to enable and disable new private endpoint connection creation on ASE
	AllowNewPrivateEndpointConnections *bool

	// Property to enable and disable FTP on ASEV3
	FtpEnabled *bool

	// Customer provided Inbound IP Address. Only able to be set on Ase create.
	InboundIPAddressOverride *string

	// Property to enable and disable Remote Debug on ASEV3
	RemoteDebugEnabled *bool

	// READ-ONLY
	ExternalInboundIPAddresses []*string

	// READ-ONLY
	InternalInboundIPAddresses []*string

	// READ-ONLY
	LinuxOutboundIPAddresses []*string

	// READ-ONLY
	WindowsOutboundIPAddresses []*string
}

// AuthPlatform - The configuration settings of the platform of App Service Authentication/Authorization.
type AuthPlatform struct {
	// The path of the config file containing auth settings if they come from a file. If the path is relative, base will the site's
	// root directory.
	ConfigFilePath *string

	// true if the Authentication / Authorization feature is enabled for the current app; otherwise, false.
	Enabled *bool

	// The RuntimeVersion of the Authentication / Authorization feature in use for the current app. The setting in this value
	// can control the behavior of certain features in the Authentication /
	// Authorization module.
	RuntimeVersion *string
}

// AutoHealActions - Actions which to take by the auto-heal module when a rule is triggered.
type AutoHealActions struct {
	// Predefined action to be taken.
	ActionType *AutoHealActionType

	// Custom action to be taken.
	CustomAction *AutoHealCustomAction

	// Minimum time the process must execute before taking the action
	MinProcessExecutionTime *string
}

// AutoHealCustomAction - Custom action to be executed when an auto heal rule is triggered.
type AutoHealCustomAction struct {
	// Executable to be run.
	Exe *string

	// Parameters for the executable.
	Parameters *string
}

// AutoHealRules - Rules that can be defined for auto-heal.
type AutoHealRules struct {
	// Actions to be executed when a rule is triggered.
	Actions *AutoHealActions

	// Conditions that describe when to execute the auto-heal actions.
	Triggers *AutoHealTriggers
}

// AutoHealTriggers - Triggers for auto-heal.
type AutoHealTriggers struct {
	// A rule based on private bytes.
	PrivateBytesInKB *int32

	// A rule based on total requests.
	Requests *RequestsBasedTrigger

	// A rule based on request execution time.
	SlowRequests *SlowRequestsBasedTrigger

	// A rule based on multiple Slow Requests Rule with path
	SlowRequestsWithPath []*SlowRequestsBasedTrigger

	// A rule based on status codes.
	StatusCodes []*StatusCodesBasedTrigger

	// A rule based on status codes ranges.
	StatusCodesRange []*StatusCodesRangeBasedTrigger
}

// AzureActiveDirectory - The configuration settings of the Azure Active directory provider.
type AzureActiveDirectory struct {
	// false if the Azure Active Directory provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool

	// Gets a value indicating whether the Azure AD configuration was auto-provisioned using 1st party tooling. This is an internal
	// flag primarily intended to support the Azure Management Portal. Users
	// should not read or write to this property.
	IsAutoProvisioned *bool

	// The configuration settings of the Azure Active Directory login flow.
	Login *AzureActiveDirectoryLogin

	// The configuration settings of the Azure Active Directory app registration.
	Registration *AzureActiveDirectoryRegistration

	// The configuration settings of the Azure Active Directory token validation flow.
	Validation *AzureActiveDirectoryValidation
}

// AzureActiveDirectoryLogin - The configuration settings of the Azure Active Directory login flow.
type AzureActiveDirectoryLogin struct {
	// true if the www-authenticate provider should be omitted from the request; otherwise, false.
	DisableWWWAuthenticate *bool

	// Login parameters to send to the OpenID Connect authorization endpoint when a user logs in. Each parameter must be in the
	// form "key=value".
	LoginParameters []*string
}

// AzureActiveDirectoryRegistration - The configuration settings of the Azure Active Directory app registration.
type AzureActiveDirectoryRegistration struct {
	// The Client ID of this relying party application, known as the clientid. This setting is required for enabling OpenID Connection
	// authentication with Azure Active Directory or other 3rd party OpenID
	// Connect providers. More information on OpenID Connect: http://openid.net/specs/openid-connect-core-10.html
	ClientID *string

	// An alternative to the client secret thumbprint, that is the issuer of a certificate used for signing purposes. This property
	// acts as a replacement for the Client Secret Certificate Thumbprint. It is
	// also optional.
	ClientSecretCertificateIssuer *string

	// An alternative to the client secret thumbprint, that is the subject alternative name of a certificate used for signing
	// purposes. This property acts as a replacement for the Client Secret Certificate
	// Thumbprint. It is also optional.
	ClientSecretCertificateSubjectAlternativeName *string

	// An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts
	// as a replacement for the Client Secret. It is also optional.
	ClientSecretCertificateThumbprint *string

	// The app setting name that contains the client secret of the relying party application.
	ClientSecretSettingName *string

	// The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application. When using Azure
	// Active Directory, this value is the URI of the directory tenant, e.g.
	// https://login.microsoftonline.com/v2.0/{tenant-guid}/. This URI is a case-sensitive identifier for the token issuer. More
	// information on OpenID Connect Discovery:
	// http://openid.net/specs/openid-connect-discovery-1_0.html
	OpenIDIssuer *string
}

// AzureActiveDirectoryValidation - The configuration settings of the Azure Active Directory token validation flow.
type AzureActiveDirectoryValidation struct {
	// The list of audiences that can make successful authentication/authorization requests.
	AllowedAudiences []*string

	// The configuration settings of the default authorization policy.
	DefaultAuthorizationPolicy *DefaultAuthorizationPolicy

	// The configuration settings of the checks that should be made while validating the JWT Claims.
	JwtClaimChecks *JwtClaimChecks
}

// AzureBlobStorageApplicationLogsConfig - Application logs azure blob storage configuration.
type AzureBlobStorageApplicationLogsConfig struct {
	// Log level.
	Level *LogLevel

	// Retention in days. Remove blobs older than X days. 0 or lower means no retention.
	RetentionInDays *int32

	// SAS url to a azure blob container with read/write/list/delete permissions.
	SasURL *string
}

// AzureBlobStorageHTTPLogsConfig - Http logs to azure blob storage configuration.
type AzureBlobStorageHTTPLogsConfig struct {
	// True if configuration is enabled, false if it is disabled and null if configuration is not set.
	Enabled *bool

	// Retention in days. Remove blobs older than X days. 0 or lower means no retention.
	RetentionInDays *int32

	// SAS url to a azure blob container with read/write/list/delete permissions.
	SasURL *string
}

// AzureResourceErrorInfo - The azure resource error info.
type AzureResourceErrorInfo struct {
	// REQUIRED; The error code.
	Code *string

	// REQUIRED; The error message.
	Message *string

	// The error details.
	Details []*AzureResourceErrorInfo
}

// AzureStaticWebApps - The configuration settings of the Azure Static Web Apps provider.
type AzureStaticWebApps struct {
	// false if the Azure Static Web Apps provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool

	// The configuration settings of the Azure Static Web Apps registration.
	Registration *AzureStaticWebAppsRegistration
}

// AzureStaticWebAppsRegistration - The configuration settings of the registration for the Azure Static Web Apps provider
type AzureStaticWebAppsRegistration struct {
	// The Client ID of the app used for login.
	ClientID *string
}

// AzureStorageInfoValue - Azure Files or Blob Storage access information value for dictionary storage.
type AzureStorageInfoValue struct {
	// Access key for the storage account.
	AccessKey *string

	// Name of the storage account.
	AccountName *string

	// Path to mount the storage within the site's runtime environment.
	MountPath *string

	// Name of the file share (container name, for Blob storage).
	ShareName *string

	// Type of storage.
	Type *AzureStorageType

	// READ-ONLY; State of the storage account.
	State *AzureStorageState
}

// AzureStoragePropertyDictionaryResource - AzureStorageInfo dictionary resource.
type AzureStoragePropertyDictionaryResource struct {
	// Kind of resource.
	Kind *string

	// Azure storage accounts.
	Properties map[string]*AzureStorageInfoValue

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// AzureTableStorageApplicationLogsConfig - Application logs to Azure table storage configuration.
type AzureTableStorageApplicationLogsConfig struct {
	// REQUIRED; SAS URL to an Azure table with add/query/delete permissions.
	SasURL *string

	// Log level.
	Level *LogLevel
}

// BackupItem - Backup description.
type BackupItem struct {
	// Kind of resource.
	Kind *string

	// BackupItem resource specific properties
	Properties *BackupItemProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// BackupItemCollection - Collection of backup items.
type BackupItemCollection struct {
	// REQUIRED; Collection of resources.
	Value []*BackupItem

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// BackupItemProperties - BackupItem resource specific properties
type BackupItemProperties struct {
	// READ-ONLY; Id of the backup.
	BackupID *int32

	// READ-ONLY; Name of the blob which contains data for this backup.
	BlobName *string

	// READ-ONLY; Unique correlation identifier. Please use this along with the timestamp while communicating with Azure support.
	CorrelationID *string

	// READ-ONLY; Timestamp of the backup creation.
	Created *time.Time

	// READ-ONLY; List of databases included in the backup.
	Databases []*DatabaseBackupSetting

	// READ-ONLY; Timestamp when this backup finished.
	FinishedTimeStamp *time.Time

	// READ-ONLY; Timestamp of a last restore operation which used this backup.
	LastRestoreTimeStamp *time.Time

	// READ-ONLY; Details regarding this backup. Might contain an error message.
	Log *string

	// READ-ONLY; Name of this backup.
	Name *string

	// READ-ONLY; True if this backup has been created due to a schedule being triggered.
	Scheduled *bool

	// READ-ONLY; Size of the backup in bytes.
	SizeInBytes *int64

	// READ-ONLY; Backup status.
	Status *BackupItemStatus

	// READ-ONLY; SAS URL for the storage account container which contains this backup.
	StorageAccountURL *string

	// READ-ONLY; Size of the original web app which has been backed up.
	WebsiteSizeInBytes *int64
}

// BackupRequest - Description of a backup which will be performed.
type BackupRequest struct {
	// Kind of resource.
	Kind *string

	// BackupRequest resource specific properties
	Properties *BackupRequestProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// BackupRequestProperties - BackupRequest resource specific properties
type BackupRequestProperties struct {
	// REQUIRED; SAS URL to the container.
	StorageAccountURL *string

	// Name of the backup.
	BackupName *string

	// Schedule for the backup if it is executed periodically.
	BackupSchedule *BackupSchedule

	// Databases included in the backup.
	Databases []*DatabaseBackupSetting

	// True if the backup schedule is enabled (must be included in that case), false if the backup schedule should be disabled.
	Enabled *bool
}

// BackupSchedule - Description of a backup schedule. Describes how often should be the backup performed and what should be
// the retention policy.
type BackupSchedule struct {
	// REQUIRED; How often the backup should be executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should
	// be set to Day)
	FrequencyInterval *int32

	// REQUIRED; The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day
	// and FrequencyInterval should be set to 7)
	FrequencyUnit *FrequencyUnit

	// REQUIRED; True if the retention policy should always keep at least one backup in the storage account, regardless how old
	// it is; false otherwise.
	KeepAtLeastOneBackup *bool

	// REQUIRED; After how many days backups should be deleted.
	RetentionPeriodInDays *int32

	// When the schedule should start working.
	StartTime *time.Time

	// READ-ONLY; Last time when this schedule was triggered.
	LastExecutionTime *time.Time
}

// BillingMeter - App Service billing entity that contains information about meter which the Azure billing system utilizes
// to charge users for services.
type BillingMeter struct {
	// Kind of resource.
	Kind *string

	// BillingMeter resource specific properties
	Properties *BillingMeterProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// BillingMeterCollection - Collection of Billing Meters
type BillingMeterCollection struct {
	// REQUIRED; Collection of resources.
	Value []*BillingMeter

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// BillingMeterProperties - BillingMeter resource specific properties
type BillingMeterProperties struct {
	// Azure Location of billable resource
	BillingLocation *string

	// Friendly name of the meter
	FriendlyName *string

	// Meter GUID onboarded in Commerce
	MeterID *string

	// Meter Multiplier
	Multiplier *float64

	// App Service OS type meter used for
	OSType *string

	// App Service ResourceType meter used for
	ResourceType *string

	// Short Name from App Service Azure pricing Page
	ShortName *string
}

// BlobStorageTokenStore - The configuration settings of the storage of the tokens if blob storage is used.
type BlobStorageTokenStore struct {
	// The name of the app setting containing the SAS URL of the blob storage containing the tokens.
	SasURLSettingName *string
}

// Capability - Describes the capabilities/features allowed for a specific SKU.
type Capability struct {
	// Name of the SKU capability.
	Name *string

	// Reason of the SKU capability.
	Reason *string

	// Value of the SKU capability.
	Value *string
}

// Certificate - Key Vault container for a certificate that is purchased through Azure.
type Certificate struct {
	// Key Vault resource Id.
	KeyVaultID *string

	// Key Vault secret name.
	KeyVaultSecretName *string

	// READ-ONLY; Status of the Key Vault secret.
	ProvisioningState *KeyVaultSecretStatus
}

// CertificateCollection - Collection of certificate order certificates.
type CertificateCollection struct {
	// REQUIRED; Collection of resources.
	Value []*CertificateResource

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// CertificateDetails - SSL certificate details.
type CertificateDetails struct {
	// READ-ONLY; Certificate Issuer.
	Issuer *string

	// READ-ONLY; Date Certificate is valid to.
	NotAfter *time.Time

	// READ-ONLY; Date Certificate is valid from.
	NotBefore *time.Time

	// READ-ONLY; Raw certificate data.
	RawData *string

	// READ-ONLY; Certificate Serial Number.
	SerialNumber *string

	// READ-ONLY; Certificate Signature algorithm.
	SignatureAlgorithm *string

	// READ-ONLY; Certificate Subject.
	Subject *string

	// READ-ONLY; Certificate Thumbprint.
	Thumbprint *string

	// READ-ONLY; Certificate Version.
	Version *int32
}

// CertificateEmail - SSL certificate email.
type CertificateEmail struct {
	// Email id.
	EmailID *string

	// Time stamp.
	TimeStamp *time.Time
}

// CertificateOrder - SSL certificate purchase order.
type CertificateOrder struct {
	// REQUIRED; Resource Location.
	Location *string

	// Kind of resource.
	Kind *string

	// AppServiceCertificateOrder resource specific properties
	Properties *CertificateOrderProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// CertificateOrderAction - Certificate order action.
type CertificateOrderAction struct {
	// READ-ONLY; Action type.
	ActionType *CertificateOrderActionType

	// READ-ONLY; Time at which the certificate action was performed.
	CreatedAt *time.Time
}

// CertificateOrderCollection - Collection of certificate orders.
type CertificateOrderCollection struct {
	// REQUIRED; Collection of resources.
	Value []*CertificateOrder

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

type CertificateOrderContact struct {
	Email     *string
	NameFirst *string
	NameLast  *string
	Phone     *string
}

// CertificateOrderPatchResource - ARM resource for a certificate order that is purchased through Azure.
type CertificateOrderPatchResource struct {
	// Kind of resource.
	Kind *string

	// AppServiceCertificateOrderPatchResource resource specific properties
	Properties *CertificateOrderPatchResourceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// CertificateOrderPatchResourceProperties - AppServiceCertificateOrderPatchResource resource specific properties
type CertificateOrderPatchResourceProperties struct {
	// REQUIRED; Certificate product type.
	ProductType *CertificateProductType

	// true if the certificate should be automatically renewed when it expires; otherwise, false.
	AutoRenew *bool

	// State of the Key Vault secret.
	Certificates map[string]*Certificate

	// Last CSR that was created for this order.
	Csr *string

	// Certificate distinguished name.
	DistinguishedName *string

	// Certificate key size.
	KeySize *int32

	// Duration in years (must be 1).
	ValidityInYears *int32

	// READ-ONLY; Reasons why App Service Certificate is not renewable at the current moment.
	AppServiceCertificateNotRenewableReasons []*ResourceNotRenewableReason

	// READ-ONLY; Contact info
	Contact *CertificateOrderContact

	// READ-ONLY; Domain verification token.
	DomainVerificationToken *string

	// READ-ONLY; Certificate expiration time.
	ExpirationTime *time.Time

	// READ-ONLY; Intermediate certificate.
	Intermediate *CertificateDetails

	// READ-ONLY; true if private key is external; otherwise, false.
	IsPrivateKeyExternal *bool

	// READ-ONLY; Certificate last issuance time.
	LastCertificateIssuanceTime *time.Time

	// READ-ONLY; Time stamp when the certificate would be auto renewed next
	NextAutoRenewalTimeStamp *time.Time

	// READ-ONLY; Status of certificate order.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Root certificate.
	Root *CertificateDetails

	// READ-ONLY; Current serial number of the certificate.
	SerialNumber *string

	// READ-ONLY; Signed certificate.
	SignedCertificate *CertificateDetails

	// READ-ONLY; Current order status.
	Status *CertificateOrderStatus
}

// CertificateOrderProperties - AppServiceCertificateOrder resource specific properties
type CertificateOrderProperties struct {
	// REQUIRED; Certificate product type.
	ProductType *CertificateProductType

	// true if the certificate should be automatically renewed when it expires; otherwise, false.
	AutoRenew *bool

	// State of the Key Vault secret.
	Certificates map[string]*Certificate

	// Last CSR that was created for this order.
	Csr *string

	// Certificate distinguished name.
	DistinguishedName *string

	// Certificate key size.
	KeySize *int32

	// Duration in years (must be 1).
	ValidityInYears *int32

	// READ-ONLY; Reasons why App Service Certificate is not renewable at the current moment.
	AppServiceCertificateNotRenewableReasons []*ResourceNotRenewableReason

	// READ-ONLY; Contact info
	Contact *CertificateOrderContact

	// READ-ONLY; Domain verification token.
	DomainVerificationToken *string

	// READ-ONLY; Certificate expiration time.
	ExpirationTime *time.Time

	// READ-ONLY; Intermediate certificate.
	Intermediate *CertificateDetails

	// READ-ONLY; true if private key is external; otherwise, false.
	IsPrivateKeyExternal *bool

	// READ-ONLY; Certificate last issuance time.
	LastCertificateIssuanceTime *time.Time

	// READ-ONLY; Time stamp when the certificate would be auto renewed next
	NextAutoRenewalTimeStamp *time.Time

	// READ-ONLY; Status of certificate order.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Root certificate.
	Root *CertificateDetails

	// READ-ONLY; Current serial number of the certificate.
	SerialNumber *string

	// READ-ONLY; Signed certificate.
	SignedCertificate *CertificateDetails

	// READ-ONLY; Current order status.
	Status *CertificateOrderStatus
}

// CertificatePatchResource - Key Vault container ARM resource for a certificate that is purchased through Azure.
type CertificatePatchResource struct {
	// Kind of resource.
	Kind *string

	// Core resource properties
	Properties *Certificate

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// CertificateResource - Key Vault container ARM resource for a certificate that is purchased through Azure.
type CertificateResource struct {
	// REQUIRED; Resource Location.
	Location *string

	// Kind of resource.
	Kind *string

	// Core resource properties
	Properties *Certificate

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ClientRegistration - The configuration settings of the app registration for providers that have client ids and client secrets
type ClientRegistration struct {
	// The Client ID of the app used for login.
	ClientID *string

	// The app setting name that contains the client secret.
	ClientSecretSettingName *string
}

// CloningInfo - Information needed for cloning operation.
type CloningInfo struct {
	// REQUIRED; ARM resource ID of the source app. App resource ID is of the form /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
	// for production slots and
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName} for
	// other slots.
	SourceWebAppID *string

	// Application setting overrides for cloned app. If specified, these settings override the settings cloned from source app.
	// Otherwise, application settings from source app are retained.
	AppSettingsOverrides map[string]*string

	// true to clone custom hostnames from source app; otherwise, false.
	CloneCustomHostNames *bool

	// true to clone source control from source app; otherwise, false.
	CloneSourceControl *bool

	// true to configure load balancing for source and destination app.
	ConfigureLoadBalancing *bool

	// Correlation ID of cloning operation. This ID ties multiple cloning operations together to use the same snapshot.
	CorrelationID *string

	// App Service Environment.
	HostingEnvironment *string

	// true to overwrite destination app; otherwise, false.
	Overwrite *bool

	// Location of source app ex: West US or North Europe
	SourceWebAppLocation *string

	// ARM resource ID of the Traffic Manager profile to use, if it exists. Traffic Manager resource ID is of the form
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
	TrafficManagerProfileID *string

	// Name of Traffic Manager profile to create. This is only needed if Traffic Manager profile does not already exist.
	TrafficManagerProfileName *string
}

// Configuration - Non versioned Container App configuration properties that define the mutable settings of a Container app
type Configuration struct {
	// ActiveRevisionsMode controls how active revisions are handled for the Container app:Multiple: multiple revisions can be
	// active. If no value if provided, this is the defaultSingle: Only one revision
	// can be active at a time. Revision weights can not be used in this mode
	ActiveRevisionsMode *ActiveRevisionsMode

	// Ingress configurations.
	Ingress *Ingress

	// Collection of private container registry credentials for containers used by the Container app
	Registries []*RegistryCredentials

	// Collection of secrets used by a Container app
	Secrets []*Secret
}

// ConnStringInfo - Database connection string information.
type ConnStringInfo struct {
	// Connection string value.
	ConnectionString *string

	// Name of connection string.
	Name *string

	// Type of database.
	Type *ConnectionStringType
}

// ConnStringValueTypePair - Database connection string value to type pair.
type ConnStringValueTypePair struct {
	// REQUIRED; Type of database.
	Type *ConnectionStringType

	// REQUIRED; Value of pair.
	Value *string
}

// ConnectionStringDictionary - String dictionary resource.
type ConnectionStringDictionary struct {
	// Kind of resource.
	Kind *string

	// Connection strings.
	Properties map[string]*ConnStringValueTypePair

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// Contact information for domain registration. If 'Domain Privacy' option is not selected then the contact information is
// made publicly available through the Whois directories as per ICANN requirements.
type Contact struct {
	// REQUIRED; Email address.
	Email *string

	// REQUIRED; First name.
	NameFirst *string

	// REQUIRED; Last name.
	NameLast *string

	// REQUIRED; Phone number.
	Phone *string

	// Mailing address.
	AddressMailing *Address

	// Fax number.
	Fax *string

	// Job title.
	JobTitle *string

	// Middle name.
	NameMiddle *string

	// Organization contact belongs to.
	Organization *string
}

// Container App container definition.
type Container struct {
	// Container start command arguments.
	Args []*string

	// Container start command.
	Command []*string

	// Container environment variables.
	Env []*EnvironmentVar

	// Container image tag.
	Image *string

	// Custom container name.
	Name *string

	// Container resource requirements.
	Resources *ContainerResources
}

// ContainerApp - Container App.
type ContainerApp struct {
	// REQUIRED; Resource Location.
	Location *string

	// Kind of resource.
	Kind *string

	// ContainerApp resource specific properties
	Properties *ContainerAppProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ContainerAppCollection - Container App collection ARM resource.
type ContainerAppCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ContainerApp

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// ContainerAppProperties - ContainerApp resource specific properties
type ContainerAppProperties struct {
	// Non versioned Container App configuration properties.
	Configuration *Configuration

	// Resource ID of the Container App's KubeEnvironment.
	KubeEnvironmentID *string

	// Container App versioned application definition.
	Template *Template

	// READ-ONLY; Fully Qualified Domain Name of the latest revision of the Container App.
	LatestRevisionFqdn *string

	// READ-ONLY; Name of the latest revision of the Container App.
	LatestRevisionName *string

	// READ-ONLY; Provisioning state of the Container App.
	ProvisioningState *ContainerAppProvisioningState
}

// ContainerAppSecret - Container App Secret.
type ContainerAppSecret struct {
	// READ-ONLY; Secret Name.
	Name *string

	// READ-ONLY; Secret Value.
	Value *string
}

type ContainerAppsConfiguration struct {
	// Resource ID of a subnet for control plane infrastructure components. This subnet must be in the same VNET as the subnet
	// defined in appSubnetResourceId. Must not overlap with the IP range defined in
	// platformReservedCidr, if defined.
	AppSubnetResourceID *string

	// Resource ID of a subnet for control plane infrastructure components. This subnet must be in the same VNET as the subnet
	// defined in appSubnetResourceId. Must not overlap with the IP range defined in
	// platformReservedCidr, if defined.
	ControlPlaneSubnetResourceID *string

	// Azure Monitor instrumentation key used by Dapr to export Service to Service communication telemetry
	DaprAIInstrumentationKey *string

	// CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the IP range
	// defined in platformReservedCidr, if defined.
	DockerBridgeCidr *string

	// IP range in CIDR notation that can be reserved for environment infrastructure IP addresses. It must not overlap with any
	// other Subnet IP ranges.
	PlatformReservedCidr *string

	// An IP address from the IP range defined by platformReservedCidr that will be reserved for the internal DNS server
	PlatformReservedDNSIP *string
}

type ContainerCPUStatistics struct {
	CPUUsage       *ContainerCPUUsage
	OnlineCPUCount *int32
	SystemCPUUsage *int64
	ThrottlingData *ContainerThrottlingData
}

type ContainerCPUUsage struct {
	KernelModeUsage *int64
	PerCPUUsage     []*int64
	TotalUsage      *int64
	UserModeUsage   *int64
}

type ContainerInfo struct {
	CurrentCPUStats   *ContainerCPUStatistics
	CurrentTimeStamp  *time.Time
	Eth0              *ContainerNetworkInterfaceStatistics
	ID                *string
	MemoryStats       *ContainerMemoryStatistics
	Name              *string
	PreviousCPUStats  *ContainerCPUStatistics
	PreviousTimeStamp *time.Time
}

type ContainerMemoryStatistics struct {
	Limit    *int64
	MaxUsage *int64
	Usage    *int64
}

type ContainerNetworkInterfaceStatistics struct {
	RxBytes   *int64
	RxDropped *int64
	RxErrors  *int64
	RxPackets *int64
	TxBytes   *int64
	TxDropped *int64
	TxErrors  *int64
	TxPackets *int64
}

// ContainerResources - Container App container resource requirements.
type ContainerResources struct {
	// Required CPU in cores, e.g. 0.5
	CPU *float64

	// Required memory, e.g. "250Mb"
	Memory *string
}

type ContainerThrottlingData struct {
	Periods          *int32
	ThrottledPeriods *int32
	ThrottledTime    *int32
}

// ContentHash - The content hash.
type ContentHash struct {
	// The algorithm of the content hash.
	Algorithm *string

	// The value of the content hash.
	Value *string
}

// ContentLink - The content link.
type ContentLink struct {
	// The content link URI.
	URI *string

	// READ-ONLY; The content hash.
	ContentHash *ContentHash

	// READ-ONLY; The content size.
	ContentSize *int64

	// READ-ONLY; The content version.
	ContentVersion *string

	// READ-ONLY; The metadata.
	Metadata any
}

// ContinuousWebJob - Continuous Web Job Information.
type ContinuousWebJob struct {
	// Kind of resource.
	Kind *string

	// ContinuousWebJob resource specific properties
	Properties *ContinuousWebJobProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ContinuousWebJobCollection - Collection of Kudu continuous web job information elements.
type ContinuousWebJobCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ContinuousWebJob

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// ContinuousWebJobProperties - ContinuousWebJob resource specific properties
type ContinuousWebJobProperties struct {
	// Detailed status.
	DetailedStatus *string

	// Error information.
	Error *string

	// Extra Info URL.
	ExtraInfoURL *string

	// Log URL.
	LogURL *string

	// Run command.
	RunCommand *string

	// Job settings.
	Settings map[string]any

	// Job status.
	Status *ContinuousWebJobStatus

	// Job URL.
	URL *string

	// Using SDK?
	UsingSdk *bool

	// Job type.
	WebJobType *WebJobType
}

// CookieExpiration - The configuration settings of the session cookie's expiration.
type CookieExpiration struct {
	// The convention used when determining the session cookie's expiration.
	Convention *CookieExpirationConvention

	// The time after the request is made when the session cookie should expire.
	TimeToExpiration *string
}

// Correlation - The correlation property.
type Correlation struct {
	// The client tracking id.
	ClientTrackingID *string
}

// CorsSettings - Cross-Origin Resource Sharing (CORS) settings for the app.
type CorsSettings struct {
	// Gets or sets the list of origins that should be allowed to make cross-origin calls (for example: http://example.com:12345).
	// Use "*" to allow all.
	AllowedOrigins []*string

	// Gets or sets whether CORS requests with credentials are allowed. See https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requestswithcredentials
	// for more details.
	SupportCredentials *bool
}

// CsmDeploymentStatus - Deployment status response payload.
type CsmDeploymentStatus struct {
	// Kind of resource.
	Kind *string

	// CsmDeploymentStatus resource specific properties
	Properties *CsmDeploymentStatusProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// CsmDeploymentStatusCollection - Deployment status collection ARM resource.
type CsmDeploymentStatusCollection struct {
	// REQUIRED; Collection of resources.
	Value []*CsmDeploymentStatus

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// CsmDeploymentStatusProperties - CsmDeploymentStatus resource specific properties
type CsmDeploymentStatusProperties struct {
	// Deployment operation id.
	DeploymentID *string

	// List of errors.
	Errors []*ErrorEntity

	// List of URLs pointing to logs for instances which failed to provision.
	FailedInstancesLogs []*string

	// Number of site instances failed to provision.
	NumberOfInstancesFailed *int32

	// Number of site instances currently being provisioned.
	NumberOfInstancesInProgress *int32

	// Number of site instances provisioned successfully.
	NumberOfInstancesSuccessful *int32

	// Deployment build status.
	Status *DeploymentBuildStatus
}

// CsmMoveResourceEnvelope - Object with a list of the resources that need to be moved and the resource group they should
// be moved to.
type CsmMoveResourceEnvelope struct {
	Resources           []*string
	TargetResourceGroup *string
}

// CsmOperationCollection - Collection of Azure resource manager operation metadata.
type CsmOperationCollection struct {
	// REQUIRED; Collection of resources.
	Value []*CsmOperationDescription

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// CsmOperationDescription - Description of an operation available for Microsoft.Web resource provider.
type CsmOperationDescription struct {
	// Meta data about operation used for display in portal.
	Display      *CsmOperationDisplay
	IsDataAction *bool
	Name         *string
	Origin       *string

	// Properties available for a Microsoft.Web resource provider operation.
	Properties *CsmOperationDescriptionProperties
}

// CsmOperationDescriptionProperties - Properties available for a Microsoft.Web resource provider operation.
type CsmOperationDescriptionProperties struct {
	// Resource metrics service provided by Microsoft.Insights resource provider.
	ServiceSpecification *ServiceSpecification
}

// CsmOperationDisplay - Meta data about operation used for display in portal.
type CsmOperationDisplay struct {
	Description *string
	Operation   *string
	Provider    *string
	Resource    *string
}

// CsmPublishingCredentialsPoliciesEntity - Publishing Credentials Policies parameters.
type CsmPublishingCredentialsPoliciesEntity struct {
	// Kind of resource.
	Kind *string

	// CsmPublishingCredentialsPoliciesEntity resource specific properties
	Properties *CsmPublishingCredentialsPoliciesEntityProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// CsmPublishingCredentialsPoliciesEntityProperties - CsmPublishingCredentialsPoliciesEntity resource specific properties
type CsmPublishingCredentialsPoliciesEntityProperties struct {
	// REQUIRED; true to allow access to a publishing method; otherwise, false.
	Allow *bool
}

// CsmPublishingProfileOptions - Publishing options for requested profile.
type CsmPublishingProfileOptions struct {
	// Name of the format. Valid values are: FileZilla3 WebDeploy -- default Ftp
	Format *PublishingProfileFormat

	// Include the DisasterRecover endpoint if true
	IncludeDisasterRecoveryEndpoints *bool
}

// CsmSlotEntity - Deployment slot parameters.
type CsmSlotEntity struct {
	// REQUIRED; true to preserve Virtual Network to the slot during swap; otherwise, false.
	PreserveVnet *bool

	// REQUIRED; Destination deployment slot during swap operation.
	TargetSlot *string
}

// CsmUsageQuota - Usage of the quota resource.
type CsmUsageQuota struct {
	// The current value of the resource counter.
	CurrentValue *int64

	// The resource limit.
	Limit *int64

	// Quota name.
	Name *LocalizableString

	// Next reset time for the resource counter.
	NextResetTime *time.Time

	// Units of measurement for the quota resource.
	Unit *string
}

// CsmUsageQuotaCollection - Collection of CSM usage quotas.
type CsmUsageQuotaCollection struct {
	// REQUIRED; Collection of resources.
	Value []*CsmUsageQuota

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// CustomDNSSuffixConfiguration - Full view of the custom domain suffix configuration for ASEv3.
type CustomDNSSuffixConfiguration struct {
	// Kind of resource.
	Kind *string

	// CustomDnsSuffixConfiguration resource specific properties
	Properties *CustomDNSSuffixConfigurationProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// CustomDNSSuffixConfigurationProperties - CustomDnsSuffixConfiguration resource specific properties
type CustomDNSSuffixConfigurationProperties struct {
	// The URL referencing the Azure Key Vault certificate secret that should be used as the default SSL/TLS certificate for sites
	// with the custom domain suffix.
	CertificateURL *string

	// The default custom domain suffix to use for all sites deployed on the ASE.
	DNSSuffix *string

	// The user-assigned identity to use for resolving the key vault certificate reference. If not specified, the system-assigned
	// ASE identity will be used if available.
	KeyVaultReferenceIdentity *string

	// READ-ONLY
	ProvisioningDetails *string

	// READ-ONLY
	ProvisioningState *CustomDNSSuffixProvisioningState
}

// CustomHostnameAnalysisResult - Custom domain analysis.
type CustomHostnameAnalysisResult struct {
	// Kind of resource.
	Kind *string

	// CustomHostnameAnalysisResult resource specific properties
	Properties *CustomHostnameAnalysisResultProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// CustomHostnameAnalysisResultProperties - CustomHostnameAnalysisResult resource specific properties
type CustomHostnameAnalysisResultProperties struct {
	// A records controller can see for this hostname.
	ARecords []*string

	// Alternate CName records controller can see for this hostname.
	AlternateCNameRecords []*string

	// Alternate TXT records controller can see for this hostname.
	AlternateTxtRecords []*string

	// CName records controller can see for this hostname.
	CNameRecords []*string

	// TXT records controller can see for this hostname.
	TxtRecords []*string

	// READ-ONLY; Name of the conflicting app on scale unit if it's within the same subscription.
	ConflictingAppResourceID *string

	// READ-ONLY; Raw failure information if DNS verification fails.
	CustomDomainVerificationFailureInfo *ErrorEntity

	// READ-ONLY; DNS verification test result.
	CustomDomainVerificationTest *DNSVerificationTestResult

	// READ-ONLY; true if there is a conflict across subscriptions; otherwise, false.
	HasConflictAcrossSubscription *bool

	// READ-ONLY; true if there is a conflict on a scale unit; otherwise, false.
	HasConflictOnScaleUnit *bool

	// READ-ONLY; true if hostname is already verified; otherwise, false.
	IsHostnameAlreadyVerified *bool
}

// CustomHostnameSites - A hostname and its assigned sites
type CustomHostnameSites struct {
	// Kind of resource.
	Kind *string

	// CustomHostnameSites resource specific properties
	Properties *CustomHostnameSitesProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// CustomHostnameSitesCollection - Collection of custom hostname sites
type CustomHostnameSitesCollection struct {
	// REQUIRED; Collection of resources.
	Value []*CustomHostnameSites

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// CustomHostnameSitesProperties - CustomHostnameSites resource specific properties
type CustomHostnameSitesProperties struct {
	CustomHostname  *string
	Region          *string
	SiteResourceIDs []*Identifier
}

// CustomOpenIDConnectProvider - The configuration settings of the custom Open ID Connect provider.
type CustomOpenIDConnectProvider struct {
	// false if the custom Open ID provider provider should not be enabled; otherwise, true.
	Enabled *bool

	// The configuration settings of the login flow of the custom Open ID Connect provider.
	Login *OpenIDConnectLogin

	// The configuration settings of the app registration for the custom Open ID Connect provider.
	Registration *OpenIDConnectRegistration
}

// CustomScaleRule - Container App container Custom scaling rule.
type CustomScaleRule struct {
	// Authentication secrets for the custom scale rule.
	Auth []*ScaleRuleAuth

	// Metadata properties to describe custom scale rule.
	Metadata map[string]*string

	// Type of the custom scale rule eg: azure-servicebus, redis etc.
	Type *string
}

// Dapr - Container App Dapr configuration.
type Dapr struct {
	// Dapr application identifier
	AppID *string

	// Port on which the Dapr side car
	AppPort *int32

	// Collection of Dapr components
	Components []*DaprComponent

	// Boolean indicating if the Dapr side car is enabled
	Enabled *bool
}

// DaprComponent - Dapr component configuration
type DaprComponent struct {
	// Component metadata
	Metadata []*DaprMetadata

	// Component name
	Name *string

	// Component type
	Type *string

	// Component version
	Version *string
}

// DaprConfig - App Dapr configuration.
type DaprConfig struct {
	// Dapr application identifier
	AppID *string

	// Tells Dapr which port your application is listening on
	AppPort *int32

	// Enables API logging for the Dapr sidecar
	EnableAPILogging *bool

	// Boolean indicating if the Dapr side car is enabled
	Enabled *bool

	// Increasing max size of request body http servers parameter in MB to handle uploading of big files. Default is 4 MB.
	HTTPMaxRequestSize *int32

	// Dapr max size of http header read buffer in KB to handle when sending multi-KB headers. Default is 65KB.
	HTTPReadBufferSize *int32

	// Sets the log level for the Dapr sidecar. Allowed values are debug, info, warn, error. Default is info.
	LogLevel *DaprLogLevel
}

// DaprMetadata - Container App Dapr component metadata.
type DaprMetadata struct {
	// Metadata property name.
	Name *string

	// Name of the Container App secret from which to pull the metadata property value.
	SecretRef *string

	// Metadata property value.
	Value *string
}

// DataProviderMetadata - Additional configuration for a data providers
type DataProviderMetadata struct {
	ProviderName *string

	// READ-ONLY; Settings for the data provider
	PropertyBag []*KeyValuePairStringObject
}

// DataSource - Class representing data source used by the detectors
type DataSource struct {
	// Datasource Uri Links
	DataSourceURI []*NameValuePair

	// Instructions if any for the data source
	Instructions []*string
}

// DataTableResponseColumn - Column definition
type DataTableResponseColumn struct {
	// Name of the column
	ColumnName *string

	// Column Type
	ColumnType *string

	// Data type which looks like 'String' or 'Int32'.
	DataType *string
}

// DataTableResponseObject - Data Table which defines columns and raw row values
type DataTableResponseObject struct {
	// List of columns with data types
	Columns []*DataTableResponseColumn

	// Raw row values
	Rows [][]*string

	// Name of the table
	TableName *string
}

// DatabaseBackupSetting - Database backup settings.
type DatabaseBackupSetting struct {
	// REQUIRED; Database type (e.g. SqlAzure / MySql).
	DatabaseType *DatabaseType

	// Contains a connection string to a database which is being backed up or restored. If the restore should happen to a new
	// database, the database name inside is the new one.
	ConnectionString *string

	// Contains a connection string name that is linked to the SiteConfig.ConnectionStrings. This is used during restore with
	// overwrite connection strings options.
	ConnectionStringName *string
	Name                 *string
}

// DatabaseConnection - Static Site Database Connection resource.
type DatabaseConnection struct {
	// Kind of resource.
	Kind *string

	// DatabaseConnection resource specific properties
	Properties *DatabaseConnectionProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// DatabaseConnectionCollection - Collection of static site database connections.
type DatabaseConnectionCollection struct {
	// REQUIRED; Collection of resources.
	Value []*DatabaseConnection

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// DatabaseConnectionOverview - Static Site Database Connection overview.
type DatabaseConnectionOverview struct {
	// READ-ONLY; A list of configuration files associated with this database connection.
	ConfigurationFiles []*StaticSiteDatabaseConnectionConfigurationFileOverview

	// READ-ONLY; If present, the identity is used in conjunction with connection string to connect to the database. Use of the
	// system-assigned managed identity is indicated with the string 'SystemAssigned', while use
	// of a user-assigned managed identity is indicated with the resource id of the managed identity resource.
	ConnectionIdentity *string

	// READ-ONLY; If present, the name of this database connection resource.
	Name *string

	// READ-ONLY; The region of the database resource.
	Region *string

	// READ-ONLY; The resource id of the database.
	ResourceID *string
}

// DatabaseConnectionPatchRequest - Static Site Database Connection Request Properties resource when patching
type DatabaseConnectionPatchRequest struct {
	// DatabaseConnectionPatchRequest resource specific properties
	Properties *DatabaseConnectionPatchRequestProperties
}

// DatabaseConnectionPatchRequestProperties - DatabaseConnectionPatchRequest resource specific properties
type DatabaseConnectionPatchRequestProperties struct {
	// If present, the identity is used in conjunction with connection string to connect to the database. Use of the system-assigned
	// managed identity is indicated with the string 'SystemAssigned', while use
	// of a user-assigned managed identity is indicated with the resource id of the managed identity resource.
	ConnectionIdentity *string

	// The connection string to use to connect to the database.
	ConnectionString *string

	// The region of the database resource.
	Region *string

	// The resource id of the database.
	ResourceID *string
}

// DatabaseConnectionProperties - DatabaseConnection resource specific properties
type DatabaseConnectionProperties struct {
	// REQUIRED; The region of the database resource.
	Region *string

	// REQUIRED; The resource id of the database.
	ResourceID *string

	// If present, the identity is used in conjunction with connection string to connect to the database. Use of the system-assigned
	// managed identity is indicated with the string 'SystemAssigned', while use
	// of a user-assigned managed identity is indicated with the resource id of the managed identity resource.
	ConnectionIdentity *string

	// The connection string to use to connect to the database.
	ConnectionString *string

	// READ-ONLY; A list of configuration files associated with this database connection.
	ConfigurationFiles []*StaticSiteDatabaseConnectionConfigurationFileOverview
}

// DefaultAuthorizationPolicy - The configuration settings of the Azure Active Directory default authorization policy.
type DefaultAuthorizationPolicy struct {
	// The configuration settings of the Azure Active Directory allowed applications.
	AllowedApplications []*string

	// The configuration settings of the Azure Active Directory allowed principals.
	AllowedPrincipals *AllowedPrincipals
}

// DefaultErrorResponse - App Service error response.
type DefaultErrorResponse struct {
	// READ-ONLY; Error model.
	Error *DefaultErrorResponseError
}

// DefaultErrorResponseError - Error model.
type DefaultErrorResponseError struct {
	Details []*DefaultErrorResponseErrorDetailsItem

	// READ-ONLY; Standardized string to programmatically identify the error.
	Code *string

	// READ-ONLY; More information to debug error.
	Innererror *string

	// READ-ONLY; Detailed error description and debugging information.
	Message *string

	// READ-ONLY; Detailed error description and debugging information.
	Target *string
}

// DefaultErrorResponseErrorDetailsItem - Detailed errors.
type DefaultErrorResponseErrorDetailsItem struct {
	// READ-ONLY; Standardized string to programmatically identify the error.
	Code *string

	// READ-ONLY; Detailed error description and debugging information.
	Message *string

	// READ-ONLY; Detailed error description and debugging information.
	Target *string
}

// DeletedAppRestoreRequest - Details about restoring a deleted app.
type DeletedAppRestoreRequest struct {
	// Kind of resource.
	Kind *string

	// DeletedAppRestoreRequest resource specific properties
	Properties *DeletedAppRestoreRequestProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// DeletedAppRestoreRequestProperties - DeletedAppRestoreRequest resource specific properties
type DeletedAppRestoreRequestProperties struct {
	// ARM resource ID of the deleted app. Example: /subscriptions/{subId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}
	DeletedSiteID *string

	// If true, deleted site configuration, in addition to content, will be restored.
	RecoverConfiguration *bool

	// Point in time to restore the deleted app from, formatted as a DateTime string. If unspecified, default value is the time
	// that the app was deleted.
	SnapshotTime *string

	// If true, the snapshot is retrieved from DRSecondary endpoint.
	UseDRSecondary *bool
}

// DeletedSite - A deleted app.
type DeletedSite struct {
	// Kind of resource.
	Kind *string

	// DeletedSite resource specific properties
	Properties *DeletedSiteProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// DeletedSiteProperties - DeletedSite resource specific properties
type DeletedSiteProperties struct {
	// READ-ONLY; Numeric id for the deleted site
	DeletedSiteID *int32

	// READ-ONLY; Name of the deleted site
	DeletedSiteName *string

	// READ-ONLY; Time in UTC when the app was deleted.
	DeletedTimestamp *string

	// READ-ONLY; Geo Region of the deleted site
	GeoRegionName *string

	// READ-ONLY; Kind of site that was deleted
	Kind *string

	// READ-ONLY; ResourceGroup that contained the deleted site
	ResourceGroup *string

	// READ-ONLY; Slot of the deleted site
	Slot *string

	// READ-ONLY; Subscription containing the deleted site
	Subscription *string
}

// DeletedWebAppCollection - Collection of deleted apps.
type DeletedWebAppCollection struct {
	// REQUIRED; Collection of resources.
	Value []*DeletedSite

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// Deployment - User credentials used for publishing activity.
type Deployment struct {
	// Kind of resource.
	Kind *string

	// Deployment resource specific properties
	Properties *DeploymentProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// DeploymentCollection - Collection of app deployments.
type DeploymentCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Deployment

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// DeploymentLocations - List of available locations (regions or App Service Environments) for deployment of App Service resources.
type DeploymentLocations struct {
	// Available App Service Environments with basic information.
	HostingEnvironmentDeploymentInfos []*HostingEnvironmentDeploymentInfo

	// Available App Service Environments with full descriptions of the environments.
	HostingEnvironments []*Environment

	// Available regions.
	Locations []*GeoRegion
}

// DeploymentProperties - Deployment resource specific properties
type DeploymentProperties struct {
	// True if deployment is currently active, false if completed and null if not started.
	Active *bool

	// Who authored the deployment.
	Author *string

	// Author email.
	AuthorEmail *string

	// Who performed the deployment.
	Deployer *string

	// Details on deployment.
	Details *string

	// End time.
	EndTime *time.Time

	// Details about deployment status.
	Message *string

	// Start time.
	StartTime *time.Time

	// Deployment status.
	Status *int32
}

// DetectorAbnormalTimePeriod - Class representing Abnormal Time Period detected.
type DetectorAbnormalTimePeriod struct {
	// End time of the correlated event
	EndTime *time.Time

	// Message describing the event
	Message *string

	// Downtime metadata
	MetaData [][]*NameValuePair

	// Represents the rank of the Detector
	Priority *float64

	// List of proposed solutions
	Solutions []*Solution

	// Represents the name of the Detector
	Source *string

	// Start time of the correlated event
	StartTime *time.Time

	// Represents the type of the Detector
	Type *IssueType
}

// DetectorDefinition - Class representing detector definition
type DetectorDefinition struct {
	// READ-ONLY; Description of the detector
	Description *string

	// READ-ONLY; Display name of the detector
	DisplayName *string

	// READ-ONLY; Flag representing whether detector is enabled or not.
	IsEnabled *bool

	// READ-ONLY; Detector Rank
	Rank *float64
}

// DetectorDefinitionResource - ARM resource for a detector definition
type DetectorDefinitionResource struct {
	// Kind of resource.
	Kind *string

	// Core resource properties
	Properties *DetectorDefinition

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// DetectorInfo - Definition of Detector
type DetectorInfo struct {
	// READ-ONLY; Analysis Types for which this detector should apply to.
	AnalysisType []*string

	// READ-ONLY; Author of the detector.
	Author *string

	// READ-ONLY; Problem category. This serves for organizing group for detectors.
	Category *string

	// READ-ONLY; Short description of the detector and its purpose.
	Description *string

	// READ-ONLY; Id of detector
	ID *string

	// READ-ONLY; Name of detector
	Name *string

	// READ-ONLY; Defines score of a detector to power ML based matching.
	Score *float32

	// READ-ONLY; List of Support Topics for which this detector is enabled.
	SupportTopicList []*SupportTopic

	// READ-ONLY; Whether this detector is an Analysis Detector or not.
	Type *DetectorType
}

// DetectorResponse - Class representing Response from Detector
type DetectorResponse struct {
	// Kind of resource.
	Kind *string

	// DetectorResponse resource specific properties
	Properties *DetectorResponseProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// DetectorResponseCollection - Collection of detector responses
type DetectorResponseCollection struct {
	// REQUIRED; Collection of resources.
	Value []*DetectorResponse

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// DetectorResponseProperties - DetectorResponse resource specific properties
type DetectorResponseProperties struct {
	// Additional configuration for different data providers to be used by the UI
	DataProvidersMetadata []*DataProviderMetadata

	// Data Set
	Dataset []*DiagnosticData

	// metadata for the detector
	Metadata *DetectorInfo

	// Indicates status of the most severe insight.
	Status *Status

	// Suggested utterances where the detector can be applicable.
	SuggestedUtterances *QueryUtterancesResults
}

// DiagnosticAnalysis - Class representing a diagnostic analysis done on an application
type DiagnosticAnalysis struct {
	// Kind of resource.
	Kind *string

	// DiagnosticAnalysis resource specific properties
	Properties *DiagnosticAnalysisProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// DiagnosticAnalysisCollection - Collection of Diagnostic Analyses
type DiagnosticAnalysisCollection struct {
	// REQUIRED; Collection of resources.
	Value []*AnalysisDefinition

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// DiagnosticAnalysisProperties - DiagnosticAnalysis resource specific properties
type DiagnosticAnalysisProperties struct {
	// List of time periods.
	AbnormalTimePeriods []*AbnormalTimePeriod

	// End time of the period
	EndTime *time.Time

	// Data by each detector for detectors that did not corelate
	NonCorrelatedDetectors []*DetectorDefinition

	// Data by each detector
	Payload []*AnalysisData

	// Start time of the period
	StartTime *time.Time
}

// DiagnosticCategory - Class representing detector definition
type DiagnosticCategory struct {
	// Kind of resource.
	Kind *string

	// DiagnosticCategory resource specific properties
	Properties *DiagnosticCategoryProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// DiagnosticCategoryCollection - Collection of Diagnostic Categories
type DiagnosticCategoryCollection struct {
	// REQUIRED; Collection of resources.
	Value []*DiagnosticCategory

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// DiagnosticCategoryProperties - DiagnosticCategory resource specific properties
type DiagnosticCategoryProperties struct {
	// READ-ONLY; Description of the diagnostic category
	Description *string
}

// DiagnosticData - Set of data with rendering instructions
type DiagnosticData struct {
	// Properties that describe how the table should be rendered
	RenderingProperties *Rendering

	// Data in table form
	Table *DataTableResponseObject
}

// DiagnosticDetectorCollection - Collection of Diagnostic Detectors
type DiagnosticDetectorCollection struct {
	// REQUIRED; Collection of resources.
	Value []*DetectorDefinitionResource

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// DiagnosticDetectorResponse - Class representing Response from Diagnostic Detectors
type DiagnosticDetectorResponse struct {
	// Kind of resource.
	Kind *string

	// DiagnosticDetectorResponse resource specific properties
	Properties *DiagnosticDetectorResponseProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// DiagnosticDetectorResponseProperties - DiagnosticDetectorResponse resource specific properties
type DiagnosticDetectorResponseProperties struct {
	// List of Correlated events found by the detector
	AbnormalTimePeriods []*DetectorAbnormalTimePeriod

	// Additional Data that detector wants to send.
	Data [][]*NameValuePair

	// Detector's definition
	DetectorDefinition *DetectorDefinition

	// End time of the period
	EndTime *time.Time

	// Flag representing Issue was detected.
	IssueDetected *bool

	// Metrics provided by the detector
	Metrics []*DiagnosticMetricSet

	// Meta Data
	ResponseMetaData *ResponseMetaData

	// Start time of the period
	StartTime *time.Time
}

// DiagnosticMetricSample - Class representing Diagnostic Metric
type DiagnosticMetricSample struct {
	// Whether the values are aggregates across all workers or not
	IsAggregated *bool

	// Maximum of the metric sampled during the time period
	Maximum *float64

	// Minimum of the metric sampled during the time period
	Minimum *float64

	// Role Instance. Null if this counter is not per instance This is returned and should be whichever instance name we desire
	// to be returned i.e. CPU and Memory return RDWORKERNAME (LargeDed…IN0) where
	// RDWORKERNAME is Machine name below and RoleInstance name in parenthesis
	RoleInstance *string

	// Time at which metric is measured
	Timestamp *time.Time

	// Total value of the metric. If multiple measurements are made this will have sum of all.
	Total *float64
}

// DiagnosticMetricSet - Class representing Diagnostic Metric information
type DiagnosticMetricSet struct {
	// End time of the period
	EndTime *time.Time

	// Name of the metric
	Name *string

	// Start time of the period
	StartTime *time.Time

	// Presented time grain. Supported grains at the moment are PT1M, PT1H, P1D
	TimeGrain *string

	// Metric's unit
	Unit *string

	// Collection of metric values for the selected period based on the {Microsoft.Web.Hosting.Administration.DiagnosticMetricSet.TimeGrain}
	Values []*DiagnosticMetricSample
}

// Dimension of a resource metric. For e.g. instance specific HTTP requests for a web app, where instance name is dimension
// of the metric HTTP request
type Dimension struct {
	DisplayName            *string
	InternalName           *string
	Name                   *string
	ToBeExportedForShoebox *bool
}

// Domain - Information about a domain.
type Domain struct {
	// REQUIRED; Resource Location.
	Location *string

	// Kind of resource.
	Kind *string

	// Domain resource specific properties
	Properties *DomainProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// DomainAvailabilityCheckResult - Domain availability check result.
type DomainAvailabilityCheckResult struct {
	// true if domain can be purchased using CreateDomain API; otherwise, false.
	Available *bool

	// Valid values are Regular domain: Azure will charge the full price of domain registration, SoftDeleted: Purchasing this
	// domain will simply restore it and this operation will not cost anything.
	DomainType *DomainType

	// Name of the domain.
	Name *string
}

// DomainCollection - Collection of domains.
type DomainCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Domain

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// DomainControlCenterSsoRequest - Single sign-on request information for domain management.
type DomainControlCenterSsoRequest struct {
	// READ-ONLY; Post parameter key.
	PostParameterKey *string

	// READ-ONLY; Post parameter value. Client should use 'application/x-www-form-urlencoded' encoding for this value.
	PostParameterValue *string

	// READ-ONLY; URL where the single sign-on request is to be made.
	URL *string
}

// DomainOwnershipIdentifier - Domain ownership Identifier.
type DomainOwnershipIdentifier struct {
	// Kind of resource.
	Kind *string

	// DomainOwnershipIdentifier resource specific properties
	Properties *DomainOwnershipIdentifierProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// DomainOwnershipIdentifierCollection - Collection of domain ownership identifiers.
type DomainOwnershipIdentifierCollection struct {
	// REQUIRED; Collection of resources.
	Value []*DomainOwnershipIdentifier

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// DomainOwnershipIdentifierProperties - DomainOwnershipIdentifier resource specific properties
type DomainOwnershipIdentifierProperties struct {
	// Ownership Id.
	OwnershipID *string
}

// DomainPatchResource - ARM resource for a domain.
type DomainPatchResource struct {
	// Kind of resource.
	Kind *string

	// DomainPatchResource resource specific properties
	Properties *DomainPatchResourceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// DomainPatchResourceProperties - DomainPatchResource resource specific properties
type DomainPatchResourceProperties struct {
	// REQUIRED; Legal agreement consent.
	Consent *DomainPurchaseConsent

	// REQUIRED; Administrative contact.
	ContactAdmin *Contact

	// REQUIRED; Billing contact.
	ContactBilling *Contact

	// REQUIRED; Registrant contact.
	ContactRegistrant *Contact

	// REQUIRED; Technical contact.
	ContactTech *Contact
	AuthCode    *string

	// true if the domain should be automatically renewed; otherwise, false.
	AutoRenew *bool

	// Current DNS type
	DNSType *DNSType

	// Azure DNS Zone to use
	DNSZoneID *string

	// true if domain privacy is enabled for this domain; otherwise, false.
	Privacy *bool

	// Target DNS type (would be used for migration)
	TargetDNSType *DNSType

	// READ-ONLY; Domain creation timestamp.
	CreatedTime *time.Time

	// READ-ONLY; Reasons why domain is not renewable.
	DomainNotRenewableReasons []*ResourceNotRenewableReason

	// READ-ONLY; Domain expiration timestamp.
	ExpirationTime *time.Time

	// READ-ONLY; Timestamp when the domain was renewed last time.
	LastRenewedTime *time.Time

	// READ-ONLY; All hostnames derived from the domain and assigned to Azure resources.
	ManagedHostNames []*HostName

	// READ-ONLY; Name servers.
	NameServers []*string

	// READ-ONLY; Domain provisioning state.
	ProvisioningState *ProvisioningState

	// READ-ONLY; true if Azure can assign this domain to App Service apps; otherwise, false. This value will be true if domain
	// registration status is active and it is hosted on name servers Azure has programmatic
	// access to.
	ReadyForDNSRecordManagement *bool

	// READ-ONLY; Domain registration status.
	RegistrationStatus *DomainStatus
}

// DomainProperties - Domain resource specific properties
type DomainProperties struct {
	// REQUIRED; Legal agreement consent.
	Consent *DomainPurchaseConsent

	// REQUIRED; Administrative contact.
	ContactAdmin *Contact

	// REQUIRED; Billing contact.
	ContactBilling *Contact

	// REQUIRED; Registrant contact.
	ContactRegistrant *Contact

	// REQUIRED; Technical contact.
	ContactTech *Contact
	AuthCode    *string

	// true if the domain should be automatically renewed; otherwise, false.
	AutoRenew *bool

	// Current DNS type
	DNSType *DNSType

	// Azure DNS Zone to use
	DNSZoneID *string

	// true if domain privacy is enabled for this domain; otherwise, false.
	Privacy *bool

	// Target DNS type (would be used for migration)
	TargetDNSType *DNSType

	// READ-ONLY; Domain creation timestamp.
	CreatedTime *time.Time

	// READ-ONLY; Reasons why domain is not renewable.
	DomainNotRenewableReasons []*ResourceNotRenewableReason

	// READ-ONLY; Domain expiration timestamp.
	ExpirationTime *time.Time

	// READ-ONLY; Timestamp when the domain was renewed last time.
	LastRenewedTime *time.Time

	// READ-ONLY; All hostnames derived from the domain and assigned to Azure resources.
	ManagedHostNames []*HostName

	// READ-ONLY; Name servers.
	NameServers []*string

	// READ-ONLY; Domain provisioning state.
	ProvisioningState *ProvisioningState

	// READ-ONLY; true if Azure can assign this domain to App Service apps; otherwise, false. This value will be true if domain
	// registration status is active and it is hosted on name servers Azure has programmatic
	// access to.
	ReadyForDNSRecordManagement *bool

	// READ-ONLY; Domain registration status.
	RegistrationStatus *DomainStatus
}

// DomainPurchaseConsent - Domain purchase consent object, representing acceptance of applicable legal agreements.
type DomainPurchaseConsent struct {
	// Timestamp when the agreements were accepted.
	AgreedAt *time.Time

	// Client IP address.
	AgreedBy *string

	// List of applicable legal agreement keys. This list can be retrieved using ListLegalAgreements API under TopLevelDomain
	// resource.
	AgreementKeys []*string
}

// DomainRecommendationSearchParameters - Domain recommendation search parameters.
type DomainRecommendationSearchParameters struct {
	// Keywords to be used for generating domain recommendations.
	Keywords *string

	// Maximum number of recommendations.
	MaxDomainRecommendations *int32
}

// EnabledConfig - Enabled configuration.
type EnabledConfig struct {
	// True if configuration is enabled, false if it is disabled and null if configuration is not set.
	Enabled *bool
}

// EndpointDependency - A domain name that a service is reached at, including details of the current connection status.
type EndpointDependency struct {
	// The domain name of the dependency.
	DomainName *string

	// The IP Addresses and Ports used when connecting to DomainName.
	EndpointDetails []*EndpointDetail
}

// EndpointDetail - Current TCP connectivity information from the App Service Environment to a single endpoint.
type EndpointDetail struct {
	// An IP Address that Domain Name currently resolves to.
	IPAddress *string

	// Whether it is possible to create a TCP connection from the App Service Environment to this IpAddress at this Port.
	IsAccessible *bool

	// The time in milliseconds it takes for a TCP connection to be created from the App Service Environment to this IpAddress
	// at this Port.
	Latency *float64

	// The port an endpoint is connected to.
	Port *int32
}

// Environment - Description of an App Service Environment.
type Environment struct {
	// REQUIRED; Description of the Virtual Network.
	VirtualNetwork *VirtualNetworkProfile

	// Custom settings for changing the behavior of the App Service Environment.
	ClusterSettings []*NameValuePair

	// Full view of the custom domain suffix configuration for ASEv3.
	CustomDNSSuffixConfiguration *CustomDNSSuffixConfiguration

	// DNS suffix of the App Service Environment.
	DNSSuffix *string

	// Dedicated Host Count
	DedicatedHostCount *int32

	// Scale factor for front-ends.
	FrontEndScaleFactor *int32

	// Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment.
	InternalLoadBalancingMode *LoadBalancingMode

	// Number of IP SSL addresses reserved for the App Service Environment.
	IpsslAddressCount *int32

	// Front-end VM size, e.g. "Medium", "Large".
	MultiSize *string

	// Full view of networking configuration for an ASE.
	NetworkingConfiguration *AseV3NetworkingConfiguration

	// Upgrade Preference
	UpgradePreference *UpgradePreference

	// User added ip ranges to whitelist on ASE db
	UserWhitelistedIPRanges []*string

	// Whether or not this App Service Environment is zone-redundant.
	ZoneRedundant *bool

	// READ-ONLY; Flag that displays whether an ASE has linux workers or not
	HasLinuxWorkers *bool

	// READ-ONLY; Maximum number of VMs in the App Service Environment.
	MaximumNumberOfMachines *int32

	// READ-ONLY; Number of front-end instances.
	MultiRoleCount *int32

	// READ-ONLY; Provisioning state of the App Service Environment.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Current status of the App Service Environment.
	Status *HostingEnvironmentStatus

	// READ-ONLY; true if the App Service Environment is suspended; otherwise, false. The environment can be suspended, e.g. when
	// the management endpoint is no longer available (most likely because NSG blocked the
	// incoming traffic).
	Suspended *bool

	// READ-ONLY; Whether an upgrade is available for this App Service Environment.
	UpgradeAvailability *UpgradeAvailability
}

// EnvironmentCollection - Collection of App Service Environments.
type EnvironmentCollection struct {
	// REQUIRED; Collection of resources.
	Value []*EnvironmentResource

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// EnvironmentPatchResource - ARM resource for a app service environment.
type EnvironmentPatchResource struct {
	// Kind of resource.
	Kind *string

	// Core resource properties
	Properties *Environment

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// EnvironmentResource - App Service Environment ARM resource.
type EnvironmentResource struct {
	// REQUIRED; Resource Location.
	Location *string

	// Kind of resource.
	Kind *string

	// Core resource properties
	Properties *Environment

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// EnvironmentVar - Container App container environment variable.
type EnvironmentVar struct {
	// Environment variable name.
	Name *string

	// Name of the Container App secret from which to pull the environment variable value.
	SecretRef *string

	// Non-secret environment variable value.
	Value *string
}

// ErrorEntity - Body of the error response returned from the API.
type ErrorEntity struct {
	// Basic error code.
	Code *string

	// Error Details.
	Details []*ErrorEntity

	// Type of error.
	ExtendedCode *string

	// Inner errors.
	InnerErrors []*ErrorEntity

	// Any details of the error.
	Message *string

	// Message template.
	MessageTemplate *string

	// Parameters for the template.
	Parameters []*string

	// The error target.
	Target *string
}

// ErrorInfo - The error info.
type ErrorInfo struct {
	// REQUIRED; The error code.
	Code *string
}

// ErrorProperties - Error properties indicate why the Logic service was not able to process the incoming request. The reason
// is provided in the error message.
type ErrorProperties struct {
	// Error code.
	Code *string

	// Error message indicating why the operation failed.
	Message *string
}

// ErrorResponse - Error response indicates Logic service is not able to process the incoming request. The error property
// contains the error details.
type ErrorResponse struct {
	// The error properties.
	Error *ErrorProperties
}

// Experiments - Routing rules in production experiments.
type Experiments struct {
	// List of ramp-up rules.
	RampUpRules []*RampUpRule
}

// Expression - The expression.
type Expression struct {
	// The azure resource error info.
	Error *AzureResourceErrorInfo

	// The sub expressions.
	Subexpressions []*Expression

	// The text.
	Text *string

	// Anything
	Value any
}

// ExpressionRoot - The expression root.
type ExpressionRoot struct {
	// The azure resource error info.
	Error *AzureResourceErrorInfo

	// The path.
	Path *string

	// The sub expressions.
	Subexpressions []*Expression

	// The text.
	Text *string

	// Anything
	Value any
}

// ExpressionTraces - The expression traces.
type ExpressionTraces struct {
	Inputs []*ExpressionRoot

	// The link used to get the next page of recommendations.
	NextLink *string

	// Anything
	Value any
}

// ExtendedLocation - Extended Location.
type ExtendedLocation struct {
	// Name of extended location.
	Name *string

	// READ-ONLY; Type of extended location.
	Type *string
}

// Facebook - The configuration settings of the Facebook provider.
type Facebook struct {
	// false if the Facebook provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool

	// The version of the Facebook api to be used while logging in.
	GraphAPIVersion *string

	// The configuration settings of the login flow.
	Login *LoginScopes

	// The configuration settings of the app registration for the Facebook provider.
	Registration *AppRegistration
}

// FileSystemApplicationLogsConfig - Application logs to file system configuration.
type FileSystemApplicationLogsConfig struct {
	// Log level.
	Level *LogLevel
}

// FileSystemHTTPLogsConfig - Http logs to file system configuration.
type FileSystemHTTPLogsConfig struct {
	// True if configuration is enabled, false if it is disabled and null if configuration is not set.
	Enabled *bool

	// Retention in days. Remove files older than X days. 0 or lower means no retention.
	RetentionInDays *int32

	// Maximum size in megabytes that http log files can use. When reached old log files will be removed to make space for new
	// ones. Value can range between 25 and 100.
	RetentionInMb *int32
}

// FileSystemTokenStore - The configuration settings of the storage of the tokens if a file system is used.
type FileSystemTokenStore struct {
	// The directory in which the tokens will be stored.
	Directory *string
}

// FlowAccessControlConfiguration - The access control configuration.
type FlowAccessControlConfiguration struct {
	// The access control configuration for workflow actions.
	Actions *FlowAccessControlConfigurationPolicy

	// The access control configuration for accessing workflow run contents.
	Contents *FlowAccessControlConfigurationPolicy

	// The access control configuration for invoking workflow triggers.
	Triggers *FlowAccessControlConfigurationPolicy

	// The access control configuration for workflow management.
	WorkflowManagement *FlowAccessControlConfigurationPolicy
}

// FlowAccessControlConfigurationPolicy - The access control configuration policy.
type FlowAccessControlConfigurationPolicy struct {
	// The allowed caller IP address ranges.
	AllowedCallerIPAddresses []*IPAddressRange

	// The authentication policies for workflow.
	OpenAuthenticationPolicies *OpenAuthenticationAccessPolicies
}

// FlowEndpoints - The flow endpoints configuration.
type FlowEndpoints struct {
	// The access endpoint ip address.
	AccessEndpointIPAddresses []*IPAddress

	// The outgoing ip address.
	OutgoingIPAddresses []*IPAddress
}

// FlowEndpointsConfiguration - The endpoints configuration.
type FlowEndpointsConfiguration struct {
	// The connector endpoints.
	Connector *FlowEndpoints

	// The workflow endpoints.
	Workflow *FlowEndpoints
}

// ForwardProxy - The configuration settings of a forward proxy used to make the requests.
type ForwardProxy struct {
	// The convention used to determine the url of the request made.
	Convention *ForwardProxyConvention

	// The name of the header containing the host of the request.
	CustomHostHeaderName *string

	// The name of the header containing the scheme of the request.
	CustomProtoHeaderName *string
}

type FrontEndConfiguration struct {
	Kind *FrontEndServiceType
}

// FunctionAppMajorVersion - Function App stack major version.
type FunctionAppMajorVersion struct {
	// READ-ONLY; Function App stack major version (display only).
	DisplayText *string

	// READ-ONLY; Minor versions associated with the major version.
	MinorVersions []*FunctionAppMinorVersion

	// READ-ONLY; Function App stack major version name.
	Value *string
}

// FunctionAppMinorVersion - Function App stack minor version.
type FunctionAppMinorVersion struct {
	// READ-ONLY; Function App stack (display only).
	DisplayText *string

	// READ-ONLY; Settings associated with the minor version.
	StackSettings *FunctionAppRuntimes

	// READ-ONLY; Function App stack name.
	Value *string
}

// FunctionAppRuntimeSettings - Function App runtime settings.
type FunctionAppRuntimeSettings struct {
	// READ-ONLY; Application Insights settings associated with the minor version.
	AppInsightsSettings *AppInsightsWebAppStackSettings

	// READ-ONLY; Application settings associated with the minor version.
	AppSettingsDictionary map[string]*string

	// READ-ONLY; End-of-life date for the minor version.
	EndOfLifeDate *time.Time

	// READ-ONLY; GitHub Actions settings associated with the minor version.
	GitHubActionSettings *GitHubActionWebAppStackSettings

	// READ-ONLY; true if the stack version is auto-updated; otherwise, false.
	IsAutoUpdate *bool

	// READ-ONLY; true if the minor version the default; otherwise, false.
	IsDefault *bool

	// READ-ONLY; true if the stack is deprecated; otherwise, false.
	IsDeprecated *bool

	// READ-ONLY; true if the minor version is early-access; otherwise, false.
	IsEarlyAccess *bool

	// READ-ONLY; true if the stack should be hidden; otherwise, false.
	IsHidden *bool

	// READ-ONLY; true if the stack is in preview; otherwise, false.
	IsPreview *bool

	// READ-ONLY; true if remote debugging is supported for the stack; otherwise, false.
	RemoteDebuggingSupported *bool

	// READ-ONLY; Function App stack minor version (runtime only).
	RuntimeVersion *string

	// READ-ONLY; Configuration settings associated with the minor version.
	SiteConfigPropertiesDictionary *SiteConfigPropertiesDictionary

	// READ-ONLY; List of supported Functions extension versions.
	SupportedFunctionsExtensionVersions []*string
}

// FunctionAppRuntimes - Function App stack runtimes.
type FunctionAppRuntimes struct {
	// READ-ONLY; Linux-specific settings associated with the minor version.
	LinuxRuntimeSettings *FunctionAppRuntimeSettings

	// READ-ONLY; Windows-specific settings associated with the minor version.
	WindowsRuntimeSettings *FunctionAppRuntimeSettings
}

// FunctionAppStack - Function App Stack.
type FunctionAppStack struct {
	// Kind of resource.
	Kind *string

	// FunctionAppStack resource specific properties
	Properties *FunctionAppStackProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Function App stack location.
	Location *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// FunctionAppStackCollection - Collection of Function app Stacks
type FunctionAppStackCollection struct {
	// REQUIRED; Collection of resources.
	Value []*FunctionAppStack

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// FunctionAppStackProperties - FunctionAppStack resource specific properties
type FunctionAppStackProperties struct {
	// READ-ONLY; Function App stack (display only).
	DisplayText *string

	// READ-ONLY; List of major versions available.
	MajorVersions []*FunctionAppMajorVersion

	// READ-ONLY; Function App stack preferred OS.
	PreferredOs *StackPreferredOs

	// READ-ONLY; Function App stack name.
	Value *string
}

// FunctionEnvelope - Function information.
type FunctionEnvelope struct {
	// Kind of resource.
	Kind *string

	// FunctionEnvelope resource specific properties
	Properties *FunctionEnvelopeProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// FunctionEnvelopeCollection - Collection of Kudu function information elements.
type FunctionEnvelopeCollection struct {
	// REQUIRED; Collection of resources.
	Value []*FunctionEnvelope

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// FunctionEnvelopeProperties - FunctionEnvelope resource specific properties
type FunctionEnvelopeProperties struct {
	// Config information.
	Config any

	// Config URI.
	ConfigHref *string

	// File list.
	Files map[string]*string

	// Function App ID.
	FunctionAppID *string

	// Function URI.
	Href *string

	// The invocation URL
	InvokeURLTemplate *string

	// Gets or sets a value indicating whether the function is disabled
	IsDisabled *bool

	// The function language
	Language *string

	// Script URI.
	ScriptHref *string

	// Script root path URI.
	ScriptRootPathHref *string

	// Secrets file URI.
	SecretsFileHref *string

	// Test data used when testing via the Azure Portal.
	TestData *string

	// Test data URI.
	TestDataHref *string
}

// FunctionSecrets - Function secrets.
type FunctionSecrets struct {
	// Secret key.
	Key *string

	// Trigger URL.
	TriggerURL *string
}

// GeoRegion - Geographical region.
type GeoRegion struct {
	// Kind of resource.
	Kind *string

	// GeoRegion resource specific properties
	Properties *GeoRegionProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// GeoRegionCollection - Collection of geographical regions.
type GeoRegionCollection struct {
	// REQUIRED; Collection of resources.
	Value []*GeoRegion

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// GeoRegionProperties - GeoRegion resource specific properties
type GeoRegionProperties struct {
	// READ-ONLY; Region description.
	Description *string

	// READ-ONLY; Display name for region.
	DisplayName *string

	// READ-ONLY; Display name for region.
	OrgDomain *string
}

// GitHub - The configuration settings of the GitHub provider.
type GitHub struct {
	// false if the GitHub provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool

	// The configuration settings of the login flow.
	Login *LoginScopes

	// The configuration settings of the app registration for the GitHub provider.
	Registration *ClientRegistration
}

// GitHubActionCodeConfiguration - The GitHub action code configuration.
type GitHubActionCodeConfiguration struct {
	// Runtime stack is used to determine the workflow file content for code base apps.
	RuntimeStack *string

	// Runtime version is used to determine what build version to set in the workflow file.
	RuntimeVersion *string
}

// GitHubActionConfiguration - The GitHub action configuration.
type GitHubActionConfiguration struct {
	// GitHub Action code configuration.
	CodeConfiguration *GitHubActionCodeConfiguration

	// GitHub Action container configuration.
	ContainerConfiguration *GitHubActionContainerConfiguration

	// Workflow option to determine whether the workflow file should be generated and written to the repository.
	GenerateWorkflowFile *bool

	// This will help determine the workflow configuration to select.
	IsLinux *bool
}

// GitHubActionContainerConfiguration - The GitHub action container configuration.
type GitHubActionContainerConfiguration struct {
	// The image name for the build.
	ImageName *string

	// The password used to upload the image to the container registry.
	Password *string

	// The server URL for the container registry where the build will be hosted.
	ServerURL *string

	// The username used to upload the image to the container registry.
	Username *string
}

// GitHubActionWebAppStackSettings - GitHub Actions Web App stack settings.
type GitHubActionWebAppStackSettings struct {
	// READ-ONLY; true if GitHub Actions is supported for the stack; otherwise, false.
	IsSupported *bool

	// READ-ONLY; The minor version that is supported for GitHub Actions.
	SupportedVersion *string
}

// GithubToken - Github access token for Appservice CLI github integration.
type GithubToken struct {
	// Github access token for Appservice CLI github integration
	AccessToken *string

	// Error message if unable to get token
	ErrorMessage *string

	// True if valid github token received, False otherwise
	GotToken *bool

	// Scope of the github access token
	Scope *string

	// token type
	TokenType *string
}

// GithubTokenRequest - Appservice Github token request content.
type GithubTokenRequest struct {
	// REQUIRED; Code string to exchange for Github Access token
	Code *string

	// REQUIRED; State string used for verification.
	State *string
}

// GlobalCsmSKUDescription - A Global SKU Description.
type GlobalCsmSKUDescription struct {
	// Capabilities of the SKU, e.g., is traffic manager enabled?
	Capabilities []*Capability

	// Min, max, and default scale values of the SKU.
	Capacity *SKUCapacity

	// Family code of the resource SKU.
	Family *string

	// Locations of the SKU.
	Locations []*string

	// Name of the resource SKU.
	Name *string

	// Size specifier of the resource SKU.
	Size *string

	// Service Tier of the resource SKU.
	Tier *string
}

// GlobalValidation - The configuration settings that determines the validation flow of users using App Service Authentication/Authorization.
type GlobalValidation struct {
	// The paths for which unauthenticated flow would not be redirected to the login page.
	ExcludedPaths []*string

	// The default authentication provider to use when multiple providers are configured. This setting is only needed if multiple
	// providers are configured and the unauthenticated client action is set to
	// "RedirectToLoginPage".
	RedirectToProvider *string

	// true if the authentication flow is required any request is made; otherwise, false.
	RequireAuthentication *bool

	// The action to take when an unauthenticated client attempts to access the app.
	UnauthenticatedClientAction *UnauthenticatedClientActionV2
}

// Google - The configuration settings of the Google provider.
type Google struct {
	// false if the Google provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool

	// The configuration settings of the login flow.
	Login *LoginScopes

	// The configuration settings of the app registration for the Google provider.
	Registration *ClientRegistration

	// The configuration settings of the Azure Active Directory token validation flow.
	Validation *AllowedAudiencesValidation
}

// HTTPLogsConfig - Http logs configuration.
type HTTPLogsConfig struct {
	// Http logs to azure blob storage configuration.
	AzureBlobStorage *AzureBlobStorageHTTPLogsConfig

	// Http logs to file system configuration.
	FileSystem *FileSystemHTTPLogsConfig
}

// HTTPScaleRule - Container App container Custom scaling rule.
type HTTPScaleRule struct {
	// Authentication secrets for the custom scale rule.
	Auth []*ScaleRuleAuth

	// Metadata properties to describe http scale rule.
	Metadata map[string]*string
}

// HTTPSettings - The configuration settings of the HTTP requests for authentication and authorization requests made against
// App Service Authentication/Authorization.
type HTTPSettings struct {
	// The configuration settings of a forward proxy used to make the requests.
	ForwardProxy *ForwardProxy

	// false if the authentication/authorization responses not having the HTTPS scheme are permissible; otherwise, true.
	RequireHTTPS *bool

	// The configuration settings of the paths HTTP requests.
	Routes *HTTPSettingsRoutes
}

// HTTPSettingsRoutes - The configuration settings of the paths HTTP requests.
type HTTPSettingsRoutes struct {
	// The prefix that should precede all the authentication/authorization paths.
	APIPrefix *string
}

// HandlerMapping - The IIS handler mappings used to define which handler processes HTTP requests with certain extension.
// For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php
// extension.
type HandlerMapping struct {
	// Command-line arguments to be passed to the script processor.
	Arguments *string

	// Requests with this extension will be handled using the specified FastCGI application.
	Extension *string

	// The absolute path to the FastCGI application.
	ScriptProcessor *string
}

// HostKeys - Functions host level keys.
type HostKeys struct {
	// Host level function keys.
	FunctionKeys map[string]*string

	// Secret key.
	MasterKey *string

	// System keys.
	SystemKeys map[string]*string
}

// HostName - Details of a hostname derived from a domain.
type HostName struct {
	// Name of the Azure resource the hostname is assigned to. If it is assigned to a Traffic Manager then it will be the Traffic
	// Manager name otherwise it will be the app name.
	AzureResourceName *string

	// Type of the Azure resource the hostname is assigned to.
	AzureResourceType *AzureResourceType

	// Type of the DNS record.
	CustomHostNameDNSRecordType *CustomHostNameDNSRecordType

	// Type of the hostname.
	HostNameType *HostNameType

	// Name of the hostname.
	Name *string

	// List of apps the hostname is assigned to. This list will have more than one app only if the hostname is pointing to a Traffic
	// Manager.
	SiteNames []*string
}

// HostNameBinding - A hostname binding object.
type HostNameBinding struct {
	// Kind of resource.
	Kind *string

	// HostNameBinding resource specific properties
	Properties *HostNameBindingProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// HostNameBindingCollection - Collection of hostname bindings.
type HostNameBindingCollection struct {
	// REQUIRED; Collection of resources.
	Value []*HostNameBinding

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// HostNameBindingProperties - HostNameBinding resource specific properties
type HostNameBindingProperties struct {
	// Azure resource name.
	AzureResourceName *string

	// Azure resource type.
	AzureResourceType *AzureResourceType

	// Custom DNS record type.
	CustomHostNameDNSRecordType *CustomHostNameDNSRecordType

	// Fully qualified ARM domain resource URI.
	DomainID *string

	// Hostname type.
	HostNameType *HostNameType

	// SSL type
	SSLState *SSLState

	// App Service app name.
	SiteName *string

	// SSL certificate thumbprint
	Thumbprint *string

	// READ-ONLY; Virtual IP address assigned to the hostname if IP based SSL is enabled.
	VirtualIP *string
}

// HostNameSSLState - SSL-enabled hostname.
type HostNameSSLState struct {
	// Indicates whether the hostname is a standard or repository hostname.
	HostType *HostType

	// Hostname.
	Name *string

	// SSL type.
	SSLState *SSLState

	// SSL certificate thumbprint.
	Thumbprint *string

	// Set to true to update existing hostname.
	ToUpdate *bool

	// Virtual IP address assigned to the hostname if IP based SSL is enabled.
	VirtualIP *string
}

// HostingEnvironmentDeploymentInfo - Information needed to create resources on an App Service Environment.
type HostingEnvironmentDeploymentInfo struct {
	// Location of the App Service Environment.
	Location *string

	// Name of the App Service Environment.
	Name *string
}

// HostingEnvironmentDiagnostics - Diagnostics for an App Service Environment.
type HostingEnvironmentDiagnostics struct {
	// Diagnostics output.
	DiagnosticsOutput *string

	// Name/identifier of the diagnostics.
	Name *string
}

// HostingEnvironmentProfile - Specification for an App Service Environment to use for this resource.
type HostingEnvironmentProfile struct {
	// Resource ID of the App Service Environment.
	ID *string

	// READ-ONLY; Name of the App Service Environment.
	Name *string

	// READ-ONLY; Resource type of the App Service Environment.
	Type *string
}

// HybridConnection - Hybrid Connection contract. This is used to configure a Hybrid Connection.
type HybridConnection struct {
	// Kind of resource.
	Kind *string

	// HybridConnection resource specific properties
	Properties *HybridConnectionProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// HybridConnectionCollection - Collection of hostname bindings.
type HybridConnectionCollection struct {
	// REQUIRED; Collection of resources.
	Value []*HybridConnection

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// HybridConnectionKey - Hybrid Connection key contract. This has the send key name and value for a Hybrid Connection.
type HybridConnectionKey struct {
	// Kind of resource.
	Kind *string

	// HybridConnectionKey resource specific properties
	Properties *HybridConnectionKeyProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// HybridConnectionKeyProperties - HybridConnectionKey resource specific properties
type HybridConnectionKeyProperties struct {
	// READ-ONLY; The name of the send key.
	SendKeyName *string

	// READ-ONLY; The value of the send key.
	SendKeyValue *string
}

// HybridConnectionLimits - Hybrid Connection limits contract. This is used to return the plan limits of Hybrid Connections.
type HybridConnectionLimits struct {
	// Kind of resource.
	Kind *string

	// HybridConnectionLimits resource specific properties
	Properties *HybridConnectionLimitsProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// HybridConnectionLimitsProperties - HybridConnectionLimits resource specific properties
type HybridConnectionLimitsProperties struct {
	// READ-ONLY; The current number of Hybrid Connections.
	Current *int32

	// READ-ONLY; The maximum number of Hybrid Connections allowed.
	Maximum *int32
}

// HybridConnectionProperties - HybridConnection resource specific properties
type HybridConnectionProperties struct {
	// The hostname of the endpoint.
	Hostname *string

	// The port of the endpoint.
	Port *int32

	// The ARM URI to the Service Bus relay.
	RelayArmURI *string

	// The name of the Service Bus relay.
	RelayName *string

	// The name of the Service Bus key which has Send permissions. This is used to authenticate to Service Bus.
	SendKeyName *string

	// The value of the Service Bus key. This is used to authenticate to Service Bus. In ARM this key will not be returned normally,
	// use the POST /listKeys API instead.
	SendKeyValue *string

	// The name of the Service Bus namespace.
	ServiceBusNamespace *string

	// The suffix for the service bus endpoint. By default this is .servicebus.windows.net
	ServiceBusSuffix *string
}

// IPAddress - The ip address.
type IPAddress struct {
	// The address.
	Address *string
}

// IPAddressRange - The ip address range.
type IPAddressRange struct {
	// The IP address range.
	AddressRange *string
}

// IPSecurityRestriction - IP security restriction on an app.
type IPSecurityRestriction struct {
	// Allow or Deny access for this IP range.
	Action *string

	// IP restriction rule description.
	Description *string

	// IP restriction rule headers. X-Forwarded-Host (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host#Examples).
	// The matching logic is ..
	// * If the property is null or empty (default), all hosts(or lack of) are allowed.
	// * A value is compared using ordinal-ignore-case (excluding port number).
	// * Subdomain wildcards are permitted but don't match the root domain. For example, *.contoso.com matches the subdomain foo.contoso.com
	// but not the root domain contoso.com or multi-level
	// foo.bar.contoso.com
	// * Unicode host names are allowed but are converted to Punycode for matching.
	// X-Forwarded-For (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For#Examples). The matching logic
	// is ..
	// * If the property is null or empty (default), any forwarded-for chains (or lack of) are allowed.
	// * If any address (excluding port number) in the chain (comma separated) matches the CIDR defined by the property.
	// X-Azure-FDID and X-FD-HealthProbe. The matching logic is exact match.
	Headers map[string][]*string

	// IP address the security restriction is valid for. It can be in form of pure ipv4 address (required SubnetMask property)
	// or CIDR notation such as ipv4/mask (leading bit match). For CIDR, SubnetMask
	// property must not be specified.
	IPAddress *string

	// IP restriction rule name.
	Name *string

	// Priority of IP restriction rule.
	Priority *int32

	// Subnet mask for the range of IP addresses the restriction is valid for.
	SubnetMask *string

	// (internal) Subnet traffic tag
	SubnetTrafficTag *int32

	// Defines what this IP filter will be used for. This is to support IP filtering on proxies.
	Tag *IPFilterTag

	// Virtual network resource id
	VnetSubnetResourceID *string

	// (internal) Vnet traffic tag
	VnetTrafficTag *int32
}

// Identifier - A domain specific resource identifier.
type Identifier struct {
	// Kind of resource.
	Kind *string

	// Identifier resource specific properties
	Properties *IdentifierProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// IdentifierCollection - Collection of identifiers.
type IdentifierCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Identifier

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// IdentifierProperties - Identifier resource specific properties
type IdentifierProperties struct {
	// String representation of the identity.
	Value *string
}

// IdentityProviders - The configuration settings of each of the identity providers used to configure App Service Authentication/Authorization.
type IdentityProviders struct {
	// The configuration settings of the Apple provider.
	Apple *Apple

	// The configuration settings of the Azure Active directory provider.
	AzureActiveDirectory *AzureActiveDirectory

	// The configuration settings of the Azure Static Web Apps provider.
	AzureStaticWebApps *AzureStaticWebApps

	// The map of the name of the alias of each custom Open ID Connect provider to the configuration settings of the custom Open
	// ID Connect provider.
	CustomOpenIDConnectProviders map[string]*CustomOpenIDConnectProvider

	// The configuration settings of the Facebook provider.
	Facebook *Facebook

	// The configuration settings of the GitHub provider.
	GitHub *GitHub

	// The configuration settings of the Google provider.
	Google *Google

	// The configuration settings of the legacy Microsoft Account provider.
	LegacyMicrosoftAccount *LegacyMicrosoftAccount

	// The configuration settings of the Twitter provider.
	Twitter *Twitter
}

// InboundEnvironmentEndpoint - The IP Addresses and Ports that require inbound network access to and within the subnet of
// the App Service Environment.
type InboundEnvironmentEndpoint struct {
	// Short text describing the purpose of the network traffic.
	Description *string

	// The IP addresses that network traffic will originate from in cidr notation.
	Endpoints []*string

	// The ports that network traffic will arrive to the App Service Environment at.
	Ports []*string
}

// InboundEnvironmentEndpointCollection - Collection of Inbound Environment Endpoints
type InboundEnvironmentEndpointCollection struct {
	// REQUIRED; Collection of resources.
	Value []*InboundEnvironmentEndpoint

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// Ingress - Container App Ingress configuration.
type Ingress struct {
	// Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS
	// connections
	AllowInsecure *bool

	// Bool indicating if app exposes an external http endpoint
	External *bool

	// Target Port in containers for traffic from ingress
	TargetPort *int32
	Traffic    []*TrafficWeight

	// Ingress transport protocol
	Transport *IngressTransportMethod

	// READ-ONLY; Hostname.
	Fqdn *string
}

// JSONSchema - The JSON schema.
type JSONSchema struct {
	// The JSON content.
	Content *string

	// The JSON title.
	Title *string
}

// JwtClaimChecks - The configuration settings of the checks that should be made while validating the JWT Claims.
type JwtClaimChecks struct {
	// The list of the allowed client applications.
	AllowedClientApplications []*string

	// The list of the allowed groups.
	AllowedGroups []*string
}

// KeyInfo - Function key info.
type KeyInfo struct {
	// Key name
	Name *string

	// Key value
	Value *string
}

type KeyValuePairStringObject struct {
	// READ-ONLY
	Key *string

	// READ-ONLY; Anything
	Value any
}

// KubeEnvironment - A Kubernetes cluster specialized for web workloads by Azure App Service
type KubeEnvironment struct {
	// REQUIRED; Resource Location.
	Location *string

	// Extended Location.
	ExtendedLocation *ExtendedLocation

	// Kind of resource.
	Kind *string

	// KubeEnvironment resource specific properties
	Properties *KubeEnvironmentProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// KubeEnvironmentCollection - Collection of Kubernetes Environments
type KubeEnvironmentCollection struct {
	// REQUIRED; Collection of resources.
	Value []*KubeEnvironment

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// KubeEnvironmentPatchResource - ARM resource for a KubeEnvironment when patching
type KubeEnvironmentPatchResource struct {
	// Kind of resource.
	Kind *string

	// KubeEnvironmentPatchResource resource specific properties
	Properties *KubeEnvironmentPatchResourceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// KubeEnvironmentPatchResourceProperties - KubeEnvironmentPatchResource resource specific properties
type KubeEnvironmentPatchResourceProperties struct {
	AksResourceID *string

	// Cluster configuration which enables the log daemon to export app logs to a destination. Currently only "log-analytics"
	// is supported
	AppLogsConfiguration *AppLogsConfiguration

	// Cluster configuration which determines the ARC cluster components types. Eg: Choosing between BuildService kind, FrontEnd
	// Service ArtifactsStorageType etc.
	ArcConfiguration *ArcConfiguration

	// Cluster configuration for Container Apps Environments to configure Dapr Instrumentation Key and VNET Configuration
	ContainerAppsConfiguration *ContainerAppsConfiguration

	// Only visible within Vnet/Subnet
	InternalLoadBalancerEnabled *bool

	// Static IP of the KubeEnvironment
	StaticIP *string

	// READ-ONLY; Default Domain Name for the cluster
	DefaultDomain *string

	// READ-ONLY; Any errors that occurred during deployment or deployment validation
	DeploymentErrors *string

	// READ-ONLY; Provisioning state of the Kubernetes Environment.
	ProvisioningState *KubeEnvironmentProvisioningState
}

// KubeEnvironmentProfile - Specification for a Kubernetes Environment to use for this resource.
type KubeEnvironmentProfile struct {
	// Resource ID of the Kubernetes Environment.
	ID *string

	// READ-ONLY; Name of the Kubernetes Environment.
	Name *string

	// READ-ONLY; Resource type of the Kubernetes Environment.
	Type *string
}

// KubeEnvironmentProperties - KubeEnvironment resource specific properties
type KubeEnvironmentProperties struct {
	AksResourceID *string

	// Cluster configuration which enables the log daemon to export app logs to a destination. Currently only "log-analytics"
	// is supported
	AppLogsConfiguration *AppLogsConfiguration

	// Cluster configuration which determines the ARC cluster components types. Eg: Choosing between BuildService kind, FrontEnd
	// Service ArtifactsStorageType etc.
	ArcConfiguration *ArcConfiguration

	// Cluster configuration for Container Apps Environments to configure Dapr Instrumentation Key and VNET Configuration
	ContainerAppsConfiguration *ContainerAppsConfiguration

	// Type of Kubernetes Environment. Only supported for Container App Environments with value as Managed
	EnvironmentType *string

	// Only visible within Vnet/Subnet
	InternalLoadBalancerEnabled *bool

	// Static IP of the KubeEnvironment
	StaticIP *string

	// READ-ONLY; Default Domain Name for the cluster
	DefaultDomain *string

	// READ-ONLY; Any errors that occurred during deployment or deployment validation
	DeploymentErrors *string

	// READ-ONLY; Provisioning state of the Kubernetes Environment.
	ProvisioningState *KubeEnvironmentProvisioningState
}

// LegacyMicrosoftAccount - The configuration settings of the legacy Microsoft Account provider.
type LegacyMicrosoftAccount struct {
	// false if the legacy Microsoft Account provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool

	// The configuration settings of the login flow.
	Login *LoginScopes

	// The configuration settings of the app registration for the legacy Microsoft Account provider.
	Registration *ClientRegistration

	// The configuration settings of the legacy Microsoft Account provider token validation flow.
	Validation *AllowedAudiencesValidation
}

// LinuxJavaContainerSettings - Linux Java Container settings.
type LinuxJavaContainerSettings struct {
	// READ-ONLY; End-of-life date for the minor version.
	EndOfLifeDate *time.Time

	// READ-ONLY; true if the stack version is auto-updated; otherwise, false.
	IsAutoUpdate *bool

	// READ-ONLY; true if the stack is deprecated; otherwise, false.
	IsDeprecated *bool

	// READ-ONLY; true if the minor version is early-access; otherwise, false.
	IsEarlyAccess *bool

	// READ-ONLY; true if the stack should be hidden; otherwise, false.
	IsHidden *bool

	// READ-ONLY; true if the stack is in preview; otherwise, false.
	IsPreview *bool

	// READ-ONLY; Java 11 version (runtime only).
	Java11Runtime *string

	// READ-ONLY; Java 8 version (runtime only).
	Java8Runtime *string
}

// LocalizableString - Localizable string object containing the name and a localized value.
type LocalizableString struct {
	// Localized name.
	LocalizedValue *string

	// Non-localized name.
	Value *string
}

type LogAnalyticsConfiguration struct {
	CustomerID *string
	SharedKey  *string
}

// LogSpecification - Log Definition of a single resource metric.
type LogSpecification struct {
	BlobDuration     *string
	DisplayName      *string
	LogFilterPattern *string
	Name             *string
}

// Login - The configuration settings of the login flow of users using App Service Authentication/Authorization.
type Login struct {
	// External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part
	// of the URL is ignored. This is an advanced setting typically only needed by
	// Windows Store application backends. Note that URLs within the current domain are always implicitly allowed.
	AllowedExternalRedirectUrls []*string

	// The configuration settings of the session cookie's expiration.
	CookieExpiration *CookieExpiration

	// The configuration settings of the nonce used in the login flow.
	Nonce *Nonce

	// true if the fragments from the request are preserved after the login request is made; otherwise, false.
	PreserveURLFragmentsForLogins *bool

	// The routes that specify the endpoints used for login and logout requests.
	Routes *LoginRoutes

	// The configuration settings of the token store.
	TokenStore *TokenStore
}

// LoginRoutes - The routes that specify the endpoints used for login and logout requests.
type LoginRoutes struct {
	// The endpoint at which a logout request should be made.
	LogoutEndpoint *string
}

// LoginScopes - The configuration settings of the login flow, including the scopes that should be requested.
type LoginScopes struct {
	// A list of the scopes that should be requested while authenticating.
	Scopes []*string
}

// MSDeploy ARM PUT information
type MSDeploy struct {
	// Kind of resource.
	Kind *string

	// Core resource properties
	Properties *MSDeployCore

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// MSDeployCore - MSDeploy ARM PUT core information
type MSDeployCore struct {
	// Sets the AppOffline rule while the MSDeploy operation executes. Setting is false by default.
	AppOffline *bool

	// SQL Connection String
	ConnectionString *string

	// Database Type
	DbType *string

	// Package URI
	PackageURI *string

	// MSDeploy Parameters. Must not be set if SetParametersXmlFileUri is used.
	SetParameters map[string]*string

	// URI of MSDeploy Parameters file. Must not be set if SetParameters is used.
	SetParametersXMLFileURI *string

	// Controls whether the MSDeploy operation skips the AppData directory. If set to true, the existing AppData directory on
	// the destination will not be deleted, and any App_Data directory in the source
	// will be ignored. Setting is false by default.
	SkipAppData *bool
}

// MSDeployLog - MSDeploy log
type MSDeployLog struct {
	// Kind of resource.
	Kind *string

	// MSDeployLog resource specific properties
	Properties *MSDeployLogProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// MSDeployLogEntry - MSDeploy log entry
type MSDeployLogEntry struct {
	// READ-ONLY; Log entry message
	Message *string

	// READ-ONLY; Timestamp of log entry
	Time *time.Time

	// READ-ONLY; Log entry type
	Type *MSDeployLogEntryType
}

// MSDeployLogProperties - MSDeployLog resource specific properties
type MSDeployLogProperties struct {
	// READ-ONLY; List of log entry messages
	Entries []*MSDeployLogEntry
}

// MSDeployStatus - MSDeploy ARM response
type MSDeployStatus struct {
	// Kind of resource.
	Kind *string

	// MSDeployStatus resource specific properties
	Properties *MSDeployStatusProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// MSDeployStatusProperties - MSDeployStatus resource specific properties
type MSDeployStatusProperties struct {
	// READ-ONLY; Whether the deployment operation has completed
	Complete *bool

	// READ-ONLY; Username of deployer
	Deployer *string

	// READ-ONLY; End time of deploy operation
	EndTime *time.Time

	// READ-ONLY; Provisioning state
	ProvisioningState *MSDeployProvisioningState

	// READ-ONLY; Start time of deploy operation
	StartTime *time.Time
}

// ManagedServiceIdentity - Managed service identity.
type ManagedServiceIdentity struct {
	// Type of managed service identity.
	Type *ManagedServiceIdentityType

	// The list of user assigned identities associated with the resource. The user identity dictionary key references will be
	// ARM resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; Principal Id of managed service identity.
	PrincipalID *string

	// READ-ONLY; Tenant of managed service identity.
	TenantID *string
}

// MetricAvailability - Retention policy of a resource metric.
type MetricAvailability struct {
	BlobDuration *string
	TimeGrain    *string
}

// MetricSpecification - Definition of a single resource metric.
type MetricSpecification struct {
	AggregationType                  *string
	Availabilities                   []*MetricAvailability
	Category                         *string
	Dimensions                       []*Dimension
	DisplayDescription               *string
	DisplayName                      *string
	EnableRegionalMdmAccount         *bool
	FillGapWithZero                  *bool
	IsInternal                       *bool
	MetricFilterPattern              *string
	Name                             *string
	SourceMdmAccount                 *string
	SourceMdmNamespace               *string
	SupportedAggregationTypes        []*string
	SupportedTimeGrainTypes          []*string
	SupportsInstanceLevelAggregation *bool
	Unit                             *string
}

// MigrateMySQLRequest - MySQL migration request.
type MigrateMySQLRequest struct {
	// Kind of resource.
	Kind *string

	// MigrateMySqlRequest resource specific properties
	Properties *MigrateMySQLRequestProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// MigrateMySQLRequestProperties - MigrateMySqlRequest resource specific properties
type MigrateMySQLRequestProperties struct {
	// REQUIRED; Connection string to the remote MySQL database.
	ConnectionString *string

	// REQUIRED; The type of migration operation to be done
	MigrationType *MySQLMigrationType
}

// MigrateMySQLStatus - MySQL migration status.
type MigrateMySQLStatus struct {
	// Kind of resource.
	Kind *string

	// MigrateMySqlStatus resource specific properties
	Properties *MigrateMySQLStatusProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// MigrateMySQLStatusProperties - MigrateMySqlStatus resource specific properties
type MigrateMySQLStatusProperties struct {
	// READ-ONLY; True if the web app has in app MySql enabled
	LocalMySQLEnabled *bool

	// READ-ONLY; Status of the migration task.
	MigrationOperationStatus *OperationStatus

	// READ-ONLY; Operation ID for the migration task.
	OperationID *string
}

// NameIdentifier - Identifies an object.
type NameIdentifier struct {
	// Name of the object.
	Name *string
}

// NameIdentifierCollection - Collection of domain name identifiers.
type NameIdentifierCollection struct {
	// REQUIRED; Collection of resources.
	Value []*NameIdentifier

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// NameValuePair - Name value pair.
type NameValuePair struct {
	// Pair name.
	Name *string

	// Pair value.
	Value *string
}

// NetworkFeatures - Full view of network features for an app (presently VNET integration and Hybrid Connections).
type NetworkFeatures struct {
	// Kind of resource.
	Kind *string

	// NetworkFeatures resource specific properties
	Properties *NetworkFeaturesProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// NetworkFeaturesProperties - NetworkFeatures resource specific properties
type NetworkFeaturesProperties struct {
	// READ-ONLY; The Hybrid Connections summary view.
	HybridConnections []*RelayServiceConnectionEntity

	// READ-ONLY; The Hybrid Connection V2 (Service Bus) view.
	HybridConnectionsV2 []*HybridConnection

	// READ-ONLY; The Virtual Network summary view.
	VirtualNetworkConnection *VnetInfo

	// READ-ONLY; The Virtual Network name.
	VirtualNetworkName *string
}

// NetworkTrace - Network trace
type NetworkTrace struct {
	// Detailed message of a network trace operation, e.g. error message in case of failure.
	Message *string

	// Local file path for the captured network trace file.
	Path *string

	// Current status of the network trace operation, same as Operation.Status (InProgress/Succeeded/Failed).
	Status *string
}

// Nonce - The configuration settings of the nonce used in the login flow.
type Nonce struct {
	// The time after the request is made when the nonce should expire.
	NonceExpirationInterval *string

	// false if the nonce should not be validated while completing the login flow; otherwise, true.
	ValidateNonce *bool
}

// OpenAuthenticationAccessPolicies - AuthenticationPolicy of type Open.
type OpenAuthenticationAccessPolicies struct {
	// Open authentication policies.
	Policies map[string]*OpenAuthenticationAccessPolicy
}

// OpenAuthenticationAccessPolicy - Open authentication access policy defined by user.
type OpenAuthenticationAccessPolicy struct {
	// The access policy claims.
	Claims []*OpenAuthenticationPolicyClaim

	// Type of provider for OAuth.
	Type *OpenAuthenticationProviderType
}

// OpenAuthenticationPolicyClaim - Open authentication policy claim.
type OpenAuthenticationPolicyClaim struct {
	// The name of the claim.
	Name *string

	// The value of the claim.
	Value *string
}

// OpenIDConnectClientCredential - The authentication client credentials of the custom Open ID Connect provider.
type OpenIDConnectClientCredential struct {
	// The app setting that contains the client secret for the custom Open ID Connect provider.
	ClientSecretSettingName *string

	// The method that should be used to authenticate the user.
	Method *string
}

// OpenIDConnectConfig - The configuration settings of the endpoints used for the custom Open ID Connect provider.
type OpenIDConnectConfig struct {
	// The endpoint to be used to make an authorization request.
	AuthorizationEndpoint *string

	// The endpoint that provides the keys necessary to validate the token.
	CertificationURI *string

	// The endpoint that issues the token.
	Issuer *string

	// The endpoint to be used to request a token.
	TokenEndpoint *string

	// The endpoint that contains all the configuration endpoints for the provider.
	WellKnownOpenIDConfiguration *string
}

// OpenIDConnectLogin - The configuration settings of the login flow of the custom Open ID Connect provider.
type OpenIDConnectLogin struct {
	// The name of the claim that contains the users name.
	NameClaimType *string

	// A list of the scopes that should be requested while authenticating.
	Scopes []*string
}

// OpenIDConnectRegistration - The configuration settings of the app registration for the custom Open ID Connect provider.
type OpenIDConnectRegistration struct {
	// The authentication credentials of the custom Open ID Connect provider.
	ClientCredential *OpenIDConnectClientCredential

	// The client id of the custom Open ID Connect provider.
	ClientID *string

	// The configuration settings of the endpoints used for the custom Open ID Connect provider.
	OpenIDConnectConfiguration *OpenIDConnectConfig
}

// Operation - An operation on a resource.
type Operation struct {
	// Time when operation has started.
	CreatedTime *time.Time

	// Any errors associate with the operation.
	Errors []*ErrorEntity

	// Time when operation will expire.
	ExpirationTime *time.Time

	// Applicable only for stamp operation ids.
	GeoMasterOperationID *string

	// Operation ID.
	ID *string

	// Time when operation has been updated.
	ModifiedTime *time.Time

	// Operation name.
	Name *string

	// The current status of the operation.
	Status *OperationStatus
}

// OperationResult - The operation result definition.
type OperationResult struct {
	// The workflow scope repetition code.
	Code *string

	// The correlation properties.
	Correlation *RunActionCorrelation

	// The end time of the workflow scope repetition.
	EndTime *time.Time

	// Anything
	Error          any
	IterationCount *int32

	// Gets the retry histories.
	RetryHistory []*RetryHistory

	// The start time of the workflow scope repetition.
	StartTime *time.Time

	// The status of the workflow scope repetition.
	Status *WorkflowStatus

	// READ-ONLY; Gets the inputs.
	Inputs any

	// READ-ONLY; Gets the link to inputs.
	InputsLink *ContentLink

	// READ-ONLY; Gets the outputs.
	Outputs any

	// READ-ONLY; Gets the link to outputs.
	OutputsLink *ContentLink

	// READ-ONLY; Gets the tracked properties.
	TrackedProperties any

	// READ-ONLY; Gets the tracking id.
	TrackingID *string
}

// OperationResultProperties - The run operation result properties.
type OperationResultProperties struct {
	// The workflow scope repetition code.
	Code *string

	// The correlation properties.
	Correlation *RunActionCorrelation

	// The end time of the workflow scope repetition.
	EndTime *time.Time

	// Anything
	Error any

	// The start time of the workflow scope repetition.
	StartTime *time.Time

	// The status of the workflow scope repetition.
	Status *WorkflowStatus
}

// OutboundEnvironmentEndpoint - Endpoints accessed for a common purpose that the App Service Environment requires outbound
// network access to.
type OutboundEnvironmentEndpoint struct {
	// The type of service accessed by the App Service Environment, e.g., Azure Storage, Azure SQL Database, and Azure Active
	// Directory.
	Category *string

	// The endpoints that the App Service Environment reaches the service at.
	Endpoints []*EndpointDependency
}

// OutboundEnvironmentEndpointCollection - Collection of Outbound Environment Endpoints
type OutboundEnvironmentEndpointCollection struct {
	// REQUIRED; Collection of resources.
	Value []*OutboundEnvironmentEndpoint

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// PerfMonCounterCollection - Collection of performance monitor counters.
type PerfMonCounterCollection struct {
	// REQUIRED; Collection of resources.
	Value []*PerfMonResponse

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// PerfMonResponse - Performance monitor API response.
type PerfMonResponse struct {
	// The response code.
	Code *string

	// The performance monitor counters.
	Data *PerfMonSet

	// The message.
	Message *string
}

// PerfMonSample - Performance monitor sample in a set.
type PerfMonSample struct {
	// Name of the server on which the measurement is made.
	InstanceName *string

	// Point in time for which counter was measured.
	Time *time.Time

	// Value of counter at a certain time.
	Value *float64
}

// PerfMonSet - Metric information.
type PerfMonSet struct {
	// End time of the period.
	EndTime *time.Time

	// Unique key name of the counter.
	Name *string

	// Start time of the period.
	StartTime *time.Time

	// Presented time grain.
	TimeGrain *string

	// Collection of workers that are active during this time.
	Values []*PerfMonSample
}

// Plan - App Service plan.
type Plan struct {
	// REQUIRED; Resource Location.
	Location *string

	// Extended Location.
	ExtendedLocation *ExtendedLocation

	// Kind of resource.
	Kind *string

	// AppServicePlan resource specific properties
	Properties *PlanProperties

	// Description of a SKU for a scalable resource.
	SKU *SKUDescription

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PlanCollection - Collection of App Service plans.
type PlanCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Plan

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// PlanPatchResource - ARM resource for a app service plan.
type PlanPatchResource struct {
	// Kind of resource.
	Kind *string

	// AppServicePlanPatchResource resource specific properties
	Properties *PlanPatchResourceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PlanPatchResourceProperties - AppServicePlanPatchResource resource specific properties
type PlanPatchResourceProperties struct {
	// ServerFarm supports ElasticScale. Apps in this plan will scale as if the ServerFarm was ElasticPremium sku
	ElasticScaleEnabled *bool

	// The time when the server farm free offer expires.
	FreeOfferExpirationTime *time.Time

	// Specification for the App Service Environment to use for the App Service plan.
	HostingEnvironmentProfile *HostingEnvironmentProfile

	// If Hyper-V container app service plan true, false otherwise.
	HyperV *bool

	// If true, this App Service Plan owns spot instances.
	IsSpot *bool

	// Obsolete: If Hyper-V container app service plan true, false otherwise.
	IsXenon *bool

	// Specification for the Kubernetes Environment to use for the App Service plan.
	KubeEnvironmentProfile *KubeEnvironmentProfile

	// Maximum number of total workers allowed for this ElasticScaleEnabled App Service Plan
	MaximumElasticWorkerCount *int32

	// If true, apps assigned to this App Service plan can be scaled independently. If false, apps assigned to this App Service
	// plan will scale to all instances of the plan.
	PerSiteScaling *bool

	// If Linux app service plan true, false otherwise.
	Reserved *bool

	// The time when the server farm expires. Valid only if it is a spot server farm.
	SpotExpirationTime *time.Time

	// Scaling worker count.
	TargetWorkerCount *int32

	// Scaling worker size ID.
	TargetWorkerSizeID *int32

	// Target worker tier assigned to the App Service plan.
	WorkerTierName *string

	// If true, this App Service Plan will perform availability zone balancing. If false, this App Service Plan will not perform
	// availability zone balancing.
	ZoneRedundant *bool

	// READ-ONLY; Geographical location for the App Service plan.
	GeoRegion *string

	// READ-ONLY; Maximum number of instances that can be assigned to this App Service plan.
	MaximumNumberOfWorkers *int32

	// READ-ONLY; Number of apps assigned to this App Service plan.
	NumberOfSites *int32

	// READ-ONLY; The number of instances that are assigned to this App Service plan.
	NumberOfWorkers *int32

	// READ-ONLY; Provisioning state of the App Service Plan.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Resource group of the App Service plan.
	ResourceGroup *string

	// READ-ONLY; App Service plan status.
	Status *StatusOptions

	// READ-ONLY; App Service plan subscription.
	Subscription *string
}

// PlanProperties - AppServicePlan resource specific properties
type PlanProperties struct {
	// ServerFarm supports ElasticScale. Apps in this plan will scale as if the ServerFarm was ElasticPremium sku
	ElasticScaleEnabled *bool

	// The time when the server farm free offer expires.
	FreeOfferExpirationTime *time.Time

	// Specification for the App Service Environment to use for the App Service plan.
	HostingEnvironmentProfile *HostingEnvironmentProfile

	// If Hyper-V container app service plan true, false otherwise.
	HyperV *bool

	// If true, this App Service Plan owns spot instances.
	IsSpot *bool

	// Obsolete: If Hyper-V container app service plan true, false otherwise.
	IsXenon *bool

	// Specification for the Kubernetes Environment to use for the App Service plan.
	KubeEnvironmentProfile *KubeEnvironmentProfile

	// Maximum number of total workers allowed for this ElasticScaleEnabled App Service Plan
	MaximumElasticWorkerCount *int32

	// If true, apps assigned to this App Service plan can be scaled independently. If false, apps assigned to this App Service
	// plan will scale to all instances of the plan.
	PerSiteScaling *bool

	// If Linux app service plan true, false otherwise.
	Reserved *bool

	// The time when the server farm expires. Valid only if it is a spot server farm.
	SpotExpirationTime *time.Time

	// Scaling worker count.
	TargetWorkerCount *int32

	// Scaling worker size ID.
	TargetWorkerSizeID *int32

	// Target worker tier assigned to the App Service plan.
	WorkerTierName *string

	// If true, this App Service Plan will perform availability zone balancing. If false, this App Service Plan will not perform
	// availability zone balancing.
	ZoneRedundant *bool

	// READ-ONLY; Geographical location for the App Service plan.
	GeoRegion *string

	// READ-ONLY; Maximum number of instances that can be assigned to this App Service plan.
	MaximumNumberOfWorkers *int32

	// READ-ONLY; Number of apps assigned to this App Service plan.
	NumberOfSites *int32

	// READ-ONLY; The number of instances that are assigned to this App Service plan.
	NumberOfWorkers *int32

	// READ-ONLY; Provisioning state of the App Service Plan.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Resource group of the App Service plan.
	ResourceGroup *string

	// READ-ONLY; App Service plan status.
	Status *StatusOptions

	// READ-ONLY; App Service plan subscription.
	Subscription *string
}

// PremierAddOn - Premier add-on.
type PremierAddOn struct {
	// REQUIRED; Resource Location.
	Location *string

	// Kind of resource.
	Kind *string

	// PremierAddOn resource specific properties
	Properties *PremierAddOnProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PremierAddOnOffer - Premier add-on offer.
type PremierAddOnOffer struct {
	// Kind of resource.
	Kind *string

	// PremierAddOnOffer resource specific properties
	Properties *PremierAddOnOfferProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PremierAddOnOfferCollection - Collection of premier add-on offers.
type PremierAddOnOfferCollection struct {
	// REQUIRED; Collection of resources.
	Value []*PremierAddOnOffer

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// PremierAddOnOfferProperties - PremierAddOnOffer resource specific properties
type PremierAddOnOfferProperties struct {
	// Legal terms URL.
	LegalTermsURL *string

	// Marketplace offer.
	MarketplaceOffer *string

	// Marketplace publisher.
	MarketplacePublisher *string

	// Privacy policy URL.
	PrivacyPolicyURL *string

	// Premier add on offer Product.
	Product *string

	// true if promotion code is required; otherwise, false.
	PromoCodeRequired *bool

	// Premier add on offer Quota.
	Quota *int32

	// Premier add on SKU.
	SKU *string

	// Premier add on offer Vendor.
	Vendor *string

	// App Service plans this offer is restricted to.
	WebHostingPlanRestrictions *AppServicePlanRestrictions
}

// PremierAddOnPatchResource - ARM resource for a PremierAddOn.
type PremierAddOnPatchResource struct {
	// Kind of resource.
	Kind *string

	// PremierAddOnPatchResource resource specific properties
	Properties *PremierAddOnPatchResourceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PremierAddOnPatchResourceProperties - PremierAddOnPatchResource resource specific properties
type PremierAddOnPatchResourceProperties struct {
	// Premier add on Marketplace offer.
	MarketplaceOffer *string

	// Premier add on Marketplace publisher.
	MarketplacePublisher *string

	// Premier add on Product.
	Product *string

	// Premier add on SKU.
	SKU *string

	// Premier add on Vendor.
	Vendor *string
}

// PremierAddOnProperties - PremierAddOn resource specific properties
type PremierAddOnProperties struct {
	// Premier add on Marketplace offer.
	MarketplaceOffer *string

	// Premier add on Marketplace publisher.
	MarketplacePublisher *string

	// Premier add on Product.
	Product *string

	// Premier add on SKU.
	SKU *string

	// Premier add on Vendor.
	Vendor *string
}

// PrivateAccess - Description of the parameters of Private Access for a Web Site.
type PrivateAccess struct {
	// Kind of resource.
	Kind *string

	// PrivateAccess resource specific properties
	Properties *PrivateAccessProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PrivateAccessProperties - PrivateAccess resource specific properties
type PrivateAccessProperties struct {
	// Whether private access is enabled or not.
	Enabled *bool

	// The Virtual Networks (and subnets) allowed to access the site privately.
	VirtualNetworks []*PrivateAccessVirtualNetwork
}

// PrivateAccessSubnet - Description of a Virtual Network subnet that is useable for private site access.
type PrivateAccessSubnet struct {
	// The key (ID) of the subnet.
	Key *int32

	// The name of the subnet.
	Name *string
}

// PrivateAccessVirtualNetwork - Description of a Virtual Network that is useable for private site access.
type PrivateAccessVirtualNetwork struct {
	// The key (ID) of the Virtual Network.
	Key *int32

	// The name of the Virtual Network.
	Name *string

	// The ARM uri of the Virtual Network
	ResourceID *string

	// A List of subnets that access is allowed to on this Virtual Network. An empty array (but not null) is interpreted to mean
	// that all subnets are allowed within this Virtual Network.
	Subnets []*PrivateAccessSubnet
}

type PrivateEndpointConnectionCollection struct {
	// REQUIRED; Collection of resources.
	Value []*RemotePrivateEndpointConnectionARMResource

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// PrivateLinkConnectionApprovalRequest - A request to approve or reject a private endpoint connection
type PrivateLinkConnectionApprovalRequest struct {
	// The state of a private link connection
	PrivateLinkServiceConnectionState *PrivateLinkConnectionState
}

// PrivateLinkConnectionApprovalRequestResource - Private Endpoint Connection Approval ARM resource.
type PrivateLinkConnectionApprovalRequestResource struct {
	// Kind of resource.
	Kind *string

	// Core resource properties
	Properties *PrivateLinkConnectionApprovalRequest

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PrivateLinkConnectionState - The state of a private link connection
type PrivateLinkConnectionState struct {
	// ActionsRequired for a private link connection
	ActionsRequired *string

	// Description of a private link connection
	Description *string

	// Status of a private link connection
	Status *string
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// REQUIRED
	ID *string

	// REQUIRED; Name of a private link resource
	Name *string

	// REQUIRED; Properties of a private link resource
	Properties *PrivateLinkResourceProperties

	// REQUIRED
	Type *string
}

// PrivateLinkResourceProperties - Properties of a private link resource
type PrivateLinkResourceProperties struct {
	// READ-ONLY; GroupId of a private link resource
	GroupID *string

	// READ-ONLY; RequiredMembers of a private link resource
	RequiredMembers []*string

	// READ-ONLY; RequiredZoneNames of a private link resource
	RequiredZoneNames []*string
}

// PrivateLinkResourcesWrapper - Wrapper for a collection of private link resources
type PrivateLinkResourcesWrapper struct {
	// REQUIRED
	Value []*PrivateLinkResource
}

// ProcessInfo - Process Information.
type ProcessInfo struct {
	// Kind of resource.
	Kind *string

	// ProcessInfo resource specific properties
	Properties *ProcessInfoProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ProcessInfoCollection - Collection of Kudu process information elements.
type ProcessInfoCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ProcessInfo

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// ProcessInfoProperties - ProcessInfo resource specific properties
type ProcessInfoProperties struct {
	// Child process list.
	Children []*string

	// Command line.
	CommandLine *string

	// Deployment name.
	DeploymentName *string

	// Description of process.
	Description *string

	// List of environment variables.
	EnvironmentVariables map[string]*string

	// File name of this process.
	FileName *string

	// Handle count.
	HandleCount *int32

	// HRef URI.
	Href *string

	// IIS Profile timeout (seconds).
	IisProfileTimeoutInSeconds *float64

	// Is the IIS Profile running?
	IsIisProfileRunning *bool

	// Is profile running?
	IsProfileRunning *bool

	// Is this the SCM site?
	IsScmSite *bool

	// Is this a Web Job?
	IsWebjob *bool

	// Minidump URI.
	Minidump *string

	// Module count.
	ModuleCount *int32

	// List of modules.
	Modules []*ProcessModuleInfo

	// Non-paged system memory.
	NonPagedSystemMemory *int64

	// List of open files.
	OpenFileHandles []*string

	// Paged memory.
	PagedMemory *int64

	// Paged system memory.
	PagedSystemMemory *int64

	// Parent process.
	Parent *string

	// Peak paged memory.
	PeakPagedMemory *int64

	// Peak virtual memory usage.
	PeakVirtualMemory *int64

	// Peak working set.
	PeakWorkingSet *int64

	// Private memory size.
	PrivateMemory *int64

	// Privileged CPU time.
	PrivilegedCPUTime *string

	// Start time.
	StartTime *time.Time

	// Thread count.
	ThreadCount *int32

	// Thread list.
	Threads []*ProcessThreadInfo

	// Time stamp.
	TimeStamp *time.Time

	// Total CPU time.
	TotalCPUTime *string

	// User CPU time.
	UserCPUTime *string

	// User name.
	UserName *string

	// Virtual memory size.
	VirtualMemory *int64

	// Working set.
	WorkingSet *int64

	// READ-ONLY; ARM Identifier for deployment.
	Identifier *int32
}

// ProcessModuleInfo - Process Module Information.
type ProcessModuleInfo struct {
	// Kind of resource.
	Kind *string

	// ProcessModuleInfo resource specific properties
	Properties *ProcessModuleInfoProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ProcessModuleInfoCollection - Collection of Kudu thread information elements.
type ProcessModuleInfoCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ProcessModuleInfo

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// ProcessModuleInfoProperties - ProcessModuleInfo resource specific properties
type ProcessModuleInfoProperties struct {
	// Base address. Used as module identifier in ARM resource URI.
	BaseAddress *string

	// File description.
	FileDescription *string

	// File name.
	FileName *string

	// File path.
	FilePath *string

	// File version.
	FileVersion *string

	// HRef URI.
	Href *string

	// Is debug?
	IsDebug *bool

	// Module language (locale).
	Language *string

	// Module memory size.
	ModuleMemorySize *int32

	// Product name.
	Product *string

	// Product version.
	ProductVersion *string
}

// ProcessThreadInfo - Process Thread Information.
type ProcessThreadInfo struct {
	// Kind of resource.
	Kind *string

	// ProcessThreadInfo resource specific properties
	Properties *ProcessThreadInfoProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ProcessThreadInfoCollection - Collection of Kudu thread information elements.
type ProcessThreadInfoCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ProcessThreadInfo

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// ProcessThreadInfoProperties - ProcessThreadInfo resource specific properties
type ProcessThreadInfoProperties struct {
	// Base priority.
	BasePriority *int32

	// Current thread priority.
	CurrentPriority *int32

	// HRef URI.
	Href *string

	// Thread priority level.
	PriorityLevel *string

	// Process URI.
	Process *string

	// Start address.
	StartAddress *string

	// Start time.
	StartTime *time.Time

	// Thread state.
	State *string

	// Total processor time.
	TotalProcessorTime *string

	// User processor time.
	UserProcessorTime *string

	// Wait reason.
	WaitReason *string

	// READ-ONLY; Site extension ID.
	Identifier *int32
}

// ProxyOnlyResource - Azure proxy only resource. This resource is not tracked by Azure Resource Manager.
type ProxyOnlyResource struct {
	// Kind of resource.
	Kind *string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PublicCertificate - Public certificate object
type PublicCertificate struct {
	// Kind of resource.
	Kind *string

	// PublicCertificate resource specific properties
	Properties *PublicCertificateProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PublicCertificateCollection - Collection of public certificates
type PublicCertificateCollection struct {
	// REQUIRED; Collection of resources.
	Value []*PublicCertificate

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// PublicCertificateProperties - PublicCertificate resource specific properties
type PublicCertificateProperties struct {
	// Public Certificate byte array
	Blob []byte

	// Public Certificate Location
	PublicCertificateLocation *PublicCertificateLocation

	// READ-ONLY; Certificate Thumbprint
	Thumbprint *string
}

// PublishingCredentialsPoliciesCollection - Publishing Credentials Policies entity collection ARM resource.
type PublishingCredentialsPoliciesCollection struct {
	// REQUIRED; Collection of resources.
	Value []*CsmPublishingCredentialsPoliciesEntity

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// PushSettings - Push settings for the App.
type PushSettings struct {
	// Kind of resource.
	Kind *string

	// PushSettings resource specific properties
	Properties *PushSettingsProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PushSettingsProperties - PushSettings resource specific properties
type PushSettingsProperties struct {
	// REQUIRED; Gets or sets a flag indicating whether the Push endpoint is enabled.
	IsPushEnabled *bool

	// Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration
	// endpoint.
	DynamicTagsJSON *string

	// Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint.
	TagWhitelistJSON *string

	// Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration
	// endpoint. Tags can consist of alphanumeric characters and the following: '_',
	// '@', '#', '.', ':', '-'. Validation should be performed at the PushRequestHandler.
	TagsRequiringAuth *string
}

// QueryUtterancesResult - Result for utterances query.
type QueryUtterancesResult struct {
	// A sample utterance.
	SampleUtterance *SampleUtterance

	// Score of a sample utterance.
	Score *float32
}

// QueryUtterancesResults - Suggested utterances where the detector can be applicable
type QueryUtterancesResults struct {
	// Search Query.
	Query *string

	// Array of utterance results for search query.
	Results []*QueryUtterancesResult
}

// QueueScaleRule - Container App container Azure Queue based scaling rule.
type QueueScaleRule struct {
	// Authentication secrets for the queue scale rule.
	Auth []*ScaleRuleAuth

	// Queue length.
	QueueLength *int32

	// Queue name.
	QueueName *string
}

// RampUpRule - Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or to gradually
// change routing % based on performance.
type RampUpRule struct {
	// Hostname of a slot to which the traffic will be redirected if decided to. E.g. myapp-stage.azurewebsites.net.
	ActionHostName *string

	// Custom decision algorithm can be provided in TiPCallback site extension which URL can be specified. See TiPCallback site
	// extension for the scaffold and contracts.
	// https://www.siteextensions.net/packages/TiPCallback/
	ChangeDecisionCallbackURL *string

	// Specifies interval in minutes to reevaluate ReroutePercentage.
	ChangeIntervalInMinutes *int32

	// In auto ramp up scenario this is the step to add/remove from ReroutePercentage until it reaches \nMinReroutePercentage
	// orMaxReroutePercentage. Site metrics are checked every N minutes specified in
	// ChangeIntervalInMinutes.\nCustom decision algorithm can be provided in TiPCallback site extension which URL can be specified
	// in ChangeDecisionCallbackUrl.
	ChangeStep *float64

	// Specifies upper boundary below which ReroutePercentage will stay.
	MaxReroutePercentage *float64

	// Specifies lower boundary above which ReroutePercentage will stay.
	MinReroutePercentage *float64

	// Name of the routing rule. The recommended name would be to point to the slot which will receive the traffic in the experiment.
	Name *string

	// Percentage of the traffic which will be redirected to ActionHostName.
	ReroutePercentage *float64
}

// Recommendation - Represents a recommendation result generated by the recommendation engine.
type Recommendation struct {
	// Kind of resource.
	Kind *string

	// Recommendation resource specific properties
	Properties *RecommendationProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RecommendationCollection - Collection of recommendations.
type RecommendationCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Recommendation

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// RecommendationProperties - Recommendation resource specific properties
type RecommendationProperties struct {
	// Name of action recommended by this object.
	ActionName *string

	// Deep link to a blade on the portal.
	BladeName *string

	// List of channels that this recommendation can apply.
	Channels *Channels

	// Timestamp when this instance was created.
	CreationTime *time.Time

	// UI friendly name of the rule (may not be unique).
	DisplayName *string

	// True if this recommendation is still valid (i.e. "actionable"). False if it is invalid.
	Enabled *int32

	// The end time in UTC of a range that the recommendation refers to.
	EndTime *time.Time

	// Extension name of the portal if exists.
	ExtensionName *string

	// Forward link to an external document associated with the rule.
	ForwardLink *string

	// True if this is associated with a dynamically added rule
	IsDynamic *bool

	// Level indicating how critical this recommendation can impact.
	Level *NotificationLevel

	// Recommendation text.
	Message *string

	// When to notify this recommendation next in UTC. Null means that this will never be notified anymore.
	NextNotificationTime *time.Time

	// Date and time in UTC when this notification expires.
	NotificationExpirationTime *time.Time

	// Last timestamp in UTC this instance was actually notified. Null means that this recommendation hasn't been notified yet.
	NotifiedTime *time.Time

	// A GUID value that each recommendation object is associated with.
	RecommendationID *string

	// Full ARM resource ID string that this recommendation object is associated with.
	ResourceID *string

	// Name of a resource type this recommendation applies, e.g. Subscription, ServerFarm, Site.
	ResourceScope *ResourceScopeType

	// Unique name of the rule.
	RuleName *string

	// A metric value measured by the rule.
	Score *float64

	// The beginning time in UTC of a range that the recommendation refers to.
	StartTime *time.Time

	// The list of states of this recommendation. If it's null then it should be considered "Active".
	States []*string

	// READ-ONLY; The list of category tags that this recommendation belongs to.
	CategoryTags []*string
}

// RecommendationRule - Represents a recommendation rule that the recommendation engine can perform.
type RecommendationRule struct {
	// Kind of resource.
	Kind *string

	// RecommendationRule resource specific properties
	Properties *RecommendationRuleProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RecommendationRuleProperties - RecommendationRule resource specific properties
type RecommendationRuleProperties struct {
	// Name of action that is recommended by this rule in string.
	ActionName *string

	// Deep link to a blade on the portal. Applicable to dynamic rule only.
	BladeName *string

	// List of available channels that this rule applies.
	Channels *Channels

	// Localized detailed description of the rule.
	Description *string

	// UI friendly name of the rule.
	DisplayName *string

	// Extension name of the portal if exists. Applicable to dynamic rule only.
	ExtensionName *string

	// Forward link to an external document associated with the rule. Applicable to dynamic rule only.
	ForwardLink *string

	// True if this is associated with a dynamically added rule
	IsDynamic *bool

	// Level of impact indicating how critical this rule is.
	Level *NotificationLevel

	// Localized name of the rule (Good for UI).
	Message *string

	// Recommendation ID of an associated recommendation object tied to the rule, if exists. If such an object doesn't exist,
	// it is set to null.
	RecommendationID *string

	// Unique name of the rule.
	RecommendationName *string

	// READ-ONLY; The list of category tags that this recommendation rule belongs to.
	CategoryTags []*string
}

// RecurrenceSchedule - The recurrence schedule.
type RecurrenceSchedule struct {
	// The hours.
	Hours []*int32

	// The minutes.
	Minutes []*int32

	// The month days.
	MonthDays []*int32

	// The monthly occurrences.
	MonthlyOccurrences []*RecurrenceScheduleOccurrence

	// The days of the week.
	WeekDays []*DaysOfWeek
}

// RecurrenceScheduleOccurrence - The recurrence schedule occurrence.
type RecurrenceScheduleOccurrence struct {
	// The day of the week.
	Day *DayOfWeek

	// The occurrence.
	Occurrence *int32
}

// RegenerateActionParameter - The access key regenerate action content.
type RegenerateActionParameter struct {
	// The key type.
	KeyType *KeyType
}

// RegistryCredentials - Container App Private Registry
type RegistryCredentials struct {
	// The name of the Secret that contains the registry login password
	PasswordSecretRef *string

	// Container Registry Server
	Server *string

	// Container Registry Username
	Username *string
}

// ReissueCertificateOrderRequest - Class representing certificate reissue request.
type ReissueCertificateOrderRequest struct {
	// Kind of resource.
	Kind *string

	// ReissueCertificateOrderRequest resource specific properties
	Properties *ReissueCertificateOrderRequestProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ReissueCertificateOrderRequestProperties - ReissueCertificateOrderRequest resource specific properties
type ReissueCertificateOrderRequestProperties struct {
	// Csr to be used for re-key operation.
	Csr *string

	// Delay in hours to revoke existing certificate after the new certificate is issued.
	DelayExistingRevokeInHours *int32

	// Should we change the ASC type (from managed private key to external private key and vice versa).
	IsPrivateKeyExternal *bool

	// Certificate Key Size.
	KeySize *int32
}

// RelayServiceConnectionEntity - Hybrid Connection for an App Service app.
type RelayServiceConnectionEntity struct {
	// Kind of resource.
	Kind *string

	// RelayServiceConnectionEntity resource specific properties
	Properties *RelayServiceConnectionEntityProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RelayServiceConnectionEntityProperties - RelayServiceConnectionEntity resource specific properties
type RelayServiceConnectionEntityProperties struct {
	BiztalkURI               *string
	EntityConnectionString   *string
	EntityName               *string
	Hostname                 *string
	Port                     *int32
	ResourceConnectionString *string
	ResourceType             *string
}

// RemotePrivateEndpointConnection - A remote private endpoint connection
type RemotePrivateEndpointConnection struct {
	// Kind of resource.
	Kind *string

	// RemotePrivateEndpointConnection resource specific properties
	Properties *RemotePrivateEndpointConnectionProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RemotePrivateEndpointConnectionARMResource - Remote Private Endpoint Connection ARM resource.
type RemotePrivateEndpointConnectionARMResource struct {
	// Kind of resource.
	Kind *string

	// RemotePrivateEndpointConnectionARMResource resource specific properties
	Properties *RemotePrivateEndpointConnectionARMResourceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RemotePrivateEndpointConnectionARMResourceProperties - RemotePrivateEndpointConnectionARMResource resource specific properties
type RemotePrivateEndpointConnectionARMResourceProperties struct {
	// Private IPAddresses mapped to the remote private endpoint
	IPAddresses []*string

	// PrivateEndpoint of a remote private endpoint connection
	PrivateEndpoint *ArmIDWrapper

	// The state of a private link connection
	PrivateLinkServiceConnectionState *PrivateLinkConnectionState

	// READ-ONLY
	ProvisioningState *string
}

// RemotePrivateEndpointConnectionProperties - RemotePrivateEndpointConnection resource specific properties
type RemotePrivateEndpointConnectionProperties struct {
	// Private IPAddresses mapped to the remote private endpoint
	IPAddresses []*string

	// PrivateEndpoint of a remote private endpoint connection
	PrivateEndpoint *ArmIDWrapper

	// The state of a private link connection
	PrivateLinkServiceConnectionState *PrivateLinkConnectionState

	// READ-ONLY
	ProvisioningState *string
}

// Rendering - Instructions for rendering the data
type Rendering struct {
	// Description of the data that will help it be interpreted
	Description *string

	// Title of data
	Title *string

	// Rendering Type
	Type *RenderingType
}

// RenewCertificateOrderRequest - Class representing certificate renew request.
type RenewCertificateOrderRequest struct {
	// Kind of resource.
	Kind *string

	// RenewCertificateOrderRequest resource specific properties
	Properties *RenewCertificateOrderRequestProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RenewCertificateOrderRequestProperties - RenewCertificateOrderRequest resource specific properties
type RenewCertificateOrderRequestProperties struct {
	// Csr to be used for re-key operation.
	Csr *string

	// Should we change the ASC type (from managed private key to external private key and vice versa).
	IsPrivateKeyExternal *bool

	// Certificate Key Size.
	KeySize *int32
}

// RepetitionIndex - The workflow run action repetition index.
type RepetitionIndex struct {
	// REQUIRED; The index.
	ItemIndex *int32

	// The scope.
	ScopeName *string
}

// Request - A request.
type Request struct {
	// A list of all the headers attached to the request.
	Headers any

	// The HTTP method used for the request.
	Method *string

	// The destination for the request.
	URI *string
}

// RequestHistory - The request history.
type RequestHistory struct {
	// The resource location.
	Location *string

	// The request history properties.
	Properties *RequestHistoryProperties

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// RequestHistoryListResult - The list of workflow request histories.
type RequestHistoryListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of workflow request histories.
	Value []*RequestHistory
}

// RequestHistoryProperties - The request history.
type RequestHistoryProperties struct {
	// The time the request ended.
	EndTime *time.Time

	// The request.
	Request *Request

	// The response.
	Response *Response

	// The time the request started.
	StartTime *time.Time
}

// RequestsBasedTrigger - Trigger based on total requests.
type RequestsBasedTrigger struct {
	// Request Count.
	Count *int32

	// Time interval.
	TimeInterval *string
}

// Resource - Azure resource. This resource is tracked in Azure Resource Manager
type Resource struct {
	// REQUIRED; Resource Location.
	Location *string

	// Kind of resource.
	Kind *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ResourceCollection - Collection of resources.
type ResourceCollection struct {
	// REQUIRED; Collection of resources.
	Value []*string

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// ResourceConfig - Function app resource requirements.
type ResourceConfig struct {
	// Required CPU in cores, e.g. 0.5
	CPU *float64

	// Required memory, e.g. "1Gi"
	Memory *string
}

// ResourceHealthMetadata - Used for getting ResourceHealthCheck settings.
type ResourceHealthMetadata struct {
	// Kind of resource.
	Kind *string

	// ResourceHealthMetadata resource specific properties
	Properties *ResourceHealthMetadataProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ResourceHealthMetadataCollection - Collection of resource health metadata.
type ResourceHealthMetadataCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ResourceHealthMetadata

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// ResourceHealthMetadataProperties - ResourceHealthMetadata resource specific properties
type ResourceHealthMetadataProperties struct {
	// The category that the resource matches in the RHC Policy File
	Category *string

	// Is there a health signal for the resource
	SignalAvailability *bool
}

// ResourceMetricAvailability - Metrics availability and retention.
type ResourceMetricAvailability struct {
	// READ-ONLY; Retention period for the current time grain.
	Retention *string

	// READ-ONLY; Time grain .
	TimeGrain *string
}

// ResourceMetricDefinition - Metadata for the metrics.
type ResourceMetricDefinition struct {
	// Kind of resource.
	Kind *string

	// ResourceMetricDefinition resource specific properties
	Properties *ResourceMetricDefinitionProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ResourceMetricDefinitionCollection - Collection of metric definitions.
type ResourceMetricDefinitionCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ResourceMetricDefinition

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// ResourceMetricDefinitionProperties - ResourceMetricDefinition resource specific properties
type ResourceMetricDefinitionProperties struct {
	// READ-ONLY; List of time grains supported for the metric together with retention period.
	MetricAvailabilities []*ResourceMetricAvailability

	// READ-ONLY; Primary aggregation type.
	PrimaryAggregationType *string

	// READ-ONLY; Resource metric definition properties.
	Properties map[string]*string

	// READ-ONLY; Resource URI.
	ResourceURI *string

	// READ-ONLY; Unit of the metric.
	Unit *string
}

// ResourceNameAvailability - Information regarding availability of a resource name.
type ResourceNameAvailability struct {
	// If reason == invalid, provide the user with the reason why the given name is invalid, and provide the resource naming requirements
	// so that the user can select a valid name. If reason == AlreadyExists,
	// explain that resource name is already in use, and direct them to select a different name.
	Message *string

	// true indicates name is valid and available. false indicates the name is invalid, unavailable, or both.
	NameAvailable *bool

	// Invalid indicates the name provided does not match Azure App Service naming requirements. AlreadyExists indicates that
	// the name is already in use and is therefore unavailable.
	Reason *InAvailabilityReasonType
}

// ResourceNameAvailabilityRequest - Resource name availability request content.
type ResourceNameAvailabilityRequest struct {
	// REQUIRED; Resource name to verify.
	Name *string

	// REQUIRED; Resource type used for verification.
	Type *CheckNameResourceTypes

	// Azure Resource Manager ID of the customer's selected Container Apps Environment on which to host the Function app. This
	// must be of the form
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.App/managedEnvironments/{managedEnvironmentName}
	EnvironmentID *string

	// Is fully qualified domain name.
	IsFqdn *bool
}

// ResourceReference - The resource reference.
type ResourceReference struct {
	// The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// Response - A response.
type Response struct {
	// Details on the location of the body content.
	BodyLink *ContentLink

	// A list of all the headers attached to the response.
	Headers any

	// The status code of the response.
	StatusCode *int32
}

// ResponseMessageEnvelopeRemotePrivateEndpointConnection - Message envelope that contains the common Azure resource manager
// properties and the resource provider specific content.
type ResponseMessageEnvelopeRemotePrivateEndpointConnection struct {
	// Azure-AsyncOperation Error info.
	Error *ErrorEntity

	// Resource Id. Typically ID is populated only for responses to GET requests. Caller is responsible for passing in this value
	// for GET requests only. For example:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupId}/providers/Microsoft.Web/sites/{sitename}
	ID *string

	// MSI resource
	Identity *ManagedServiceIdentity

	// Geographical region resource belongs to e.g. SouthCentralUS, SouthEastAsia.
	Location *string

	// Name of resource.
	Name *string

	// Azure resource manager plan.
	Plan *ArmPlan

	// Resource specific properties.
	Properties *RemotePrivateEndpointConnection

	// SKU description of the resource.
	SKU *SKUDescription

	// Azure-AsyncOperation Status info.
	Status *string

	// Tags associated with resource.
	Tags map[string]*string

	// Type of resource e.g "Microsoft.Web/sites".
	Type *string

	// Logical Availability Zones the service is hosted in
	Zones []*string
}

type ResponseMetaData struct {
	// Source of the Data
	DataSource *DataSource
}

// RestoreRequest - Description of a restore request.
type RestoreRequest struct {
	// Kind of resource.
	Kind *string

	// RestoreRequest resource specific properties
	Properties *RestoreRequestProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RestoreRequestProperties - RestoreRequest resource specific properties
type RestoreRequestProperties struct {
	// REQUIRED; true if the restore operation can overwrite target app; otherwise, false. true is needed if trying to restore
	// over an existing app.
	Overwrite *bool

	// REQUIRED; SAS URL to the container.
	StorageAccountURL *string

	// true if SiteConfig.ConnectionStrings should be set in new app; otherwise, false.
	AdjustConnectionStrings *bool

	// Specify app service plan that will own restored site.
	AppServicePlan *string

	// Name of a blob which contains the backup.
	BlobName *string

	// Collection of databases which should be restored. This list has to match the list of databases included in the backup.
	Databases []*DatabaseBackupSetting

	// App Service Environment name, if needed (only when restoring an app to an App Service Environment).
	HostingEnvironment *string

	// Changes a logic when restoring an app with custom domains. true to remove custom domains automatically. If false, custom
	// domains are added to the app's object when it is being restored, but that might
	// fail due to conflicts during the operation.
	IgnoreConflictingHostNames *bool

	// Ignore the databases and only restore the site content
	IgnoreDatabases *bool

	// Operation type.
	OperationType *BackupRestoreOperationType

	// Name of an app.
	SiteName *string
}

// RetryHistory - The retry history.
type RetryHistory struct {
	// Gets the client request Id.
	ClientRequestID *string

	// Gets the status code.
	Code *string

	// Gets the end time.
	EndTime *time.Time

	// Gets the error response.
	Error *ErrorResponse

	// Gets the service request Id.
	ServiceRequestID *string

	// Gets the start time.
	StartTime *time.Time
}

// Revision - Container App Revision.
type Revision struct {
	// REQUIRED; Resource Location.
	Location *string

	// Kind of resource.
	Kind *string

	// Revision resource specific properties
	Properties *RevisionProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RevisionCollection - Container App Revisions collection ARM resource.
type RevisionCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Revision

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// RevisionProperties - Revision resource specific properties
type RevisionProperties struct {
	// READ-ONLY; Boolean describing if the Revision is Active
	Active *bool

	// READ-ONLY; Timestamp describing when the revision was created by controller
	CreatedTime *time.Time

	// READ-ONLY; Fully qualified domain name of the revision
	Fqdn *string

	// READ-ONLY; Current health State of the revision
	HealthState *RevisionHealthState

	// READ-ONLY; Optional Field - Platform Error Message
	ProvisioningError *string

	// READ-ONLY; Current provisioning State of the revision
	ProvisioningState *RevisionProvisioningState

	// READ-ONLY; Number of pods currently running for this revision
	Replicas *int32

	// READ-ONLY; Container App Revision Template with all possible settings and the defaults if user did not provide them. The
	// defaults are populated as they were at the creation time
	Template *Template

	// READ-ONLY; Traffic weight assigned to this revision
	TrafficWeight *int32
}

// RunActionCorrelation - The workflow run action correlation properties.
type RunActionCorrelation struct {
	// The action tracking identifier.
	ActionTrackingID *string

	// The client keywords.
	ClientKeywords []*string

	// The client tracking identifier.
	ClientTrackingID *string
}

// RunCorrelation - The correlation properties.
type RunCorrelation struct {
	// The client keywords.
	ClientKeywords []*string

	// The client tracking identifier.
	ClientTrackingID *string
}

// SKUCapacity - Description of the App Service plan scale options.
type SKUCapacity struct {
	// Default number of workers for this App Service plan SKU.
	Default *int32

	// Maximum number of Elastic workers for this App Service plan SKU.
	ElasticMaximum *int32

	// Maximum number of workers for this App Service plan SKU.
	Maximum *int32

	// Minimum number of workers for this App Service plan SKU.
	Minimum *int32

	// Available scale configurations for an App Service plan.
	ScaleType *string
}

// SKUDescription - Description of a SKU for a scalable resource.
type SKUDescription struct {
	// Capabilities of the SKU, e.g., is traffic manager enabled?
	Capabilities []*Capability

	// Current number of instances assigned to the resource.
	Capacity *int32

	// Family code of the resource SKU.
	Family *string

	// Locations of the SKU.
	Locations []*string

	// Name of the resource SKU.
	Name *string

	// Min, max, and default scale values of the SKU.
	SKUCapacity *SKUCapacity

	// Size specifier of the resource SKU.
	Size *string

	// Service tier of the resource SKU.
	Tier *string
}

// SKUInfo - SKU discovery information.
type SKUInfo struct {
	// Min, max, and default scale values of the SKU.
	Capacity *SKUCapacity

	// Resource type that this SKU applies to.
	ResourceType *string

	// Name and tier of the SKU.
	SKU *SKUDescription
}

// SKUInfoCollection - Collection of SKU information.
type SKUInfoCollection struct {
	// REQUIRED; Collection of resources.
	Value []*SKUInfo

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// SKUInfos - Collection of SKU information.
type SKUInfos struct {
	// Resource type that this SKU applies to.
	ResourceType *string

	// List of SKUs the subscription is able to use.
	SKUs []*GlobalCsmSKUDescription
}

// SampleUtterance - Sample utterance.
type SampleUtterance struct {
	// Links attribute of sample utterance.
	Links []*string

	// Question id of sample utterance (for stackoverflow questions titles).
	Qid *string

	// Text attribute of sample utterance.
	Text *string
}

// Scale - Container App scaling configurations.
type Scale struct {
	// Optional. Maximum number of container replicas. Defaults to 10 if not set.
	MaxReplicas *int32

	// Optional. Minimum number of container replicas.
	MinReplicas *int32

	// Scaling rules.
	Rules []*ScaleRule
}

// ScaleRule - Container App container scaling rule.
type ScaleRule struct {
	// Azure Queue based scaling.
	AzureQueue *QueueScaleRule

	// Custom scale rule.
	Custom *CustomScaleRule

	// HTTP requests based scaling.
	HTTP *HTTPScaleRule

	// Scale Rule Name
	Name *string
}

// ScaleRuleAuth - Auth Secrets for Container App Scale Rule
type ScaleRuleAuth struct {
	// Name of the Container App secret from which to pull the auth params.
	SecretRef *string

	// Trigger Parameter that uses the secret
	TriggerParameter *string
}

// Secret - Container App Secret.
type Secret struct {
	// Secret Name.
	Name *string

	// Secret Value.
	Value *string
}

// SecretsCollection - Container App Secrets Collection ARM resource.
type SecretsCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ContainerAppSecret
}

// ServiceSpecification - Resource metrics service provided by Microsoft.Insights resource provider.
type ServiceSpecification struct {
	LogSpecifications    []*LogSpecification
	MetricSpecifications []*MetricSpecification
}

// Site - A web app, a mobile app backend, or an API app.
type Site struct {
	// REQUIRED; Resource Location.
	Location *string

	// Extended Location.
	ExtendedLocation *ExtendedLocation

	// Managed service identity.
	Identity *ManagedServiceIdentity

	// Kind of resource.
	Kind *string

	// Site resource specific properties
	Properties *SiteProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SiteAuthSettings - Configuration settings for the Azure App Service Authentication / Authorization feature.
type SiteAuthSettings struct {
	// Kind of resource.
	Kind *string

	// SiteAuthSettings resource specific properties
	Properties *SiteAuthSettingsProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SiteAuthSettingsProperties - SiteAuthSettings resource specific properties
type SiteAuthSettingsProperties struct {
	// Gets a JSON string containing the Azure AD Acl settings.
	AADClaimsAuthorization *string

	// Login parameters to send to the OpenID Connect authorization endpoint when a user logs in. Each parameter must be in the
	// form "key=value".
	AdditionalLoginParams []*string

	// Allowed audience values to consider when validating JSON Web Tokens issued by Azure Active Directory. Note that the ClientID
	// value is always considered an allowed audience, regardless of this setting.
	AllowedAudiences []*string

	// External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part
	// of the URL is ignored. This is an advanced setting typically only needed by
	// Windows Store application backends. Note that URLs within the current domain are always implicitly allowed.
	AllowedExternalRedirectUrls []*string

	// The path of the config file containing auth settings. If the path is relative, base will the site's root directory.
	AuthFilePath *string

	// The Client ID of this relying party application, known as the clientid. This setting is required for enabling OpenID Connection
	// authentication with Azure Active Directory or other 3rd party OpenID
	// Connect providers. More information on OpenID Connect: http://openid.net/specs/openid-connect-core-10.html
	ClientID *string

	// The Client Secret of this relying party application (in Azure Active Directory, this is also referred to as the Key). This
	// setting is optional. If no client secret is configured, the OpenID Connect
	// implicit auth flow is used to authenticate end users. Otherwise, the OpenID Connect Authorization Code Flow is used to
	// authenticate end users. More information on OpenID Connect:
	// http://openid.net/specs/openid-connect-core-1_0.html
	ClientSecret *string

	// An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts
	// as a replacement for the Client Secret. It is also optional.
	ClientSecretCertificateThumbprint *string

	// The app setting name that contains the client secret of the relying party application.
	ClientSecretSettingName *string

	// The ConfigVersion of the Authentication / Authorization feature in use for the current app. The setting in this value can
	// control the behavior of the control plane for Authentication / Authorization.
	ConfigVersion *string

	// The default authentication provider to use when multiple providers are configured. This setting is only needed if multiple
	// providers are configured and the unauthenticated client action is set to
	// "RedirectToLoginPage".
	DefaultProvider *BuiltInAuthenticationProvider

	// true if the Authentication / Authorization feature is enabled for the current app; otherwise, false.
	Enabled *bool

	// The App ID of the Facebook app used for login. This setting is required for enabling Facebook Login. Facebook Login documentation:
	// https://developers.facebook.com/docs/facebook-login
	FacebookAppID *string

	// The App Secret of the Facebook app used for Facebook Login. This setting is required for enabling Facebook Login. Facebook
	// Login documentation: https://developers.facebook.com/docs/facebook-login
	FacebookAppSecret *string

	// The app setting name that contains the app secret used for Facebook Login.
	FacebookAppSecretSettingName *string

	// The OAuth 2.0 scopes that will be requested as part of Facebook Login authentication. This setting is optional. Facebook
	// Login documentation: https://developers.facebook.com/docs/facebook-login
	FacebookOAuthScopes []*string

	// The Client Id of the GitHub app used for login. This setting is required for enabling Github login
	GitHubClientID *string

	// The Client Secret of the GitHub app used for Github Login. This setting is required for enabling Github login.
	GitHubClientSecret *string

	// The app setting name that contains the client secret of the Github app used for GitHub Login.
	GitHubClientSecretSettingName *string

	// The OAuth 2.0 scopes that will be requested as part of GitHub Login authentication. This setting is optional
	GitHubOAuthScopes []*string

	// The OpenID Connect Client ID for the Google web application. This setting is required for enabling Google Sign-In. Google
	// Sign-In documentation: https://developers.google.com/identity/sign-in/web/
	GoogleClientID *string

	// The client secret associated with the Google web application. This setting is required for enabling Google Sign-In. Google
	// Sign-In documentation: https://developers.google.com/identity/sign-in/web/
	GoogleClientSecret *string

	// The app setting name that contains the client secret associated with the Google web application.
	GoogleClientSecretSettingName *string

	// The OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication. This setting is optional. If not
	// specified, "openid", "profile", and "email" are used as default scopes. Google
	// Sign-In documentation: https://developers.google.com/identity/sign-in/web/
	GoogleOAuthScopes []*string

	// "true" if the auth config settings should be read from a file, "false" otherwise
	IsAuthFromFile *string

	// The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application. When using Azure
	// Active Directory, this value is the URI of the directory tenant, e.g.
	// https://sts.windows.net/{tenant-guid}/. This URI is a case-sensitive identifier for the token issuer. More information
	// on OpenID Connect Discovery:
	// http://openid.net/specs/openid-connect-discovery-1_0.html
	Issuer *string

	// The OAuth 2.0 client ID that was created for the app used for authentication. This setting is required for enabling Microsoft
	// Account authentication. Microsoft Account OAuth documentation:
	// https://dev.onedrive.com/auth/msa_oauth.htm
	MicrosoftAccountClientID *string

	// The OAuth 2.0 client secret that was created for the app used for authentication. This setting is required for enabling
	// Microsoft Account authentication. Microsoft Account OAuth documentation:
	// https://dev.onedrive.com/auth/msa_oauth.htm
	MicrosoftAccountClientSecret *string

	// The app setting name containing the OAuth 2.0 client secret that was created for the app used for authentication.
	MicrosoftAccountClientSecretSettingName *string

	// The OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication. This setting is optional. If not
	// specified, "wl.basic" is used as the default scope. Microsoft Account Scopes
	// and permissions documentation: https://msdn.microsoft.com/en-us/library/dn631845.aspx
	MicrosoftAccountOAuthScopes []*string

	// The RuntimeVersion of the Authentication / Authorization feature in use for the current app. The setting in this value
	// can control the behavior of certain features in the Authentication /
	// Authorization module.
	RuntimeVersion *string

	// The number of hours after session token expiration that a session token can be used to call the token refresh API. The
	// default is 72 hours.
	TokenRefreshExtensionHours *float64

	// true to durably store platform-specific security tokens that are obtained during login flows; otherwise, false. The default
	// is false.
	TokenStoreEnabled *bool

	// The OAuth 1.0a consumer key of the Twitter application used for sign-in. This setting is required for enabling Twitter
	// Sign-In. Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
	TwitterConsumerKey *string

	// The OAuth 1.0a consumer secret of the Twitter application used for sign-in. This setting is required for enabling Twitter
	// Sign-In. Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
	TwitterConsumerSecret *string

	// The app setting name that contains the OAuth 1.0a consumer secret of the Twitter application used for sign-in.
	TwitterConsumerSecretSettingName *string

	// The action to take when an unauthenticated client attempts to access the app.
	UnauthenticatedClientAction *UnauthenticatedClientAction

	// Gets a value indicating whether the issuer should be a valid HTTPS url and be validated as such.
	ValidateIssuer *bool
}

// SiteAuthSettingsV2 - Configuration settings for the Azure App Service Authentication / Authorization V2 feature.
type SiteAuthSettingsV2 struct {
	// Kind of resource.
	Kind *string

	// SiteAuthSettingsV2 resource specific properties
	Properties *SiteAuthSettingsV2Properties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SiteAuthSettingsV2Properties - SiteAuthSettingsV2 resource specific properties
type SiteAuthSettingsV2Properties struct {
	// The configuration settings that determines the validation flow of users using App Service Authentication/Authorization.
	GlobalValidation *GlobalValidation

	// The configuration settings of the HTTP requests for authentication and authorization requests made against App Service
	// Authentication/Authorization.
	HTTPSettings *HTTPSettings

	// The configuration settings of each of the identity providers used to configure App Service Authentication/Authorization.
	IdentityProviders *IdentityProviders

	// The configuration settings of the login flow of users using App Service Authentication/Authorization.
	Login *Login

	// The configuration settings of the platform of App Service Authentication/Authorization.
	Platform *AuthPlatform
}

// SiteCloneability - Represents whether or not an app is cloneable.
type SiteCloneability struct {
	// List of blocking application characteristics.
	BlockingCharacteristics []*SiteCloneabilityCriterion

	// List of features enabled on app that prevent cloning.
	BlockingFeatures []*SiteCloneabilityCriterion

	// Name of app.
	Result *CloneAbilityResult

	// List of features enabled on app that are non-blocking but cannot be cloned. The app can still be cloned but the features
	// in this list will not be set up on cloned app.
	UnsupportedFeatures []*SiteCloneabilityCriterion
}

// SiteCloneabilityCriterion - An app cloneability criterion.
type SiteCloneabilityCriterion struct {
	// Description of criterion.
	Description *string

	// Name of criterion.
	Name *string
}

// SiteConfig - Configuration of an App Service app.
type SiteConfig struct {
	// Information about the formal API definition for the app.
	APIDefinition *APIDefinitionInfo

	// Azure API management settings linked to the app.
	APIManagementConfig *APIManagementConfig

	// Flag to use Managed Identity Creds for ACR pull
	AcrUseManagedIdentityCreds *bool

	// If using user managed identity, the user managed identity ClientId
	AcrUserManagedIdentityID *string

	// true if Always On is enabled; otherwise, false.
	AlwaysOn *bool

	// App command line to launch.
	AppCommandLine *string

	// Application settings.
	AppSettings []*NameValuePair

	// true if Auto Heal is enabled; otherwise, false.
	AutoHealEnabled *bool

	// Auto Heal rules.
	AutoHealRules *AutoHealRules

	// Auto-swap slot name.
	AutoSwapSlotName *string

	// List of Azure Storage Accounts.
	AzureStorageAccounts map[string]*AzureStorageInfoValue

	// Connection strings.
	ConnectionStrings []*ConnStringInfo

	// Cross-Origin Resource Sharing (CORS) settings.
	Cors *CorsSettings

	// Default documents.
	DefaultDocuments []*string

	// true if detailed error logging is enabled; otherwise, false.
	DetailedErrorLoggingEnabled *bool

	// Document root.
	DocumentRoot *string

	// Maximum number of workers that a site can scale out to. This setting only applies to apps in plans where ElasticScaleEnabled
	// is true
	ElasticWebAppScaleLimit *int32

	// This is work around for polymorphic types.
	Experiments *Experiments

	// State of FTP / FTPS service
	FtpsState *FtpsState

	// Maximum number of workers that a site can scale out to. This setting only applies to the Consumption and Elastic Premium
	// Plans
	FunctionAppScaleLimit *int32

	// Gets or sets a value indicating whether functions runtime scale monitoring is enabled. When enabled, the ScaleController
	// will not monitor event sources directly, but will instead call to the runtime
	// to get scale status.
	FunctionsRuntimeScaleMonitoringEnabled *bool

	// true if HTTP logging is enabled; otherwise, false.
	HTTPLoggingEnabled *bool

	// Handler mappings.
	HandlerMappings []*HandlerMapping

	// Health check path
	HealthCheckPath *string

	// Http20Enabled: configures a web site to allow clients to connect over http2.0
	Http20Enabled *bool

	// IP security restrictions for main.
	IPSecurityRestrictions []*IPSecurityRestriction

	// Default action for main access restriction if no rules are matched.
	IPSecurityRestrictionsDefaultAction *DefaultAction

	// Java container.
	JavaContainer *string

	// Java container version.
	JavaContainerVersion *string

	// Java version.
	JavaVersion *string

	// Identity to use for Key Vault Reference authentication.
	KeyVaultReferenceIdentity *string

	// Site limits.
	Limits *SiteLimits

	// Linux App Framework and version
	LinuxFxVersion *string

	// Site load balancing.
	LoadBalancing *SiteLoadBalancing

	// true to enable local MySQL; otherwise, false.
	LocalMySQLEnabled *bool

	// HTTP logs directory size limit.
	LogsDirectorySizeLimit *int32

	// Managed pipeline mode.
	ManagedPipelineMode *ManagedPipelineMode

	// Managed Service Identity Id
	ManagedServiceIdentityID *int32

	// Application metadata. This property cannot be retrieved, since it may contain secrets.
	Metadata []*NameValuePair

	// The minimum strength TLS cipher suite allowed for an application
	MinTLSCipherSuite *TLSCipherSuites

	// MinTlsVersion: configures the minimum version of TLS required for SSL requests
	MinTLSVersion *SupportedTLSVersions

	// Number of minimum instance count for a site This setting only applies to the Elastic Plans
	MinimumElasticInstanceCount *int32

	// .NET Framework version.
	NetFrameworkVersion *string

	// Version of Node.js.
	NodeVersion *string

	// Number of workers.
	NumberOfWorkers *int32

	// Version of PHP.
	PhpVersion *string

	// Version of PowerShell.
	PowerShellVersion *string

	// Number of preWarmed instances. This setting only applies to the Consumption and Elastic Plans
	PreWarmedInstanceCount *int32

	// Property to allow or block all public traffic.
	PublicNetworkAccess *string

	// Publishing user name.
	PublishingUsername *string

	// Push endpoint settings.
	Push *PushSettings

	// Version of Python.
	PythonVersion *string

	// true if remote debugging is enabled; otherwise, false.
	RemoteDebuggingEnabled *bool

	// Remote debugging version.
	RemoteDebuggingVersion *string

	// true if request tracing is enabled; otherwise, false.
	RequestTracingEnabled *bool

	// Request tracing expiration time.
	RequestTracingExpirationTime *time.Time

	// IP security restrictions for scm.
	ScmIPSecurityRestrictions []*IPSecurityRestriction

	// Default action for scm access restriction if no rules are matched.
	ScmIPSecurityRestrictionsDefaultAction *DefaultAction

	// IP security restrictions for scm to use main.
	ScmIPSecurityRestrictionsUseMain *bool

	// ScmMinTlsVersion: configures the minimum version of TLS required for SSL requests for SCM site
	ScmMinTLSVersion *SupportedTLSVersions

	// SCM type.
	ScmType *ScmType

	// Tracing options.
	TracingOptions *string

	// true to use 32-bit worker process; otherwise, false.
	Use32BitWorkerProcess *bool

	// Virtual applications.
	VirtualApplications []*VirtualApplication

	// Virtual Network name.
	VnetName *string

	// The number of private ports assigned to this app. These will be assigned dynamically on runtime.
	VnetPrivatePortsCount *int32

	// Virtual Network Route All enabled. This causes all outbound traffic to have Virtual Network Security Groups and User Defined
	// Routes applied.
	VnetRouteAllEnabled *bool

	// true if WebSocket is enabled; otherwise, false.
	WebSocketsEnabled *bool

	// Sets the time zone a site uses for generating timestamps. Compatible with Linux and Windows App Service. Setting the WEBSITETIMEZONE
	// app setting takes precedence over this config. For Linux, expects
	// tz database values https://www.iana.org/time-zones (for a quick reference see https://en.wikipedia.org/wiki/Listoftzdatabasetimezones).
	// For Windows, expects one of the time zones listed under HKEY
	// LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones
	WebsiteTimeZone *string

	// Xenon App Framework and version
	WindowsFxVersion *string

	// Explicit Managed Service Identity Id
	XManagedServiceIdentityID *int32

	// READ-ONLY; Site MachineKey.
	MachineKey *SiteMachineKey
}

// SiteConfigPropertiesDictionary - Site config properties dictionary.
type SiteConfigPropertiesDictionary struct {
	// READ-ONLY; JavaVersion configuration setting.
	JavaVersion *string

	// READ-ONLY; LinuxFxVersion configuration setting.
	LinuxFxVersion *string

	// READ-ONLY; PowerShellVersion configuration setting.
	PowerShellVersion *string

	// READ-ONLY; true if use32BitWorkerProcess should be set to true for the stack; otherwise, false.
	Use32BitWorkerProcess *bool
}

// SiteConfigResource - Web app configuration ARM resource.
type SiteConfigResource struct {
	// Kind of resource.
	Kind *string

	// Core resource properties
	Properties *SiteConfig

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SiteConfigResourceCollection - Collection of site configurations.
type SiteConfigResourceCollection struct {
	// REQUIRED; Collection of resources.
	Value []*SiteConfigResource

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// SiteConfigurationSnapshotInfo - A snapshot of a web app configuration.
type SiteConfigurationSnapshotInfo struct {
	// Kind of resource.
	Kind *string

	// SiteConfigurationSnapshotInfo resource specific properties
	Properties *SiteConfigurationSnapshotInfoProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SiteConfigurationSnapshotInfoCollection - Collection of metadata for the app configuration snapshots that can be restored.
type SiteConfigurationSnapshotInfoCollection struct {
	// REQUIRED; Collection of resources.
	Value []*SiteConfigurationSnapshotInfo

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// SiteConfigurationSnapshotInfoProperties - SiteConfigurationSnapshotInfo resource specific properties
type SiteConfigurationSnapshotInfoProperties struct {
	// READ-ONLY; The id of the snapshot
	SnapshotID *int32

	// READ-ONLY; The time the snapshot was taken.
	Time *time.Time
}

// SiteExtensionInfo - Site Extension Information.
type SiteExtensionInfo struct {
	// Kind of resource.
	Kind *string

	// SiteExtensionInfo resource specific properties
	Properties *SiteExtensionInfoProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SiteExtensionInfoCollection - Collection of Kudu site extension information elements.
type SiteExtensionInfoCollection struct {
	// REQUIRED; Collection of resources.
	Value []*SiteExtensionInfo

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// SiteExtensionInfoProperties - SiteExtensionInfo resource specific properties
type SiteExtensionInfoProperties struct {
	// List of authors.
	Authors []*string

	// Site Extension comment.
	Comment *string

	// Detailed description.
	Description *string

	// Count of downloads.
	DownloadCount *int32

	// Site extension ID.
	ExtensionID *string

	// Site extension type.
	ExtensionType *SiteExtensionType

	// Extension URL.
	ExtensionURL *string

	// Feed URL.
	FeedURL *string

	// Icon URL.
	IconURL *string

	// Installed timestamp.
	InstalledDateTime *time.Time

	// Installer command line parameters.
	InstallerCommandLineParams *string

	// License URL.
	LicenseURL *string

	// true if the local version is the latest version; false otherwise.
	LocalIsLatestVersion *bool

	// Local path.
	LocalPath *string

	// Project URL.
	ProjectURL *string

	// Provisioning state.
	ProvisioningState *string

	// Published timestamp.
	PublishedDateTime *time.Time

	// Summary description.
	Summary *string
	Title   *string

	// Version information.
	Version *string
}

// SiteLimits - Metric limits set on an app.
type SiteLimits struct {
	// Maximum allowed disk size usage in MB.
	MaxDiskSizeInMb *int64

	// Maximum allowed memory usage in MB.
	MaxMemoryInMb *int64

	// Maximum allowed CPU usage percentage.
	MaxPercentageCPU *float64
}

// SiteLogsConfig - Configuration of App Service site logs.
type SiteLogsConfig struct {
	// Kind of resource.
	Kind *string

	// SiteLogsConfig resource specific properties
	Properties *SiteLogsConfigProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SiteLogsConfigProperties - SiteLogsConfig resource specific properties
type SiteLogsConfigProperties struct {
	// Application logs configuration.
	ApplicationLogs *ApplicationLogsConfig

	// Detailed error messages configuration.
	DetailedErrorMessages *EnabledConfig

	// Failed requests tracing configuration.
	FailedRequestsTracing *EnabledConfig

	// HTTP logs configuration.
	HTTPLogs *HTTPLogsConfig
}

// SiteMachineKey - MachineKey of an app.
type SiteMachineKey struct {
	// Algorithm used for decryption.
	Decryption *string

	// Decryption key.
	DecryptionKey *string

	// MachineKey validation.
	Validation *string

	// Validation key.
	ValidationKey *string
}

// SitePatchResource - ARM resource for a site.
type SitePatchResource struct {
	// Managed service identity.
	Identity *ManagedServiceIdentity

	// Kind of resource.
	Kind *string

	// SitePatchResource resource specific properties
	Properties *SitePatchResourceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SitePatchResourceProperties - SitePatchResource resource specific properties
type SitePatchResourceProperties struct {
	// true to enable client affinity; false to stop sending session affinity cookies, which route client requests in the same
	// session to the same instance. Default is true.
	ClientAffinityEnabled *bool

	// true to enable client certificate authentication (TLS mutual authentication); otherwise, false. Default is false.
	ClientCertEnabled *bool

	// client certificate authentication comma-separated exclusion paths
	ClientCertExclusionPaths *string

	// This composes with ClientCertEnabled setting.
	// * ClientCertEnabled: false means ClientCert is ignored.
	// * ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
	// * ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or accepted.
	ClientCertMode *ClientCertMode

	// If specified during app creation, the app is cloned from a source app.
	CloningInfo *CloningInfo

	// Size of the function container.
	ContainerSize *int32

	// Unique identifier that verifies the custom domains assigned to the app. Customer will add this id to a txt record for verification.
	CustomDomainVerificationID *string

	// Maximum allowed daily memory-time quota (applicable on dynamic apps only).
	DailyMemoryTimeQuota *int32

	// true if the app is enabled; otherwise, false. Setting this value to false disables the app (takes the app offline).
	Enabled *bool

	// HttpsOnly: configures a web site to accept only https requests. Issues redirect for http requests
	HTTPSOnly *bool

	// Hostname SSL states are used to manage the SSL bindings for app's hostnames.
	HostNameSSLStates []*HostNameSSLState

	// true to disable the public hostnames of the app; otherwise, false. If true, the app is only accessible via API management
	// process.
	HostNamesDisabled *bool

	// App Service Environment to use for the app.
	HostingEnvironmentProfile *HostingEnvironmentProfile

	// Hyper-V sandbox.
	HyperV *bool

	// Obsolete: Hyper-V sandbox.
	IsXenon *bool

	// Identity to use for Key Vault Reference authentication.
	KeyVaultReferenceIdentity *string

	// Site redundancy mode
	RedundancyMode *RedundancyMode

	// true if reserved; otherwise, false.
	Reserved *bool

	// true to stop SCM (KUDU) site when the app is stopped; otherwise, false. The default is false.
	ScmSiteAlsoStopped *bool

	// Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
	ServerFarmID *string

	// Configuration of the app.
	SiteConfig *SiteConfig

	// Checks if Customer provided storage account is required
	StorageAccountRequired *bool

	// Azure Resource Manager ID of the Virtual network and subnet to be joined by Regional VNET Integration. This must be of
	// the form
	// /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}
	VirtualNetworkSubnetID *string

	// READ-ONLY; Management information availability state for the app.
	AvailabilityState *SiteAvailabilityState

	// READ-ONLY; Default hostname of the app. Read-only.
	DefaultHostName *string

	// READ-ONLY; Enabled hostnames for the app.Hostnames need to be assigned (see HostNames) AND enabled. Otherwise, the app
	// is not served on those hostnames.
	EnabledHostNames []*string

	// READ-ONLY; Hostnames associated with the app.
	HostNames []*string

	// READ-ONLY; Specifies an operation id if this site has a pending operation.
	InProgressOperationID *string

	// READ-ONLY; true if the app is a default container; otherwise, false.
	IsDefaultContainer *bool

	// READ-ONLY; Last time the app was modified, in UTC. Read-only.
	LastModifiedTimeUTC *time.Time

	// READ-ONLY; Maximum number of workers. This only applies to Functions container.
	MaxNumberOfWorkers *int32

	// READ-ONLY; List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from tenants
	// that site can be hosted with current settings. Read-only.
	OutboundIPAddresses *string

	// READ-ONLY; List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from all
	// tenants except dataComponent. Read-only.
	PossibleOutboundIPAddresses *string

	// READ-ONLY; Name of the repository site.
	RepositorySiteName *string

	// READ-ONLY; Name of the resource group the app belongs to. Read-only.
	ResourceGroup *string

	// READ-ONLY; Status of the last deployment slot swap operation.
	SlotSwapStatus *SlotSwapStatus

	// READ-ONLY; Current state of the app.
	State *string

	// READ-ONLY; App suspended till in case memory-time quota is exceeded.
	SuspendedTill *time.Time

	// READ-ONLY; Specifies which deployment slot this app will swap into. Read-only.
	TargetSwapSlot *string

	// READ-ONLY; Azure Traffic Manager hostnames associated with the app. Read-only.
	TrafficManagerHostNames []*string

	// READ-ONLY; State indicating whether the app has exceeded its quota usage. Read-only.
	UsageState *UsageState
}

// SitePhpErrorLogFlag - Used for getting PHP error logging flag.
type SitePhpErrorLogFlag struct {
	// Kind of resource.
	Kind *string

	// SitePhpErrorLogFlag resource specific properties
	Properties *SitePhpErrorLogFlagProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SitePhpErrorLogFlagProperties - SitePhpErrorLogFlag resource specific properties
type SitePhpErrorLogFlagProperties struct {
	// Local log_errors setting.
	LocalLogErrors *string

	// Local logerrorsmax_len setting.
	LocalLogErrorsMaxLength *string

	// Master log_errors setting.
	MasterLogErrors *string

	// Master logerrorsmax_len setting.
	MasterLogErrorsMaxLength *string
}

// SiteProperties - Site resource specific properties
type SiteProperties struct {
	// true to enable client affinity; false to stop sending session affinity cookies, which route client requests in the same
	// session to the same instance. Default is true.
	ClientAffinityEnabled *bool

	// true to enable client certificate authentication (TLS mutual authentication); otherwise, false. Default is false.
	ClientCertEnabled *bool

	// client certificate authentication comma-separated exclusion paths
	ClientCertExclusionPaths *string

	// This composes with ClientCertEnabled setting.
	// * ClientCertEnabled: false means ClientCert is ignored.
	// * ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
	// * ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or accepted.
	ClientCertMode *ClientCertMode

	// If specified during app creation, the app is cloned from a source app.
	CloningInfo *CloningInfo

	// Size of the function container.
	ContainerSize *int32

	// Unique identifier that verifies the custom domains assigned to the app. Customer will add this id to a txt record for verification.
	CustomDomainVerificationID *string

	// Maximum allowed daily memory-time quota (applicable on dynamic apps only).
	DailyMemoryTimeQuota *int32

	// Dapr configuration of the app.
	DaprConfig *DaprConfig

	// true if the app is enabled; otherwise, false. Setting this value to false disables the app (takes the app offline).
	Enabled *bool

	// HttpsOnly: configures a web site to accept only https requests. Issues redirect for http requests
	HTTPSOnly *bool

	// Hostname SSL states are used to manage the SSL bindings for app's hostnames.
	HostNameSSLStates []*HostNameSSLState

	// true to disable the public hostnames of the app; otherwise, false. If true, the app is only accessible via API management
	// process.
	HostNamesDisabled *bool

	// App Service Environment to use for the app.
	HostingEnvironmentProfile *HostingEnvironmentProfile

	// Hyper-V sandbox.
	HyperV *bool

	// Obsolete: Hyper-V sandbox.
	IsXenon *bool

	// Identity to use for Key Vault Reference authentication.
	KeyVaultReferenceIdentity *string

	// Azure Resource Manager ID of the customer's selected Managed Environment on which to host this app. This must be of the
	// form
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.App/managedEnvironments/{managedEnvironmentName}
	ManagedEnvironmentID *string

	// Property to allow or block all public traffic. Allowed Values: 'Enabled', 'Disabled' or an empty string.
	PublicNetworkAccess *string

	// Site redundancy mode
	RedundancyMode *RedundancyMode

	// true if reserved; otherwise, false.
	Reserved *bool

	// Function app resource requirements.
	ResourceConfig *ResourceConfig

	// true to stop SCM (KUDU) site when the app is stopped; otherwise, false. The default is false.
	ScmSiteAlsoStopped *bool

	// Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
	ServerFarmID *string

	// Configuration of the app.
	SiteConfig *SiteConfig

	// Checks if Customer provided storage account is required
	StorageAccountRequired *bool

	// Azure Resource Manager ID of the Virtual network and subnet to be joined by Regional VNET Integration. This must be of
	// the form
	// /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}
	VirtualNetworkSubnetID *string

	// To enable accessing content over virtual network
	VnetContentShareEnabled *bool

	// To enable pulling image over Virtual Network
	VnetImagePullEnabled *bool

	// Virtual Network Route All enabled. This causes all outbound traffic to have Virtual Network Security Groups and User Defined
	// Routes applied.
	VnetRouteAllEnabled *bool

	// Workload profile name for function app to execute on.
	WorkloadProfileName *string

	// READ-ONLY; Management information availability state for the app.
	AvailabilityState *SiteAvailabilityState

	// READ-ONLY; Default hostname of the app. Read-only.
	DefaultHostName *string

	// READ-ONLY; Enabled hostnames for the app.Hostnames need to be assigned (see HostNames) AND enabled. Otherwise, the app
	// is not served on those hostnames.
	EnabledHostNames []*string

	// READ-ONLY; Hostnames associated with the app.
	HostNames []*string

	// READ-ONLY; Specifies an operation id if this site has a pending operation.
	InProgressOperationID *string

	// READ-ONLY; true if the app is a default container; otherwise, false.
	IsDefaultContainer *bool

	// READ-ONLY; Last time the app was modified, in UTC. Read-only.
	LastModifiedTimeUTC *time.Time

	// READ-ONLY; Maximum number of workers. This only applies to Functions container.
	MaxNumberOfWorkers *int32

	// READ-ONLY; List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from tenants
	// that site can be hosted with current settings. Read-only.
	OutboundIPAddresses *string

	// READ-ONLY; List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from all
	// tenants except dataComponent. Read-only.
	PossibleOutboundIPAddresses *string

	// READ-ONLY; Name of the repository site.
	RepositorySiteName *string

	// READ-ONLY; Name of the resource group the app belongs to. Read-only.
	ResourceGroup *string

	// READ-ONLY; Status of the last deployment slot swap operation.
	SlotSwapStatus *SlotSwapStatus

	// READ-ONLY; Current state of the app.
	State *string

	// READ-ONLY; App suspended till in case memory-time quota is exceeded.
	SuspendedTill *time.Time

	// READ-ONLY; Specifies which deployment slot this app will swap into. Read-only.
	TargetSwapSlot *string

	// READ-ONLY; Azure Traffic Manager hostnames associated with the app. Read-only.
	TrafficManagerHostNames []*string

	// READ-ONLY; State indicating whether the app has exceeded its quota usage. Read-only.
	UsageState *UsageState
}

// SiteSeal - Site seal
type SiteSeal struct {
	// REQUIRED; HTML snippet
	HTML *string
}

// SiteSealRequest - Site seal request.
type SiteSealRequest struct {
	// If true use the light color theme for site seal; otherwise, use the default color theme.
	LightTheme *bool

	// Locale of site seal.
	Locale *string
}

// SiteSourceControl - Source control configuration for an app.
type SiteSourceControl struct {
	// Kind of resource.
	Kind *string

	// SiteSourceControl resource specific properties
	Properties *SiteSourceControlProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SiteSourceControlProperties - SiteSourceControl resource specific properties
type SiteSourceControlProperties struct {
	// Name of branch to use for deployment.
	Branch *string

	// true to enable deployment rollback; otherwise, false.
	DeploymentRollbackEnabled *bool

	// If GitHub Action is selected, than the associated configuration.
	GitHubActionConfiguration *GitHubActionConfiguration

	// true if this is deployed via GitHub action.
	IsGitHubAction *bool

	// true to limit to manual integration; false to enable continuous integration (which configures webhooks into online repos
	// like GitHub).
	IsManualIntegration *bool

	// true for a Mercurial repository; false for a Git repository.
	IsMercurial *bool

	// Repository or source control URL.
	RepoURL *string
}

// SlotConfigNames - Names for connection strings, application settings, and external Azure storage account configuration
// identifiers to be marked as sticky to the deployment slot and not moved during a swap operation.
// This is valid for all deployment slots in an app.
type SlotConfigNames struct {
	// List of application settings names.
	AppSettingNames []*string

	// List of external Azure storage account identifiers.
	AzureStorageConfigNames []*string

	// List of connection string names.
	ConnectionStringNames []*string
}

// SlotConfigNamesResource - Slot Config names azure resource.
type SlotConfigNamesResource struct {
	// Kind of resource.
	Kind *string

	// Core resource properties
	Properties *SlotConfigNames

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SlotDifference - A setting difference between two deployment slots of an app.
type SlotDifference struct {
	// Kind of resource.
	Kind *string

	// SlotDifference resource specific properties
	Properties *SlotDifferenceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SlotDifferenceCollection - Collection of slot differences.
type SlotDifferenceCollection struct {
	// REQUIRED; Collection of resources.
	Value []*SlotDifference

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// SlotDifferenceProperties - SlotDifference resource specific properties
type SlotDifferenceProperties struct {
	// READ-ONLY; Description of the setting difference.
	Description *string

	// READ-ONLY; Rule that describes how to process the setting difference during a slot swap.
	DiffRule *string

	// READ-ONLY; Level of the difference: Information, Warning or Error.
	Level *string

	// READ-ONLY; Name of the setting.
	SettingName *string

	// READ-ONLY; The type of the setting: General, AppSetting or ConnectionString.
	SettingType *string

	// READ-ONLY; Value of the setting in the current slot.
	ValueInCurrentSlot *string

	// READ-ONLY; Value of the setting in the target slot.
	ValueInTargetSlot *string
}

// SlotSwapStatus - The status of the last successful slot swap operation.
type SlotSwapStatus struct {
	// READ-ONLY; The destination slot of the last swap operation.
	DestinationSlotName *string

	// READ-ONLY; The source slot of the last swap operation.
	SourceSlotName *string

	// READ-ONLY; The time the last successful slot swap completed.
	TimestampUTC *time.Time
}

// SlowRequestsBasedTrigger - Trigger based on request execution time.
type SlowRequestsBasedTrigger struct {
	// Request Count.
	Count *int32

	// Request Path.
	Path *string

	// Time interval.
	TimeInterval *string

	// Time taken.
	TimeTaken *string
}

// Snapshot - A snapshot of an app.
type Snapshot struct {
	// Kind of resource.
	Kind *string

	// Snapshot resource specific properties
	Properties *SnapshotProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SnapshotCollection - Collection of snapshots which can be used to revert an app to a previous time.
type SnapshotCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Snapshot

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// SnapshotProperties - Snapshot resource specific properties
type SnapshotProperties struct {
	// READ-ONLY; The time the snapshot was taken.
	Time *string
}

// SnapshotRecoverySource - Specifies the web app that snapshot contents will be retrieved from.
type SnapshotRecoverySource struct {
	// ARM resource ID of the source app. /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
	// for production slots and
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName} for
	// other slots.
	ID *string

	// Geographical location of the source web app, e.g. SouthEastAsia, SouthCentralUS
	Location *string
}

// SnapshotRestoreRequest - Details about app recovery operation.
type SnapshotRestoreRequest struct {
	// Kind of resource.
	Kind *string

	// SnapshotRestoreRequest resource specific properties
	Properties *SnapshotRestoreRequestProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SnapshotRestoreRequestProperties - SnapshotRestoreRequest resource specific properties
type SnapshotRestoreRequestProperties struct {
	// REQUIRED; If true the restore operation can overwrite source app; otherwise, false.
	Overwrite *bool

	// If true, custom hostname conflicts will be ignored when recovering to a target web app. This setting is only necessary
	// when RecoverConfiguration is enabled.
	IgnoreConflictingHostNames *bool

	// If true, site configuration, in addition to content, will be reverted.
	RecoverConfiguration *bool

	// Optional. Specifies the web app that snapshot contents will be retrieved from. If empty, the targeted web app will be used
	// as the source.
	RecoverySource *SnapshotRecoverySource

	// Point in time in which the app restore should be done, formatted as a DateTime string.
	SnapshotTime *string

	// If true, the snapshot is retrieved from DRSecondary endpoint.
	UseDRSecondary *bool
}

// Solution - Class Representing Solution for problems detected.
type Solution struct {
	// Solution Data.
	Data [][]*NameValuePair

	// Description of the solution
	Description *string

	// Display Name of the solution
	DisplayName *string

	// Solution Id.
	ID *float64

	// Solution Metadata.
	Metadata [][]*NameValuePair

	// Order of the solution.
	Order *float64

	// Type of Solution
	Type *SolutionType
}

// SourceControl - The source control OAuth token.
type SourceControl struct {
	// Kind of resource.
	Kind *string

	// SourceControl resource specific properties
	Properties *SourceControlProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SourceControlCollection - Collection of source controls.
type SourceControlCollection struct {
	// REQUIRED; Collection of resources.
	Value []*SourceControl

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// SourceControlProperties - SourceControl resource specific properties
type SourceControlProperties struct {
	// OAuth token expiration.
	ExpirationTime *time.Time

	// OAuth refresh token.
	RefreshToken *string

	// OAuth access token.
	Token *string

	// OAuth access token secret.
	TokenSecret *string
}

// StackMajorVersion - Application stack major version.
type StackMajorVersion struct {
	// Example: All the function apps need AppSetting: "FUNCTIONSWORKERRUNTIME" to be set stack name
	AppSettingsDictionary map[string]any

	// true if this supports Application Insights; otherwise, false.
	ApplicationInsights *bool

	// Application stack major version (display only).
	DisplayVersion *string

	// true if this is the default major version; otherwise, false.
	IsDefault *bool

	// true if this stack has been deprecated, otherwise false.
	IsDeprecated *bool

	// true if this stack should be hidden for new customers on portal, otherwise false.
	IsHidden *bool

	// true if this stack is in Preview, otherwise false.
	IsPreview *bool

	// Minor versions associated with the major version.
	MinorVersions []*StackMinorVersion

	// Application stack major version (runtime only).
	RuntimeVersion *string

	// Example: All Linux Function Apps, need Use32BitWorkerProcess to be set to 0
	SiteConfigPropertiesDictionary map[string]any
}

// StackMinorVersion - Application stack minor version.
type StackMinorVersion struct {
	// Application stack minor version (display only).
	DisplayVersion *string

	// true if this is the default minor version; otherwise, false.
	IsDefault *bool

	// true if this supports Remote Debugging, otherwise false.
	IsRemoteDebuggingEnabled *bool

	// Application stack minor version (runtime only).
	RuntimeVersion *string
}

// StampCapacity - Stamp capacity information.
type StampCapacity struct {
	// Available capacity (# of machines, bytes of storage etc…).
	AvailableCapacity *int64

	// Shared/dedicated workers.
	ComputeMode *ComputeModeOptions

	// If true, it includes basic apps. Basic apps are not used for capacity allocation.
	ExcludeFromCapacityAllocation *bool

	// true if capacity is applicable for all apps; otherwise, false.
	IsApplicableForAllComputeModes *bool

	// Is this a linux stamp capacity
	IsLinux *bool

	// Name of the stamp.
	Name *string

	// Shared or Dedicated.
	SiteMode *string

	// Total capacity (# of machines, bytes of storage etc…).
	TotalCapacity *int64

	// Name of the unit.
	Unit *string

	// Size of the machines.
	WorkerSize *WorkerSizeOptions

	// Size ID of machines: 0 - Small 1 - Medium 2 - Large
	WorkerSizeID *int32
}

// StampCapacityCollection - Collection of stamp capacities.
type StampCapacityCollection struct {
	// REQUIRED; Collection of resources.
	Value []*StampCapacity

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// StaticSite - A static site.
type StaticSite struct {
	// false if config file is locked for this static web app; otherwise, true.
	AllowConfigFileUpdates *bool

	// The target branch in the repository.
	Branch *string

	// Build properties to configure on the repository.
	BuildProperties *StaticSiteBuildProperties

	// State indicating the status of the enterprise grade CDN serving traffic to the static web app.
	EnterpriseGradeCdnStatus *EnterpriseGradeCdnStatus

	// The provider that submitted the last deployment to the primary environment of the static site.
	Provider *string

	// State indicating whether public traffic are allowed or not for a static web app. Allowed Values: 'Enabled', 'Disabled'
	// or an empty string.
	PublicNetworkAccess *string

	// A user's github repository token. This is used to setup the Github Actions workflow file and API secrets.
	RepositoryToken *string

	// URL for the repository of the static site.
	RepositoryURL *string

	// State indicating whether staging environments are allowed or not allowed for a static web app.
	StagingEnvironmentPolicy *StagingEnvironmentPolicy

	// Template options for generating a new repository.
	TemplateProperties *StaticSiteTemplateOptions

	// READ-ONLY; The content distribution endpoint for the static site.
	ContentDistributionEndpoint *string

	// READ-ONLY; The custom domains associated with this static site.
	CustomDomains []*string

	// READ-ONLY; Database connections for the static site
	DatabaseConnections []*DatabaseConnectionOverview

	// READ-ONLY; The default autogenerated hostname for the static site.
	DefaultHostname *string

	// READ-ONLY; Identity to use for Key Vault Reference authentication.
	KeyVaultReferenceIdentity *string

	// READ-ONLY; Backends linked to the static side
	LinkedBackends []*StaticSiteLinkedBackend

	// READ-ONLY; Private endpoint connections
	PrivateEndpointConnections []*ResponseMessageEnvelopeRemotePrivateEndpointConnection

	// READ-ONLY; User provided function apps registered with the static site
	UserProvidedFunctionApps []*StaticSiteUserProvidedFunctionApp
}

// StaticSiteARMResource - Static Site ARM resource.
type StaticSiteARMResource struct {
	// REQUIRED; Resource Location.
	Location *string

	// Managed service identity.
	Identity *ManagedServiceIdentity

	// Kind of resource.
	Kind *string

	// Core resource properties
	Properties *StaticSite

	// Description of a SKU for a scalable resource.
	SKU *SKUDescription

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// StaticSiteBasicAuthPropertiesARMResource - Static site basic auth properties ARM resource.
type StaticSiteBasicAuthPropertiesARMResource struct {
	// Kind of resource.
	Kind *string

	// StaticSiteBasicAuthPropertiesARMResource resource specific properties
	Properties *StaticSiteBasicAuthPropertiesARMResourceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// StaticSiteBasicAuthPropertiesARMResourceProperties - StaticSiteBasicAuthPropertiesARMResource resource specific properties
type StaticSiteBasicAuthPropertiesARMResourceProperties struct {
	// REQUIRED; State indicating if basic auth is enabled and for what environments it is active.
	ApplicableEnvironmentsMode *string

	// The list of enabled environments for Basic Auth if ApplicableEnvironmentsMode is set to SpecifiedEnvironments.
	Environments []*string

	// The password for basic auth.
	Password *string

	// Url to the secret in Key Vault.
	SecretURL *string

	// READ-ONLY; State indicating if basic auth has a secret and what type it is.
	SecretState *string
}

// StaticSiteBasicAuthPropertiesCollection - Collection of static site basic auth.
type StaticSiteBasicAuthPropertiesCollection struct {
	// REQUIRED; Collection of resources.
	Value []*StaticSiteBasicAuthPropertiesARMResource

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// StaticSiteBuildARMResource - Static Site Build ARM resource.
type StaticSiteBuildARMResource struct {
	// Kind of resource.
	Kind *string

	// StaticSiteBuildARMResource resource specific properties
	Properties *StaticSiteBuildARMResourceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// StaticSiteBuildARMResourceProperties - StaticSiteBuildARMResource resource specific properties
type StaticSiteBuildARMResourceProperties struct {
	// READ-ONLY; An identifier for the static site build.
	BuildID *string

	// READ-ONLY; When this build was created.
	CreatedTimeUTC *time.Time

	// READ-ONLY; Database connections for the static site build
	DatabaseConnections []*DatabaseConnectionOverview

	// READ-ONLY; The hostname for a static site build.
	Hostname *string

	// READ-ONLY; When this build was updated.
	LastUpdatedOn *time.Time

	// READ-ONLY; Backends linked to the static side build
	LinkedBackends []*StaticSiteLinkedBackend

	// READ-ONLY; The title of a pull request that a static site build is related to.
	PullRequestTitle *string

	// READ-ONLY; The source branch.
	SourceBranch *string

	// READ-ONLY; The status of the static site build.
	Status *BuildStatus

	// READ-ONLY; User provided function apps registered with the static site build
	UserProvidedFunctionApps []*StaticSiteUserProvidedFunctionApp
}

// StaticSiteBuildCollection - Collection of static site builds.
type StaticSiteBuildCollection struct {
	// REQUIRED; Collection of resources.
	Value []*StaticSiteBuildARMResource

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// StaticSiteBuildProperties - Build properties for the static site.
type StaticSiteBuildProperties struct {
	// A custom command to run during deployment of the Azure Functions API application.
	APIBuildCommand *string

	// The path to the api code within the repository.
	APILocation *string

	// Deprecated: The path of the app artifacts after building (deprecated in favor of OutputLocation)
	AppArtifactLocation *string

	// A custom command to run during deployment of the static content application.
	AppBuildCommand *string

	// The path to the app code within the repository.
	AppLocation *string

	// Github Action secret name override.
	GithubActionSecretNameOverride *string

	// The output path of the app after building.
	OutputLocation *string

	// Skip Github Action workflow generation.
	SkipGithubActionWorkflowGeneration *bool
}

// StaticSiteCollection - Collection of static sites.
type StaticSiteCollection struct {
	// REQUIRED; Collection of resources.
	Value []*StaticSiteARMResource

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// StaticSiteCustomDomainOverviewARMResource - Static Site Custom Domain Overview ARM resource.
type StaticSiteCustomDomainOverviewARMResource struct {
	// Kind of resource.
	Kind *string

	// StaticSiteCustomDomainOverviewARMResource resource specific properties
	Properties *StaticSiteCustomDomainOverviewARMResourceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// StaticSiteCustomDomainOverviewARMResourceProperties - StaticSiteCustomDomainOverviewARMResource resource specific properties
type StaticSiteCustomDomainOverviewARMResourceProperties struct {
	// READ-ONLY; The date and time on which the custom domain was created for the static site.
	CreatedOn *time.Time

	// READ-ONLY; The domain name for the static site custom domain.
	DomainName *string

	// READ-ONLY
	ErrorMessage *string

	// READ-ONLY; The status of the custom domain
	Status *CustomDomainStatus

	// READ-ONLY; The TXT record validation token
	ValidationToken *string
}

// StaticSiteCustomDomainOverviewCollection - Collection of static site custom domains.
type StaticSiteCustomDomainOverviewCollection struct {
	// REQUIRED; Collection of resources.
	Value []*StaticSiteCustomDomainOverviewARMResource

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// StaticSiteCustomDomainRequestPropertiesARMResource - Static Site Custom Domain Request Properties ARM resource.
type StaticSiteCustomDomainRequestPropertiesARMResource struct {
	// Kind of resource.
	Kind *string

	// StaticSiteCustomDomainRequestPropertiesARMResource resource specific properties
	Properties *StaticSiteCustomDomainRequestPropertiesARMResourceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// StaticSiteCustomDomainRequestPropertiesARMResourceProperties - StaticSiteCustomDomainRequestPropertiesARMResource resource
// specific properties
type StaticSiteCustomDomainRequestPropertiesARMResourceProperties struct {
	// Validation method for adding a custom domain
	ValidationMethod *string
}

// StaticSiteDatabaseConnectionConfigurationFileOverview - A database connection configuration file
type StaticSiteDatabaseConnectionConfigurationFileOverview struct {
	// READ-ONLY; The Base64 encoding of the file contents.
	Contents *string

	// READ-ONLY; The name of the configuration file.
	FileName *string

	// READ-ONLY; The type of configuration file.
	Type *string
}

// StaticSiteFunctionOverviewARMResource - Static Site Function Overview ARM resource.
type StaticSiteFunctionOverviewARMResource struct {
	// Kind of resource.
	Kind *string

	// StaticSiteFunctionOverviewARMResource resource specific properties
	Properties *StaticSiteFunctionOverviewARMResourceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// StaticSiteFunctionOverviewARMResourceProperties - StaticSiteFunctionOverviewARMResource resource specific properties
type StaticSiteFunctionOverviewARMResourceProperties struct {
	// READ-ONLY; The name for the function
	FunctionName *string

	// READ-ONLY; The trigger type of the function
	TriggerType *TriggerTypes
}

// StaticSiteFunctionOverviewCollection - Collection of static site functions.
type StaticSiteFunctionOverviewCollection struct {
	// REQUIRED; Collection of resources.
	Value []*StaticSiteFunctionOverviewARMResource

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// StaticSiteLinkedBackend - Static Site Linked Backend ARM resource.
type StaticSiteLinkedBackend struct {
	// The resource id of the backend linked to the static site
	BackendResourceID *string

	// The region of the backend linked to the static site
	Region *string

	// READ-ONLY; The date and time on which the backend was linked to the static site.
	CreatedOn *time.Time

	// READ-ONLY; The provisioning state of the linking process.
	ProvisioningState *string
}

// StaticSiteLinkedBackendARMResource - Static Site Linked Backend ARM resource.
type StaticSiteLinkedBackendARMResource struct {
	// Kind of resource.
	Kind *string

	// StaticSiteLinkedBackendARMResource resource specific properties
	Properties *StaticSiteLinkedBackendARMResourceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// StaticSiteLinkedBackendARMResourceProperties - StaticSiteLinkedBackendARMResource resource specific properties
type StaticSiteLinkedBackendARMResourceProperties struct {
	// The resource id of the backend linked to the static site
	BackendResourceID *string

	// The region of the backend linked to the static site
	Region *string

	// READ-ONLY; The date and time on which the backend was linked to the static site.
	CreatedOn *time.Time

	// READ-ONLY; The provisioning state of the linking process.
	ProvisioningState *string
}

// StaticSiteLinkedBackendsCollection - Collection of static site linked backends.
type StaticSiteLinkedBackendsCollection struct {
	// REQUIRED; Collection of resources.
	Value []*StaticSiteLinkedBackendARMResource

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// StaticSitePatchResource - ARM resource for a static site when patching
type StaticSitePatchResource struct {
	// Kind of resource.
	Kind *string

	// Core resource properties
	Properties *StaticSite

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// StaticSiteResetPropertiesARMResource - Static Site Reset Properties ARM resource.
type StaticSiteResetPropertiesARMResource struct {
	// Kind of resource.
	Kind *string

	// StaticSiteResetPropertiesARMResource resource specific properties
	Properties *StaticSiteResetPropertiesARMResourceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// StaticSiteResetPropertiesARMResourceProperties - StaticSiteResetPropertiesARMResource resource specific properties
type StaticSiteResetPropertiesARMResourceProperties struct {
	// The token which proves admin privileges to the repository.
	RepositoryToken *string

	// Determines whether the repository should be updated with the new properties.
	ShouldUpdateRepository *bool
}

// StaticSiteTemplateOptions - Template Options for the static site.
type StaticSiteTemplateOptions struct {
	// Description of the newly generated repository.
	Description *string

	// Whether or not the newly generated repository is a private repository. Defaults to false (i.e. public).
	IsPrivate *bool

	// Owner of the newly generated repository.
	Owner *string

	// Name of the newly generated repository.
	RepositoryName *string

	// URL of the template repository. The newly generated repository will be based on this one.
	TemplateRepositoryURL *string
}

// StaticSiteUserARMResource - Static Site User ARM resource.
type StaticSiteUserARMResource struct {
	// Kind of resource.
	Kind *string

	// StaticSiteUserARMResource resource specific properties
	Properties *StaticSiteUserARMResourceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// StaticSiteUserARMResourceProperties - StaticSiteUserARMResource resource specific properties
type StaticSiteUserARMResourceProperties struct {
	// The roles for the static site user, in free-form string format
	Roles *string

	// READ-ONLY; The display name for the static site user.
	DisplayName *string

	// READ-ONLY; The identity provider for the static site user.
	Provider *string

	// READ-ONLY; The user id for the static site user.
	UserID *string
}

// StaticSiteUserCollection - Collection of static site custom users.
type StaticSiteUserCollection struct {
	// REQUIRED; Collection of resources.
	Value []*StaticSiteUserARMResource

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// StaticSiteUserInvitationRequestResource - Static sites user roles invitation resource.
type StaticSiteUserInvitationRequestResource struct {
	// Kind of resource.
	Kind *string

	// StaticSiteUserInvitationRequestResource resource specific properties
	Properties *StaticSiteUserInvitationRequestResourceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// StaticSiteUserInvitationRequestResourceProperties - StaticSiteUserInvitationRequestResource resource specific properties
type StaticSiteUserInvitationRequestResourceProperties struct {
	// The domain name for the static site custom domain.
	Domain *string

	// The number of hours the sas token stays valid
	NumHoursToExpiration *int32

	// The identity provider for the static site user.
	Provider *string

	// The roles for the static site user, in free-form string format
	Roles *string

	// The user id for the static site user.
	UserDetails *string
}

// StaticSiteUserInvitationResponseResource - Static sites user roles invitation link resource.
type StaticSiteUserInvitationResponseResource struct {
	// Kind of resource.
	Kind *string

	// StaticSiteUserInvitationResponseResource resource specific properties
	Properties *StaticSiteUserInvitationResponseResourceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// StaticSiteUserInvitationResponseResourceProperties - StaticSiteUserInvitationResponseResource resource specific properties
type StaticSiteUserInvitationResponseResourceProperties struct {
	// READ-ONLY; The expiration time of the invitation
	ExpiresOn *time.Time

	// READ-ONLY; The url for the invitation link
	InvitationURL *string
}

// StaticSiteUserProvidedFunctionApp - A static site user provided function.
type StaticSiteUserProvidedFunctionApp struct {
	// Kind of resource.
	Kind *string

	// StaticSiteUserProvidedFunctionApp resource specific properties
	Properties *StaticSiteUserProvidedFunctionAppProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// StaticSiteUserProvidedFunctionAppARMResource - Static Site User Provided Function App ARM resource.
type StaticSiteUserProvidedFunctionAppARMResource struct {
	// Kind of resource.
	Kind *string

	// StaticSiteUserProvidedFunctionAppARMResource resource specific properties
	Properties *StaticSiteUserProvidedFunctionAppARMResourceProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// StaticSiteUserProvidedFunctionAppARMResourceProperties - StaticSiteUserProvidedFunctionAppARMResource resource specific
// properties
type StaticSiteUserProvidedFunctionAppARMResourceProperties struct {
	// The region of the function app registered with the static site
	FunctionAppRegion *string

	// The resource id of the function app registered with the static site
	FunctionAppResourceID *string

	// READ-ONLY; The date and time on which the function app was registered with the static site.
	CreatedOn *time.Time
}

// StaticSiteUserProvidedFunctionAppProperties - StaticSiteUserProvidedFunctionApp resource specific properties
type StaticSiteUserProvidedFunctionAppProperties struct {
	// The region of the function app registered with the static site
	FunctionAppRegion *string

	// The resource id of the function app registered with the static site
	FunctionAppResourceID *string

	// READ-ONLY; The date and time on which the function app was registered with the static site.
	CreatedOn *time.Time
}

// StaticSiteUserProvidedFunctionAppsCollection - Collection of static site user provided function apps.
type StaticSiteUserProvidedFunctionAppsCollection struct {
	// REQUIRED; Collection of resources.
	Value []*StaticSiteUserProvidedFunctionAppARMResource

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// StaticSiteZipDeployment - A static site zip deployment.
type StaticSiteZipDeployment struct {
	// URL for the zipped api content
	APIZipURL *string

	// URL for the zipped app content
	AppZipURL *string

	// A title to label the deployment
	DeploymentTitle *string

	// The language of the api content, if it exists
	FunctionLanguage *string

	// The provider submitting this deployment
	Provider *string
}

// StaticSiteZipDeploymentARMResource - Static site zip deployment ARM resource.
type StaticSiteZipDeploymentARMResource struct {
	// Kind of resource.
	Kind *string

	// Core resource properties
	Properties *StaticSiteZipDeployment

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// StaticSitesWorkflowPreview - Preview for the Static Site Workflow to be generated
type StaticSitesWorkflowPreview struct {
	// Kind of resource.
	Kind *string

	// StaticSitesWorkflowPreview resource specific properties
	Properties *StaticSitesWorkflowPreviewProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// StaticSitesWorkflowPreviewProperties - StaticSitesWorkflowPreview resource specific properties
type StaticSitesWorkflowPreviewProperties struct {
	// READ-ONLY; The contents for the workflow file to be generated
	Contents *string

	// READ-ONLY; The path for the workflow file to be generated
	Path *string
}

// StaticSitesWorkflowPreviewRequest - Request entity for previewing the Static Site workflow
type StaticSitesWorkflowPreviewRequest struct {
	// Kind of resource.
	Kind *string

	// StaticSitesWorkflowPreviewRequest resource specific properties
	Properties *StaticSitesWorkflowPreviewRequestProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// StaticSitesWorkflowPreviewRequestProperties - StaticSitesWorkflowPreviewRequest resource specific properties
type StaticSitesWorkflowPreviewRequestProperties struct {
	// The target branch in the repository.
	Branch *string

	// Build properties to configure on the repository.
	BuildProperties *StaticSiteBuildProperties

	// URL for the repository of the static site.
	RepositoryURL *string
}

// Status - Identify the status of the most severe insight generated by the detector.
type Status struct {
	// Descriptive message.
	Message *string

	// Level of the most severe insight generated by the detector.
	StatusID *InsightStatus
}

// StatusCodesBasedTrigger - Trigger based on status code.
type StatusCodesBasedTrigger struct {
	// Request Count.
	Count *int32

	// Request Path
	Path *string

	// HTTP status code.
	Status *int32

	// Request Sub Status.
	SubStatus *int32

	// Time interval.
	TimeInterval *string

	// Win32 error code.
	Win32Status *int32
}

// StatusCodesRangeBasedTrigger - Trigger based on range of status codes.
type StatusCodesRangeBasedTrigger struct {
	// Request Count.
	Count *int32
	Path  *string

	// HTTP status code.
	StatusCodes *string

	// Time interval.
	TimeInterval *string
}

// StorageMigrationOptions - Options for app content migration.
type StorageMigrationOptions struct {
	// Kind of resource.
	Kind *string

	// StorageMigrationOptions resource specific properties
	Properties *StorageMigrationOptionsProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// StorageMigrationOptionsProperties - StorageMigrationOptions resource specific properties
type StorageMigrationOptionsProperties struct {
	// REQUIRED; AzureFiles connection string.
	AzurefilesConnectionString *string

	// REQUIRED; AzureFiles share.
	AzurefilesShare *string

	// true if the app should be read only during copy operation; otherwise, false.
	BlockWriteAccessToSite *bool

	// trueif the app should be switched over; otherwise, false.
	SwitchSiteAfterMigration *bool
}

// StorageMigrationResponse - Response for a migration of app content request.
type StorageMigrationResponse struct {
	// Kind of resource.
	Kind *string

	// StorageMigrationResponse resource specific properties
	Properties *StorageMigrationResponseProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// StorageMigrationResponseProperties - StorageMigrationResponse resource specific properties
type StorageMigrationResponseProperties struct {
	// READ-ONLY; When server starts the migration process, it will return an operation ID identifying that particular migration
	// operation.
	OperationID *string
}

// StringDictionary - String dictionary resource.
type StringDictionary struct {
	// Kind of resource.
	Kind *string

	// Settings.
	Properties map[string]*string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// StringList - String list resource.
type StringList struct {
	// Kind of resource.
	Kind *string

	// List of string resources.
	Properties []*string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SubResource - The sub resource type.
type SubResource struct {
	// READ-ONLY; The resource id.
	ID *string
}

// SupportTopic - Defines a unique Support Topic
type SupportTopic struct {
	// READ-ONLY; Support Topic Id
	ID *string

	// READ-ONLY; Unique resource Id
	PesID *string
}

// SwiftVirtualNetwork - Swift Virtual Network Contract. This is used to enable the new Swift way of doing virtual network
// integration.
type SwiftVirtualNetwork struct {
	// Kind of resource.
	Kind *string

	// SwiftVirtualNetwork resource specific properties
	Properties *SwiftVirtualNetworkProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SwiftVirtualNetworkProperties - SwiftVirtualNetwork resource specific properties
type SwiftVirtualNetworkProperties struct {
	// The Virtual Network subnet's resource ID. This is the subnet that this Web App will join. This subnet must have a delegation
	// to Microsoft.Web/serverFarms defined first.
	SubnetResourceID *string

	// A flag that specifies if the scale unit this Web App is on supports Swift integration.
	SwiftSupported *bool
}

// Template - Container App versioned application definition. Defines the desired state of an immutable revision. Any changes
// to this section Will result in a new revision being created
type Template struct {
	// List of container definitions for the Container App.
	Containers []*Container

	// Dapr configuration for the Container App.
	Dapr *Dapr

	// User friendly suffix that is appended to the revision name
	RevisionSuffix *string

	// Scaling properties for the Container App.
	Scale *Scale
}

// TldLegalAgreement - Legal agreement for a top level domain.
type TldLegalAgreement struct {
	// REQUIRED; Unique identifier for the agreement.
	AgreementKey *string

	// REQUIRED; Agreement details.
	Content *string

	// REQUIRED; Agreement title.
	Title *string

	// URL where a copy of the agreement details is hosted.
	URL *string
}

// TldLegalAgreementCollection - Collection of top-level domain legal agreements.
type TldLegalAgreementCollection struct {
	// REQUIRED; Collection of resources.
	Value []*TldLegalAgreement

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// TokenStore - The configuration settings of the token store.
type TokenStore struct {
	// The configuration settings of the storage of the tokens if blob storage is used.
	AzureBlobStorage *BlobStorageTokenStore

	// true to durably store platform-specific security tokens that are obtained during login flows; otherwise, false. The default
	// is false.
	Enabled *bool

	// The configuration settings of the storage of the tokens if a file system is used.
	FileSystem *FileSystemTokenStore

	// The number of hours after session token expiration that a session token can be used to call the token refresh API. The
	// default is 72 hours.
	TokenRefreshExtensionHours *float64
}

// TopLevelDomain - A top level domain object.
type TopLevelDomain struct {
	// Kind of resource.
	Kind *string

	// TopLevelDomain resource specific properties
	Properties *TopLevelDomainProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// TopLevelDomainAgreementOption - Options for retrieving the list of top level domain legal agreements.
type TopLevelDomainAgreementOption struct {
	// If true, then the list of agreements will include agreements for domain transfer as well; otherwise, false.
	ForTransfer *bool

	// If true, then the list of agreements will include agreements for domain privacy as well; otherwise, false.
	IncludePrivacy *bool
}

// TopLevelDomainCollection - Collection of Top-level domains.
type TopLevelDomainCollection struct {
	// REQUIRED; Collection of resources.
	Value []*TopLevelDomain

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// TopLevelDomainProperties - TopLevelDomain resource specific properties
type TopLevelDomainProperties struct {
	// If true, then the top level domain supports domain privacy; otherwise, false.
	Privacy *bool
}

// TrafficWeight - Traffic weight assigned to a revision
type TrafficWeight struct {
	// Indicates that the traffic weight belongs to a latest stable revision
	LatestRevision *bool

	// Name of a revision
	RevisionName *string

	// Traffic weight assigned to a revision
	Weight *int32
}

// TriggeredJobHistory - Triggered Web Job History. List of Triggered Web Job Run Information elements.
type TriggeredJobHistory struct {
	// Kind of resource.
	Kind *string

	// TriggeredJobHistory resource specific properties
	Properties *TriggeredJobHistoryProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// TriggeredJobHistoryCollection - Collection of Kudu continuous web job information elements.
type TriggeredJobHistoryCollection struct {
	// REQUIRED; Collection of resources.
	Value []*TriggeredJobHistory

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// TriggeredJobHistoryProperties - TriggeredJobHistory resource specific properties
type TriggeredJobHistoryProperties struct {
	// List of triggered web job runs.
	Runs []*TriggeredJobRun
}

// TriggeredJobRun - Triggered Web Job Run Information.
type TriggeredJobRun struct {
	// Job duration.
	Duration *string

	// End time.
	EndTime *time.Time

	// Error URL.
	ErrorURL *string

	// Job name.
	JobName *string

	// Output URL.
	OutputURL *string

	// Start time.
	StartTime *time.Time

	// Job status.
	Status *TriggeredWebJobStatus

	// Job trigger.
	Trigger *string

	// Job URL.
	URL *string

	// Job ID.
	WebJobID *string

	// Job name.
	WebJobName *string
}

// TriggeredWebJob - Triggered Web Job Information.
type TriggeredWebJob struct {
	// Kind of resource.
	Kind *string

	// TriggeredWebJob resource specific properties
	Properties *TriggeredWebJobProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// TriggeredWebJobCollection - Collection of Kudu continuous web job information elements.
type TriggeredWebJobCollection struct {
	// REQUIRED; Collection of resources.
	Value []*TriggeredWebJob

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// TriggeredWebJobProperties - TriggeredWebJob resource specific properties
type TriggeredWebJobProperties struct {
	// Error information.
	Error *string

	// Extra Info URL.
	ExtraInfoURL *string

	// History URL.
	HistoryURL *string

	// Latest job run information.
	LatestRun *TriggeredJobRun

	// Property to allow or block all public traffic. Allowed Values: 'Enabled', 'Disabled' or an empty string.
	PublicNetworkAccess *string

	// Run command.
	RunCommand *string

	// Scheduler Logs URL.
	SchedulerLogsURL *string

	// Job settings.
	Settings map[string]any

	// Checks if Customer provided storage account is required
	StorageAccountRequired *bool

	// Job URL.
	URL *string

	// Using SDK?
	UsingSdk *bool

	// Job type.
	WebJobType *WebJobType
}

// Twitter - The configuration settings of the Twitter provider.
type Twitter struct {
	// false if the Twitter provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool

	// The configuration settings of the app registration for the Twitter provider.
	Registration *TwitterRegistration
}

// TwitterRegistration - The configuration settings of the app registration for the Twitter provider.
type TwitterRegistration struct {
	// The OAuth 1.0a consumer key of the Twitter application used for sign-in. This setting is required for enabling Twitter
	// Sign-In. Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
	ConsumerKey *string

	// The app setting name that contains the OAuth 1.0a consumer secret of the Twitter application used for sign-in.
	ConsumerSecretSettingName *string
}

// Usage of the quota resource.
type Usage struct {
	// Kind of resource.
	Kind *string

	// Usage resource specific properties
	Properties *UsageProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// UsageCollection - Collection of usages.
type UsageCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Usage

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// UsageProperties - Usage resource specific properties
type UsageProperties struct {
	// READ-ONLY; Compute mode used for this usage.
	ComputeMode *ComputeModeOptions

	// READ-ONLY; The current value of the resource counter.
	CurrentValue *int64

	// READ-ONLY; Friendly name shown in the UI.
	DisplayName *string

	// READ-ONLY; The resource limit.
	Limit *int64

	// READ-ONLY; Next reset time for the resource counter.
	NextResetTime *time.Time

	// READ-ONLY; Name of the quota resource.
	ResourceName *string

	// READ-ONLY; Site mode used for this usage.
	SiteMode *string

	// READ-ONLY; Units of measurement for the quota resource.
	Unit *string
}

// User credentials used for publishing activity.
type User struct {
	// Kind of resource.
	Kind *string

	// User resource specific properties
	Properties *UserProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// UserAssignedIdentity - User Assigned identity.
type UserAssignedIdentity struct {
	// READ-ONLY; Client Id of user assigned identity
	ClientID *string

	// READ-ONLY; Principal Id of user assigned identity
	PrincipalID *string
}

// UserProperties - User resource specific properties
type UserProperties struct {
	// REQUIRED; Username used for publishing.
	PublishingUserName *string

	// Password used for publishing.
	PublishingPassword *string

	// Password hash used for publishing.
	PublishingPasswordHash *string

	// Password hash salt used for publishing.
	PublishingPasswordHashSalt *string

	// Url of SCM site.
	ScmURI *string
}

// ValidateProperties - App properties used for validation.
type ValidateProperties struct {
	// App Service Environment Properties
	AppServiceEnvironment *Environment

	// Target capacity of the App Service plan (number of VMs).
	Capacity *int32

	// Platform (windows or linux)
	ContainerImagePlatform *string

	// Repository name (image name)
	ContainerImageRepository *string

	// Image tag
	ContainerImageTag *string

	// Base URL of the container registry
	ContainerRegistryBaseURL *string

	// Password for to access the container registry
	ContainerRegistryPassword *string

	// Username for to access the container registry
	ContainerRegistryUsername *string

	// Name of App Service Environment where app or App Service plan should be created.
	HostingEnvironment *string

	// true if App Service plan is for Spot instances; otherwise, false.
	IsSpot *bool

	// true if App Service plan is running as a windows container
	IsXenon *bool

	// true if App Service plan is for Linux workers; otherwise, false.
	NeedLinuxWorkers *bool

	// Name of the target SKU for the App Service plan.
	SKUName *string

	// ARM resource ID of an App Service plan that would host the app.
	ServerFarmID *string
}

// ValidateRequest - Resource validation request content.
type ValidateRequest struct {
	// REQUIRED; Expected location of the resource.
	Location *string

	// REQUIRED; Resource name to verify.
	Name *string

	// REQUIRED; Properties of the resource to validate.
	Properties *ValidateProperties

	// REQUIRED; Resource type used for verification.
	Type *ValidateResourceTypes
}

// ValidateResponse - Describes the result of resource validation.
type ValidateResponse struct {
	// Error details for the case when validation fails.
	Error *ValidateResponseError

	// Result of validation.
	Status *string
}

// ValidateResponseError - Error details for when validation fails.
type ValidateResponseError struct {
	// Validation error code.
	Code *string

	// Validation error message.
	Message *string
}

// VirtualApplication - Virtual application in an app.
type VirtualApplication struct {
	// Physical path.
	PhysicalPath *string

	// true if preloading is enabled; otherwise, false.
	PreloadEnabled *bool

	// Virtual directories for virtual application.
	VirtualDirectories []*VirtualDirectory

	// Virtual path.
	VirtualPath *string
}

// VirtualDirectory - Directory for virtual application.
type VirtualDirectory struct {
	// Physical path.
	PhysicalPath *string

	// Path to virtual application.
	VirtualPath *string
}

// VirtualIPMapping - Virtual IP mapping.
type VirtualIPMapping struct {
	// Is virtual IP mapping in use.
	InUse *bool

	// Internal HTTP port.
	InternalHTTPPort *int32

	// Internal HTTPS port.
	InternalHTTPSPort *int32

	// name of the service that virtual IP is assigned to
	ServiceName *string

	// Virtual IP address.
	VirtualIP *string
}

// VirtualNetworkProfile - Specification for using a Virtual Network.
type VirtualNetworkProfile struct {
	// REQUIRED; Resource id of the Virtual Network.
	ID *string

	// Subnet within the Virtual Network.
	Subnet *string

	// READ-ONLY; Name of the Virtual Network (read-only).
	Name *string

	// READ-ONLY; Resource type of the Virtual Network (read-only).
	Type *string
}

// VnetGateway - The Virtual Network gateway contract. This is used to give the Virtual Network gateway access to the VPN
// package.
type VnetGateway struct {
	// Kind of resource.
	Kind *string

	// VnetGateway resource specific properties
	Properties *VnetGatewayProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// VnetGatewayProperties - VnetGateway resource specific properties
type VnetGatewayProperties struct {
	// REQUIRED; The URI where the VPN package can be downloaded.
	VPNPackageURI *string

	// The Virtual Network name.
	VnetName *string
}

// VnetInfo - Virtual Network information contract.
type VnetInfo struct {
	// A certificate file (.cer) blob containing the public key of the private key used to authenticate a Point-To-Site VPN connection.
	CertBlob *string

	// DNS servers to be used by this Virtual Network. This should be a comma-separated list of IP addresses.
	DNSServers *string

	// Flag that is used to denote if this is VNET injection
	IsSwift *bool

	// The Virtual Network's resource ID.
	VnetResourceID *string

	// READ-ONLY; The client certificate thumbprint.
	CertThumbprint *string

	// READ-ONLY; true if a resync is required; otherwise, false.
	ResyncRequired *bool

	// READ-ONLY; The routes that this Virtual Network connection uses.
	Routes []*VnetRoute
}

// VnetInfoResource - Virtual Network information ARM resource.
type VnetInfoResource struct {
	// Kind of resource.
	Kind *string

	// Core resource properties
	Properties *VnetInfo

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// VnetParameters - The required set of inputs to validate a VNET
type VnetParameters struct {
	// Kind of resource.
	Kind *string

	// VnetParameters resource specific properties
	Properties *VnetParametersProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// VnetParametersProperties - VnetParameters resource specific properties
type VnetParametersProperties struct {
	// The ARM Resource ID of the subnet to validate
	SubnetResourceID *string

	// The name of the VNET to be validated
	VnetName *string

	// The Resource Group of the VNET to be validated
	VnetResourceGroup *string

	// The subnet name to be validated
	VnetSubnetName *string
}

// VnetRoute - Virtual Network route contract used to pass routing information for a Virtual Network.
type VnetRoute struct {
	// Kind of resource.
	Kind *string

	// VnetRoute resource specific properties
	Properties *VnetRouteProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// VnetRouteProperties - VnetRoute resource specific properties
type VnetRouteProperties struct {
	// The ending address for this route. If the start address is specified in CIDR notation, this must be omitted.
	EndAddress *string

	// The type of route this is: DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
	// INHERITED - Routes inherited from the real Virtual Network routes STATIC - Static
	// route set on the app only
	// These values will be used for syncing an app's routes with those from a Virtual Network.
	RouteType *RouteType

	// The starting address for this route. This may also include a CIDR notation, in which case the end address must not be specified.
	StartAddress *string
}

// VnetValidationFailureDetails - A class that describes the reason for a validation failure.
type VnetValidationFailureDetails struct {
	// Kind of resource.
	Kind *string

	// VnetValidationFailureDetails resource specific properties
	Properties *VnetValidationFailureDetailsProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// VnetValidationFailureDetailsProperties - VnetValidationFailureDetails resource specific properties
type VnetValidationFailureDetailsProperties struct {
	// A flag describing whether or not validation failed.
	Failed *bool

	// A list of tests that failed in the validation.
	FailedTests []*VnetValidationTestFailure

	// Text describing the validation outcome.
	Message *string

	// A list of warnings generated during validation.
	Warnings []*VnetValidationTestFailure
}

// VnetValidationTestFailure - A class that describes a test that failed during NSG and UDR validation.
type VnetValidationTestFailure struct {
	// Kind of resource.
	Kind *string

	// VnetValidationTestFailure resource specific properties
	Properties *VnetValidationTestFailureProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// VnetValidationTestFailureProperties - VnetValidationTestFailure resource specific properties
type VnetValidationTestFailureProperties struct {
	// The details of what caused the failure, e.g. the blocking rule name, etc.
	Details *string

	// The name of the test that failed.
	TestName *string
}

// WebAppCollection - Collection of App Service apps.
type WebAppCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Site

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// WebAppInstanceStatusCollection - Collection of app instances.
type WebAppInstanceStatusCollection struct {
	// REQUIRED; Collection of resources.
	Value []*WebSiteInstanceStatus

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// WebAppMajorVersion - Web App stack major version.
type WebAppMajorVersion struct {
	// READ-ONLY; Web App stack major version (display only).
	DisplayText *string

	// READ-ONLY; Minor versions associated with the major version.
	MinorVersions []*WebAppMinorVersion

	// READ-ONLY; Web App stack major version name.
	Value *string
}

// WebAppMinorVersion - Web App stack minor version.
type WebAppMinorVersion struct {
	// READ-ONLY; Web App stack minor version (display only).
	DisplayText *string

	// READ-ONLY; Settings associated with the minor version.
	StackSettings *WebAppRuntimes

	// READ-ONLY; Web App stack major version name.
	Value *string
}

// WebAppRuntimeSettings - Web App runtime settings.
type WebAppRuntimeSettings struct {
	// READ-ONLY; Application Insights settings associated with the minor version.
	AppInsightsSettings *AppInsightsWebAppStackSettings

	// READ-ONLY; End-of-life date for the minor version.
	EndOfLifeDate *time.Time

	// READ-ONLY; GitHub Actions settings associated with the minor version.
	GitHubActionSettings *GitHubActionWebAppStackSettings

	// READ-ONLY; true if the stack version is auto-updated; otherwise, false.
	IsAutoUpdate *bool

	// READ-ONLY; true if the stack is deprecated; otherwise, false.
	IsDeprecated *bool

	// READ-ONLY; true if the minor version is early-access; otherwise, false.
	IsEarlyAccess *bool

	// READ-ONLY; true if the stack should be hidden; otherwise, false.
	IsHidden *bool

	// READ-ONLY; true if the stack is in preview; otherwise, false.
	IsPreview *bool

	// READ-ONLY; true if remote debugging is supported for the stack; otherwise, false.
	RemoteDebuggingSupported *bool

	// READ-ONLY; Web App stack minor version (runtime only).
	RuntimeVersion *string
}

// WebAppRuntimes - Web App stack runtimes.
type WebAppRuntimes struct {
	// READ-ONLY; Linux-specific settings associated with the Java container minor version.
	LinuxContainerSettings *LinuxJavaContainerSettings

	// READ-ONLY; Linux-specific settings associated with the minor version.
	LinuxRuntimeSettings *WebAppRuntimeSettings

	// READ-ONLY; Windows-specific settings associated with the Java container minor version.
	WindowsContainerSettings *WindowsJavaContainerSettings

	// READ-ONLY; Windows-specific settings associated with the minor version.
	WindowsRuntimeSettings *WebAppRuntimeSettings
}

// WebAppStack - Web App stack.
type WebAppStack struct {
	// Kind of resource.
	Kind *string

	// WebAppStack resource specific properties
	Properties *WebAppStackProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Web App stack location.
	Location *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// WebAppStackCollection - Collection of Web app Stacks
type WebAppStackCollection struct {
	// REQUIRED; Collection of resources.
	Value []*WebAppStack

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// WebAppStackProperties - WebAppStack resource specific properties
type WebAppStackProperties struct {
	// READ-ONLY; Web App stack (display only).
	DisplayText *string

	// READ-ONLY; List of major versions available.
	MajorVersions []*WebAppMajorVersion

	// READ-ONLY; Web App stack preferred OS.
	PreferredOs *StackPreferredOs

	// READ-ONLY; Web App stack name.
	Value *string
}

// WebJob - Web Job Information.
type WebJob struct {
	// Kind of resource.
	Kind *string

	// WebJob resource specific properties
	Properties *WebJobProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// WebJobCollection - Collection of Kudu web job information elements.
type WebJobCollection struct {
	// REQUIRED; Collection of resources.
	Value []*WebJob

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// WebJobProperties - WebJob resource specific properties
type WebJobProperties struct {
	// Error information.
	Error *string

	// Extra Info URL.
	ExtraInfoURL *string

	// Run command.
	RunCommand *string

	// Job settings.
	Settings map[string]any

	// Job URL.
	URL *string

	// Using SDK?
	UsingSdk *bool

	// Job type.
	WebJobType *WebJobType
}

type WebSiteInstanceStatus struct {
	// Kind of resource.
	Kind *string

	// WebSiteInstanceStatus resource specific properties
	Properties *WebSiteInstanceStatusProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// WebSiteInstanceStatusProperties - WebSiteInstanceStatus resource specific properties
type WebSiteInstanceStatusProperties struct {
	// Link to the console to web app instance
	ConsoleURL *string

	// Dictionary of
	Containers map[string]*ContainerInfo

	// Link to the Diagnose and Solve Portal
	DetectorURL *string

	// Link to the console to web app instance
	HealthCheckURL *string
	State          *SiteRuntimeState

	// Link to the GetStatusApi in Kudu
	StatusURL *string
}

// WindowsJavaContainerSettings - Windows Java Container settings.
type WindowsJavaContainerSettings struct {
	// READ-ONLY; End-of-life date for the minor version.
	EndOfLifeDate *time.Time

	// READ-ONLY; true if the stack version is auto-updated; otherwise, false.
	IsAutoUpdate *bool

	// READ-ONLY; true if the stack is deprecated; otherwise, false.
	IsDeprecated *bool

	// READ-ONLY; true if the minor version is early-access; otherwise, false.
	IsEarlyAccess *bool

	// READ-ONLY; true if the stack should be hidden; otherwise, false.
	IsHidden *bool

	// READ-ONLY; true if the stack is in preview; otherwise, false.
	IsPreview *bool

	// READ-ONLY; Java container (runtime only).
	JavaContainer *string

	// READ-ONLY; Java container version (runtime only).
	JavaContainerVersion *string
}

// WorkerPool - Worker pool of an App Service Environment.
type WorkerPool struct {
	// Shared or dedicated app hosting.
	ComputeMode *ComputeModeOptions

	// Number of instances in the worker pool.
	WorkerCount *int32

	// VM size of the worker pool instances.
	WorkerSize *string

	// Worker size ID for referencing this worker pool.
	WorkerSizeID *int32

	// READ-ONLY; Names of all instances in the worker pool (read only).
	InstanceNames []*string
}

// WorkerPoolCollection - Collection of worker pools.
type WorkerPoolCollection struct {
	// REQUIRED; Collection of resources.
	Value []*WorkerPoolResource

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// WorkerPoolResource - Worker pool of an App Service Environment ARM resource.
type WorkerPoolResource struct {
	// Kind of resource.
	Kind *string

	// Core resource properties
	Properties *WorkerPool

	// Description of a SKU for a scalable resource.
	SKU *SKUDescription

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource Name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// Workflow - The workflow type.
type Workflow struct {
	// Managed service identity.
	Identity *ManagedServiceIdentity

	// The resource location.
	Location *string

	// The workflow properties.
	Properties *WorkflowProperties

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// WorkflowArtifacts - The workflow filter.
type WorkflowArtifacts struct {
	// Application settings of the workflow.
	AppSettings any

	// Files of the app.
	Files map[string]any

	// Files of the app to delete.
	FilesToDelete []*string
}

// WorkflowEnvelope - Workflow properties definition.
type WorkflowEnvelope struct {
	// The resource kind.
	Kind *string

	// The resource location.
	Location *string

	// Additional workflow properties.
	Properties *WorkflowEnvelopeProperties

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// WorkflowEnvelopeCollection - Collection of Kudu workflow information elements.
type WorkflowEnvelopeCollection struct {
	// REQUIRED; Collection of resources.
	Value []*WorkflowEnvelope

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// WorkflowEnvelopeProperties - Additional workflow properties.
type WorkflowEnvelopeProperties struct {
	// Gets or sets the files.
	Files map[string]any

	// Gets or sets the state of the workflow.
	FlowState *WorkflowState

	// Gets or sets workflow health.
	Health *WorkflowHealth
}

// WorkflowFilter - The workflow filter.
type WorkflowFilter struct {
	// The state of workflows.
	State *WorkflowState
}

// WorkflowHealth - Represents the workflow health.
type WorkflowHealth struct {
	// REQUIRED; Gets or sets the workflow health state.
	State *WorkflowHealthState

	// Gets or sets the workflow error.
	Error *ErrorEntity
}

// WorkflowListResult - The list of workflows.
type WorkflowListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// The list of workflows.
	Value []*Workflow
}

// WorkflowOutputParameter - The workflow output parameter.
type WorkflowOutputParameter struct {
	// The description.
	Description *string

	// The metadata.
	Metadata any

	// The type.
	Type *ParameterType

	// The value.
	Value any

	// READ-ONLY; Gets the error.
	Error any
}

// WorkflowParameter - The workflow parameters.
type WorkflowParameter struct {
	// The description.
	Description *string

	// The metadata.
	Metadata any

	// The type.
	Type *ParameterType

	// The value.
	Value any
}

// WorkflowProperties - The workflow properties.
type WorkflowProperties struct {
	// The access control configuration.
	AccessControl *FlowAccessControlConfiguration

	// The definition.
	Definition any

	// The endpoints configuration.
	EndpointsConfiguration *FlowEndpointsConfiguration

	// The integration account.
	IntegrationAccount *ResourceReference

	// The integration service environment.
	IntegrationServiceEnvironment *ResourceReference

	// The workflow kind.
	Kind *Kind

	// The parameters.
	Parameters map[string]*WorkflowParameter

	// The state.
	State *WorkflowState

	// READ-ONLY; Gets the access endpoint.
	AccessEndpoint *string

	// READ-ONLY; Gets the changed time.
	ChangedTime *time.Time

	// READ-ONLY; Gets the created time.
	CreatedTime *time.Time

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *WorkflowProvisioningState

	// READ-ONLY; The sku.
	SKU *WorkflowSKU

	// READ-ONLY; Gets the version.
	Version *string
}

// WorkflowResource - The base resource type.
type WorkflowResource struct {
	// The resource location.
	Location *string

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// WorkflowRun - The workflow run.
type WorkflowRun struct {
	// The workflow run properties.
	Properties *WorkflowRunProperties

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the workflow run name.
	Name *string

	// READ-ONLY; Gets the workflow run type.
	Type *string
}

// WorkflowRunAction - The workflow run action.
type WorkflowRunAction struct {
	// The workflow run action properties.
	Properties *WorkflowRunActionProperties

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the workflow run action name.
	Name *string

	// READ-ONLY; Gets the workflow run action type.
	Type *string
}

// WorkflowRunActionFilter - The workflow run action filter.
type WorkflowRunActionFilter struct {
	// The status of workflow run action.
	Status *WorkflowStatus
}

// WorkflowRunActionListResult - The list of workflow run actions.
type WorkflowRunActionListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of workflow run actions.
	Value []*WorkflowRunAction
}

// WorkflowRunActionProperties - The workflow run action properties.
type WorkflowRunActionProperties struct {
	// The correlation properties.
	Correlation *RunActionCorrelation

	// Gets the retry histories.
	RetryHistory []*RetryHistory

	// READ-ONLY; Gets the code.
	Code *string

	// READ-ONLY; Gets the end time.
	EndTime *time.Time

	// READ-ONLY; Gets the error.
	Error any

	// READ-ONLY; Gets the link to inputs.
	InputsLink *ContentLink

	// READ-ONLY; Gets the link to outputs.
	OutputsLink *ContentLink

	// READ-ONLY; Gets the start time.
	StartTime *time.Time

	// READ-ONLY; Gets the status.
	Status *WorkflowStatus

	// READ-ONLY; Gets the tracked properties.
	TrackedProperties any

	// READ-ONLY; Gets the tracking id.
	TrackingID *string
}

// WorkflowRunActionRepetitionDefinition - The workflow run action repetition definition.
type WorkflowRunActionRepetitionDefinition struct {
	// REQUIRED; The workflow run action repetition properties definition.
	Properties *WorkflowRunActionRepetitionProperties

	// The resource location.
	Location *string

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// WorkflowRunActionRepetitionDefinitionCollection - A collection of workflow run action repetitions.
type WorkflowRunActionRepetitionDefinitionCollection struct {
	// The link used to get the next page of recommendations.
	NextLink *string
	Value    []*WorkflowRunActionRepetitionDefinition
}

// WorkflowRunActionRepetitionProperties - The workflow run action repetition properties definition.
type WorkflowRunActionRepetitionProperties struct {
	// The workflow scope repetition code.
	Code *string

	// The correlation properties.
	Correlation *RunActionCorrelation

	// The end time of the workflow scope repetition.
	EndTime *time.Time

	// Anything
	Error          any
	IterationCount *int32

	// The repetition indexes.
	RepetitionIndexes []*RepetitionIndex

	// Gets the retry histories.
	RetryHistory []*RetryHistory

	// The start time of the workflow scope repetition.
	StartTime *time.Time

	// The status of the workflow scope repetition.
	Status *WorkflowStatus

	// READ-ONLY; Gets the inputs.
	Inputs any

	// READ-ONLY; Gets the link to inputs.
	InputsLink *ContentLink

	// READ-ONLY; Gets the outputs.
	Outputs any

	// READ-ONLY; Gets the link to outputs.
	OutputsLink *ContentLink

	// READ-ONLY; Gets the tracked properties.
	TrackedProperties any

	// READ-ONLY; Gets the tracking id.
	TrackingID *string
}

// WorkflowRunFilter - The workflow run filter.
type WorkflowRunFilter struct {
	// The status of workflow run.
	Status *WorkflowStatus
}

// WorkflowRunListResult - The list of workflow runs.
type WorkflowRunListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of workflow runs.
	Value []*WorkflowRun
}

// WorkflowRunProperties - The workflow run properties.
type WorkflowRunProperties struct {
	// The run correlation.
	Correlation *Correlation

	// READ-ONLY; Gets the code.
	Code *string

	// READ-ONLY; Gets the correlation id.
	CorrelationID *string

	// READ-ONLY; Gets the end time.
	EndTime *time.Time

	// READ-ONLY; Gets the error.
	Error any

	// READ-ONLY; Gets the outputs.
	Outputs map[string]*WorkflowOutputParameter

	// READ-ONLY; Gets the response of the flow run.
	Response *WorkflowRunTrigger

	// READ-ONLY; Gets the start time.
	StartTime *time.Time

	// READ-ONLY; Gets the status.
	Status *WorkflowStatus

	// READ-ONLY; Gets the fired trigger.
	Trigger *WorkflowRunTrigger

	// READ-ONLY; Gets the wait end time.
	WaitEndTime *time.Time

	// READ-ONLY; Gets the reference to workflow version.
	Workflow *ResourceReference
}

// WorkflowRunTrigger - The workflow run trigger.
type WorkflowRunTrigger struct {
	// The run correlation.
	Correlation *Correlation

	// READ-ONLY; Gets the code.
	Code *string

	// READ-ONLY; Gets the end time.
	EndTime *time.Time

	// READ-ONLY; Gets the error.
	Error any

	// READ-ONLY; Gets the inputs.
	Inputs any

	// READ-ONLY; Gets the link to inputs.
	InputsLink *ContentLink

	// READ-ONLY; Gets the name.
	Name *string

	// READ-ONLY; Gets the outputs.
	Outputs any

	// READ-ONLY; Gets the link to outputs.
	OutputsLink *ContentLink

	// READ-ONLY; Gets the scheduled time.
	ScheduledTime *time.Time

	// READ-ONLY; Gets the start time.
	StartTime *time.Time

	// READ-ONLY; Gets the status.
	Status *WorkflowStatus

	// READ-ONLY; Gets the tracked properties.
	TrackedProperties any

	// READ-ONLY; Gets the tracking id.
	TrackingID *string
}

// WorkflowSKU - The sku type.
type WorkflowSKU struct {
	// REQUIRED; The name.
	Name *WorkflowSKUName

	// The reference to plan.
	Plan *ResourceReference
}

// WorkflowTrigger - The workflow trigger.
type WorkflowTrigger struct {
	// The workflow trigger properties.
	Properties *WorkflowTriggerProperties

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the workflow trigger name.
	Name *string

	// READ-ONLY; Gets the workflow trigger type.
	Type *string
}

// WorkflowTriggerCallbackURL - The workflow trigger callback URL.
type WorkflowTriggerCallbackURL struct {
	// Gets the workflow trigger callback URL query parameters.
	Queries *WorkflowTriggerListCallbackURLQueries

	// Gets the workflow trigger callback URL relative path parameters.
	RelativePathParameters []*string

	// READ-ONLY; Gets the workflow trigger callback URL base path.
	BasePath *string

	// READ-ONLY; Gets the workflow trigger callback URL HTTP method.
	Method *string

	// READ-ONLY; Gets the workflow trigger callback URL relative path.
	RelativePath *string

	// READ-ONLY; Gets the workflow trigger callback URL.
	Value *string
}

// WorkflowTriggerFilter - The workflow trigger filter.
type WorkflowTriggerFilter struct {
	// The state of workflow trigger.
	State *WorkflowState
}

// WorkflowTriggerHistory - The workflow trigger history.
type WorkflowTriggerHistory struct {
	// Gets the workflow trigger history properties.
	Properties *WorkflowTriggerHistoryProperties

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the workflow trigger history name.
	Name *string

	// READ-ONLY; Gets the workflow trigger history type.
	Type *string
}

// WorkflowTriggerHistoryFilter - The workflow trigger history filter.
type WorkflowTriggerHistoryFilter struct {
	// The status of workflow trigger history.
	Status *WorkflowStatus
}

// WorkflowTriggerHistoryListResult - The list of workflow trigger histories.
type WorkflowTriggerHistoryListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of workflow trigger histories.
	Value []*WorkflowTriggerHistory
}

// WorkflowTriggerHistoryProperties - The workflow trigger history properties.
type WorkflowTriggerHistoryProperties struct {
	// The run correlation.
	Correlation *Correlation

	// READ-ONLY; Gets the code.
	Code *string

	// READ-ONLY; Gets the end time.
	EndTime *time.Time

	// READ-ONLY; Gets the error.
	Error any

	// READ-ONLY; The value indicating whether trigger was fired.
	Fired *bool

	// READ-ONLY; Gets the link to input parameters.
	InputsLink *ContentLink

	// READ-ONLY; Gets the link to output parameters.
	OutputsLink *ContentLink

	// READ-ONLY; Gets the reference to workflow run.
	Run *ResourceReference

	// READ-ONLY; The scheduled time.
	ScheduledTime *time.Time

	// READ-ONLY; Gets the start time.
	StartTime *time.Time

	// READ-ONLY; Gets the status.
	Status *WorkflowStatus

	// READ-ONLY; Gets the tracking id.
	TrackingID *string
}

// WorkflowTriggerListCallbackURLQueries - Gets the workflow trigger callback URL query parameters.
type WorkflowTriggerListCallbackURLQueries struct {
	// The api version.
	APIVersion *string

	// The SAS timestamp.
	Se *string

	// The SAS signature.
	Sig *string

	// The SAS permissions.
	Sp *string

	// The SAS version.
	Sv *string
}

// WorkflowTriggerListResult - The list of workflow triggers.
type WorkflowTriggerListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of workflow triggers.
	Value []*WorkflowTrigger
}

// WorkflowTriggerProperties - The workflow trigger properties.
type WorkflowTriggerProperties struct {
	// READ-ONLY; Gets the changed time.
	ChangedTime *time.Time

	// READ-ONLY; Gets the created time.
	CreatedTime *time.Time

	// READ-ONLY; Gets the last execution time.
	LastExecutionTime *time.Time

	// READ-ONLY; Gets the next execution time.
	NextExecutionTime *time.Time

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *WorkflowTriggerProvisioningState

	// READ-ONLY; Gets the workflow trigger recurrence.
	Recurrence *WorkflowTriggerRecurrence

	// READ-ONLY; Gets the state.
	State *WorkflowState

	// READ-ONLY; Gets the status.
	Status *WorkflowStatus

	// READ-ONLY; Gets the reference to workflow.
	Workflow *ResourceReference
}

// WorkflowTriggerRecurrence - The workflow trigger recurrence.
type WorkflowTriggerRecurrence struct {
	// The end time.
	EndTime *string

	// The frequency.
	Frequency *RecurrenceFrequency

	// The interval.
	Interval *int32

	// The recurrence schedule.
	Schedule *RecurrenceSchedule

	// The start time.
	StartTime *string

	// The time zone.
	TimeZone *string
}

// WorkflowVersion - The workflow version.
type WorkflowVersion struct {
	// The resource location.
	Location *string

	// The workflow version properties.
	Properties *WorkflowVersionProperties

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource id.
	ID *string

	// READ-ONLY; Gets the resource name.
	Name *string

	// READ-ONLY; Gets the resource type.
	Type *string
}

// WorkflowVersionListResult - The list of workflow versions.
type WorkflowVersionListResult struct {
	// The URL to get the next set of results.
	NextLink *string

	// A list of workflow versions.
	Value []*WorkflowVersion
}

// WorkflowVersionProperties - The workflow version properties.
type WorkflowVersionProperties struct {
	// The access control configuration.
	AccessControl *FlowAccessControlConfiguration

	// The definition.
	Definition any

	// The endpoints configuration.
	EndpointsConfiguration *FlowEndpointsConfiguration

	// The integration account.
	IntegrationAccount *ResourceReference

	// The parameters.
	Parameters map[string]*WorkflowParameter

	// The state.
	State *WorkflowState

	// READ-ONLY; Gets the access endpoint.
	AccessEndpoint *string

	// READ-ONLY; Gets the changed time.
	ChangedTime *time.Time

	// READ-ONLY; Gets the created time.
	CreatedTime *time.Time

	// READ-ONLY; The provisioning state.
	ProvisioningState *WorkflowProvisioningState

	// READ-ONLY; The sku.
	SKU *WorkflowSKU

	// READ-ONLY; Gets the version.
	Version *string
}
