//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
	"net/http"
	"net/url"
	"regexp"
)

// SoftwareUpdateConfigurationRunsServer is a fake server for instances of the armautomation.SoftwareUpdateConfigurationRunsClient type.
type SoftwareUpdateConfigurationRunsServer struct {
	// GetByID is the fake for method SoftwareUpdateConfigurationRunsClient.GetByID
	// HTTP status codes to indicate success: http.StatusOK
	GetByID func(ctx context.Context, resourceGroupName string, automationAccountName string, softwareUpdateConfigurationRunID string, options *armautomation.SoftwareUpdateConfigurationRunsClientGetByIDOptions) (resp azfake.Responder[armautomation.SoftwareUpdateConfigurationRunsClientGetByIDResponse], errResp azfake.ErrorResponder)

	// List is the fake for method SoftwareUpdateConfigurationRunsClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, resourceGroupName string, automationAccountName string, options *armautomation.SoftwareUpdateConfigurationRunsClientListOptions) (resp azfake.Responder[armautomation.SoftwareUpdateConfigurationRunsClientListResponse], errResp azfake.ErrorResponder)
}

// NewSoftwareUpdateConfigurationRunsServerTransport creates a new instance of SoftwareUpdateConfigurationRunsServerTransport with the provided implementation.
// The returned SoftwareUpdateConfigurationRunsServerTransport instance is connected to an instance of armautomation.SoftwareUpdateConfigurationRunsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSoftwareUpdateConfigurationRunsServerTransport(srv *SoftwareUpdateConfigurationRunsServer) *SoftwareUpdateConfigurationRunsServerTransport {
	return &SoftwareUpdateConfigurationRunsServerTransport{srv: srv}
}

// SoftwareUpdateConfigurationRunsServerTransport connects instances of armautomation.SoftwareUpdateConfigurationRunsClient to instances of SoftwareUpdateConfigurationRunsServer.
// Don't use this type directly, use NewSoftwareUpdateConfigurationRunsServerTransport instead.
type SoftwareUpdateConfigurationRunsServerTransport struct {
	srv *SoftwareUpdateConfigurationRunsServer
}

// Do implements the policy.Transporter interface for SoftwareUpdateConfigurationRunsServerTransport.
func (s *SoftwareUpdateConfigurationRunsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SoftwareUpdateConfigurationRunsClient.GetByID":
		resp, err = s.dispatchGetByID(req)
	case "SoftwareUpdateConfigurationRunsClient.List":
		resp, err = s.dispatchList(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SoftwareUpdateConfigurationRunsServerTransport) dispatchGetByID(req *http.Request) (*http.Response, error) {
	if s.srv.GetByID == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByID not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/softwareUpdateConfigurationRuns/(?P<softwareUpdateConfigurationRunId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	softwareUpdateConfigurationRunIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("softwareUpdateConfigurationRunId")])
	if err != nil {
		return nil, err
	}
	clientRequestIDParam := getOptional(getHeaderValue(req.Header, "clientRequestId"))
	var options *armautomation.SoftwareUpdateConfigurationRunsClientGetByIDOptions
	if clientRequestIDParam != nil {
		options = &armautomation.SoftwareUpdateConfigurationRunsClientGetByIDOptions{
			ClientRequestID: clientRequestIDParam,
		}
	}
	respr, errRespr := s.srv.GetByID(req.Context(), resourceGroupNameParam, automationAccountNameParam, softwareUpdateConfigurationRunIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SoftwareUpdateConfigurationRun, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SoftwareUpdateConfigurationRunsServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if s.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/softwareUpdateConfigurationRuns`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	clientRequestIDParam := getOptional(getHeaderValue(req.Header, "clientRequestId"))
	filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
	if err != nil {
		return nil, err
	}
	filterParam := getOptional(filterUnescaped)
	skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
	if err != nil {
		return nil, err
	}
	skipParam := getOptional(skipUnescaped)
	topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
	if err != nil {
		return nil, err
	}
	topParam := getOptional(topUnescaped)
	var options *armautomation.SoftwareUpdateConfigurationRunsClientListOptions
	if clientRequestIDParam != nil || filterParam != nil || skipParam != nil || topParam != nil {
		options = &armautomation.SoftwareUpdateConfigurationRunsClientListOptions{
			ClientRequestID: clientRequestIDParam,
			Filter:          filterParam,
			Skip:            skipParam,
			Top:             topParam,
		}
	}
	respr, errRespr := s.srv.List(req.Context(), resourceGroupNameParam, automationAccountNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SoftwareUpdateConfigurationRunListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
