//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcontainerservicefleet

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/containerservicefleet/armcontainerservicefleet"
	moduleVersion = "v1.1.0"
)

// ActionType - Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
type ActionType string

const (
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeInternal,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// FleetMemberProvisioningState - The provisioning state of the last accepted operation.
type FleetMemberProvisioningState string

const (
	// FleetMemberProvisioningStateCanceled - Resource creation was canceled.
	FleetMemberProvisioningStateCanceled FleetMemberProvisioningState = "Canceled"
	// FleetMemberProvisioningStateFailed - Resource creation failed.
	FleetMemberProvisioningStateFailed FleetMemberProvisioningState = "Failed"
	// FleetMemberProvisioningStateJoining - The provisioning state of a member joining a fleet.
	FleetMemberProvisioningStateJoining FleetMemberProvisioningState = "Joining"
	// FleetMemberProvisioningStateLeaving - The provisioning state of a member leaving a fleet.
	FleetMemberProvisioningStateLeaving FleetMemberProvisioningState = "Leaving"
	// FleetMemberProvisioningStateSucceeded - Resource has been created.
	FleetMemberProvisioningStateSucceeded FleetMemberProvisioningState = "Succeeded"
	// FleetMemberProvisioningStateUpdating - The provisioning state of a member being updated.
	FleetMemberProvisioningStateUpdating FleetMemberProvisioningState = "Updating"
)

// PossibleFleetMemberProvisioningStateValues returns the possible values for the FleetMemberProvisioningState const type.
func PossibleFleetMemberProvisioningStateValues() []FleetMemberProvisioningState {
	return []FleetMemberProvisioningState{
		FleetMemberProvisioningStateCanceled,
		FleetMemberProvisioningStateFailed,
		FleetMemberProvisioningStateJoining,
		FleetMemberProvisioningStateLeaving,
		FleetMemberProvisioningStateSucceeded,
		FleetMemberProvisioningStateUpdating,
	}
}

// FleetProvisioningState - The provisioning state of the last accepted operation.
type FleetProvisioningState string

const (
	// FleetProvisioningStateCanceled - Resource creation was canceled.
	FleetProvisioningStateCanceled FleetProvisioningState = "Canceled"
	// FleetProvisioningStateCreating - The provisioning state of a fleet being created.
	FleetProvisioningStateCreating FleetProvisioningState = "Creating"
	// FleetProvisioningStateDeleting - The provisioning state of a fleet being deleted.
	FleetProvisioningStateDeleting FleetProvisioningState = "Deleting"
	// FleetProvisioningStateFailed - Resource creation failed.
	FleetProvisioningStateFailed FleetProvisioningState = "Failed"
	// FleetProvisioningStateSucceeded - Resource has been created.
	FleetProvisioningStateSucceeded FleetProvisioningState = "Succeeded"
	// FleetProvisioningStateUpdating - The provisioning state of a fleet being updated.
	FleetProvisioningStateUpdating FleetProvisioningState = "Updating"
)

// PossibleFleetProvisioningStateValues returns the possible values for the FleetProvisioningState const type.
func PossibleFleetProvisioningStateValues() []FleetProvisioningState {
	return []FleetProvisioningState{
		FleetProvisioningStateCanceled,
		FleetProvisioningStateCreating,
		FleetProvisioningStateDeleting,
		FleetProvisioningStateFailed,
		FleetProvisioningStateSucceeded,
		FleetProvisioningStateUpdating,
	}
}

// FleetUpdateStrategyProvisioningState - The provisioning state of the UpdateStrategy resource.
type FleetUpdateStrategyProvisioningState string

const (
	// FleetUpdateStrategyProvisioningStateCanceled - Resource creation was canceled.
	FleetUpdateStrategyProvisioningStateCanceled FleetUpdateStrategyProvisioningState = "Canceled"
	// FleetUpdateStrategyProvisioningStateFailed - Resource creation failed.
	FleetUpdateStrategyProvisioningStateFailed FleetUpdateStrategyProvisioningState = "Failed"
	// FleetUpdateStrategyProvisioningStateSucceeded - Resource has been created.
	FleetUpdateStrategyProvisioningStateSucceeded FleetUpdateStrategyProvisioningState = "Succeeded"
)

// PossibleFleetUpdateStrategyProvisioningStateValues returns the possible values for the FleetUpdateStrategyProvisioningState const type.
func PossibleFleetUpdateStrategyProvisioningStateValues() []FleetUpdateStrategyProvisioningState {
	return []FleetUpdateStrategyProvisioningState{
		FleetUpdateStrategyProvisioningStateCanceled,
		FleetUpdateStrategyProvisioningStateFailed,
		FleetUpdateStrategyProvisioningStateSucceeded,
	}
}

// ManagedClusterUpgradeType - The type of upgrade to perform when targeting ManagedClusters.
type ManagedClusterUpgradeType string

const (
	// ManagedClusterUpgradeTypeFull - Full upgrades the control plane and all agent pools of the target ManagedClusters.
	ManagedClusterUpgradeTypeFull ManagedClusterUpgradeType = "Full"
	// ManagedClusterUpgradeTypeNodeImageOnly - NodeImageOnly upgrades only the node images of the target ManagedClusters.
	ManagedClusterUpgradeTypeNodeImageOnly ManagedClusterUpgradeType = "NodeImageOnly"
)

// PossibleManagedClusterUpgradeTypeValues returns the possible values for the ManagedClusterUpgradeType const type.
func PossibleManagedClusterUpgradeTypeValues() []ManagedClusterUpgradeType {
	return []ManagedClusterUpgradeType{
		ManagedClusterUpgradeTypeFull,
		ManagedClusterUpgradeTypeNodeImageOnly,
	}
}

// ManagedServiceIdentityType - Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
type ManagedServiceIdentityType string

const (
	ManagedServiceIdentityTypeNone                       ManagedServiceIdentityType = "None"
	ManagedServiceIdentityTypeSystemAssigned             ManagedServiceIdentityType = "SystemAssigned"
	ManagedServiceIdentityTypeSystemAssignedUserAssigned ManagedServiceIdentityType = "SystemAssigned, UserAssigned"
	ManagedServiceIdentityTypeUserAssigned               ManagedServiceIdentityType = "UserAssigned"
)

// PossibleManagedServiceIdentityTypeValues returns the possible values for the ManagedServiceIdentityType const type.
func PossibleManagedServiceIdentityTypeValues() []ManagedServiceIdentityType {
	return []ManagedServiceIdentityType{
		ManagedServiceIdentityTypeNone,
		ManagedServiceIdentityTypeSystemAssigned,
		ManagedServiceIdentityTypeSystemAssignedUserAssigned,
		ManagedServiceIdentityTypeUserAssigned,
	}
}

// NodeImageSelectionType - The node image upgrade type.
type NodeImageSelectionType string

const (
	// NodeImageSelectionTypeConsistent - The image versions to upgrade nodes to are selected as described below: for each node
	// pool in managed clusters affected by the update run, the system selects the latest image version such that it is available
	// across all other node pools (in all other clusters) of the same image type. As a result, all node pools of the same image
	// type will be upgraded to the same image version. For example, if the latest image version for image type 'AKSUbuntu-1804gen2containerd'
	// is 'AKSUbuntu-1804gen2containerd-2021.10.12' for a node pool in cluster A in region X, and is 'AKSUbuntu-1804gen2containerd-2021.10.17'
	// for a node pool in cluster B in region Y, the system will upgrade both node pools to image version 'AKSUbuntu-1804gen2containerd-2021.10.12'.
	NodeImageSelectionTypeConsistent NodeImageSelectionType = "Consistent"
	// NodeImageSelectionTypeLatest - Use the latest image version when upgrading nodes. Clusters may use different image versions
	// (e.g., 'AKSUbuntu-1804gen2containerd-2021.10.12' and 'AKSUbuntu-1804gen2containerd-2021.10.19') because, for example, the
	// latest available version is different in different regions.
	NodeImageSelectionTypeLatest NodeImageSelectionType = "Latest"
)

// PossibleNodeImageSelectionTypeValues returns the possible values for the NodeImageSelectionType const type.
func PossibleNodeImageSelectionTypeValues() []NodeImageSelectionType {
	return []NodeImageSelectionType{
		NodeImageSelectionTypeConsistent,
		NodeImageSelectionTypeLatest,
	}
}

// Origin - The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
// value is "user,system"
type Origin string

const (
	OriginSystem     Origin = "system"
	OriginUser       Origin = "user"
	OriginUserSystem Origin = "user,system"
)

// PossibleOriginValues returns the possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{
		OriginSystem,
		OriginUser,
		OriginUserSystem,
	}
}

// UpdateRunProvisioningState - The provisioning state of the UpdateRun resource.
type UpdateRunProvisioningState string

const (
	// UpdateRunProvisioningStateCanceled - Resource creation was canceled.
	UpdateRunProvisioningStateCanceled UpdateRunProvisioningState = "Canceled"
	// UpdateRunProvisioningStateFailed - Resource creation failed.
	UpdateRunProvisioningStateFailed UpdateRunProvisioningState = "Failed"
	// UpdateRunProvisioningStateSucceeded - Resource has been created.
	UpdateRunProvisioningStateSucceeded UpdateRunProvisioningState = "Succeeded"
)

// PossibleUpdateRunProvisioningStateValues returns the possible values for the UpdateRunProvisioningState const type.
func PossibleUpdateRunProvisioningStateValues() []UpdateRunProvisioningState {
	return []UpdateRunProvisioningState{
		UpdateRunProvisioningStateCanceled,
		UpdateRunProvisioningStateFailed,
		UpdateRunProvisioningStateSucceeded,
	}
}

// UpdateState - The state of the UpdateRun, UpdateStage, UpdateGroup, or MemberUpdate.
type UpdateState string

const (
	// UpdateStateCompleted - The state of an UpdateRun/UpdateStage/UpdateGroup/MemberUpdate that has completed.
	UpdateStateCompleted UpdateState = "Completed"
	// UpdateStateFailed - The state of an UpdateRun/UpdateStage/UpdateGroup/MemberUpdate that has failed.
	UpdateStateFailed UpdateState = "Failed"
	// UpdateStateNotStarted - The state of an UpdateRun/UpdateStage/UpdateGroup/MemberUpdate that has not been started.
	UpdateStateNotStarted UpdateState = "NotStarted"
	// UpdateStateRunning - The state of an UpdateRun/UpdateStage/UpdateGroup/MemberUpdate that is running.
	UpdateStateRunning UpdateState = "Running"
	// UpdateStateSkipped - The state of an UpdateRun/UpdateStage/UpdateGroup/MemberUpdate that has been skipped.
	UpdateStateSkipped UpdateState = "Skipped"
	// UpdateStateStopped - The state of an UpdateRun/UpdateStage/UpdateGroup/MemberUpdate that has stopped.
	UpdateStateStopped UpdateState = "Stopped"
	// UpdateStateStopping - The state of an UpdateRun/UpdateStage/UpdateGroup/MemberUpdate that is being stopped.
	UpdateStateStopping UpdateState = "Stopping"
)

// PossibleUpdateStateValues returns the possible values for the UpdateState const type.
func PossibleUpdateStateValues() []UpdateState {
	return []UpdateState{
		UpdateStateCompleted,
		UpdateStateFailed,
		UpdateStateNotStarted,
		UpdateStateRunning,
		UpdateStateSkipped,
		UpdateStateStopped,
		UpdateStateStopping,
	}
}
