//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datashare/armdatashare"
	"net/http"
	"net/url"
	"regexp"
)

// ConsumerSourceDataSetsServer is a fake server for instances of the armdatashare.ConsumerSourceDataSetsClient type.
type ConsumerSourceDataSetsServer struct {
	// NewListByShareSubscriptionPager is the fake for method ConsumerSourceDataSetsClient.NewListByShareSubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByShareSubscriptionPager func(resourceGroupName string, accountName string, shareSubscriptionName string, options *armdatashare.ConsumerSourceDataSetsClientListByShareSubscriptionOptions) (resp azfake.PagerResponder[armdatashare.ConsumerSourceDataSetsClientListByShareSubscriptionResponse])
}

// NewConsumerSourceDataSetsServerTransport creates a new instance of ConsumerSourceDataSetsServerTransport with the provided implementation.
// The returned ConsumerSourceDataSetsServerTransport instance is connected to an instance of armdatashare.ConsumerSourceDataSetsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewConsumerSourceDataSetsServerTransport(srv *ConsumerSourceDataSetsServer) *ConsumerSourceDataSetsServerTransport {
	return &ConsumerSourceDataSetsServerTransport{
		srv:                             srv,
		newListByShareSubscriptionPager: newTracker[azfake.PagerResponder[armdatashare.ConsumerSourceDataSetsClientListByShareSubscriptionResponse]](),
	}
}

// ConsumerSourceDataSetsServerTransport connects instances of armdatashare.ConsumerSourceDataSetsClient to instances of ConsumerSourceDataSetsServer.
// Don't use this type directly, use NewConsumerSourceDataSetsServerTransport instead.
type ConsumerSourceDataSetsServerTransport struct {
	srv                             *ConsumerSourceDataSetsServer
	newListByShareSubscriptionPager *tracker[azfake.PagerResponder[armdatashare.ConsumerSourceDataSetsClientListByShareSubscriptionResponse]]
}

// Do implements the policy.Transporter interface for ConsumerSourceDataSetsServerTransport.
func (c *ConsumerSourceDataSetsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ConsumerSourceDataSetsClient.NewListByShareSubscriptionPager":
		resp, err = c.dispatchNewListByShareSubscriptionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ConsumerSourceDataSetsServerTransport) dispatchNewListByShareSubscriptionPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByShareSubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByShareSubscriptionPager not implemented")}
	}
	newListByShareSubscriptionPager := c.newListByShareSubscriptionPager.get(req)
	if newListByShareSubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataShare/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/shareSubscriptions/(?P<shareSubscriptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/consumerSourceDataSets`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		shareSubscriptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("shareSubscriptionName")])
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armdatashare.ConsumerSourceDataSetsClientListByShareSubscriptionOptions
		if skipTokenParam != nil {
			options = &armdatashare.ConsumerSourceDataSetsClientListByShareSubscriptionOptions{
				SkipToken: skipTokenParam,
			}
		}
		resp := c.srv.NewListByShareSubscriptionPager(resourceGroupNameParam, accountNameParam, shareSubscriptionNameParam, options)
		newListByShareSubscriptionPager = &resp
		c.newListByShareSubscriptionPager.add(req, newListByShareSubscriptionPager)
		server.PagerResponderInjectNextLinks(newListByShareSubscriptionPager, req, func(page *armdatashare.ConsumerSourceDataSetsClientListByShareSubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByShareSubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByShareSubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByShareSubscriptionPager) {
		c.newListByShareSubscriptionPager.remove(req)
	}
	return resp, nil
}
