//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hybridnetwork/armhybridnetwork/v2"
	"net/http"
	"net/url"
	"regexp"
)

// NetworkFunctionDefinitionVersionsServer is a fake server for instances of the armhybridnetwork.NetworkFunctionDefinitionVersionsClient type.
type NetworkFunctionDefinitionVersionsServer struct {
	// BeginCreateOrUpdate is the fake for method NetworkFunctionDefinitionVersionsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, publisherName string, networkFunctionDefinitionGroupName string, networkFunctionDefinitionVersionName string, parameters armhybridnetwork.NetworkFunctionDefinitionVersion, options *armhybridnetwork.NetworkFunctionDefinitionVersionsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armhybridnetwork.NetworkFunctionDefinitionVersionsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method NetworkFunctionDefinitionVersionsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, publisherName string, networkFunctionDefinitionGroupName string, networkFunctionDefinitionVersionName string, options *armhybridnetwork.NetworkFunctionDefinitionVersionsClientBeginDeleteOptions) (resp azfake.PollerResponder[armhybridnetwork.NetworkFunctionDefinitionVersionsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method NetworkFunctionDefinitionVersionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, publisherName string, networkFunctionDefinitionGroupName string, networkFunctionDefinitionVersionName string, options *armhybridnetwork.NetworkFunctionDefinitionVersionsClientGetOptions) (resp azfake.Responder[armhybridnetwork.NetworkFunctionDefinitionVersionsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByNetworkFunctionDefinitionGroupPager is the fake for method NetworkFunctionDefinitionVersionsClient.NewListByNetworkFunctionDefinitionGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByNetworkFunctionDefinitionGroupPager func(resourceGroupName string, publisherName string, networkFunctionDefinitionGroupName string, options *armhybridnetwork.NetworkFunctionDefinitionVersionsClientListByNetworkFunctionDefinitionGroupOptions) (resp azfake.PagerResponder[armhybridnetwork.NetworkFunctionDefinitionVersionsClientListByNetworkFunctionDefinitionGroupResponse])

	// Update is the fake for method NetworkFunctionDefinitionVersionsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, publisherName string, networkFunctionDefinitionGroupName string, networkFunctionDefinitionVersionName string, parameters armhybridnetwork.TagsObject, options *armhybridnetwork.NetworkFunctionDefinitionVersionsClientUpdateOptions) (resp azfake.Responder[armhybridnetwork.NetworkFunctionDefinitionVersionsClientUpdateResponse], errResp azfake.ErrorResponder)

	// BeginUpdateState is the fake for method NetworkFunctionDefinitionVersionsClient.BeginUpdateState
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateState func(ctx context.Context, resourceGroupName string, publisherName string, networkFunctionDefinitionGroupName string, networkFunctionDefinitionVersionName string, parameters armhybridnetwork.NetworkFunctionDefinitionVersionUpdateState, options *armhybridnetwork.NetworkFunctionDefinitionVersionsClientBeginUpdateStateOptions) (resp azfake.PollerResponder[armhybridnetwork.NetworkFunctionDefinitionVersionsClientUpdateStateResponse], errResp azfake.ErrorResponder)
}

// NewNetworkFunctionDefinitionVersionsServerTransport creates a new instance of NetworkFunctionDefinitionVersionsServerTransport with the provided implementation.
// The returned NetworkFunctionDefinitionVersionsServerTransport instance is connected to an instance of armhybridnetwork.NetworkFunctionDefinitionVersionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewNetworkFunctionDefinitionVersionsServerTransport(srv *NetworkFunctionDefinitionVersionsServer) *NetworkFunctionDefinitionVersionsServerTransport {
	return &NetworkFunctionDefinitionVersionsServerTransport{
		srv:                 srv,
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armhybridnetwork.NetworkFunctionDefinitionVersionsClientCreateOrUpdateResponse]](),
		beginDelete:         newTracker[azfake.PollerResponder[armhybridnetwork.NetworkFunctionDefinitionVersionsClientDeleteResponse]](),
		newListByNetworkFunctionDefinitionGroupPager: newTracker[azfake.PagerResponder[armhybridnetwork.NetworkFunctionDefinitionVersionsClientListByNetworkFunctionDefinitionGroupResponse]](),
		beginUpdateState: newTracker[azfake.PollerResponder[armhybridnetwork.NetworkFunctionDefinitionVersionsClientUpdateStateResponse]](),
	}
}

// NetworkFunctionDefinitionVersionsServerTransport connects instances of armhybridnetwork.NetworkFunctionDefinitionVersionsClient to instances of NetworkFunctionDefinitionVersionsServer.
// Don't use this type directly, use NewNetworkFunctionDefinitionVersionsServerTransport instead.
type NetworkFunctionDefinitionVersionsServerTransport struct {
	srv                                          *NetworkFunctionDefinitionVersionsServer
	beginCreateOrUpdate                          *tracker[azfake.PollerResponder[armhybridnetwork.NetworkFunctionDefinitionVersionsClientCreateOrUpdateResponse]]
	beginDelete                                  *tracker[azfake.PollerResponder[armhybridnetwork.NetworkFunctionDefinitionVersionsClientDeleteResponse]]
	newListByNetworkFunctionDefinitionGroupPager *tracker[azfake.PagerResponder[armhybridnetwork.NetworkFunctionDefinitionVersionsClientListByNetworkFunctionDefinitionGroupResponse]]
	beginUpdateState                             *tracker[azfake.PollerResponder[armhybridnetwork.NetworkFunctionDefinitionVersionsClientUpdateStateResponse]]
}

// Do implements the policy.Transporter interface for NetworkFunctionDefinitionVersionsServerTransport.
func (n *NetworkFunctionDefinitionVersionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "NetworkFunctionDefinitionVersionsClient.BeginCreateOrUpdate":
		resp, err = n.dispatchBeginCreateOrUpdate(req)
	case "NetworkFunctionDefinitionVersionsClient.BeginDelete":
		resp, err = n.dispatchBeginDelete(req)
	case "NetworkFunctionDefinitionVersionsClient.Get":
		resp, err = n.dispatchGet(req)
	case "NetworkFunctionDefinitionVersionsClient.NewListByNetworkFunctionDefinitionGroupPager":
		resp, err = n.dispatchNewListByNetworkFunctionDefinitionGroupPager(req)
	case "NetworkFunctionDefinitionVersionsClient.Update":
		resp, err = n.dispatchUpdate(req)
	case "NetworkFunctionDefinitionVersionsClient.BeginUpdateState":
		resp, err = n.dispatchBeginUpdateState(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (n *NetworkFunctionDefinitionVersionsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if n.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := n.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridNetwork/publishers/(?P<publisherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkFunctionDefinitionGroups/(?P<networkFunctionDefinitionGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkFunctionDefinitionVersions/(?P<networkFunctionDefinitionVersionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armhybridnetwork.NetworkFunctionDefinitionVersion](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		publisherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("publisherName")])
		if err != nil {
			return nil, err
		}
		networkFunctionDefinitionGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFunctionDefinitionGroupName")])
		if err != nil {
			return nil, err
		}
		networkFunctionDefinitionVersionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFunctionDefinitionVersionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := n.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, publisherNameParam, networkFunctionDefinitionGroupNameParam, networkFunctionDefinitionVersionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		n.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		n.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		n.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (n *NetworkFunctionDefinitionVersionsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if n.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := n.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridNetwork/publishers/(?P<publisherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkFunctionDefinitionGroups/(?P<networkFunctionDefinitionGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkFunctionDefinitionVersions/(?P<networkFunctionDefinitionVersionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		publisherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("publisherName")])
		if err != nil {
			return nil, err
		}
		networkFunctionDefinitionGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFunctionDefinitionGroupName")])
		if err != nil {
			return nil, err
		}
		networkFunctionDefinitionVersionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFunctionDefinitionVersionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := n.srv.BeginDelete(req.Context(), resourceGroupNameParam, publisherNameParam, networkFunctionDefinitionGroupNameParam, networkFunctionDefinitionVersionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		n.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		n.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		n.beginDelete.remove(req)
	}

	return resp, nil
}

func (n *NetworkFunctionDefinitionVersionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if n.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridNetwork/publishers/(?P<publisherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkFunctionDefinitionGroups/(?P<networkFunctionDefinitionGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkFunctionDefinitionVersions/(?P<networkFunctionDefinitionVersionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	publisherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("publisherName")])
	if err != nil {
		return nil, err
	}
	networkFunctionDefinitionGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFunctionDefinitionGroupName")])
	if err != nil {
		return nil, err
	}
	networkFunctionDefinitionVersionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFunctionDefinitionVersionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := n.srv.Get(req.Context(), resourceGroupNameParam, publisherNameParam, networkFunctionDefinitionGroupNameParam, networkFunctionDefinitionVersionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NetworkFunctionDefinitionVersion, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (n *NetworkFunctionDefinitionVersionsServerTransport) dispatchNewListByNetworkFunctionDefinitionGroupPager(req *http.Request) (*http.Response, error) {
	if n.srv.NewListByNetworkFunctionDefinitionGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByNetworkFunctionDefinitionGroupPager not implemented")}
	}
	newListByNetworkFunctionDefinitionGroupPager := n.newListByNetworkFunctionDefinitionGroupPager.get(req)
	if newListByNetworkFunctionDefinitionGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridNetwork/publishers/(?P<publisherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkFunctionDefinitionGroups/(?P<networkFunctionDefinitionGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkFunctionDefinitionVersions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		publisherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("publisherName")])
		if err != nil {
			return nil, err
		}
		networkFunctionDefinitionGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFunctionDefinitionGroupName")])
		if err != nil {
			return nil, err
		}
		resp := n.srv.NewListByNetworkFunctionDefinitionGroupPager(resourceGroupNameParam, publisherNameParam, networkFunctionDefinitionGroupNameParam, nil)
		newListByNetworkFunctionDefinitionGroupPager = &resp
		n.newListByNetworkFunctionDefinitionGroupPager.add(req, newListByNetworkFunctionDefinitionGroupPager)
		server.PagerResponderInjectNextLinks(newListByNetworkFunctionDefinitionGroupPager, req, func(page *armhybridnetwork.NetworkFunctionDefinitionVersionsClientListByNetworkFunctionDefinitionGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByNetworkFunctionDefinitionGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		n.newListByNetworkFunctionDefinitionGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByNetworkFunctionDefinitionGroupPager) {
		n.newListByNetworkFunctionDefinitionGroupPager.remove(req)
	}
	return resp, nil
}

func (n *NetworkFunctionDefinitionVersionsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if n.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridNetwork/publishers/(?P<publisherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkFunctionDefinitionGroups/(?P<networkFunctionDefinitionGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkFunctionDefinitionVersions/(?P<networkFunctionDefinitionVersionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armhybridnetwork.TagsObject](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	publisherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("publisherName")])
	if err != nil {
		return nil, err
	}
	networkFunctionDefinitionGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFunctionDefinitionGroupName")])
	if err != nil {
		return nil, err
	}
	networkFunctionDefinitionVersionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFunctionDefinitionVersionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := n.srv.Update(req.Context(), resourceGroupNameParam, publisherNameParam, networkFunctionDefinitionGroupNameParam, networkFunctionDefinitionVersionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NetworkFunctionDefinitionVersion, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (n *NetworkFunctionDefinitionVersionsServerTransport) dispatchBeginUpdateState(req *http.Request) (*http.Response, error) {
	if n.srv.BeginUpdateState == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateState not implemented")}
	}
	beginUpdateState := n.beginUpdateState.get(req)
	if beginUpdateState == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridNetwork/publishers/(?P<publisherName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkFunctionDefinitionGroups/(?P<networkFunctionDefinitionGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/networkFunctionDefinitionVersions/(?P<networkFunctionDefinitionVersionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/updateState`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armhybridnetwork.NetworkFunctionDefinitionVersionUpdateState](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		publisherNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("publisherName")])
		if err != nil {
			return nil, err
		}
		networkFunctionDefinitionGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFunctionDefinitionGroupName")])
		if err != nil {
			return nil, err
		}
		networkFunctionDefinitionVersionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("networkFunctionDefinitionVersionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := n.srv.BeginUpdateState(req.Context(), resourceGroupNameParam, publisherNameParam, networkFunctionDefinitionGroupNameParam, networkFunctionDefinitionVersionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateState = &respr
		n.beginUpdateState.add(req, beginUpdateState)
	}

	resp, err := server.PollerResponderNext(beginUpdateState, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		n.beginUpdateState.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateState) {
		n.beginUpdateState.remove(req)
	}

	return resp, nil
}
