//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armproviderhub

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SKUsClient contains the methods for the SKUs group.
// Don't use this type directly, use NewSKUsClient() instead.
type SKUsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewSKUsClient creates a new instance of SKUsClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewSKUsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*SKUsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &SKUsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdate - Creates or updates the resource type skus in the given resource type.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-11-20
//   - providerNamespace - The name of the resource provider hosted within ProviderHub.
//   - resourceType - The resource type.
//   - sku - The SKU.
//   - properties - The required body parameters supplied to the resource sku operation.
//   - options - SKUsClientCreateOrUpdateOptions contains the optional parameters for the SKUsClient.CreateOrUpdate method.
func (client *SKUsClient) CreateOrUpdate(ctx context.Context, providerNamespace string, resourceType string, sku string, properties SKUResource, options *SKUsClientCreateOrUpdateOptions) (SKUsClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "SKUsClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, providerNamespace, resourceType, sku, properties, options)
	if err != nil {
		return SKUsClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SKUsClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SKUsClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *SKUsClient) createOrUpdateCreateRequest(ctx context.Context, providerNamespace string, resourceType string, sku string, properties SKUResource, options *SKUsClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/skus/{sku}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if providerNamespace == "" {
		return nil, errors.New("parameter providerNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerNamespace}", url.PathEscape(providerNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if sku == "" {
		return nil, errors.New("parameter sku cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sku}", url.PathEscape(sku))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-20")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, properties); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *SKUsClient) createOrUpdateHandleResponse(resp *http.Response) (SKUsClientCreateOrUpdateResponse, error) {
	result := SKUsClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUResource); err != nil {
		return SKUsClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateNestedResourceTypeFirst - Creates or updates the resource type skus in the given resource type.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-11-20
//   - providerNamespace - The name of the resource provider hosted within ProviderHub.
//   - resourceType - The resource type.
//   - nestedResourceTypeFirst - The first child resource type.
//   - sku - The SKU.
//   - properties - The required body parameters supplied to the resource sku operation.
//   - options - SKUsClientCreateOrUpdateNestedResourceTypeFirstOptions contains the optional parameters for the SKUsClient.CreateOrUpdateNestedResourceTypeFirst
//     method.
func (client *SKUsClient) CreateOrUpdateNestedResourceTypeFirst(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, sku string, properties SKUResource, options *SKUsClientCreateOrUpdateNestedResourceTypeFirstOptions) (SKUsClientCreateOrUpdateNestedResourceTypeFirstResponse, error) {
	var err error
	const operationName = "SKUsClient.CreateOrUpdateNestedResourceTypeFirst"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateNestedResourceTypeFirstCreateRequest(ctx, providerNamespace, resourceType, nestedResourceTypeFirst, sku, properties, options)
	if err != nil {
		return SKUsClientCreateOrUpdateNestedResourceTypeFirstResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SKUsClientCreateOrUpdateNestedResourceTypeFirstResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SKUsClientCreateOrUpdateNestedResourceTypeFirstResponse{}, err
	}
	resp, err := client.createOrUpdateNestedResourceTypeFirstHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateNestedResourceTypeFirstCreateRequest creates the CreateOrUpdateNestedResourceTypeFirst request.
func (client *SKUsClient) createOrUpdateNestedResourceTypeFirstCreateRequest(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, sku string, properties SKUResource, options *SKUsClientCreateOrUpdateNestedResourceTypeFirstOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/skus/{sku}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if providerNamespace == "" {
		return nil, errors.New("parameter providerNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerNamespace}", url.PathEscape(providerNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if nestedResourceTypeFirst == "" {
		return nil, errors.New("parameter nestedResourceTypeFirst cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeFirst}", url.PathEscape(nestedResourceTypeFirst))
	if sku == "" {
		return nil, errors.New("parameter sku cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sku}", url.PathEscape(sku))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-20")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, properties); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateNestedResourceTypeFirstHandleResponse handles the CreateOrUpdateNestedResourceTypeFirst response.
func (client *SKUsClient) createOrUpdateNestedResourceTypeFirstHandleResponse(resp *http.Response) (SKUsClientCreateOrUpdateNestedResourceTypeFirstResponse, error) {
	result := SKUsClientCreateOrUpdateNestedResourceTypeFirstResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUResource); err != nil {
		return SKUsClientCreateOrUpdateNestedResourceTypeFirstResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateNestedResourceTypeSecond - Creates or updates the resource type skus in the given resource type.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-11-20
//   - providerNamespace - The name of the resource provider hosted within ProviderHub.
//   - resourceType - The resource type.
//   - nestedResourceTypeFirst - The first child resource type.
//   - nestedResourceTypeSecond - The second child resource type.
//   - sku - The SKU.
//   - properties - The required body parameters supplied to the resource sku operation.
//   - options - SKUsClientCreateOrUpdateNestedResourceTypeSecondOptions contains the optional parameters for the SKUsClient.CreateOrUpdateNestedResourceTypeSecond
//     method.
func (client *SKUsClient) CreateOrUpdateNestedResourceTypeSecond(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, sku string, properties SKUResource, options *SKUsClientCreateOrUpdateNestedResourceTypeSecondOptions) (SKUsClientCreateOrUpdateNestedResourceTypeSecondResponse, error) {
	var err error
	const operationName = "SKUsClient.CreateOrUpdateNestedResourceTypeSecond"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateNestedResourceTypeSecondCreateRequest(ctx, providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku, properties, options)
	if err != nil {
		return SKUsClientCreateOrUpdateNestedResourceTypeSecondResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SKUsClientCreateOrUpdateNestedResourceTypeSecondResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SKUsClientCreateOrUpdateNestedResourceTypeSecondResponse{}, err
	}
	resp, err := client.createOrUpdateNestedResourceTypeSecondHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateNestedResourceTypeSecondCreateRequest creates the CreateOrUpdateNestedResourceTypeSecond request.
func (client *SKUsClient) createOrUpdateNestedResourceTypeSecondCreateRequest(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, sku string, properties SKUResource, options *SKUsClientCreateOrUpdateNestedResourceTypeSecondOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/skus/{sku}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if providerNamespace == "" {
		return nil, errors.New("parameter providerNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerNamespace}", url.PathEscape(providerNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if nestedResourceTypeFirst == "" {
		return nil, errors.New("parameter nestedResourceTypeFirst cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeFirst}", url.PathEscape(nestedResourceTypeFirst))
	if nestedResourceTypeSecond == "" {
		return nil, errors.New("parameter nestedResourceTypeSecond cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeSecond}", url.PathEscape(nestedResourceTypeSecond))
	if sku == "" {
		return nil, errors.New("parameter sku cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sku}", url.PathEscape(sku))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-20")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, properties); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateNestedResourceTypeSecondHandleResponse handles the CreateOrUpdateNestedResourceTypeSecond response.
func (client *SKUsClient) createOrUpdateNestedResourceTypeSecondHandleResponse(resp *http.Response) (SKUsClientCreateOrUpdateNestedResourceTypeSecondResponse, error) {
	result := SKUsClientCreateOrUpdateNestedResourceTypeSecondResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUResource); err != nil {
		return SKUsClientCreateOrUpdateNestedResourceTypeSecondResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateNestedResourceTypeThird - Creates or updates the resource type skus in the given resource type.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-11-20
//   - providerNamespace - The name of the resource provider hosted within ProviderHub.
//   - resourceType - The resource type.
//   - nestedResourceTypeFirst - The first child resource type.
//   - nestedResourceTypeSecond - The second child resource type.
//   - nestedResourceTypeThird - The third child resource type.
//   - sku - The SKU.
//   - properties - The required body parameters supplied to the resource sku operation.
//   - options - SKUsClientCreateOrUpdateNestedResourceTypeThirdOptions contains the optional parameters for the SKUsClient.CreateOrUpdateNestedResourceTypeThird
//     method.
func (client *SKUsClient) CreateOrUpdateNestedResourceTypeThird(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, nestedResourceTypeThird string, sku string, properties SKUResource, options *SKUsClientCreateOrUpdateNestedResourceTypeThirdOptions) (SKUsClientCreateOrUpdateNestedResourceTypeThirdResponse, error) {
	var err error
	const operationName = "SKUsClient.CreateOrUpdateNestedResourceTypeThird"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateNestedResourceTypeThirdCreateRequest(ctx, providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku, properties, options)
	if err != nil {
		return SKUsClientCreateOrUpdateNestedResourceTypeThirdResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SKUsClientCreateOrUpdateNestedResourceTypeThirdResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SKUsClientCreateOrUpdateNestedResourceTypeThirdResponse{}, err
	}
	resp, err := client.createOrUpdateNestedResourceTypeThirdHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateNestedResourceTypeThirdCreateRequest creates the CreateOrUpdateNestedResourceTypeThird request.
func (client *SKUsClient) createOrUpdateNestedResourceTypeThirdCreateRequest(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, nestedResourceTypeThird string, sku string, properties SKUResource, options *SKUsClientCreateOrUpdateNestedResourceTypeThirdOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/resourcetypeRegistrations/{nestedResourceTypeThird}/skus/{sku}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if providerNamespace == "" {
		return nil, errors.New("parameter providerNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerNamespace}", url.PathEscape(providerNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if nestedResourceTypeFirst == "" {
		return nil, errors.New("parameter nestedResourceTypeFirst cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeFirst}", url.PathEscape(nestedResourceTypeFirst))
	if nestedResourceTypeSecond == "" {
		return nil, errors.New("parameter nestedResourceTypeSecond cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeSecond}", url.PathEscape(nestedResourceTypeSecond))
	if nestedResourceTypeThird == "" {
		return nil, errors.New("parameter nestedResourceTypeThird cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeThird}", url.PathEscape(nestedResourceTypeThird))
	if sku == "" {
		return nil, errors.New("parameter sku cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sku}", url.PathEscape(sku))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-20")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, properties); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateNestedResourceTypeThirdHandleResponse handles the CreateOrUpdateNestedResourceTypeThird response.
func (client *SKUsClient) createOrUpdateNestedResourceTypeThirdHandleResponse(resp *http.Response) (SKUsClientCreateOrUpdateNestedResourceTypeThirdResponse, error) {
	result := SKUsClientCreateOrUpdateNestedResourceTypeThirdResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUResource); err != nil {
		return SKUsClientCreateOrUpdateNestedResourceTypeThirdResponse{}, err
	}
	return result, nil
}

// Delete - Deletes a resource type sku.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-11-20
//   - providerNamespace - The name of the resource provider hosted within ProviderHub.
//   - resourceType - The resource type.
//   - sku - The SKU.
//   - options - SKUsClientDeleteOptions contains the optional parameters for the SKUsClient.Delete method.
func (client *SKUsClient) Delete(ctx context.Context, providerNamespace string, resourceType string, sku string, options *SKUsClientDeleteOptions) (SKUsClientDeleteResponse, error) {
	var err error
	const operationName = "SKUsClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, providerNamespace, resourceType, sku, options)
	if err != nil {
		return SKUsClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SKUsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return SKUsClientDeleteResponse{}, err
	}
	return SKUsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *SKUsClient) deleteCreateRequest(ctx context.Context, providerNamespace string, resourceType string, sku string, options *SKUsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/skus/{sku}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if providerNamespace == "" {
		return nil, errors.New("parameter providerNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerNamespace}", url.PathEscape(providerNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if sku == "" {
		return nil, errors.New("parameter sku cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sku}", url.PathEscape(sku))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-20")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteNestedResourceTypeFirst - Deletes a resource type sku.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-11-20
//   - providerNamespace - The name of the resource provider hosted within ProviderHub.
//   - resourceType - The resource type.
//   - nestedResourceTypeFirst - The first child resource type.
//   - sku - The SKU.
//   - options - SKUsClientDeleteNestedResourceTypeFirstOptions contains the optional parameters for the SKUsClient.DeleteNestedResourceTypeFirst
//     method.
func (client *SKUsClient) DeleteNestedResourceTypeFirst(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, sku string, options *SKUsClientDeleteNestedResourceTypeFirstOptions) (SKUsClientDeleteNestedResourceTypeFirstResponse, error) {
	var err error
	const operationName = "SKUsClient.DeleteNestedResourceTypeFirst"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteNestedResourceTypeFirstCreateRequest(ctx, providerNamespace, resourceType, nestedResourceTypeFirst, sku, options)
	if err != nil {
		return SKUsClientDeleteNestedResourceTypeFirstResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SKUsClientDeleteNestedResourceTypeFirstResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return SKUsClientDeleteNestedResourceTypeFirstResponse{}, err
	}
	return SKUsClientDeleteNestedResourceTypeFirstResponse{}, nil
}

// deleteNestedResourceTypeFirstCreateRequest creates the DeleteNestedResourceTypeFirst request.
func (client *SKUsClient) deleteNestedResourceTypeFirstCreateRequest(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, sku string, options *SKUsClientDeleteNestedResourceTypeFirstOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/skus/{sku}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if providerNamespace == "" {
		return nil, errors.New("parameter providerNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerNamespace}", url.PathEscape(providerNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if nestedResourceTypeFirst == "" {
		return nil, errors.New("parameter nestedResourceTypeFirst cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeFirst}", url.PathEscape(nestedResourceTypeFirst))
	if sku == "" {
		return nil, errors.New("parameter sku cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sku}", url.PathEscape(sku))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-20")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteNestedResourceTypeSecond - Deletes a resource type sku.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-11-20
//   - providerNamespace - The name of the resource provider hosted within ProviderHub.
//   - resourceType - The resource type.
//   - nestedResourceTypeFirst - The first child resource type.
//   - nestedResourceTypeSecond - The second child resource type.
//   - sku - The SKU.
//   - options - SKUsClientDeleteNestedResourceTypeSecondOptions contains the optional parameters for the SKUsClient.DeleteNestedResourceTypeSecond
//     method.
func (client *SKUsClient) DeleteNestedResourceTypeSecond(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, sku string, options *SKUsClientDeleteNestedResourceTypeSecondOptions) (SKUsClientDeleteNestedResourceTypeSecondResponse, error) {
	var err error
	const operationName = "SKUsClient.DeleteNestedResourceTypeSecond"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteNestedResourceTypeSecondCreateRequest(ctx, providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku, options)
	if err != nil {
		return SKUsClientDeleteNestedResourceTypeSecondResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SKUsClientDeleteNestedResourceTypeSecondResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return SKUsClientDeleteNestedResourceTypeSecondResponse{}, err
	}
	return SKUsClientDeleteNestedResourceTypeSecondResponse{}, nil
}

// deleteNestedResourceTypeSecondCreateRequest creates the DeleteNestedResourceTypeSecond request.
func (client *SKUsClient) deleteNestedResourceTypeSecondCreateRequest(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, sku string, options *SKUsClientDeleteNestedResourceTypeSecondOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/skus/{sku}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if providerNamespace == "" {
		return nil, errors.New("parameter providerNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerNamespace}", url.PathEscape(providerNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if nestedResourceTypeFirst == "" {
		return nil, errors.New("parameter nestedResourceTypeFirst cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeFirst}", url.PathEscape(nestedResourceTypeFirst))
	if nestedResourceTypeSecond == "" {
		return nil, errors.New("parameter nestedResourceTypeSecond cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeSecond}", url.PathEscape(nestedResourceTypeSecond))
	if sku == "" {
		return nil, errors.New("parameter sku cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sku}", url.PathEscape(sku))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-20")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteNestedResourceTypeThird - Deletes a resource type sku.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-11-20
//   - providerNamespace - The name of the resource provider hosted within ProviderHub.
//   - resourceType - The resource type.
//   - nestedResourceTypeFirst - The first child resource type.
//   - nestedResourceTypeSecond - The second child resource type.
//   - nestedResourceTypeThird - The third child resource type.
//   - sku - The SKU.
//   - options - SKUsClientDeleteNestedResourceTypeThirdOptions contains the optional parameters for the SKUsClient.DeleteNestedResourceTypeThird
//     method.
func (client *SKUsClient) DeleteNestedResourceTypeThird(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, nestedResourceTypeThird string, sku string, options *SKUsClientDeleteNestedResourceTypeThirdOptions) (SKUsClientDeleteNestedResourceTypeThirdResponse, error) {
	var err error
	const operationName = "SKUsClient.DeleteNestedResourceTypeThird"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteNestedResourceTypeThirdCreateRequest(ctx, providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku, options)
	if err != nil {
		return SKUsClientDeleteNestedResourceTypeThirdResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SKUsClientDeleteNestedResourceTypeThirdResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return SKUsClientDeleteNestedResourceTypeThirdResponse{}, err
	}
	return SKUsClientDeleteNestedResourceTypeThirdResponse{}, nil
}

// deleteNestedResourceTypeThirdCreateRequest creates the DeleteNestedResourceTypeThird request.
func (client *SKUsClient) deleteNestedResourceTypeThirdCreateRequest(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, nestedResourceTypeThird string, sku string, options *SKUsClientDeleteNestedResourceTypeThirdOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/resourcetypeRegistrations/{nestedResourceTypeThird}/skus/{sku}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if providerNamespace == "" {
		return nil, errors.New("parameter providerNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerNamespace}", url.PathEscape(providerNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if nestedResourceTypeFirst == "" {
		return nil, errors.New("parameter nestedResourceTypeFirst cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeFirst}", url.PathEscape(nestedResourceTypeFirst))
	if nestedResourceTypeSecond == "" {
		return nil, errors.New("parameter nestedResourceTypeSecond cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeSecond}", url.PathEscape(nestedResourceTypeSecond))
	if nestedResourceTypeThird == "" {
		return nil, errors.New("parameter nestedResourceTypeThird cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeThird}", url.PathEscape(nestedResourceTypeThird))
	if sku == "" {
		return nil, errors.New("parameter sku cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sku}", url.PathEscape(sku))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-20")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets the sku details for the given resource type and sku name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-11-20
//   - providerNamespace - The name of the resource provider hosted within ProviderHub.
//   - resourceType - The resource type.
//   - sku - The SKU.
//   - options - SKUsClientGetOptions contains the optional parameters for the SKUsClient.Get method.
func (client *SKUsClient) Get(ctx context.Context, providerNamespace string, resourceType string, sku string, options *SKUsClientGetOptions) (SKUsClientGetResponse, error) {
	var err error
	const operationName = "SKUsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, providerNamespace, resourceType, sku, options)
	if err != nil {
		return SKUsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SKUsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SKUsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *SKUsClient) getCreateRequest(ctx context.Context, providerNamespace string, resourceType string, sku string, options *SKUsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/skus/{sku}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if providerNamespace == "" {
		return nil, errors.New("parameter providerNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerNamespace}", url.PathEscape(providerNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if sku == "" {
		return nil, errors.New("parameter sku cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sku}", url.PathEscape(sku))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-20")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SKUsClient) getHandleResponse(resp *http.Response) (SKUsClientGetResponse, error) {
	result := SKUsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUResource); err != nil {
		return SKUsClientGetResponse{}, err
	}
	return result, nil
}

// GetNestedResourceTypeFirst - Gets the sku details for the given resource type and sku name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-11-20
//   - providerNamespace - The name of the resource provider hosted within ProviderHub.
//   - resourceType - The resource type.
//   - nestedResourceTypeFirst - The first child resource type.
//   - sku - The SKU.
//   - options - SKUsClientGetNestedResourceTypeFirstOptions contains the optional parameters for the SKUsClient.GetNestedResourceTypeFirst
//     method.
func (client *SKUsClient) GetNestedResourceTypeFirst(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, sku string, options *SKUsClientGetNestedResourceTypeFirstOptions) (SKUsClientGetNestedResourceTypeFirstResponse, error) {
	var err error
	const operationName = "SKUsClient.GetNestedResourceTypeFirst"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getNestedResourceTypeFirstCreateRequest(ctx, providerNamespace, resourceType, nestedResourceTypeFirst, sku, options)
	if err != nil {
		return SKUsClientGetNestedResourceTypeFirstResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SKUsClientGetNestedResourceTypeFirstResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SKUsClientGetNestedResourceTypeFirstResponse{}, err
	}
	resp, err := client.getNestedResourceTypeFirstHandleResponse(httpResp)
	return resp, err
}

// getNestedResourceTypeFirstCreateRequest creates the GetNestedResourceTypeFirst request.
func (client *SKUsClient) getNestedResourceTypeFirstCreateRequest(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, sku string, options *SKUsClientGetNestedResourceTypeFirstOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/skus/{sku}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if providerNamespace == "" {
		return nil, errors.New("parameter providerNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerNamespace}", url.PathEscape(providerNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if nestedResourceTypeFirst == "" {
		return nil, errors.New("parameter nestedResourceTypeFirst cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeFirst}", url.PathEscape(nestedResourceTypeFirst))
	if sku == "" {
		return nil, errors.New("parameter sku cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sku}", url.PathEscape(sku))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-20")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getNestedResourceTypeFirstHandleResponse handles the GetNestedResourceTypeFirst response.
func (client *SKUsClient) getNestedResourceTypeFirstHandleResponse(resp *http.Response) (SKUsClientGetNestedResourceTypeFirstResponse, error) {
	result := SKUsClientGetNestedResourceTypeFirstResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUResource); err != nil {
		return SKUsClientGetNestedResourceTypeFirstResponse{}, err
	}
	return result, nil
}

// GetNestedResourceTypeSecond - Gets the sku details for the given resource type and sku name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-11-20
//   - providerNamespace - The name of the resource provider hosted within ProviderHub.
//   - resourceType - The resource type.
//   - nestedResourceTypeFirst - The first child resource type.
//   - nestedResourceTypeSecond - The second child resource type.
//   - sku - The SKU.
//   - options - SKUsClientGetNestedResourceTypeSecondOptions contains the optional parameters for the SKUsClient.GetNestedResourceTypeSecond
//     method.
func (client *SKUsClient) GetNestedResourceTypeSecond(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, sku string, options *SKUsClientGetNestedResourceTypeSecondOptions) (SKUsClientGetNestedResourceTypeSecondResponse, error) {
	var err error
	const operationName = "SKUsClient.GetNestedResourceTypeSecond"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getNestedResourceTypeSecondCreateRequest(ctx, providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, sku, options)
	if err != nil {
		return SKUsClientGetNestedResourceTypeSecondResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SKUsClientGetNestedResourceTypeSecondResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SKUsClientGetNestedResourceTypeSecondResponse{}, err
	}
	resp, err := client.getNestedResourceTypeSecondHandleResponse(httpResp)
	return resp, err
}

// getNestedResourceTypeSecondCreateRequest creates the GetNestedResourceTypeSecond request.
func (client *SKUsClient) getNestedResourceTypeSecondCreateRequest(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, sku string, options *SKUsClientGetNestedResourceTypeSecondOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/skus/{sku}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if providerNamespace == "" {
		return nil, errors.New("parameter providerNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerNamespace}", url.PathEscape(providerNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if nestedResourceTypeFirst == "" {
		return nil, errors.New("parameter nestedResourceTypeFirst cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeFirst}", url.PathEscape(nestedResourceTypeFirst))
	if nestedResourceTypeSecond == "" {
		return nil, errors.New("parameter nestedResourceTypeSecond cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeSecond}", url.PathEscape(nestedResourceTypeSecond))
	if sku == "" {
		return nil, errors.New("parameter sku cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sku}", url.PathEscape(sku))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-20")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getNestedResourceTypeSecondHandleResponse handles the GetNestedResourceTypeSecond response.
func (client *SKUsClient) getNestedResourceTypeSecondHandleResponse(resp *http.Response) (SKUsClientGetNestedResourceTypeSecondResponse, error) {
	result := SKUsClientGetNestedResourceTypeSecondResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUResource); err != nil {
		return SKUsClientGetNestedResourceTypeSecondResponse{}, err
	}
	return result, nil
}

// GetNestedResourceTypeThird - Gets the sku details for the given resource type and sku name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-11-20
//   - providerNamespace - The name of the resource provider hosted within ProviderHub.
//   - resourceType - The resource type.
//   - nestedResourceTypeFirst - The first child resource type.
//   - nestedResourceTypeSecond - The second child resource type.
//   - nestedResourceTypeThird - The third child resource type.
//   - sku - The SKU.
//   - options - SKUsClientGetNestedResourceTypeThirdOptions contains the optional parameters for the SKUsClient.GetNestedResourceTypeThird
//     method.
func (client *SKUsClient) GetNestedResourceTypeThird(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, nestedResourceTypeThird string, sku string, options *SKUsClientGetNestedResourceTypeThirdOptions) (SKUsClientGetNestedResourceTypeThirdResponse, error) {
	var err error
	const operationName = "SKUsClient.GetNestedResourceTypeThird"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getNestedResourceTypeThirdCreateRequest(ctx, providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, sku, options)
	if err != nil {
		return SKUsClientGetNestedResourceTypeThirdResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SKUsClientGetNestedResourceTypeThirdResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SKUsClientGetNestedResourceTypeThirdResponse{}, err
	}
	resp, err := client.getNestedResourceTypeThirdHandleResponse(httpResp)
	return resp, err
}

// getNestedResourceTypeThirdCreateRequest creates the GetNestedResourceTypeThird request.
func (client *SKUsClient) getNestedResourceTypeThirdCreateRequest(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, nestedResourceTypeThird string, sku string, options *SKUsClientGetNestedResourceTypeThirdOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/resourcetypeRegistrations/{nestedResourceTypeThird}/skus/{sku}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if providerNamespace == "" {
		return nil, errors.New("parameter providerNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerNamespace}", url.PathEscape(providerNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if nestedResourceTypeFirst == "" {
		return nil, errors.New("parameter nestedResourceTypeFirst cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeFirst}", url.PathEscape(nestedResourceTypeFirst))
	if nestedResourceTypeSecond == "" {
		return nil, errors.New("parameter nestedResourceTypeSecond cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeSecond}", url.PathEscape(nestedResourceTypeSecond))
	if nestedResourceTypeThird == "" {
		return nil, errors.New("parameter nestedResourceTypeThird cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeThird}", url.PathEscape(nestedResourceTypeThird))
	if sku == "" {
		return nil, errors.New("parameter sku cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sku}", url.PathEscape(sku))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-20")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getNestedResourceTypeThirdHandleResponse handles the GetNestedResourceTypeThird response.
func (client *SKUsClient) getNestedResourceTypeThirdHandleResponse(resp *http.Response) (SKUsClientGetNestedResourceTypeThirdResponse, error) {
	result := SKUsClientGetNestedResourceTypeThirdResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUResource); err != nil {
		return SKUsClientGetNestedResourceTypeThirdResponse{}, err
	}
	return result, nil
}

// NewListByResourceTypeRegistrationsPager - Gets the list of skus for the given resource type.
//
// Generated from API version 2020-11-20
//   - providerNamespace - The name of the resource provider hosted within ProviderHub.
//   - resourceType - The resource type.
//   - options - SKUsClientListByResourceTypeRegistrationsOptions contains the optional parameters for the SKUsClient.NewListByResourceTypeRegistrationsPager
//     method.
func (client *SKUsClient) NewListByResourceTypeRegistrationsPager(providerNamespace string, resourceType string, options *SKUsClientListByResourceTypeRegistrationsOptions) *runtime.Pager[SKUsClientListByResourceTypeRegistrationsResponse] {
	return runtime.NewPager(runtime.PagingHandler[SKUsClientListByResourceTypeRegistrationsResponse]{
		More: func(page SKUsClientListByResourceTypeRegistrationsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SKUsClientListByResourceTypeRegistrationsResponse) (SKUsClientListByResourceTypeRegistrationsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SKUsClient.NewListByResourceTypeRegistrationsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByResourceTypeRegistrationsCreateRequest(ctx, providerNamespace, resourceType, options)
			}, nil)
			if err != nil {
				return SKUsClientListByResourceTypeRegistrationsResponse{}, err
			}
			return client.listByResourceTypeRegistrationsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceTypeRegistrationsCreateRequest creates the ListByResourceTypeRegistrations request.
func (client *SKUsClient) listByResourceTypeRegistrationsCreateRequest(ctx context.Context, providerNamespace string, resourceType string, options *SKUsClientListByResourceTypeRegistrationsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/skus"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if providerNamespace == "" {
		return nil, errors.New("parameter providerNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerNamespace}", url.PathEscape(providerNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-20")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceTypeRegistrationsHandleResponse handles the ListByResourceTypeRegistrations response.
func (client *SKUsClient) listByResourceTypeRegistrationsHandleResponse(resp *http.Response) (SKUsClientListByResourceTypeRegistrationsResponse, error) {
	result := SKUsClientListByResourceTypeRegistrationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUResourceArrayResponseWithContinuation); err != nil {
		return SKUsClientListByResourceTypeRegistrationsResponse{}, err
	}
	return result, nil
}

// NewListByResourceTypeRegistrationsNestedResourceTypeFirstPager - Gets the list of skus for the given resource type.
//
// Generated from API version 2020-11-20
//   - providerNamespace - The name of the resource provider hosted within ProviderHub.
//   - resourceType - The resource type.
//   - nestedResourceTypeFirst - The first child resource type.
//   - options - SKUsClientListByResourceTypeRegistrationsNestedResourceTypeFirstOptions contains the optional parameters for
//     the SKUsClient.NewListByResourceTypeRegistrationsNestedResourceTypeFirstPager method.
func (client *SKUsClient) NewListByResourceTypeRegistrationsNestedResourceTypeFirstPager(providerNamespace string, resourceType string, nestedResourceTypeFirst string, options *SKUsClientListByResourceTypeRegistrationsNestedResourceTypeFirstOptions) *runtime.Pager[SKUsClientListByResourceTypeRegistrationsNestedResourceTypeFirstResponse] {
	return runtime.NewPager(runtime.PagingHandler[SKUsClientListByResourceTypeRegistrationsNestedResourceTypeFirstResponse]{
		More: func(page SKUsClientListByResourceTypeRegistrationsNestedResourceTypeFirstResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SKUsClientListByResourceTypeRegistrationsNestedResourceTypeFirstResponse) (SKUsClientListByResourceTypeRegistrationsNestedResourceTypeFirstResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SKUsClient.NewListByResourceTypeRegistrationsNestedResourceTypeFirstPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByResourceTypeRegistrationsNestedResourceTypeFirstCreateRequest(ctx, providerNamespace, resourceType, nestedResourceTypeFirst, options)
			}, nil)
			if err != nil {
				return SKUsClientListByResourceTypeRegistrationsNestedResourceTypeFirstResponse{}, err
			}
			return client.listByResourceTypeRegistrationsNestedResourceTypeFirstHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceTypeRegistrationsNestedResourceTypeFirstCreateRequest creates the ListByResourceTypeRegistrationsNestedResourceTypeFirst request.
func (client *SKUsClient) listByResourceTypeRegistrationsNestedResourceTypeFirstCreateRequest(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, options *SKUsClientListByResourceTypeRegistrationsNestedResourceTypeFirstOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/skus"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if providerNamespace == "" {
		return nil, errors.New("parameter providerNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerNamespace}", url.PathEscape(providerNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if nestedResourceTypeFirst == "" {
		return nil, errors.New("parameter nestedResourceTypeFirst cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeFirst}", url.PathEscape(nestedResourceTypeFirst))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-20")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceTypeRegistrationsNestedResourceTypeFirstHandleResponse handles the ListByResourceTypeRegistrationsNestedResourceTypeFirst response.
func (client *SKUsClient) listByResourceTypeRegistrationsNestedResourceTypeFirstHandleResponse(resp *http.Response) (SKUsClientListByResourceTypeRegistrationsNestedResourceTypeFirstResponse, error) {
	result := SKUsClientListByResourceTypeRegistrationsNestedResourceTypeFirstResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUResourceArrayResponseWithContinuation); err != nil {
		return SKUsClientListByResourceTypeRegistrationsNestedResourceTypeFirstResponse{}, err
	}
	return result, nil
}

// NewListByResourceTypeRegistrationsNestedResourceTypeSecondPager - Gets the list of skus for the given resource type.
//
// Generated from API version 2020-11-20
//   - providerNamespace - The name of the resource provider hosted within ProviderHub.
//   - resourceType - The resource type.
//   - nestedResourceTypeFirst - The first child resource type.
//   - nestedResourceTypeSecond - The second child resource type.
//   - options - SKUsClientListByResourceTypeRegistrationsNestedResourceTypeSecondOptions contains the optional parameters for
//     the SKUsClient.NewListByResourceTypeRegistrationsNestedResourceTypeSecondPager method.
func (client *SKUsClient) NewListByResourceTypeRegistrationsNestedResourceTypeSecondPager(providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, options *SKUsClientListByResourceTypeRegistrationsNestedResourceTypeSecondOptions) *runtime.Pager[SKUsClientListByResourceTypeRegistrationsNestedResourceTypeSecondResponse] {
	return runtime.NewPager(runtime.PagingHandler[SKUsClientListByResourceTypeRegistrationsNestedResourceTypeSecondResponse]{
		More: func(page SKUsClientListByResourceTypeRegistrationsNestedResourceTypeSecondResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SKUsClientListByResourceTypeRegistrationsNestedResourceTypeSecondResponse) (SKUsClientListByResourceTypeRegistrationsNestedResourceTypeSecondResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SKUsClient.NewListByResourceTypeRegistrationsNestedResourceTypeSecondPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByResourceTypeRegistrationsNestedResourceTypeSecondCreateRequest(ctx, providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, options)
			}, nil)
			if err != nil {
				return SKUsClientListByResourceTypeRegistrationsNestedResourceTypeSecondResponse{}, err
			}
			return client.listByResourceTypeRegistrationsNestedResourceTypeSecondHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceTypeRegistrationsNestedResourceTypeSecondCreateRequest creates the ListByResourceTypeRegistrationsNestedResourceTypeSecond request.
func (client *SKUsClient) listByResourceTypeRegistrationsNestedResourceTypeSecondCreateRequest(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, options *SKUsClientListByResourceTypeRegistrationsNestedResourceTypeSecondOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/skus"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if providerNamespace == "" {
		return nil, errors.New("parameter providerNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerNamespace}", url.PathEscape(providerNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if nestedResourceTypeFirst == "" {
		return nil, errors.New("parameter nestedResourceTypeFirst cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeFirst}", url.PathEscape(nestedResourceTypeFirst))
	if nestedResourceTypeSecond == "" {
		return nil, errors.New("parameter nestedResourceTypeSecond cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeSecond}", url.PathEscape(nestedResourceTypeSecond))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-20")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceTypeRegistrationsNestedResourceTypeSecondHandleResponse handles the ListByResourceTypeRegistrationsNestedResourceTypeSecond response.
func (client *SKUsClient) listByResourceTypeRegistrationsNestedResourceTypeSecondHandleResponse(resp *http.Response) (SKUsClientListByResourceTypeRegistrationsNestedResourceTypeSecondResponse, error) {
	result := SKUsClientListByResourceTypeRegistrationsNestedResourceTypeSecondResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUResourceArrayResponseWithContinuation); err != nil {
		return SKUsClientListByResourceTypeRegistrationsNestedResourceTypeSecondResponse{}, err
	}
	return result, nil
}

// NewListByResourceTypeRegistrationsNestedResourceTypeThirdPager - Gets the list of skus for the given resource type.
//
// Generated from API version 2020-11-20
//   - providerNamespace - The name of the resource provider hosted within ProviderHub.
//   - resourceType - The resource type.
//   - nestedResourceTypeFirst - The first child resource type.
//   - nestedResourceTypeSecond - The second child resource type.
//   - nestedResourceTypeThird - The third child resource type.
//   - options - SKUsClientListByResourceTypeRegistrationsNestedResourceTypeThirdOptions contains the optional parameters for
//     the SKUsClient.NewListByResourceTypeRegistrationsNestedResourceTypeThirdPager method.
func (client *SKUsClient) NewListByResourceTypeRegistrationsNestedResourceTypeThirdPager(providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, nestedResourceTypeThird string, options *SKUsClientListByResourceTypeRegistrationsNestedResourceTypeThirdOptions) *runtime.Pager[SKUsClientListByResourceTypeRegistrationsNestedResourceTypeThirdResponse] {
	return runtime.NewPager(runtime.PagingHandler[SKUsClientListByResourceTypeRegistrationsNestedResourceTypeThirdResponse]{
		More: func(page SKUsClientListByResourceTypeRegistrationsNestedResourceTypeThirdResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SKUsClientListByResourceTypeRegistrationsNestedResourceTypeThirdResponse) (SKUsClientListByResourceTypeRegistrationsNestedResourceTypeThirdResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SKUsClient.NewListByResourceTypeRegistrationsNestedResourceTypeThirdPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByResourceTypeRegistrationsNestedResourceTypeThirdCreateRequest(ctx, providerNamespace, resourceType, nestedResourceTypeFirst, nestedResourceTypeSecond, nestedResourceTypeThird, options)
			}, nil)
			if err != nil {
				return SKUsClientListByResourceTypeRegistrationsNestedResourceTypeThirdResponse{}, err
			}
			return client.listByResourceTypeRegistrationsNestedResourceTypeThirdHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceTypeRegistrationsNestedResourceTypeThirdCreateRequest creates the ListByResourceTypeRegistrationsNestedResourceTypeThird request.
func (client *SKUsClient) listByResourceTypeRegistrationsNestedResourceTypeThirdCreateRequest(ctx context.Context, providerNamespace string, resourceType string, nestedResourceTypeFirst string, nestedResourceTypeSecond string, nestedResourceTypeThird string, options *SKUsClientListByResourceTypeRegistrationsNestedResourceTypeThirdOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/resourcetypeRegistrations/{nestedResourceTypeThird}/skus"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if providerNamespace == "" {
		return nil, errors.New("parameter providerNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{providerNamespace}", url.PathEscape(providerNamespace))
	if resourceType == "" {
		return nil, errors.New("parameter resourceType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", url.PathEscape(resourceType))
	if nestedResourceTypeFirst == "" {
		return nil, errors.New("parameter nestedResourceTypeFirst cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeFirst}", url.PathEscape(nestedResourceTypeFirst))
	if nestedResourceTypeSecond == "" {
		return nil, errors.New("parameter nestedResourceTypeSecond cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeSecond}", url.PathEscape(nestedResourceTypeSecond))
	if nestedResourceTypeThird == "" {
		return nil, errors.New("parameter nestedResourceTypeThird cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{nestedResourceTypeThird}", url.PathEscape(nestedResourceTypeThird))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-20")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceTypeRegistrationsNestedResourceTypeThirdHandleResponse handles the ListByResourceTypeRegistrationsNestedResourceTypeThird response.
func (client *SKUsClient) listByResourceTypeRegistrationsNestedResourceTypeThirdHandleResponse(resp *http.Response) (SKUsClientListByResourceTypeRegistrationsNestedResourceTypeThirdResponse, error) {
	result := SKUsClientListByResourceTypeRegistrationsNestedResourceTypeThirdResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SKUResourceArrayResponseWithContinuation); err != nil {
		return SKUsClientListByResourceTypeRegistrationsNestedResourceTypeThirdResponse{}, err
	}
	return result, nil
}
