//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armreservations_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/reservations/armreservations/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/GetAvailableScope.json
func ExampleReservationClient_BeginAvailableScopes() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewReservationClient().BeginAvailableScopes(ctx, "276e7ae4-84d0-4da6-ab4b-d6b94f3557da", "356e7ae4-84d0-4da6-ab4b-d6b94f3557da", armreservations.AvailableScopeRequest{
		Properties: &armreservations.AvailableScopeRequestProperties{
			Scopes: []*string{
				to.Ptr("/subscriptions/efc7c997-7700-4a74-b731-55aec16c15e9")},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AvailableScopeProperties = armreservations.AvailableScopeProperties{
	// 	Properties: &armreservations.SubscriptionScopeProperties{
	// 		Scopes: []*armreservations.ScopeProperties{
	// 			{
	// 				Scope: to.Ptr("/subscriptions/efc7c997-7700-4a74-b731-55aec16c15e9"),
	// 				Valid: to.Ptr(true),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/SplitReservation.json
func ExampleReservationClient_BeginSplit() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewReservationClient().BeginSplit(ctx, "276e7ae4-84d0-4da6-ab4b-d6b94f3557da", armreservations.SplitRequest{
		Properties: &armreservations.SplitProperties{
			Quantities: []*int32{
				to.Ptr[int32](1),
				to.Ptr[int32](2)},
			ReservationID: to.Ptr("/providers/Microsoft.Capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/bcae77cd-3119-4766-919f-b50d36c75c7a"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ReservationResponseArray = []*armreservations.ReservationResponse{
	// 	{
	// 		Name: to.Ptr("00238563-7312-4c20-a134-8c030bf938a7"),
	// 		Type: to.Ptr("Microsoft.Capacity/reservationOrders/reservations"),
	// 		ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/00238563-7312-4c20-a134-8c030bf938a7"),
	// 		Etag: to.Ptr[int32](2),
	// 		Location: to.Ptr("eastus"),
	// 		Properties: &armreservations.Properties{
	// 			AppliedScopeProperties: &armreservations.AppliedScopeProperties{
	// 				DisplayName: to.Ptr("Azure subscription 1"),
	// 				SubscriptionID: to.Ptr("/subscriptions/98df3792-7962-4f18-8be2-d5576f122de3"),
	// 			},
	// 			AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeSingle),
	// 			BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
	// 			BillingScopeID: to.Ptr("/subscriptions/19376483-64b8-49e4-a931-d5248828720a"),
	// 			DisplayName: to.Ptr("cabri_test"),
	// 			EffectiveDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T01:00:30.925Z"); return t}()),
	// 			ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-09-22"); return t}()),
	// 			ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-22T01:00:30.925Z"); return t}()),
	// 			InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOff),
	// 			LastUpdatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T01:00:36.319Z"); return t}()),
	// 			ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
	// 			Quantity: to.Ptr[int32](1),
	// 			Renew: to.Ptr(false),
	// 			ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
	// 			SKUDescription: to.Ptr("D1 v2"),
	// 			SplitProperties: &armreservations.ReservationSplitProperties{
	// 				SplitSource: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/bcae77cd-3119-4766-919f-b50d36c75c7a"),
	// 			},
	// 		},
	// 		SKU: &armreservations.SKUName{
	// 			Name: to.Ptr("Standard_DS1_v2"),
	// 		},
	// 	},
	// 	{
	// 		Name: to.Ptr("e0e4b4f5-77ea-4984-9ee4-6bf9850ee6de"),
	// 		Type: to.Ptr("Microsoft.Capacity/reservationOrders/reservations"),
	// 		ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/e0e4b4f5-77ea-4984-9ee4-6bf9850ee6de"),
	// 		Etag: to.Ptr[int32](2),
	// 		Location: to.Ptr("eastus"),
	// 		Properties: &armreservations.Properties{
	// 			AppliedScopeProperties: &armreservations.AppliedScopeProperties{
	// 				DisplayName: to.Ptr("Azure subscription 1"),
	// 				SubscriptionID: to.Ptr("/subscriptions/98df3792-7962-4f18-8be2-d5576f122de3"),
	// 			},
	// 			AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeSingle),
	// 			BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
	// 			BillingScopeID: to.Ptr("/subscriptions/19376483-64b8-49e4-a931-d5248828720a"),
	// 			DisplayName: to.Ptr("cabri_test"),
	// 			EffectiveDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T01:00:30.925Z"); return t}()),
	// 			ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-09-22"); return t}()),
	// 			ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-22T01:00:30.925Z"); return t}()),
	// 			InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOff),
	// 			LastUpdatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T01:00:36.319Z"); return t}()),
	// 			ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
	// 			Quantity: to.Ptr[int32](2),
	// 			Renew: to.Ptr(false),
	// 			ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
	// 			SKUDescription: to.Ptr("D1 v2"),
	// 			SplitProperties: &armreservations.ReservationSplitProperties{
	// 				SplitSource: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/bcae77cd-3119-4766-919f-b50d36c75c7a"),
	// 			},
	// 		},
	// 		SKU: &armreservations.SKUName{
	// 			Name: to.Ptr("Standard_DS1_v2"),
	// 		},
	// 	},
	// 	{
	// 		Name: to.Ptr("bcae77cd-3119-4766-919f-b50d36c75c7a"),
	// 		Type: to.Ptr("Microsoft.Capacity/reservationOrders/reservations"),
	// 		ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/bcae77cd-3119-4766-919f-b50d36c75c7a"),
	// 		Etag: to.Ptr[int32](10),
	// 		Location: to.Ptr("eastus"),
	// 		Properties: &armreservations.Properties{
	// 			AppliedScopeProperties: &armreservations.AppliedScopeProperties{
	// 				DisplayName: to.Ptr("Azure subscription 1"),
	// 				SubscriptionID: to.Ptr("/subscriptions/98df3792-7962-4f18-8be2-d5576f122de3"),
	// 			},
	// 			AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeSingle),
	// 			BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
	// 			BillingScopeID: to.Ptr("/subscriptions/19376483-64b8-49e4-a931-d5248828720a"),
	// 			DisplayName: to.Ptr("cabri_test"),
	// 			EffectiveDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T01:00:30.925Z"); return t}()),
	// 			ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-09-22"); return t}()),
	// 			ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-22T01:00:30.925Z"); return t}()),
	// 			ExtendedStatusInfo: &armreservations.ExtendedStatusInfo{
	// 				Message: to.Ptr("This reservation was split and is no longer active."),
	// 				StatusCode: to.Ptr(armreservations.ReservationStatusCodeSplit),
	// 			},
	// 			InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOff),
	// 			LastUpdatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T01:00:36.319Z"); return t}()),
	// 			ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
	// 			Quantity: to.Ptr[int32](3),
	// 			Renew: to.Ptr(false),
	// 			ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
	// 			SKUDescription: to.Ptr("D1 v2"),
	// 			SplitProperties: &armreservations.ReservationSplitProperties{
	// 				SplitDestinations: []*string{
	// 					to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/00238563-7312-4c20-a134-8c030bf938a7"),
	// 					to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/e0e4b4f5-77ea-4984-9ee4-6bf9850ee6de")},
	// 				},
	// 			},
	// 			SKU: &armreservations.SKUName{
	// 				Name: to.Ptr("Standard_DS1_v2"),
	// 			},
	// 	}}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/MergeReservations.json
func ExampleReservationClient_BeginMerge() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewReservationClient().BeginMerge(ctx, "276e7ae4-84d0-4da6-ab4b-d6b94f3557da", armreservations.MergeRequest{
		Properties: &armreservations.MergeProperties{
			Sources: []*string{
				to.Ptr("/providers/Microsoft.Capacity/reservationOrders/c0565a8a-4491-4e77-b07b-5e6d66718e1c/reservations/cea04232-932e-47db-acb5-e29a945ecc73"),
				to.Ptr("/providers/Microsoft.Capacity/reservationOrders/c0565a8a-4491-4e77-b07b-5e6d66718e1c/reservations/5bf54dc7-dacd-4f46-a16b-7b78f4a59799")},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ReservationResponseArray = []*armreservations.ReservationResponse{
	// 	{
	// 		Name: to.Ptr("00238563-7312-4c20-a134-8c030bf938a7"),
	// 		Type: to.Ptr("Microsoft.Capacity/reservationOrders/reservations"),
	// 		ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/00238563-7312-4c20-a134-8c030bf938a7"),
	// 		Etag: to.Ptr[int32](5),
	// 		Location: to.Ptr("eastus"),
	// 		Properties: &armreservations.Properties{
	// 			AppliedScopeProperties: &armreservations.AppliedScopeProperties{
	// 				DisplayName: to.Ptr("Azure subscription 1"),
	// 				SubscriptionID: to.Ptr("/subscriptions/98df3792-7962-4f18-8be2-d5576f122de3"),
	// 			},
	// 			AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeSingle),
	// 			BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
	// 			BillingScopeID: to.Ptr("/subscriptions/19376483-64b8-49e4-a931-d5248828720a"),
	// 			DisplayName: to.Ptr("cabri_test"),
	// 			EffectiveDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
	// 			ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-09-22"); return t}()),
	// 			ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-22T22:46:32.763Z"); return t}()),
	// 			ExtendedStatusInfo: &armreservations.ExtendedStatusInfo{
	// 				Message: to.Ptr("This reservation was merged and is no longer active."),
	// 				StatusCode: to.Ptr(armreservations.ReservationStatusCodeMerged),
	// 			},
	// 			InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOff),
	// 			LastUpdatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
	// 			MergeProperties: &armreservations.ReservationMergeProperties{
	// 				MergeDestination: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/6ef59113-3482-40da-8d79-787f823e34bc"),
	// 			},
	// 			ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
	// 			Quantity: to.Ptr[int32](1),
	// 			Renew: to.Ptr(false),
	// 			ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
	// 			SKUDescription: to.Ptr("D1 v2"),
	// 			SplitProperties: &armreservations.ReservationSplitProperties{
	// 				SplitSource: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/bcae77cd-3119-4766-919f-b50d36c75c7a"),
	// 			},
	// 		},
	// 		SKU: &armreservations.SKUName{
	// 			Name: to.Ptr("Standard_DS1_v2"),
	// 		},
	// 	},
	// 	{
	// 		Name: to.Ptr("e0e4b4f5-77ea-4984-9ee4-6bf9850ee6de"),
	// 		Type: to.Ptr("Microsoft.Capacity/reservationOrders/reservations"),
	// 		ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/e0e4b4f5-77ea-4984-9ee4-6bf9850ee6de"),
	// 		Etag: to.Ptr[int32](4),
	// 		Location: to.Ptr("eastus"),
	// 		Properties: &armreservations.Properties{
	// 			AppliedScopeProperties: &armreservations.AppliedScopeProperties{
	// 				DisplayName: to.Ptr("Azure subscription 1"),
	// 				SubscriptionID: to.Ptr("/subscriptions/98df3792-7962-4f18-8be2-d5576f122de3"),
	// 			},
	// 			AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeSingle),
	// 			BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
	// 			BillingScopeID: to.Ptr("/subscriptions/19376483-64b8-49e4-a931-d5248828720a"),
	// 			DisplayName: to.Ptr("cabri_test"),
	// 			EffectiveDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
	// 			ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-09-22"); return t}()),
	// 			ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-22T22:46:32.763Z"); return t}()),
	// 			ExtendedStatusInfo: &armreservations.ExtendedStatusInfo{
	// 				Message: to.Ptr("This reservation was merged and is no longer active."),
	// 				StatusCode: to.Ptr(armreservations.ReservationStatusCodeMerged),
	// 			},
	// 			InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOff),
	// 			LastUpdatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
	// 			MergeProperties: &armreservations.ReservationMergeProperties{
	// 				MergeDestination: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/6ef59113-3482-40da-8d79-787f823e34bc"),
	// 			},
	// 			ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
	// 			Quantity: to.Ptr[int32](2),
	// 			Renew: to.Ptr(false),
	// 			ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
	// 			SKUDescription: to.Ptr("D1 v2"),
	// 			SplitProperties: &armreservations.ReservationSplitProperties{
	// 				SplitSource: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/bcae77cd-3119-4766-919f-b50d36c75c7a"),
	// 			},
	// 		},
	// 		SKU: &armreservations.SKUName{
	// 			Name: to.Ptr("Standard_DS1_v2"),
	// 		},
	// 	},
	// 	{
	// 		Name: to.Ptr("6ef59113-3482-40da-8d79-787f823e34bc"),
	// 		Type: to.Ptr("Microsoft.Capacity/reservationOrders/reservations"),
	// 		ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/6ef59113-3482-40da-8d79-787f823e34bc"),
	// 		Etag: to.Ptr[int32](2),
	// 		Location: to.Ptr("eastus"),
	// 		Properties: &armreservations.Properties{
	// 			AppliedScopeProperties: &armreservations.AppliedScopeProperties{
	// 				DisplayName: to.Ptr("Azure subscription 1"),
	// 				SubscriptionID: to.Ptr("/subscriptions/98df3792-7962-4f18-8be2-d5576f122de3"),
	// 			},
	// 			AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeSingle),
	// 			BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
	// 			BillingScopeID: to.Ptr("/subscriptions/19376483-64b8-49e4-a931-d5248828720a"),
	// 			DisplayName: to.Ptr("cabri_test"),
	// 			EffectiveDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
	// 			ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-09-22"); return t}()),
	// 			ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-22T22:46:32.763Z"); return t}()),
	// 			InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOff),
	// 			LastUpdatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
	// 			MergeProperties: &armreservations.ReservationMergeProperties{
	// 				MergeSources: []*string{
	// 					to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/00238563-7312-4c20-a134-8c030bf938a7"),
	// 					to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/e0e4b4f5-77ea-4984-9ee4-6bf9850ee6de")},
	// 				},
	// 				ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
	// 				Quantity: to.Ptr[int32](3),
	// 				Renew: to.Ptr(false),
	// 				ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
	// 				SKUDescription: to.Ptr("D1 v2"),
	// 			},
	// 			SKU: &armreservations.SKUName{
	// 				Name: to.Ptr("Standard_DS1_v2"),
	// 			},
	// 	}}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/GetReservationsFromOrder.json
func ExampleReservationClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewReservationClient().NewListPager("276e7ae4-84d0-4da6-ab4b-d6b94f3557da", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ReservationList = armreservations.ReservationList{
		// 	Value: []*armreservations.ReservationResponse{
		// 		{
		// 			Name: to.Ptr("bcae77cd-3119-4766-919f-b50d36c75c7a"),
		// 			Type: to.Ptr("Microsoft.Capacity/reservationOrders/reservations"),
		// 			ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/bcae77cd-3119-4766-919f-b50d36c75c7a"),
		// 			Etag: to.Ptr[int32](10),
		// 			Location: to.Ptr("eastus"),
		// 			Properties: &armreservations.Properties{
		// 				AppliedScopeProperties: &armreservations.AppliedScopeProperties{
		// 					DisplayName: to.Ptr("Azure subscription 1"),
		// 					SubscriptionID: to.Ptr("/subscriptions/98df3792-7962-4f18-8be2-d5576f122de3"),
		// 				},
		// 				AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeSingle),
		// 				BenefitStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T01:00:30.925Z"); return t}()),
		// 				BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
		// 				BillingScopeID: to.Ptr("/subscriptions/19376483-64b8-49e4-a931-d5248828720a"),
		// 				DisplayName: to.Ptr("cabri_test"),
		// 				EffectiveDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T01:00:30.925Z"); return t}()),
		// 				ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-09-22"); return t}()),
		// 				ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-22T01:00:30.925Z"); return t}()),
		// 				ExtendedStatusInfo: &armreservations.ExtendedStatusInfo{
		// 					Message: to.Ptr("This reservation was split and is no longer active."),
		// 					StatusCode: to.Ptr(armreservations.ReservationStatusCodeSplit),
		// 				},
		// 				InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOn),
		// 				LastUpdatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T01:00:36.319Z"); return t}()),
		// 				ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
		// 				Quantity: to.Ptr[int32](3),
		// 				Renew: to.Ptr(false),
		// 				ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
		// 				SKUDescription: to.Ptr("D1 v2"),
		// 				SplitProperties: &armreservations.ReservationSplitProperties{
		// 					SplitDestinations: []*string{
		// 						to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/00238563-7312-4c20-a134-8c030bf938a7"),
		// 						to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/e0e4b4f5-77ea-4984-9ee4-6bf9850ee6de")},
		// 					},
		// 				},
		// 				SKU: &armreservations.SKUName{
		// 					Name: to.Ptr("Standard_DS1_v2"),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("00238563-7312-4c20-a134-8c030bf938a7"),
		// 				Type: to.Ptr("Microsoft.Capacity/reservationOrders/reservations"),
		// 				ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/00238563-7312-4c20-a134-8c030bf938a7"),
		// 				Etag: to.Ptr[int32](5),
		// 				Location: to.Ptr("eastus"),
		// 				Properties: &armreservations.Properties{
		// 					AppliedScopeProperties: &armreservations.AppliedScopeProperties{
		// 						DisplayName: to.Ptr("Azure subscription 1"),
		// 						SubscriptionID: to.Ptr("/subscriptions/98df3792-7962-4f18-8be2-d5576f122de3"),
		// 					},
		// 					AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeSingle),
		// 					BenefitStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
		// 					BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
		// 					BillingScopeID: to.Ptr("/subscriptions/19376483-64b8-49e4-a931-d5248828720a"),
		// 					DisplayName: to.Ptr("cabri_test"),
		// 					EffectiveDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
		// 					ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-09-22"); return t}()),
		// 					ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-22T22:46:32.763Z"); return t}()),
		// 					ExtendedStatusInfo: &armreservations.ExtendedStatusInfo{
		// 						Message: to.Ptr("This reservation was merged and is no longer active."),
		// 						StatusCode: to.Ptr(armreservations.ReservationStatusCodeMerged),
		// 					},
		// 					InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOn),
		// 					LastUpdatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
		// 					MergeProperties: &armreservations.ReservationMergeProperties{
		// 						MergeDestination: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/6ef59113-3482-40da-8d79-787f823e34bc"),
		// 					},
		// 					ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
		// 					Quantity: to.Ptr[int32](1),
		// 					Renew: to.Ptr(false),
		// 					ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
		// 					SKUDescription: to.Ptr("D1 v2"),
		// 					SplitProperties: &armreservations.ReservationSplitProperties{
		// 						SplitSource: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/bcae77cd-3119-4766-919f-b50d36c75c7a"),
		// 					},
		// 				},
		// 				SKU: &armreservations.SKUName{
		// 					Name: to.Ptr("Standard_DS1_v2"),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("e0e4b4f5-77ea-4984-9ee4-6bf9850ee6de"),
		// 				Type: to.Ptr("Microsoft.Capacity/reservationOrders/reservations"),
		// 				ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/e0e4b4f5-77ea-4984-9ee4-6bf9850ee6de"),
		// 				Etag: to.Ptr[int32](4),
		// 				Location: to.Ptr("eastus"),
		// 				Properties: &armreservations.Properties{
		// 					AppliedScopeProperties: &armreservations.AppliedScopeProperties{
		// 						DisplayName: to.Ptr("Azure subscription 1"),
		// 						SubscriptionID: to.Ptr("/subscriptions/98df3792-7962-4f18-8be2-d5576f122de3"),
		// 					},
		// 					AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeSingle),
		// 					BenefitStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
		// 					BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
		// 					BillingScopeID: to.Ptr("/subscriptions/19376483-64b8-49e4-a931-d5248828720a"),
		// 					DisplayName: to.Ptr("cabri_test"),
		// 					EffectiveDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
		// 					ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-09-22"); return t}()),
		// 					ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-22T22:46:32.763Z"); return t}()),
		// 					ExtendedStatusInfo: &armreservations.ExtendedStatusInfo{
		// 						Message: to.Ptr("This reservation was merged and is no longer active."),
		// 						StatusCode: to.Ptr(armreservations.ReservationStatusCodeMerged),
		// 					},
		// 					InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOn),
		// 					LastUpdatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
		// 					MergeProperties: &armreservations.ReservationMergeProperties{
		// 						MergeDestination: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/6ef59113-3482-40da-8d79-787f823e34bc"),
		// 					},
		// 					ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
		// 					Quantity: to.Ptr[int32](2),
		// 					Renew: to.Ptr(false),
		// 					ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
		// 					SKUDescription: to.Ptr("D1 v2"),
		// 					SplitProperties: &armreservations.ReservationSplitProperties{
		// 						SplitSource: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/bcae77cd-3119-4766-919f-b50d36c75c7a"),
		// 					},
		// 				},
		// 				SKU: &armreservations.SKUName{
		// 					Name: to.Ptr("Standard_DS1_v2"),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("6ef59113-3482-40da-8d79-787f823e34bc"),
		// 				Type: to.Ptr("Microsoft.Capacity/reservationOrders/reservations"),
		// 				ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/6ef59113-3482-40da-8d79-787f823e34bc"),
		// 				Etag: to.Ptr[int32](2),
		// 				Location: to.Ptr("eastus"),
		// 				Properties: &armreservations.Properties{
		// 					AppliedScopeProperties: &armreservations.AppliedScopeProperties{
		// 						DisplayName: to.Ptr("Azure subscription 1"),
		// 						SubscriptionID: to.Ptr("/subscriptions/98df3792-7962-4f18-8be2-d5576f122de3"),
		// 					},
		// 					AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeSingle),
		// 					BenefitStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
		// 					BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
		// 					BillingScopeID: to.Ptr("/subscriptions/19376483-64b8-49e4-a931-d5248828720a"),
		// 					DisplayName: to.Ptr("cabri_test"),
		// 					EffectiveDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
		// 					ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-09-22"); return t}()),
		// 					ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-22T22:46:32.763Z"); return t}()),
		// 					InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOn),
		// 					LastUpdatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
		// 					MergeProperties: &armreservations.ReservationMergeProperties{
		// 						MergeSources: []*string{
		// 							to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/00238563-7312-4c20-a134-8c030bf938a7"),
		// 							to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/e0e4b4f5-77ea-4984-9ee4-6bf9850ee6de")},
		// 						},
		// 						ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
		// 						Quantity: to.Ptr[int32](3),
		// 						Renew: to.Ptr(false),
		// 						ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
		// 						SKUDescription: to.Ptr("D1 v2"),
		// 					},
		// 					SKU: &armreservations.SKUName{
		// 						Name: to.Ptr("Standard_DS1_v2"),
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("5se63214-3382-40da-ed79-787f823e34bc"),
		// 					Type: to.Ptr("Microsoft.Capacity/reservationOrders/reservations"),
		// 					ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/5se63214-3382-40da-ed79-787f823e34bc"),
		// 					Etag: to.Ptr[int32](2),
		// 					Location: to.Ptr("eastus"),
		// 					Properties: &armreservations.Properties{
		// 						AppliedScopeProperties: &armreservations.AppliedScopeProperties{
		// 							DisplayName: to.Ptr("Azure subscription 1"),
		// 							SubscriptionID: to.Ptr("/subscriptions/98df3792-7962-4f18-8be2-d5576f122de3"),
		// 						},
		// 						AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeSingle),
		// 						BenefitStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:40:32.763Z"); return t}()),
		// 						BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
		// 						BillingScopeID: to.Ptr("/subscriptions/19376483-64b8-49e4-a931-d5248828720a"),
		// 						DisplayName: to.Ptr("cabri_test"),
		// 						EffectiveDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
		// 						ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-09-22"); return t}()),
		// 						ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-22T22:46:32.763Z"); return t}()),
		// 						InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOn),
		// 						LastUpdatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
		// 						ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
		// 						Quantity: to.Ptr[int32](3),
		// 						Renew: to.Ptr(false),
		// 						ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
		// 						SKUDescription: to.Ptr("D1 v2"),
		// 						SwapProperties: &armreservations.ReservationSwapProperties{
		// 							SwapDestination: to.Ptr("/providers/microsoft.capacity/reservationOrders/63027ae3-389a-4716-ad77-04f42ce93c06/reservations/4jf50113-3382-40da-ed79-787f823e34bc"),
		// 						},
		// 					},
		// 					SKU: &armreservations.SKUName{
		// 						Name: to.Ptr("Standard_D1_v2"),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/GetReservationDetails.json
func ExampleReservationClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewReservationClient().Get(ctx, "276e7ae4-84d0-4da6-ab4b-d6b94f3557da", "6ef59113-3482-40da-8d79-787f823e34bc", &armreservations.ReservationClientGetOptions{Expand: to.Ptr("renewProperties")})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ReservationResponse = armreservations.ReservationResponse{
	// 	Name: to.Ptr("6ef59113-3482-40da-8d79-787f823e34bc"),
	// 	Type: to.Ptr("Microsoft.Capacity/reservationOrders/reservations"),
	// 	ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/6ef59113-3482-40da-8d79-787f823e34bc"),
	// 	Etag: to.Ptr[int32](2),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armreservations.Properties{
	// 		AppliedScopeProperties: &armreservations.AppliedScopeProperties{
	// 			DisplayName: to.Ptr("Azure subscription 1"),
	// 			SubscriptionID: to.Ptr("/subscriptions/98df3792-7962-4f18-8be2-d5576f122de3"),
	// 		},
	// 		AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeSingle),
	// 		BenefitStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
	// 		BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
	// 		BillingScopeID: to.Ptr("/subscriptions/19376483-64b8-49e4-a931-d5248828720a"),
	// 		DisplayName: to.Ptr("cabri_test"),
	// 		EffectiveDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
	// 		ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-09-22"); return t}()),
	// 		ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-22T22:46:32.763Z"); return t}()),
	// 		InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOff),
	// 		LastUpdatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
	// 		MergeProperties: &armreservations.ReservationMergeProperties{
	// 			MergeSources: []*string{
	// 				to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/00238563-7312-4c20-a134-8c030bf938a7"),
	// 				to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/e0e4b4f5-77ea-4984-9ee4-6bf9850ee6de")},
	// 			},
	// 			ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
	// 			Quantity: to.Ptr[int32](3),
	// 			Renew: to.Ptr(false),
	// 			RenewDestination: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/00238563-7312-4c20-a134-8c030bf938a7"),
	// 			RenewProperties: &armreservations.RenewPropertiesResponse{
	// 				BillingCurrencyTotal: &armreservations.RenewPropertiesResponseBillingCurrencyTotal{
	// 					Amount: to.Ptr[float32](466),
	// 					CurrencyCode: to.Ptr("USD"),
	// 				},
	// 				PricingCurrencyTotal: &armreservations.RenewPropertiesResponsePricingCurrencyTotal{
	// 					Amount: to.Ptr[float32](466),
	// 					CurrencyCode: to.Ptr("USD"),
	// 				},
	// 				PurchaseProperties: &armreservations.PurchaseRequest{
	// 					Location: to.Ptr("westus"),
	// 					Properties: &armreservations.PurchaseRequestProperties{
	// 						AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeShared),
	// 						BillingScopeID: to.Ptr("/subscriptions/19376483-64b8-49e4-a931-d5248828720a"),
	// 						DisplayName: to.Ptr("Renew_Test_0618"),
	// 						Quantity: to.Ptr[int32](2),
	// 						Renew: to.Ptr(false),
	// 						ReservedResourceProperties: &armreservations.PurchaseRequestPropertiesReservedResourceProperties{
	// 							InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOn),
	// 						},
	// 						ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
	// 						Term: to.Ptr(armreservations.ReservationTermP1Y),
	// 					},
	// 					SKU: &armreservations.SKUName{
	// 						Name: to.Ptr("Standard_D1"),
	// 					},
	// 				},
	// 			},
	// 			RenewSource: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/00238563-7312-4c20-a134-8c030bf938a7"),
	// 			ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
	// 			SKUDescription: to.Ptr("D1 v2"),
	// 			SwapProperties: &armreservations.ReservationSwapProperties{
	// 				SwapSource: to.Ptr("/providers/microsoft.capacity/reservationOrders/63037ae3-385a-4716-ad77-02f42ce93c06/reservations/5c6383f5-3f2c-4159-ae74-j72i1c1a49bc"),
	// 			},
	// 			Term: to.Ptr(armreservations.ReservationTermP1Y),
	// 		},
	// 		SKU: &armreservations.SKUName{
	// 			Name: to.Ptr("Standard_DS1_v2"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/UpdateReservation.json
func ExampleReservationClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewReservationClient().BeginUpdate(ctx, "276e7ae4-84d0-4da6-ab4b-d6b94f3557da", "6ef59113-3482-40da-8d79-787f823e34bc", armreservations.Patch{
		Properties: &armreservations.PatchProperties{
			AppliedScopeType:    to.Ptr(armreservations.AppliedScopeTypeShared),
			InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOff),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ReservationResponse = armreservations.ReservationResponse{
	// 	Name: to.Ptr("6ef59113-3482-40da-8d79-787f823e34bc"),
	// 	Type: to.Ptr("Microsoft.Capacity/reservationOrders/reservations"),
	// 	ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/6ef59113-3482-40da-8d79-787f823e34bc"),
	// 	Etag: to.Ptr[int32](4),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armreservations.Properties{
	// 		AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeShared),
	// 		BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
	// 		BillingScopeID: to.Ptr("/subscriptions/19376483-64b8-49e4-a931-d5248828720a"),
	// 		DisplayName: to.Ptr("cabri_test"),
	// 		EffectiveDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T23:57:48.189Z"); return t}()),
	// 		ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-09-22"); return t}()),
	// 		ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-22T23:57:48.189Z"); return t}()),
	// 		InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOff),
	// 		LastUpdatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T23:57:54.376Z"); return t}()),
	// 		MergeProperties: &armreservations.ReservationMergeProperties{
	// 			MergeSources: []*string{
	// 				to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/00238563-7312-4c20-a134-8c030bf938a7"),
	// 				to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/e0e4b4f5-77ea-4984-9ee4-6bf9850ee6de")},
	// 			},
	// 			ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
	// 			Quantity: to.Ptr[int32](3),
	// 			Renew: to.Ptr(false),
	// 			ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
	// 			SKUDescription: to.Ptr("D1 v2"),
	// 		},
	// 		SKU: &armreservations.SKUName{
	// 			Name: to.Ptr("Standard_DS1_v2"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/Archive.json
func ExampleReservationClient_Archive() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewReservationClient().Archive(ctx, "276e7ae4-84d0-4da6-ab4b-d6b94f3557da", "356e7ae4-84d0-4da6-ab4b-d6b94f3557da", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/Unarchive.json
func ExampleReservationClient_Unarchive() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewReservationClient().Unarchive(ctx, "276e7ae4-84d0-4da6-ab4b-d6b94f3557da", "356e7ae4-84d0-4da6-ab4b-d6b94f3557da", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/GetReservationRevisions.json
func ExampleReservationClient_NewListRevisionsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewReservationClient().NewListRevisionsPager("276e7ae4-84d0-4da6-ab4b-d6b94f3557da", "6ef59113-3482-40da-8d79-787f823e34bc", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ReservationList = armreservations.ReservationList{
		// 	Value: []*armreservations.ReservationResponse{
		// 		{
		// 			Name: to.Ptr("4"),
		// 			Type: to.Ptr("Microsoft.Capacity/reservationOrders/reservations/revisions"),
		// 			ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/6ef59113-3482-40da-8d79-787f823e34bc/revisions/4"),
		// 			Etag: to.Ptr[int32](4),
		// 			Location: to.Ptr("eastus"),
		// 			Properties: &armreservations.Properties{
		// 				AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeShared),
		// 				BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
		// 				DisplayName: to.Ptr("cabri_test"),
		// 				EffectiveDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T23:57:48.189Z"); return t}()),
		// 				ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-09-22"); return t}()),
		// 				ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-22T23:57:48.189Z"); return t}()),
		// 				InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOn),
		// 				LastUpdatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T23:57:54.376Z"); return t}()),
		// 				MergeProperties: &armreservations.ReservationMergeProperties{
		// 					MergeSources: []*string{
		// 						to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/00238563-7312-4c20-a134-8c030bf938a7"),
		// 						to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/e0e4b4f5-77ea-4984-9ee4-6bf9850ee6de")},
		// 					},
		// 					ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
		// 					Quantity: to.Ptr[int32](3),
		// 					ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
		// 					SKUDescription: to.Ptr("D1 v2"),
		// 				},
		// 				SKU: &armreservations.SKUName{
		// 					Name: to.Ptr("Standard_DS1_v2"),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("3"),
		// 				Type: to.Ptr("Microsoft.Capacity/reservationOrders/reservations/revisions"),
		// 				ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/6ef59113-3482-40da-8d79-787f823e34bc/revisions/3"),
		// 				Etag: to.Ptr[int32](3),
		// 				Location: to.Ptr("eastus"),
		// 				Properties: &armreservations.Properties{
		// 					AppliedScopeProperties: &armreservations.AppliedScopeProperties{
		// 						DisplayName: to.Ptr("Azure subscription 1"),
		// 						SubscriptionID: to.Ptr("/subscriptions/98df3792-7962-4f18-8be2-d5576f122de3"),
		// 					},
		// 					AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeSingle),
		// 					BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
		// 					DisplayName: to.Ptr("cabri_test"),
		// 					EffectiveDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
		// 					ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-09-22"); return t}()),
		// 					ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-22T22:46:32.763Z"); return t}()),
		// 					ExtendedStatusInfo: &armreservations.ExtendedStatusInfo{
		// 						Message: to.Ptr("An operation is in progress on your reservation. Please wait for operation to complete before taking further action"),
		// 						StatusCode: to.Ptr(armreservations.ReservationStatusCodePending),
		// 					},
		// 					InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOn),
		// 					LastUpdatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T23:57:47.488Z"); return t}()),
		// 					MergeProperties: &armreservations.ReservationMergeProperties{
		// 						MergeSources: []*string{
		// 							to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/00238563-7312-4c20-a134-8c030bf938a7"),
		// 							to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/e0e4b4f5-77ea-4984-9ee4-6bf9850ee6de")},
		// 						},
		// 						ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
		// 						Quantity: to.Ptr[int32](3),
		// 						ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
		// 						SKUDescription: to.Ptr("D1 v2"),
		// 					},
		// 					SKU: &armreservations.SKUName{
		// 						Name: to.Ptr("Standard_DS1_v2"),
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("2"),
		// 					Type: to.Ptr("Microsoft.Capacity/reservationOrders/reservations/revisions"),
		// 					ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/6ef59113-3482-40da-8d79-787f823e34bc/revisions/2"),
		// 					Etag: to.Ptr[int32](2),
		// 					Location: to.Ptr("eastus"),
		// 					Properties: &armreservations.Properties{
		// 						AppliedScopeProperties: &armreservations.AppliedScopeProperties{
		// 							DisplayName: to.Ptr("Azure subscription 1"),
		// 							SubscriptionID: to.Ptr("/subscriptions/98df3792-7962-4f18-8be2-d5576f122de3"),
		// 						},
		// 						AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeSingle),
		// 						BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
		// 						DisplayName: to.Ptr("cabri_test"),
		// 						EffectiveDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
		// 						ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-09-22"); return t}()),
		// 						ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-22T22:46:32.763Z"); return t}()),
		// 						InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOn),
		// 						LastUpdatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
		// 						MergeProperties: &armreservations.ReservationMergeProperties{
		// 							MergeSources: []*string{
		// 								to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/00238563-7312-4c20-a134-8c030bf938a7"),
		// 								to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/e0e4b4f5-77ea-4984-9ee4-6bf9850ee6de")},
		// 							},
		// 							ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
		// 							Quantity: to.Ptr[int32](3),
		// 							ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
		// 							SKUDescription: to.Ptr("D1 v2"),
		// 							SwapProperties: &armreservations.ReservationSwapProperties{
		// 								SwapDestination: to.Ptr("/providers/microsoft.capacity/reservationOrders/afadf486-3432-4254-b297-4db8ef055f38/reservations/317efb41-b3ef-3706-8447-c2c045ab3ef5"),
		// 							},
		// 						},
		// 						SKU: &armreservations.SKUName{
		// 							Name: to.Ptr("Standard_DS1_v2"),
		// 						},
		// 					},
		// 					{
		// 						Name: to.Ptr("1"),
		// 						Type: to.Ptr("Microsoft.Capacity/reservationOrders/reservations/revisions"),
		// 						ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/6ef59113-3482-40da-8d79-787f823e34bc/revisions/1"),
		// 						Etag: to.Ptr[int32](1),
		// 						Location: to.Ptr("eastus"),
		// 						Properties: &armreservations.Properties{
		// 							AppliedScopeProperties: &armreservations.AppliedScopeProperties{
		// 								DisplayName: to.Ptr("Azure subscription 1"),
		// 								SubscriptionID: to.Ptr("/subscriptions/98df3792-7962-4f18-8be2-d5576f122de3"),
		// 							},
		// 							AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeSingle),
		// 							DisplayName: to.Ptr("cabri_test"),
		// 							EffectiveDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:27.331Z"); return t}()),
		// 							ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-09-22"); return t}()),
		// 							ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-09-22T22:46:27.331Z"); return t}()),
		// 							InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOn),
		// 							LastUpdatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:27.331Z"); return t}()),
		// 							MergeProperties: &armreservations.ReservationMergeProperties{
		// 								MergeSources: []*string{
		// 									to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/00238563-7312-4c20-a134-8c030bf938a7"),
		// 									to.Ptr("/providers/microsoft.capacity/reservationOrders/276e7ae4-84d0-4da6-ab4b-d6b94f3557da/reservations/e0e4b4f5-77ea-4984-9ee4-6bf9850ee6de")},
		// 								},
		// 								ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
		// 								Quantity: to.Ptr[int32](3),
		// 								ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
		// 								SKUDescription: to.Ptr("D1 v2"),
		// 							},
		// 							SKU: &armreservations.SKUName{
		// 								Name: to.Ptr("Standard_DS1_v2"),
		// 							},
		// 					}},
		// 				}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/GetReservations.json
func ExampleReservationClient_NewListAllPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewReservationClient().NewListAllPager(&armreservations.ReservationClientListAllOptions{Filter: to.Ptr("(properties%2farchived+eq+false)"),
		Orderby:        to.Ptr("properties/displayName asc"),
		RefreshSummary: nil,
		Skiptoken:      to.Ptr[float32](50),
		SelectedState:  nil,
		Take:           to.Ptr[float32](1),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ListResult = armreservations.ListResult{
		// 	Summary: &armreservations.ReservationSummary{
		// 		CancelledCount: to.Ptr[float32](0),
		// 		ExpiredCount: to.Ptr[float32](0),
		// 		ExpiringCount: to.Ptr[float32](0),
		// 		FailedCount: to.Ptr[float32](0),
		// 		PendingCount: to.Ptr[float32](0),
		// 		SucceededCount: to.Ptr[float32](1),
		// 	},
		// 	Value: []*armreservations.ReservationResponse{
		// 		{
		// 			Name: to.Ptr("00000000-0000-0000-0000-000000000001/00000000-0000-0000-0000-000000000000"),
		// 			Type: to.Ptr("Microsoft.Capacity/reservationOrders/reservations"),
		// 			ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/00000000-0000-0000-0000-000000000001/reservations/00000000-0000-0000-0000-000000000000"),
		// 			Location: to.Ptr("westus"),
		// 			Properties: &armreservations.Properties{
		// 				AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeShared),
		// 				DisplayName: to.Ptr("VM_RI_07-21-2020_12-06"),
		// 				DisplayProvisioningState: to.Ptr("Succeeded"),
		// 				EffectiveDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-09-22T22:46:32.763Z"); return t}()),
		// 				ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2023-07-21"); return t}()),
		// 				ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-07-21T22:46:32.763Z"); return t}()),
		// 				ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
		// 				PurchaseDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2021-04-22"); return t}()),
		// 				PurchaseDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-22T22:46:32.763Z"); return t}()),
		// 				Quantity: to.Ptr[int32](2),
		// 				Renew: to.Ptr(false),
		// 				RenewSource: to.Ptr("/providers/Microsoft.Capacity/reservationorders/00000000-0000-0000-0000-000000000002/reservations/00000000-0000-0000-0000-000000000003"),
		// 				ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
		// 				Term: to.Ptr(armreservations.ReservationTermP3Y),
		// 				UserFriendlyAppliedScopeType: to.Ptr("Shared"),
		// 				UserFriendlyRenewState: to.Ptr("Off"),
		// 				Utilization: &armreservations.PropertiesUtilization{
		// 					Aggregates: []*armreservations.ReservationUtilizationAggregates{
		// 						{
		// 							Grain: to.Ptr[float32](1),
		// 							GrainUnit: to.Ptr("days"),
		// 							Value: to.Ptr[float32](0.05),
		// 							ValueUnit: to.Ptr("percentage"),
		// 						},
		// 						{
		// 							Grain: to.Ptr[float32](7),
		// 							GrainUnit: to.Ptr("days"),
		// 							Value: to.Ptr[float32](0.05),
		// 							ValueUnit: to.Ptr("percentage"),
		// 						},
		// 						{
		// 							Grain: to.Ptr[float32](30),
		// 							GrainUnit: to.Ptr("days"),
		// 							Value: to.Ptr[float32](0.05),
		// 							ValueUnit: to.Ptr("percentage"),
		// 					}},
		// 					Trend: to.Ptr("UP"),
		// 				},
		// 			},
		// 			SKU: &armreservations.SKUName{
		// 				Name: to.Ptr("Standard_D1"),
		// 			},
		// 	}},
		// }
	}
}
